/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.parser;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.ColorDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.ConstraintDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.PointDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.SketchDocumentDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.SketchLayerDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers.SketchMetaDeserializer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchFile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchParser {
    private static final Logger LOG = Logger.getInstance(SketchParser.class);
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(SketchDocument.class, (Object)new SketchDocumentDeserializer()).registerTypeAdapter(SketchMeta.class, (Object)new SketchMetaDeserializer()).registerTypeAdapter(SketchLayer.class, (Object)new SketchLayerDeserializer()).registerTypeAdapter(Color.class, (Object)new ColorDeserializer()).registerTypeAdapter(SketchPoint2D.class, (Object)new PointDeserializer()).registerTypeAdapter(ResizingConstraint.class, (Object)new ConstraintDeserializer()).create();

    @Nullable
    public static SketchFile read(@NotNull String path2) {
        SketchFile sketchFile;
        ZipFile zip = new ZipFile(path2);
        try {
            SketchFile sketchFile2 = new SketchFile();
            Enumeration<? extends ZipEntry> e = zip.entries();
            block17: while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!FilenameUtils.getExtension((String)entryName).equals("json")) continue;
                switch (entryName) {
                    case "document.json": {
                        SketchDocument document2 = (SketchDocument)SketchParser.parseJson(zip.getInputStream(entry), SketchDocument.class);
                        if (document2 == null) continue block17;
                        sketchFile2.setDocument(document2);
                        continue block17;
                    }
                    case "meta.json": {
                        SketchMeta meta = (SketchMeta)SketchParser.parseJson(zip.getInputStream(entry), SketchMeta.class);
                        if (meta == null) continue block17;
                        sketchFile2.setMeta(meta);
                        continue block17;
                    }
                    case "user.json": {
                        continue block17;
                    }
                }
                SketchPage page = (SketchPage)SketchParser.parseJson(zip.getInputStream(entry), SketchPage.class);
                if (page == null) continue;
                sketchFile2.addPage(page);
            }
            sketchFile = sketchFile2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Failed to read from sketch file: " + path2 + ".", (Throwable)e);
                return null;
            }
        }
        zip.close();
        return sketchFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T parseJson(@NotNull InputStream in, @NotNull Type typeOfT) {
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(in));){
            Object object = gson.fromJson((Reader)reader2, typeOfT);
            return (T)object;
        }
        catch (Exception e) {
            LOG.warn("Could not read JSON from input stream.", (Throwable)e);
            return null;
        }
    }
}

