/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceUtils;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorerKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"getSortedResourceTypes", "", "Lcom/android/resources/ResourceType;", "originalSet", "", "(Ljava/util/Set;)[Lcom/android/resources/ResourceType;", "getReferenceString", "", "Lcom/android/ide/common/resources/ResourceItem;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourcePickerDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcePickerDialog.kt\ncom/android/tools/idea/ui/resourcemanager/ResourcePickerDialogKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,211:1\n37#2,2:212\n37#2,2:216\n13543#3,2:214\n*S KotlinDebug\n*F\n+ 1 ResourcePickerDialog.kt\ncom/android/tools/idea/ui/resourcemanager/ResourcePickerDialogKt\n*L\n146#1:212,2\n154#1:216,2\n148#1:214,2\n*E\n"})
public final class ResourcePickerDialogKt {
    private static final ResourceType[] getSortedResourceTypes(Set<? extends ResourceType> originalSet) {
        ResourceType[] resManagerTypes = ResourceExplorerKt.getMANAGER_SUPPORTED_RESOURCES();
        ArrayList<ResourceType> sortedTypes = new ArrayList<ResourceType>();
        Collection $this$toTypedArray$iv = originalSet;
        int $i$f$toTypedArray = 0;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ResourceType[] resourceTypeArray = thisCollection$iv.toArray(new ResourceType[0]);
        Set remainingTypes = SetsKt.mutableSetOf((Object[])Arrays.copyOf(resourceTypeArray, resourceTypeArray.length));
        ResourceType[] $this$forEach$iv = resManagerTypes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for ($i$f$toTypedArray = 0; $i$f$toTypedArray < n; ++$i$f$toTypedArray) {
            ResourceType element$iv;
            ResourceType resourceType = element$iv = $this$forEach$iv[$i$f$toTypedArray];
            boolean bl = false;
            if (!remainingTypes.remove(resourceType)) continue;
            sortedTypes.add(resourceType);
        }
        sortedTypes.addAll(remainingTypes);
        Collection $this$toTypedArray$iv2 = sortedTypes;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        return thisCollection$iv2.toArray(new ResourceType[0]);
    }

    private static final String getReferenceString(ResourceItem $this$getReferenceString) {
        ResourceReference resourceReference = $this$getReferenceString.getReferenceToSelf();
        Object qualifiedName = resourceReference.getQualifiedName();
        if (Intrinsics.areEqual((Object)resourceReference.getNamespace(), (Object)ResourceNamespace.TOOLS)) {
            String string = qualifiedName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"qualifiedName");
            if (StringsKt.lastIndexOf$default((CharSequence)string, (String)":", (int)0, (boolean)false, (int)6, null) < 0) {
                qualifiedName = resourceReference.getNamespace().toString() + ":" + (String)qualifiedName;
            }
        }
        String string = qualifiedName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"qualifiedName");
        String string2 = $this$getReferenceString.getType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.getName()");
        return ResourceUtils.getResourceUrlFromQualifiedName(string, string2);
    }

    public static final /* synthetic */ String access$getReferenceString(ResourceItem $receiver) {
        return ResourcePickerDialogKt.getReferenceString($receiver);
    }

    public static final /* synthetic */ ResourceType[] access$getSortedResourceTypes(Set originalSet) {
        return ResourcePickerDialogKt.getSortedResourceTypes(originalSet);
    }
}

