/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.model.stdui.CommonComboBoxModel;
import com.android.tools.adtui.stdui.CommonComboBox;
import com.android.tools.adtui.ui.ClickableLabel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.ui.resourcechooser.ColorResourceModel;
import com.android.tools.idea.ui.resourcechooser.ColorResourcePickerListener;
import com.android.tools.idea.ui.resourcechooser.ItemRenderer;
import com.android.tools.idea.ui.resourcechooser.MyComboBoxModel;
import com.android.tools.idea.ui.resourcechooser.ResourceCellData;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerBuilderKt;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u001bH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/ui/resourcechooser/ColorResourcePicker;", "Ljavax/swing/JPanel;", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "initialResourceReference", "Lcom/android/ide/common/rendering/api/ResourceReference;", "(Lcom/android/tools/idea/configurations/Configuration;Lcom/android/ide/common/rendering/api/ResourceReference;)V", "box", "Lcom/android/tools/adtui/stdui/CommonComboBox;", "", "Lcom/android/tools/idea/ui/resourcechooser/MyComboBoxModel;", "boxModel", "colorResourceModel", "Lcom/android/tools/idea/ui/resourcechooser/ColorResourceModel;", "list", "Lcom/intellij/ui/components/JBList;", "Lcom/android/tools/idea/ui/resourcechooser/ResourceCellData;", "listData", "Ljava/util/Vector;", "listeners", "", "Lcom/android/tools/idea/ui/resourcechooser/ColorResourcePickerListener;", "scrollView", "Ljavax/swing/JScrollPane;", "searchField", "Lcom/intellij/ui/SearchTextField;", "addColorResourcePickerListener", "", "listener", "getPreferredSize", "Ljava/awt/Dimension;", "selectAndNavigateToResourceReference", "ref", "updateListData", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nColorResourcePicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorResourcePicker.kt\ncom/android/tools/idea/ui/resourcechooser/ColorResourcePicker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1549#2:334\n1620#2,3:335\n1611#2:361\n1851#2:362\n1852#2:364\n1612#2:365\n107#3:338\n79#3,22:339\n1#4:363\n*S KotlinDebug\n*F\n+ 1 ColorResourcePicker.kt\ncom/android/tools/idea/ui/resourcechooser/ColorResourcePicker\n*L\n192#1:334\n192#1:335,3\n202#1:361\n202#1:362\n202#1:364\n202#1:365\n201#1:338\n201#1:339,22\n202#1:363\n*E\n"})
public final class ColorResourcePicker
extends JPanel {
    @NotNull
    private final ColorResourceModel colorResourceModel;
    @NotNull
    private final SearchTextField searchField;
    @NotNull
    private final JScrollPane scrollView;
    @NotNull
    private final MyComboBoxModel boxModel;
    @NotNull
    private final CommonComboBox<String, MyComboBoxModel> box;
    @NotNull
    private final JBList<ResourceCellData> list;
    @NotNull
    private final Vector<ResourceCellData> listData;
    @NotNull
    private final List<ColorResourcePickerListener> listeners;

    public ColorResourcePicker(@NotNull Configuration configuration, @Nullable ResourceReference initialResourceReference) {
        block1: {
            ClickableLabel clickableLabel;
            JPanel jPanel;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(new BorderLayout());
            this.colorResourceModel = new ColorResourceModel(configuration);
            this.searchField = new SearchTextField();
            this.list = new JBList();
            this.listData = new Vector();
            this.listeners = new ArrayList();
            JPanel boxPanel = new JPanel(new BorderLayout());
            boxPanel.setBorder(JBUI.Borders.empty((int)14));
            boxPanel.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
            SearchTextField $this$_init__u24lambda_u240 = this.searchField;
            boolean bl = false;
            $this$_init__u24lambda_u240.setPreferredSize((Dimension)new JBDimension(165, 30));
            $this$_init__u24lambda_u240.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
            $this$_init__u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)14));
            $this$_init__u24lambda_u240.addDocumentListener((DocumentListener)new DocumentAdapter(this){
                final /* synthetic */ ColorResourcePicker this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void textChanged(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ColorResourcePicker.access$updateListData(this.this$0);
                }
            });
            this.boxModel = new MyComboBoxModel(this.colorResourceModel.getCategories());
            this.box = new CommonComboBox((CommonComboBoxModel)this.boxModel);
            this.box.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    this.updateListData();
                }
            });
            this.box.setPreferredSize((Dimension)new JBDimension(105, 30));
            this.box.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
            boxPanel.add((Component)this.searchField, "West");
            boxPanel.add((Component)this.box, "Center");
            this.list.setSelectionMode(0);
            this.list.setCellRenderer((ListCellRenderer)new ItemRenderer());
            this.list.setListData(this.listData);
            this.list.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
            this.list.setBorder((Border)JBUI.Borders.empty((int)0, (int)14, (int)14, (int)14));
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public final void valueChanged(ListSelectionEvent it) {
                    int index2 = list.getSelectedIndex();
                    if (index2 < 0 || index2 >= listData.size()) {
                        return;
                    }
                    ResourceCellData selectedResource = (ResourceCellData)listData.get(index2);
                    Iterable $this$forEach$iv = listeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ColorResourcePickerListener it2 = (ColorResourcePickerListener)element$iv;
                        boolean bl = false;
                        it2.colorResourcePicked(selectedResource.getResourceReference());
                    }
                }
            });
            JBList<ResourceCellData> jBList = this.list;
            this.scrollView = (JScrollPane)new JBScrollPane(jBList){

                @NotNull
                public Dimension getPreferredSize() {
                    return (Dimension)new JBDimension(300, 400);
                }
            };
            this.add((Component)boxPanel, "North");
            this.add((Component)this.scrollView, "Center");
            this.updateListData();
            if (initialResourceReference != null) {
                this.selectAndNavigateToResourceReference(initialResourceReference);
            }
            Module module2 = configuration.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"configuration.module");
            AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)module2);
            if (androidFacet == null) break block1;
            AndroidFacet facet2 = androidFacet;
            boolean bl2 = false;
            JPanel $this$lambda_u243_u24lambda_u242 = jPanel = new JPanel(new BorderLayout());
            boolean bl3 = false;
            $this$lambda_u243_u24lambda_u242.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
            ClickableLabel $this$lambda_u243_u24lambda_u242_u24lambda_u241 = clickableLabel = new ClickableLabel("Browse");
            boolean bl4 = false;
            $this$lambda_u243_u24lambda_u242_u24lambda_u241.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
            $this$lambda_u243_u24lambda_u242_u24lambda_u241.setOpaque(false);
            $this$lambda_u243_u24lambda_u242_u24lambda_u241.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
            $this$lambda_u243_u24lambda_u242_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)7, (int)14));
            $this$lambda_u243_u24lambda_u242_u24lambda_u241.addActionListener(new ActionListener(initialResourceReference, facet2, configuration, this){
                final /* synthetic */ ResourceReference $initialResourceReference;
                final /* synthetic */ AndroidFacet $facet;
                final /* synthetic */ Configuration $configuration;
                final /* synthetic */ ColorResourcePicker this$0;
                {
                    this.$initialResourceReference = $initialResourceReference;
                    this.$facet = $facet;
                    this.$configuration = $configuration;
                    this.this$0 = $receiver;
                }

                public final void actionPerformed(ActionEvent it) {
                    block3: {
                        ResourceReference resourceReference = this.$initialResourceReference;
                        ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog("Pick a Color", resourceReference != null && (resourceReference = resourceReference.getResourceUrl()) != null ? resourceReference.toString() : null, this.$facet, SetsKt.setOf((Object)ResourceType.COLOR), ResourceType.COLOR, false, false, true, this.$configuration.getFile());
                        if (!dialog2.showAndGet()) break block3;
                        String string = dialog2.getResourceName();
                        if (string != null) {
                            ResourceReference resourceReference2;
                            String string2 = string;
                            ColorResourcePicker colorResourcePicker = this.this$0;
                            String pickedResourceName = string2;
                            boolean bl = false;
                            ResourceUrl resourceUrl = ResourceUrl.parse((String)pickedResourceName);
                            if (resourceUrl != null && (resourceReference2 = resourceUrl.resolve(ResourceNamespace.TODO(), ResourceNamespace.Resolver.EMPTY_RESOLVER)) != null) {
                                ResourceReference ref = resourceReference2;
                                boolean bl2 = false;
                                ColorResourcePicker.access$selectAndNavigateToResourceReference(colorResourcePicker, ref);
                                Iterable $this$forEach$iv = ColorResourcePicker.access$getListeners$p(colorResourcePicker);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    ColorResourcePickerListener listener2 = (ColorResourcePickerListener)element$iv;
                                    boolean bl3 = false;
                                    listener2.colorResourcePicked(ref);
                                }
                            }
                        }
                    }
                }
            });
            ClickableLabel browseLabel2 = clickableLabel;
            $this$lambda_u243_u24lambda_u242.add((Component)browseLabel2, "East");
            JPanel footerPanel2 = jPanel;
            this.add((Component)footerPanel2, "South");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void selectAndNavigateToResourceReference(ResourceReference ref) {
        void $this$mapTo$iv$iv;
        String category;
        int boxSelectedIndex;
        String string = this.colorResourceModel.findResourceCategory(ref);
        if (string == null) {
            string = (String)CollectionsKt.first(this.colorResourceModel.getCategories());
        }
        if ((boxSelectedIndex = this.boxModel.getIndexOf(category = string)) == -1) {
            return;
        }
        this.box.setSelectedIndex(boxSelectedIndex);
        Iterable $this$map$iv = this.listData;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceCellData resourceCellData = (ResourceCellData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getResourceReference());
        }
        int itemIndex = ((List)destination$iv$iv).indexOf(ref);
        if (itemIndex != -1) {
            this.list.setSelectedIndex(itemIndex);
            this.list.ensureIndexIsVisible(itemIndex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateListData() {
        void $this$mapNotNullTo$iv;
        String string;
        block8: {
            block7: {
                this.listData.clear();
                string = this.searchField.getText();
                if (string == null) break block7;
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) != null) break block8;
            }
            string = "";
        }
        String filter2 = string;
        Object object = this.box.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        Iterable iterable = this.colorResourceModel.getResourceReference((String)object, filter2);
        Collection destination$iv = this.listData;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ResourceCellData it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            ResourceReference it = (ResourceReference)element$iv;
            boolean bl3 = false;
            Color color = this.colorResourceModel.resolveColor(it);
            if ((color != null ? new ResourceCellData(it, color) : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        this.list.setListData(this.listData);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension2 = this.scrollView.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"scrollView.preferredSize");
        return dimension2;
    }

    public final void addColorResourcePickerListener(@NotNull ColorResourcePickerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public static final /* synthetic */ void access$selectAndNavigateToResourceReference(ColorResourcePicker $this, ResourceReference ref) {
        $this.selectAndNavigateToResourceReference(ref);
    }
}

