/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport.poller;

import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.idea.transport.poller.TransportEventPoller;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/transport/poller/TransportEventPoller;", "", "transportClient", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "sortOrder", "Ljava/util/Comparator;", "Lcom/android/tools/profiler/proto/Common$Event;", "Lkotlin/Comparator;", "(Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;Ljava/util/Comparator;)V", "eventListeners", "", "Lcom/android/tools/idea/transport/poller/TransportEventListener;", "listenersToLastTimestamp", "Ljava/util/concurrent/ConcurrentHashMap;", "", "writeLock", "Ljava/lang/Object;", "poll", "", "registerListener", "listener", "unregisterListener", "Companion", "intellij.android.transport"})
@SourceDebugExtension(value={"SMAP\nTransportEventPoller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportEventPoller.kt\ncom/android/tools/idea/transport/poller/TransportEventPoller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1360#3:158\n1446#3,5:159\n766#3:164\n857#3,2:165\n1851#3,2:167\n1959#3,14:169\n*S KotlinDebug\n*F\n+ 1 TransportEventPoller.kt\ncom/android/tools/idea/transport/poller/TransportEventPoller\n*L\n86#1:158\n86#1:159,5\n88#1:164\n88#1:165,2\n89#1:167,2\n99#1:169,14\n*E\n"})
public final class TransportEventPoller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub transportClient;
    @NotNull
    private final Comparator<Common.Event> sortOrder;
    @NotNull
    private final Object writeLock;
    @NotNull
    private final List<TransportEventListener> eventListeners;
    @NotNull
    private final ConcurrentHashMap<TransportEventListener, Long> listenersToLastTimestamp;
    @NotNull
    private static final ScheduledExecutorService myExecutorService;
    @NotNull
    private static final Map<TransportEventPoller, ScheduledFuture<?>> myScheduledFutures;

    public TransportEventPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, @NotNull Comparator<Common.Event> sortOrder) {
        Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
        Intrinsics.checkNotNullParameter(sortOrder, (String)"sortOrder");
        this.transportClient = transportClient;
        this.sortOrder = sortOrder;
        this.writeLock = new Object();
        this.eventListeners = new CopyOnWriteArrayList();
        this.listenersToLastTimestamp = new ConcurrentHashMap();
    }

    public /* synthetic */ TransportEventPoller(TransportServiceGrpc.TransportServiceBlockingStub transportServiceBlockingStub, Comparator comparator2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Comparator comparator3 = Comparator.comparing(1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(comparator3, (String)"comparing(Common.Event::getTimestamp)");
            comparator2 = comparator3;
        }
        this(transportServiceBlockingStub, comparator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerListener(@NotNull TransportEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl = false;
            this.eventListeners.add(listener2);
            ((Map)this.listenersToLastTimestamp).put(listener2, Long.MIN_VALUE);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterListener(@NotNull TransportEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl = false;
            this.eventListeners.remove(listener2);
            Long l = this.listenersToLastTimestamp.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void poll() {
        var2_1 = new ArrayList<E>();
        $this$poll_u24lambda_u242 = var2_1;
        $i$a$-apply-TransportEventPoller$poll$listeners$1 = false;
        $this$poll_u24lambda_u242.addAll((Collection)this.eventListeners);
        listeners = var2_1;
        for (TransportEventListener eventListener : listeners) {
            v0 = this.listenersToLastTimestamp.get(eventListener);
            if (v0 == null) {
                v0 = -9223372036854775808L;
            }
            var6_6 = ((Number)v0).longValue();
            v1 = eventListener.getStartTime();
            var8_8 = v1 != null ? ((Number)v1.invoke()).longValue() : -9223372036854775808L;
            startTimestamp = Math.max(var6_6, var8_8);
            endTimestamp = ((Number)eventListener.getEndTime().invoke()).longValue();
            builder = Transport.GetEventGroupsRequest.newBuilder().setKind(eventListener.getEventKind()).setFromTimestamp(startTimestamp).setToTimestamp(endTimestamp);
            v2 = eventListener.getStreamId();
            if (v2 != null) {
                it = ((Number)v2.invoke()).longValue();
                $i$a$-let-TransportEventPoller$poll$1 = false;
                builder.setStreamId(it);
            }
            v3 = eventListener.getProcessId();
            if (v3 != null) {
                it = ((Number)v3.invoke()).intValue();
                $i$a$-let-TransportEventPoller$poll$2 = false;
                builder.setPid(it);
            }
            v4 = eventListener.getGroupId();
            if (v4 != null) {
                it = ((Number)v4.invoke()).longValue();
                $i$a$-let-TransportEventPoller$poll$3 = false;
                builder.setGroupId(it);
            }
            if (Intrinsics.areEqual((Object)(response = this.transportClient.getEventGroups(request = builder.build())), (Object)Transport.GetEventGroupsResponse.getDefaultInstance())) continue;
            v5 = response.getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"response.groupsList");
            it = v5;
            $i$f$flatMap = false;
            var14_19 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                group = (Transport.EventGroup)element$iv$iv;
                $i$a$-flatMap-TransportEventPoller$poll$filtered$1 = false;
                v6 = group.getEventsList();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"group.eventsList");
                list$iv$iv = v6;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), this.sortOrder);
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var17_29 = $this$filterTo$iv$iv.iterator();
            while (var17_29.hasNext()) {
                element$iv$iv = var17_29.next();
                event = (Common.Event)element$iv$iv;
                $i$a$-filter-TransportEventPoller$poll$filtered$2 = false;
                if (event.getTimestamp() < startTimestamp) ** GOTO lbl-1000
                v7 = eventListener.getFilter();
                Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                if (((Boolean)v7.invoke((Object)event)).booleanValue()) {
                    v8 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v8 = false;
                }
                if (!v8) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            filtered = (List)destination$iv$iv;
            $this$forEach$iv = filtered;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                event = (Common.Event)element$iv;
                $i$a$-forEach-TransportEventPoller$poll$4 = false;
                eventListener.getExecutor().execute(new Runnable(eventListener, event, this){
                    final /* synthetic */ TransportEventListener $eventListener;
                    final /* synthetic */ Common.Event $event;
                    final /* synthetic */ TransportEventPoller this$0;
                    {
                        this.$eventListener = $eventListener;
                        this.$event = $event;
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        Function1<Common.Event, Boolean> function1 = this.$eventListener.getCallback();
                        Common.Event event2 = this.$event;
                        Intrinsics.checkNotNullExpressionValue((Object)event2, (String)"event");
                        if (((Boolean)function1.invoke((Object)event2)).booleanValue()) {
                            this.this$0.unregisterListener(this.$eventListener);
                        }
                    }
                });
            }
            $this$maxByOrNull$iv = filtered;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v9 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v9 = maxElem$iv;
                } else {
                    it = (Common.Event)maxElem$iv;
                    $i$a$-maxByOrNull-TransportEventPoller$poll$maxTimeEvent$1 = false;
                    maxValue$iv = it.getTimestamp();
                    do {
                        e$iv = iterator$iv.next();
                        it = (Common.Event)e$iv;
                        $i$a$-maxByOrNull-TransportEventPoller$poll$maxTimeEvent$1 = false;
                        v$iv = it.getTimestamp();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v9 = maxElem$iv;
                }
            }
            maxTimeEvent = v9;
            var14_19 = this.writeLock;
            synchronized (var14_19) {
                $i$a$-synchronized-TransportEventPoller$poll$5 = false;
                if (maxTimeEvent != null && this.listenersToLastTimestamp.containsKey(eventListener)) {
                    ((Map)this.listenersToLastTimestamp).put(eventListener, Math.max(startTimestamp, maxTimeEvent.getTimestamp() + 1L));
                }
                var15_24 = Unit.INSTANCE;
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder, @Nullable ScheduledExecutorService executorServiceForTest) {
        return Companion.createStartedPoller(transportClient, pollPeriodNs, sortOrder, executorServiceForTest);
    }

    @JvmStatic
    public static final void startPoller(@NotNull TransportEventPoller poller, long pollPeriodNs, @Nullable ScheduledExecutorService executorServiceForTest) {
        Companion.startPoller(poller, pollPeriodNs, executorServiceForTest);
    }

    @JvmStatic
    public static final void stopPoller(@NotNull TransportEventPoller poller) {
        Companion.stopPoller(poller);
    }

    @JvmStatic
    public static final boolean isPollerRunning(@NotNull TransportEventPoller poller) {
        return Companion.isPollerRunning(poller);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder) {
        return Companion.createStartedPoller(transportClient, pollPeriodNs, sortOrder);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs) {
        return Companion.createStartedPoller(transportClient, pollPeriodNs);
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(1)");
        myExecutorService = scheduledExecutorService;
        myScheduledFutures = new LinkedHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0007J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/transport/poller/TransportEventPoller$Companion;", "", "()V", "myExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "myScheduledFutures", "", "Lcom/android/tools/idea/transport/poller/TransportEventPoller;", "Ljava/util/concurrent/ScheduledFuture;", "createStartedPoller", "transportClient", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "pollPeriodNs", "", "sortOrder", "Ljava/util/Comparator;", "Lcom/android/tools/profiler/proto/Common$Event;", "executorServiceForTest", "isPollerRunning", "", "poller", "startPoller", "", "stopPoller", "intellij.android.transport"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder, @Nullable ScheduledExecutorService executorServiceForTest) {
            Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
            Intrinsics.checkNotNullParameter(sortOrder, (String)"sortOrder");
            TransportEventPoller poller = new TransportEventPoller(transportClient, sortOrder);
            this.startPoller(poller, pollPeriodNs, executorServiceForTest);
            return poller;
        }

        public static /* synthetic */ TransportEventPoller createStartedPoller$default(Companion companion, TransportServiceGrpc.TransportServiceBlockingStub transportServiceBlockingStub, long l, Comparator comparator2, ScheduledExecutorService scheduledExecutorService, int n, Object object) {
            if ((n & 4) != 0) {
                Comparator<Common.Event> comparator3 = Comparator.comparing(createStartedPoller.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator3, (String)"comparing(Common.Event::getTimestamp)");
                comparator2 = comparator3;
            }
            if ((n & 8) != 0) {
                scheduledExecutorService = null;
            }
            return companion.createStartedPoller(transportServiceBlockingStub, l, comparator2, scheduledExecutorService);
        }

        @JvmStatic
        public final void startPoller(@NotNull TransportEventPoller poller, long pollPeriodNs, @Nullable ScheduledExecutorService executorServiceForTest) {
            Intrinsics.checkNotNullParameter((Object)poller, (String)"poller");
            ScheduledExecutorService scheduledExecutorService = executorServiceForTest;
            if (scheduledExecutorService == null) {
                scheduledExecutorService = myExecutorService;
            }
            ScheduledFuture<?> scheduledFuture2 = scheduledExecutorService.scheduleWithFixedDelay(new Runnable(poller){
                final /* synthetic */ TransportEventPoller $poller;
                {
                    this.$poller = $poller;
                }

                public final void run() {
                    try {
                        this.$poller.poll();
                    }
                    catch (Throwable t) {
                        Logger.getInstance(TransportEventPoller.class).warn(t.toString());
                    }
                }
            }, 0L, pollPeriodNs, TimeUnit.NANOSECONDS);
            Map map2 = myScheduledFutures;
            Intrinsics.checkNotNullExpressionValue(scheduledFuture2, (String)"scheduledFuture");
            map2.put(poller, scheduledFuture2);
        }

        public static /* synthetic */ void startPoller$default(Companion companion, TransportEventPoller transportEventPoller, long l, ScheduledExecutorService scheduledExecutorService, int n, Object object) {
            if ((n & 4) != 0) {
                scheduledExecutorService = null;
            }
            companion.startPoller(transportEventPoller, l, scheduledExecutorService);
        }

        @JvmStatic
        public final void stopPoller(@NotNull TransportEventPoller poller) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)poller, (String)"poller");
                ScheduledFuture scheduledFuture2 = (ScheduledFuture)myScheduledFutures.remove(poller);
                if (scheduledFuture2 == null) break block0;
                scheduledFuture2.cancel(false);
            }
        }

        @JvmStatic
        public final boolean isPollerRunning(@NotNull TransportEventPoller poller) {
            Intrinsics.checkNotNullParameter((Object)poller, (String)"poller");
            return myScheduledFutures.containsKey(poller);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs, @NotNull Comparator<Common.Event> sortOrder) {
            Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
            Intrinsics.checkNotNullParameter(sortOrder, (String)"sortOrder");
            return com.android.tools.idea.transport.poller.TransportEventPoller$Companion.createStartedPoller$default(this, transportClient, pollPeriodNs, sortOrder, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TransportEventPoller createStartedPoller(@NotNull TransportServiceGrpc.TransportServiceBlockingStub transportClient, long pollPeriodNs) {
            Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
            return com.android.tools.idea.transport.poller.TransportEventPoller$Companion.createStartedPoller$default(this, transportClient, pollPeriodNs, null, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

