/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.inprocess.InProcessChannelBuilder;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.idea.transport.IntellijLogService;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Common;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/transport/TransportServiceImpl;", "Lcom/android/tools/idea/transport/TransportService;", "()V", "customStreamId", "Ljava/util/concurrent/atomic/AtomicInteger;", "dataStoreService", "Lcom/android/tools/datastore/DataStoreService;", "deviceManager", "Lcom/android/tools/idea/transport/TransportDeviceManager;", "logService", "Lcom/android/tools/idea/transport/IntellijLogService;", "getLogService", "()Lcom/android/tools/idea/transport/IntellijLogService;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "Lorg/jetbrains/annotations/NotNull;", "getMessageBus", "()Lcom/intellij/util/messages/MessageBus;", "streamIdToServerMap", "", "", "Lcom/android/tools/idea/transport/EventStreamServer;", "dispose", "", "registerStreamServer", "Lcom/android/tools/profiler/proto/Common$Stream;", "streamType", "Lcom/android/tools/profiler/proto/Common$Stream$Type;", "streamServer", "unregisterStreamServer", "streamId", "Companion", "intellij.android.transport"})
@SourceDebugExtension(value={"SMAP\nTransportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportServiceImpl.kt\ncom/android/tools/idea/transport/TransportServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1851#2,2:80\n*S KotlinDebug\n*F\n+ 1 TransportServiceImpl.kt\ncom/android/tools/idea/transport/TransportServiceImpl\n*L\n47#1:80,2\n*E\n"})
public final class TransportServiceImpl
implements TransportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataStoreService dataStoreService;
    @NotNull
    private final TransportDeviceManager deviceManager;
    @NotNull
    private final AtomicInteger customStreamId = new AtomicInteger();
    @NotNull
    private final Map<Long, EventStreamServer> streamIdToServerMap = new HashMap();
    @NotNull
    private final IntellijLogService logService = new IntellijLogService();
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private static final Logger logger;

    @VisibleForTesting
    public TransportServiceImpl() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getApplication().messageBus");
        this.messageBus = messageBus;
        String[] stringArray = new String[]{".android"};
        String datastoreDirectory = Paths.get(PathManager.getSystemPath(), stringArray) + File.separator;
        this.dataStoreService = new DataStoreService(TransportService.Companion.getChannelName(), datastoreDirectory, (Consumer)1.INSTANCE, (LogService)this.getLogService());
        this.dataStoreService.setNoPiiExceptionHandler((Consumer)2.INSTANCE);
        this.deviceManager = new TransportDeviceManager(this.dataStoreService, this.getMessageBus(), this);
    }

    @Override
    @NotNull
    public IntellijLogService getLogService() {
        return this.logService;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.streamIdToServerMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventStreamServer p0 = (EventStreamServer)element$iv;
            boolean bl = false;
            p0.stop();
        }
        this.streamIdToServerMap.clear();
        this.dataStoreService.shutdown();
    }

    @Override
    @NotNull
    public Common.Stream registerStreamServer(@NotNull Common.Stream.Type streamType, @NotNull EventStreamServer streamServer) {
        Intrinsics.checkNotNullParameter((Object)streamType, (String)"streamType");
        Intrinsics.checkNotNullParameter((Object)streamServer, (String)"streamServer");
        Common.Stream stream = Common.Stream.newBuilder().setStreamId((long)this.customStreamId.incrementAndGet()).setType(streamType).build();
        ManagedChannel channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)streamServer.getServerName()).usePlaintext().directExecutor()).build();
        this.dataStoreService.connect(stream, channel);
        this.streamIdToServerMap.put(stream.getStreamId(), streamServer);
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
        return stream;
    }

    @Override
    public void unregisterStreamServer(long streamId) {
        block0: {
            EventStreamServer eventStreamServer = this.streamIdToServerMap.get(streamId);
            if (eventStreamServer == null) break block0;
            EventStreamServer it = eventStreamServer;
            boolean bl = false;
            it.stop();
            this.dataStoreService.disconnect(streamId);
            this.streamIdToServerMap.remove(streamId);
        }
    }

    static {
        Logger logger2 = Logger.getInstance(TransportServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(TransportServiceImpl::class.java)");
        logger = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/transport/TransportServiceImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.transport"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

