/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.Server;
import com.android.tools.idea.io.grpc.inprocess.InProcessServerBuilder;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TransportProxy {
    private Server myProxyServer;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final ManagedChannel myTransportChannel;
    @NotNull
    private final TransportServiceProxy myProxyService;
    @NotNull
    private final LinkedBlockingDeque<Common.Event> myProxyEventQueue = new LinkedBlockingDeque();
    @NotNull
    private final Map<String, ByteString> myProxyBytesCache = Collections.synchronizedMap(new HashMap());

    public TransportProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device transportDevice, @NotNull ManagedChannel transportChannel) {
        this.myDevice = ddmlibDevice;
        this.myTransportChannel = transportChannel;
        this.myProxyService = new TransportServiceProxy(ddmlibDevice, transportDevice, transportChannel, this.myProxyEventQueue, this.myProxyBytesCache);
    }

    @NotNull
    public BlockingDeque<Common.Event> getEventQueue() {
        return this.myProxyEventQueue;
    }

    @NotNull
    public Map<String, ByteString> getBytesCache() {
        return this.myProxyBytesCache;
    }

    public void registerProxyCommandHandler(Commands.Command.CommandType commandType, ProxyCommandHandler handler2) {
        this.myProxyService.registerCommandHandler(commandType, handler2);
    }

    public void registerEventPreprocessor(TransportEventPreprocessor eventPreprocessor) {
        this.myProxyService.registerEventPreprocessor(eventPreprocessor);
    }

    public void registerDataPreprocessor(TransportBytesPreprocessor dataPreprocessor) {
        this.myProxyService.registerDataPreprocessor(dataPreprocessor);
    }

    public void initializeProxyServer(String channelName) {
        this.myProxyServer = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)channelName).addService(this.myProxyService.getServiceDefinition())).build();
    }

    public void connect() throws IOException {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyServer.start();
    }

    public void disconnect() {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyService.disconnect();
        this.myProxyServer.shutdown();
        if (!this.myTransportChannel.isShutdown()) {
            this.myTransportChannel.shutdown();
        }
        try {
            this.myTransportChannel.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public ManagedChannel getTransportChannel() {
        return this.myTransportChannel;
    }

    public static interface ProxyCommandHandler {
        public Transport.ExecuteResponse execute(Commands.Command var1);

        default public boolean shouldHandle(Commands.Command command) {
            return true;
        }
    }
}

