/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.inprocess.InProcessChannelBuilder;
import com.android.tools.idea.io.grpc.netty.NettyChannelBuilder;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.transport.FailedToStartServerException;
import com.android.tools.idea.transport.TransportClient;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.google.common.base.Charsets;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.PerfdCrashInfo;
import com.google.wireless.android.sdk.stats.TransportDaemonStartedInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public final class TransportDeviceManager
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    public static final Topic<TransportDeviceManagerListener> TOPIC = new Topic("TransportDevice", TransportDeviceManagerListener.class);
    private static final String BOOT_COMPLETE_PROPERTY = "dev.bootcomplete";
    private static final String BOOT_COMPLETE_MESSAGE = "1";
    private static final int MAX_MESSAGE_SIZE = 0x1FFFFFFF;
    private static final int DEVICE_PORT = 12389;
    public static final String DEVICE_SOCKET_NAME = "AndroidStudioTransport";
    @NotNull
    private final DataStoreService myDataStoreService;
    @NotNull
    private final MessageBus myMessageBus;
    private final Map<String, DeviceContext> mySerialToDeviceContextMap = new ConcurrentHashMap<String, DeviceContext>();

    private static Logger getLogger() {
        return Logger.getInstance(TransportDeviceManager.class);
    }

    public TransportDeviceManager(@NotNull DataStoreService dataStoreService, @NotNull MessageBus messageBus, @NotNull Disposable disposableParent) {
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.myDataStoreService = dataStoreService;
        this.myMessageBus = messageBus;
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.disconnectProxies();
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge != null) {
            for (IDevice device2 : bridge.getDevices()) {
                this.deviceConnected(device2);
            }
        } else {
            this.disconnectProxies();
        }
    }

    public void deviceConnected(IDevice device2) {
        this.mySerialToDeviceContextMap.computeIfAbsent(device2.getSerialNumber(), serial -> new DeviceContext());
        if (device2.isOnline()) {
            this.spawnTransportThread(device2);
        }
    }

    private static boolean isAtLeastO(IDevice device2) {
        return device2.getVersion().getFeatureLevel() >= 26;
    }

    public void deviceDisconnected(IDevice device2) {
        this.disconnectProxy(device2);
    }

    public void deviceChanged(IDevice device2, int changeMask) {
        if ((changeMask & 1) != 0) {
            if (device2.isOnline()) {
                this.spawnTransportThread(device2);
            } else {
                this.disconnectProxy(device2);
            }
        }
    }

    @NotNull
    private Runnable getDisconnectRunnable(@NotNull String serialNumber) {
        return () -> this.mySerialToDeviceContextMap.compute(serialNumber, (unused, context2) -> {
            assert (context2 != null);
            TransportDeviceManager.disconnect(context2, this.myDataStoreService);
            return context2;
        });
    }

    @NotNull
    private static void disconnect(@NotNull DeviceContext context2, @NotNull DataStoreService dataStoreService) {
        TransportProxy proxy = context2.myLastKnownTransportProxy;
        if (proxy != null) {
            proxy.disconnect();
        }
        context2.myLastKnownTransportProxy = null;
        if (context2.myDevice != null) {
            dataStoreService.disconnect(context2.myDevice.getDeviceId());
        }
        context2.myDevice = null;
    }

    private void disconnectProxy(IDevice device2) {
        this.mySerialToDeviceContextMap.compute(device2.getSerialNumber(), (serial, context2) -> {
            assert (context2 != null);
            if (context2.myLastKnownTransportThreadFuture != null) {
                context2.myLastKnownTransportThreadFuture.cancel(true);
                context2.myLastKnownTransportThreadFuture = null;
            }
            context2.myExecutor.execute(this.getDisconnectRunnable((String)serial));
            return context2;
        });
    }

    private void disconnectProxies() {
        this.mySerialToDeviceContextMap.forEach((serial, context2) -> {
            assert (context2 != null);
            if (context2.myLastKnownTransportThreadFuture != null) {
                context2.myLastKnownTransportThreadFuture.cancel(true);
                context2.myLastKnownTransportThreadFuture = null;
            }
            context2.myExecutor.execute(this.getDisconnectRunnable((String)serial));
        });
    }

    private void spawnTransportThread(IDevice device2) {
        TransportThread transportThread = new TransportThread(device2, this.myDataStoreService, this.myMessageBus, this.mySerialToDeviceContextMap);
        this.mySerialToDeviceContextMap.compute(device2.getSerialNumber(), (serial, context2) -> {
            assert (context2 != null && (context2.myLastKnownTransportProxy == null || context2.myLastKnownTransportProxy.getDevice() != device2));
            context2.myLastKnownTransportThreadFuture = context2.myExecutor.submit(transportThread);
            return context2;
        });
    }

    private static class DeviceContext {
        @NotNull
        public final ExecutorService myExecutor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        public TransportProxy myLastKnownTransportProxy;
        public Future<?> myLastKnownTransportThreadFuture;
        public Common.Device myDevice;
        @NotNull
        public final Set<Long> myConnectedAgents = new TreeSet<Long>();
        @NotNull
        public final Map<Long, Common.Process> myPidToProcessMap = new HashMap<Long, Common.Process>();

        private DeviceContext() {
        }
    }

    private static final class TransportThread
    implements Runnable {
        @NotNull
        private final DataStoreService myDataStore;
        @NotNull
        private final IDevice myDevice;
        @NotNull
        private final MessageBus myMessageBus;
        private volatile TransportProxy myTransportProxy;
        @NotNull
        private final Map<String, DeviceContext> mySerialToDeviceContextMap;

        private TransportThread(@NotNull IDevice device2, @NotNull DataStoreService datastore, @NotNull MessageBus messageBus, @NotNull Map<String, DeviceContext> serialToDeviceContextMap) {
            this.myDataStore = datastore;
            this.myMessageBus = messageBus;
            this.myDevice = device2;
            this.mySerialToDeviceContextMap = serialToDeviceContextMap;
        }

        @Override
        public void run() {
            Common.Device transportDevice = Common.Device.getDefaultInstance();
            try {
                if (!this.waitForBootComplete()) {
                    throw new com.android.ddmlib.TimeoutException("Timed out waiting for device to be ready.");
                }
                transportDevice = TransportServiceProxy.transportDeviceFromIDevice(this.myDevice);
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onPreTransportDaemonStart(transportDevice);
                TransportFileManager fileManager = new TransportFileManager(this.myDevice, this.myMessageBus);
                fileManager.copyFilesToDevice();
                long lastDaemonStartTime = System.currentTimeMillis();
                int attemptCounter = 0;
                boolean reconnectAgents = false;
                while (true) {
                    long currentTimeMs = System.currentTimeMillis();
                    this.reportTransportDaemonStarted(reconnectAgents, currentTimeMs - lastDaemonStartTime);
                    this.startTransportDaemon(transportDevice, reconnectAgents, attemptCounter);
                    TransportDeviceManager.getLogger().info("Daemon stopped running; will try to restart it");
                    TransportDeviceManager.disconnect(this.mySerialToDeviceContextMap.get(this.myDevice.getSerialNumber()), this.myDataStore);
                    lastDaemonStartTime = currentTimeMs;
                    ++attemptCounter;
                    Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                    reconnectAgents = true;
                }
            }
            catch (ShellCommandUnresponsiveException | SyncException e) {
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onTransportDaemonException(transportDevice, (Exception)e);
                TransportDeviceManager.getLogger().error("Error when trying to spawn Transport daemon", e);
            }
            catch (AdbCommandRejectedException | IOException e) {
                TransportDeviceManager.getLogger().warn("Error when trying to spawn Transport", e);
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onTransportDaemonException(transportDevice, (Exception)e);
            }
            catch (com.android.ddmlib.TimeoutException | InterruptedException e) {
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onTransportDaemonException(transportDevice, (Exception)e);
            }
            catch (FailedToStartServerException e) {
                TransportDeviceManager.getLogger().warn("Error when trying to spawn Transport", (Throwable)e);
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onStartTransportDaemonServerFail(transportDevice, e);
            }
            catch (RuntimeException e) {
                TransportDeviceManager.getLogger().warn("Error when trying to spawn Transport", (Throwable)e);
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onTransportDaemonException(transportDevice, e);
            }
        }

        private void startTransportDaemon(final @NotNull Common.Device transportDevice, final boolean reconnectAgents, final int attemptNumber) throws com.android.ddmlib.TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
            String command = TransportFileManager.getTransportExecutablePath() + " -config_file=" + TransportFileManager.getDaemonConfigPath();
            TransportDeviceManager.getLogger().info("[Transport]: Executing " + command);
            this.myDevice.executeShellCommand(command, new IShellOutputReceiver(){

                public void addOutput(byte[] data, int offset, int length) {
                    String startGrpcServerOutput = new String(data, offset, length, Charsets.UTF_8);
                    if (startGrpcServerOutput.contains("Perfd Segmentation Fault:")) {
                        this.reportTransportSegmentationFault(startGrpcServerOutput);
                    }
                    TransportDeviceManager.getLogger().info("[Transport]: " + startGrpcServerOutput);
                    if (!startGrpcServerOutput.startsWith("Server listening on")) {
                        if (attemptNumber >= 3) {
                            throw new FailedToStartServerException(startGrpcServerOutput);
                        }
                        return;
                    }
                    boolean[] alreadyExists = new boolean[]{false};
                    mySerialToDeviceContextMap.compute(myDevice.getSerialNumber(), (serial, context2) -> {
                        assert (context2 != null);
                        if (context2.myLastKnownTransportProxy != null) {
                            TransportDeviceManager.getLogger().info(String.format("TransportProxy was already created for device: %s", myDevice));
                            alreadyExists[0] = true;
                        }
                        return context2;
                    });
                    if (alreadyExists[0]) {
                        return;
                    }
                    try {
                        this.createTransportProxy(transportDevice);
                        if (reconnectAgents) {
                            this.reconnectAgents();
                        }
                        TransportDeviceManager.getLogger().info(String.format("TransportProxy successfully created for device: %s", myDevice));
                    }
                    catch (AdbCommandRejectedException | com.android.ddmlib.TimeoutException | IOException e) {
                        ((TransportDeviceManagerListener)myMessageBus.syncPublisher(TOPIC)).onTransportProxyCreationFail(transportDevice, (Exception)e);
                        TransportDeviceManager.getLogger().error(String.format("TransportProxy failed for device: %s", myDevice), e);
                    }
                }

                private void reconnectAgents() {
                    TransportClient client2 = new TransportClient(TransportService.getChannelName());
                    DeviceContext context2 = mySerialToDeviceContextMap.get(transportDevice.getSerial());
                    assert (context2 != null);
                    for (Long pid : context2.myConnectedAgents) {
                        Commands.Command attachCommand = Commands.Command.newBuilder().setStreamId(transportDevice.getDeviceId()).setPid(pid.intValue()).setType(Commands.Command.CommandType.ATTACH_AGENT).setAttachAgent(Commands.AttachAgent.newBuilder().setAgentLibFileName(String.format("libjvmtiagent_%s.so", context2.myPidToProcessMap.get(pid).getAbiCpuArch())).setAgentConfigPath(TransportFileManager.getAgentConfigFile()).setPackageName(context2.myPidToProcessMap.get(pid).getPackageName())).build();
                        Transport.ExecuteResponse executeResponse = client2.getTransportStub().execute(Transport.ExecuteRequest.newBuilder().setCommand(attachCommand).build());
                    }
                }

                public void flush() {
                }

                public boolean isCancelled() {
                    if (Thread.interrupted()) {
                        Thread.currentThread().interrupt();
                        return true;
                    }
                    return false;
                }
            }, 0L, null);
        }

        private void createTransportProxy(@NotNull Common.Device transportDevice) throws com.android.ddmlib.TimeoutException, AdbCommandRejectedException, IOException {
            int localPort = NetUtils.findAvailableSocketPort();
            if (localPort < 0) {
                throw new RuntimeException("Unable to find available socket port");
            }
            if (TransportDeviceManager.isAtLeastO(this.myDevice)) {
                this.myDevice.createForward(localPort, TransportDeviceManager.DEVICE_SOCKET_NAME, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
            } else {
                this.myDevice.createForward(localPort, 12389);
            }
            TransportDeviceManager.getLogger().info(String.format(Locale.US, "Port forwarding created for port: %d", localPort));
            ClassLoader stashedContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(NettyChannelBuilder.class.getClassLoader());
            ManagedChannel transportChannel = NettyChannelBuilder.forAddress((String)"localhost", (int)localPort).usePlaintext().maxInboundMessageSize(0x1FFFFFFF).build();
            Thread.currentThread().setContextClassLoader(stashedContextClassLoader);
            String channelName = this.myDevice.getSerialNumber();
            this.myTransportProxy = new TransportProxy(this.myDevice, transportDevice, transportChannel);
            ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).customizeProxyService(this.myTransportProxy);
            this.myTransportProxy.initializeProxyServer(channelName);
            try {
                this.myTransportProxy.connect();
            }
            catch (IOException exception) {
                this.myTransportProxy.disconnect();
                throw exception;
            }
            this.mySerialToDeviceContextMap.compute(this.myDevice.getSerialNumber(), (serial, context2) -> {
                assert (context2 != null);
                context2.myLastKnownTransportProxy = this.myTransportProxy;
                context2.myDevice = transportDevice;
                this.myTransportProxy.registerEventPreprocessor(new ConnectedAgentPreprossor((DeviceContext)context2));
                return context2;
            });
            ManagedChannel proxyChannel = InProcessChannelBuilder.forName((String)channelName).build();
            this.myDataStore.connect(Common.Stream.newBuilder().setStreamId(transportDevice.getDeviceId()).setType(Common.Stream.Type.DEVICE).setDevice(transportDevice).build(), proxyChannel);
        }

        private boolean waitForBootComplete() throws InterruptedException {
            int maxSeconds = 60;
            for (int i = 0; i < maxSeconds; ++i) {
                String state2 = this.myDevice.getProperty(TransportDeviceManager.BOOT_COMPLETE_PROPERTY);
                if (TransportDeviceManager.BOOT_COMPLETE_MESSAGE.equals(state2)) {
                    try {
                        this.myDevice.getAvdData().get((long)(maxSeconds - i), TimeUnit.SECONDS);
                    }
                    catch (ExecutionException | TimeoutException exception) {
                        // empty catch block
                    }
                    return true;
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            return false;
        }

        private void reportTransportSegmentationFault(String crashString) {
            PerfdCrashInfo.Builder crashInfo = PerfdCrashInfo.newBuilder();
            String[] stack = crashString.split("[:,]+");
            for (int i = 1; i < stack.length; ++i) {
                try {
                    crashInfo.addBackstackAddressList(Long.parseLong(stack[i].trim()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            AndroidStudioEvent.Builder event2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(this.myDevice)).setAndroidProfilerEvent(AndroidProfilerEvent.newBuilder().setType(AndroidProfilerEvent.Type.PERFD_CRASHED).setPerfdCrashInfo(crashInfo));
            UsageTracker.log((AndroidStudioEvent.Builder)event2);
        }

        private void reportTransportDaemonStarted(boolean isRestart, long millisecSinceLastStart) {
            TransportDaemonStartedInfo.Builder info2 = TransportDaemonStartedInfo.newBuilder().setIsRestart(isRestart);
            if (isRestart) {
                info2.setMillisecSinceLastStart(millisecSinceLastStart);
            }
            AndroidStudioEvent.Builder event2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setAndroidProfilerEvent(AndroidProfilerEvent.newBuilder().setType(AndroidProfilerEvent.Type.TRANSPORT_DAEMON_STARTED).setTransportDaemonStartedInfo(info2));
            UsageTracker.log((AndroidStudioEvent.Builder)event2);
        }
    }

    public static interface TransportDeviceManagerListener {
        public void onPreTransportDaemonStart(@NotNull Common.Device var1);

        public void onTransportDaemonException(@NotNull Common.Device var1, @NotNull Exception var2);

        public void onTransportProxyCreationFail(@NotNull Common.Device var1, @NotNull Exception var2);

        public void onStartTransportDaemonServerFail(@NotNull Common.Device var1, @NotNull FailedToStartServerException var2);

        public void customizeProxyService(@NotNull TransportProxy var1);

        public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder var1);

        public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder var1, AndroidRunConfigurationBase var2);
    }

    private static class ConnectedAgentPreprossor
    implements TransportEventPreprocessor {
        @NotNull
        private final DeviceContext myContext;

        public ConnectedAgentPreprossor(@NotNull DeviceContext context2) {
            this.myContext = context2;
        }

        @Override
        public boolean shouldPreprocess(Common.Event event2) {
            switch (event2.getKind()) {
                case AGENT: 
                case PROCESS: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterable<Common.Event> preprocessEvent(Common.Event event2) {
            switch (event2.getKind()) {
                case AGENT: {
                    if (!event2.getAgentData().getStatus().equals((Object)Common.AgentData.Status.ATTACHED)) break;
                    long pid = event2.getPid();
                    this.myContext.myConnectedAgents.add(pid);
                    break;
                }
                case PROCESS: {
                    long pid = event2.getGroupId();
                    if (event2.getProcess().hasProcessStarted()) {
                        this.myContext.myPidToProcessMap.put(pid, event2.getProcess().getProcessStarted().getProcess());
                        break;
                    }
                    this.myContext.myPidToProcessMap.remove(pid);
                    this.myContext.myConnectedAgents.remove(pid);
                    break;
                }
            }
            return Collections.emptyList();
        }
    }
}

