/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.inprocess.InProcessChannelBuilder;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TransportClient {
    private static final long SHUTDOWN_TIMEOUT_MS = 1000L;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myTransportStub;
    @NotNull
    private final ManagedChannel myChannel;

    public TransportClient(String channelName) {
        this.myChannel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)channelName).usePlaintext().directExecutor()).build();
        this.myTransportStub = TransportServiceGrpc.newBlockingStub((Channel)this.myChannel);
    }

    @NotNull
    public TransportServiceGrpc.TransportServiceBlockingStub getTransportStub() {
        return this.myTransportStub;
    }

    public void shutdown() throws InterruptedException {
        this.myChannel.shutdown();
        this.myChannel.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Transport.ExecuteResponse> executeAsync(Commands.Command command, Executor executor2) {
        return TransportClient.executeAsync(this.myTransportStub, command, executor2);
    }

    public static CompletableFuture<Transport.ExecuteResponse> executeAsync(TransportServiceGrpc.TransportServiceBlockingStub stub, Commands.Command command, Executor executor2) {
        return CompletableFuture.supplyAsync(() -> stub.execute(Transport.ExecuteRequest.newBuilder().setCommand(command).build()), executor2);
    }
}

