/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.idea.transport.Constants;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployableFile {
    @NotNull
    private final String myFileName;
    @NotNull
    private final String myReleaseDir;
    @NotNull
    private final String myDevDir;
    @Nullable
    private final String myOnDeviceAbiFileNameFormat;
    private final boolean myExecutable;
    @NotNull
    private final Supplier<Boolean> myIsRunningFromSourcesSupplier;
    @NotNull
    private final Supplier<String> myHomePathSupplier;
    @NotNull
    private final Supplier<String> mySourcesRootSupplier;

    private DeployableFile(@NotNull Builder builder2) {
        this.myFileName = builder2.myFileName;
        this.myReleaseDir = builder2.myReleaseDir;
        this.myDevDir = builder2.myDevDir;
        this.myOnDeviceAbiFileNameFormat = builder2.myOnDeviceAbiFileNameFormat;
        this.myIsRunningFromSourcesSupplier = builder2.myIsRunningFromSourcesSupplier;
        this.myHomePathSupplier = builder2.myHomePathSupplier;
        this.mySourcesRootSupplier = builder2.mySourcesRootSupplier;
        this.myExecutable = builder2.myExecutable;
    }

    @NotNull
    public String getFileName() {
        return this.myFileName;
    }

    public boolean isExecutable() {
        return this.myExecutable;
    }

    public boolean isAbiDependent() {
        return this.myOnDeviceAbiFileNameFormat != null;
    }

    @Nullable
    public String getOnDeviceAbiFileNameFormat() {
        return this.myOnDeviceAbiFileNameFormat;
    }

    @NotNull
    private File getDir(@NotNull String parent2, @NotNull String child) {
        File childFile = new File(child);
        if (childFile.isAbsolute()) {
            return childFile;
        }
        return new File(parent2, child);
    }

    @NotNull
    public File getDir() {
        if (this.myIsRunningFromSourcesSupplier.get().booleanValue()) {
            return this.getDir(this.mySourcesRootSupplier.get(), this.myDevDir);
        }
        return this.getDir(this.myHomePathSupplier.get(), this.myReleaseDir);
    }

    public static class Builder {
        @NotNull
        private final String myFileName;
        @NotNull
        private String myReleaseDir = Constants.PERFA_RELEASE_DIR;
        @NotNull
        private String myDevDir = Constants.PERFA_DEV_DIR;
        @Nullable
        private String myOnDeviceAbiFileNameFormat;
        @NotNull
        private Supplier<Boolean> myIsRunningFromSourcesSupplier = StudioPathManager::isRunningFromSources;
        @NotNull
        private Supplier<String> myHomePathSupplier = PathManager::getHomePath;
        @NotNull
        private Supplier<String> mySourcesRootSupplier = StudioPathManager::getSourcesRoot;
        private boolean myExecutable = false;

        public Builder(@NotNull String fileName) {
            this.myFileName = fileName;
        }

        @NotNull
        public Builder setReleaseDir(@NotNull String releaseDir) {
            this.myReleaseDir = releaseDir;
            return this;
        }

        @NotNull
        public Builder setDevDir(@NotNull String devDir) {
            this.myDevDir = devDir;
            return this;
        }

        @NotNull
        public Builder setExecutable(boolean executable) {
            this.myExecutable = executable;
            return this;
        }

        @NotNull
        public Builder setOnDeviceAbiFileNameFormat(@NotNull String format) {
            this.myOnDeviceAbiFileNameFormat = format;
            return this;
        }

        @VisibleForTesting
        @NotNull
        public Builder setIsRunningFromSources(boolean isRunningFromSources) {
            this.myIsRunningFromSourcesSupplier = () -> isRunningFromSources;
            return this;
        }

        @VisibleForTesting
        @NotNull
        public Builder setHomePath(String homePath) {
            this.myHomePathSupplier = () -> homePath;
            return this;
        }

        @VisibleForTesting
        @NotNull
        public Builder setSourcesRoot(String sourcesRoot) {
            this.mySourcesRootSupplier = () -> sourcesRoot;
            return this;
        }

        @NotNull
        public DeployableFile build() {
            return new DeployableFile(this);
        }
    }
}

