/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view;

import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultStats;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.BenchmarkOutput;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestResultsRow;
import java.io.File;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0017\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0016\u0010&\u001a\u00020%2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0016J\u0016\u0010'\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0016J\b\u0010(\u001a\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsRow;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "methodName", "", "className", "packageName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getMethodName", "myTestCases", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "getPackageName", "addTestCase", "", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "testCase", "getBenchmark", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/benchmark/BenchmarkOutput;", "getDuration", "Ljava/time/Duration;", "getErrorStackTrace", "getLogcat", "getResultStats", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultStats;", "devices", "", "getRetentionInfo", "Ljava/io/File;", "getRetentionSnapshot", "getStartTime", "", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;)Ljava/lang/Long;", "getTestCaseResult", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCaseResult;", "getTestResultSummary", "getTestResultSummaryText", "getTotalDuration", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidTestResultsTableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestResultsTableView.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsRow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1407:1\n1785#2,3:1408\n1785#2,3:1411\n*S KotlinDebug\n*F\n+ 1 AndroidTestResultsTableView.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsRow\n*L\n1185#1:1408,3\n1196#1:1411,3\n*E\n"})
final class AndroidTestResultsRow
extends DefaultMutableTreeNode
implements AndroidTestResults {
    @NotNull
    private final String methodName;
    @NotNull
    private final String className;
    @NotNull
    private final String packageName;
    @NotNull
    private final Map<String, AndroidTestCase> myTestCases;

    public AndroidTestResultsRow(@NotNull String methodName, @NotNull String className, @NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        this.methodName = methodName;
        this.className = className;
        this.packageName = packageName2;
        this.myTestCases = new LinkedHashMap();
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    public final void addTestCase(@NotNull AndroidDevice device2, @NotNull AndroidTestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        this.myTestCases.put(device2.getId(), testCase);
    }

    @Override
    @Nullable
    public AndroidTestCaseResult getTestCaseResult(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getResult() : null;
    }

    @Override
    @NotNull
    public String getLogcat(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getLogcat()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @Nullable
    public Long getStartTime(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getStartTimestampMillis() : null;
    }

    @Override
    @Nullable
    public Duration getDuration(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getStartTimestampMillis()) == null) {
            return null;
        }
        long start2 = (Long)object;
        Object object2 = this.myTestCases.get(device2.getId());
        long end = object2 != null && (object2 = ((AndroidTestCase)object2).getEndTimestampMillis()) != null ? (Long)object2 : System.currentTimeMillis();
        return Duration.ofMillis(Math.max(end - start2, 0L));
    }

    @Override
    @NotNull
    public Duration getTotalDuration() {
        Duration duration2 = Duration.ofMillis(SequencesKt.sumOfLong((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.myTestCases.values()), (Function1)getTotalDuration.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(myTestCases.val\u2026- start, 0L)\n    }.sum())");
        return duration2;
    }

    @Override
    @NotNull
    public String getErrorStackTrace(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getErrorStackTrace()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public BenchmarkOutput getBenchmark(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getBenchmark()) == null) {
            object = "";
        }
        return new BenchmarkOutput((String)object);
    }

    @Override
    @Nullable
    public File getRetentionInfo(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getRetentionInfo() : null;
    }

    @Override
    @Nullable
    public File getRetentionSnapshot(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getRetentionSnapshot() : null;
    }

    @Override
    @NotNull
    public AndroidTestCaseResult getTestResultSummary() {
        return AndroidTestResultsKt.getSummaryResult(this.getResultStats());
    }

    @Override
    @NotNull
    public AndroidTestCaseResult getTestResultSummary(@NotNull List<AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        return AndroidTestResultsKt.getSummaryResult(this.getResultStats(devices2));
    }

    @Override
    @NotNull
    public String getTestResultSummaryText(@NotNull List<AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        AndroidTestResultStats stats = this.getResultStats(devices2);
        return stats.getFailed() == 1 ? "Fail" : (stats.getFailed() > 0 ? "Fail (" + stats.getFailed() + ")" : (stats.getCancelled() > 0 ? "Cancelled" : (stats.getRunning() > 0 ? "Running" : (stats.getPassed() > 0 ? "Pass" : (stats.getSkipped() > 0 ? "Skip" : "")))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AndroidTestResultStats getResultStats() {
        void $this$fold$iv;
        Iterable iterable = this.myTestCases.values();
        AndroidTestResultStats initial$iv = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        boolean $i$f$fold = false;
        AndroidTestResultStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void androidTestCase;
            AndroidTestCase androidTestCase2 = (AndroidTestCase)element$iv;
            AndroidTestResultStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addTestCaseResult(androidTestCase.getResult());
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public AndroidTestResultStats getResultStats(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestResultStats stats = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        return stats.addTestCaseResult(this.getTestCaseResult(device2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AndroidTestResultStats getResultStats(@NotNull List<AndroidDevice> devices2) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Iterable iterable = devices2;
        AndroidTestResultStats initial$iv = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        boolean $i$f$fold = false;
        AndroidTestResultStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void device2;
            AndroidDevice androidDevice = (AndroidDevice)element$iv;
            AndroidTestResultStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addTestCaseResult(this.getTestCaseResult((AndroidDevice)device2));
        }
        return accumulator$iv;
    }
}

