/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.export;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsTreeNode;
import com.android.tools.idea.testartifacts.instrumented.testsuite.export.AndroidTestResultsXmlFormatter;
import com.android.tools.idea.testartifacts.instrumented.testsuite.export.ExportUtilsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsAction;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0003\u001a$\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0003\u001a`\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0007\u001a \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0003\u001a4\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012\b\u0010!\u001a\u0004\u0018\u00010\"H\u0003\u00a8\u0006#"}, d2={"createOutputText", "", "exportConfig", "Lcom/intellij/execution/testframework/export/ExportTestResultsConfiguration;", "executionDuration", "Ljava/time/Duration;", "rootResultsNode", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultsTreeNode;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "devices", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "toolWindowId", "createTransformerHandler", "Ljavax/xml/transform/sax/TransformerHandler;", "exportAndroidTestMatrixResultXmlFile", "", "project", "Lcom/intellij/openapi/project/Project;", "exportFile", "Ljava/io/File;", "onFinishedFunc", "Lkotlin/Function0;", "openEditorOrBrowser", "result", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "", "showBalloon", "type", "Lcom/intellij/openapi/ui/MessageType;", "text", "listener", "Ljavax/swing/event/HyperlinkListener;", "intellij.android.core"})
public final class ExportUtilsKt {
    @AnyThread
    public static final void exportAndroidTestMatrixResultXmlFile(@NotNull Project project, @Nullable String toolWindowId, @NotNull ExportTestResultsConfiguration exportConfig, @NotNull File exportFile, @NotNull Duration executionDuration, @NotNull AndroidTestResultsTreeNode rootResultsNode, @NotNull RunConfiguration runConfiguration, @NotNull List<AndroidDevice> devices2, @NotNull Function0<Unit> onFinishedFunc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)exportConfig, (String)"exportConfig");
        Intrinsics.checkNotNullParameter((Object)exportFile, (String)"exportFile");
        Intrinsics.checkNotNullParameter((Object)executionDuration, (String)"executionDuration");
        Intrinsics.checkNotNullParameter((Object)rootResultsNode, (String)"rootResultsNode");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Intrinsics.checkNotNullParameter(onFinishedFunc, (String)"onFinishedFunc");
        String string = ExecutionBundle.message((String)"export.test.results.task.name", (Object[])new Object[0]);
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, exportConfig, executionDuration, rootResultsNode, runConfiguration, devices2, toolWindowId, exportFile, onFinishedFunc, string, performInBackgroundOption){
            final /* synthetic */ Project $project;
            final /* synthetic */ ExportTestResultsConfiguration $exportConfig;
            final /* synthetic */ Duration $executionDuration;
            final /* synthetic */ AndroidTestResultsTreeNode $rootResultsNode;
            final /* synthetic */ RunConfiguration $runConfiguration;
            final /* synthetic */ List<AndroidDevice> $devices;
            final /* synthetic */ String $toolWindowId;
            final /* synthetic */ File $exportFile;
            final /* synthetic */ Function0<Unit> $onFinishedFunc;
            {
                this.$project = $project;
                this.$exportConfig = $exportConfig;
                this.$executionDuration = $executionDuration;
                this.$rootResultsNode = $rootResultsNode;
                this.$runConfiguration = $runConfiguration;
                this.$devices = $devices;
                this.$toolWindowId = $toolWindowId;
                this.$exportFile = $exportFile;
                this.$onFinishedFunc = $onFinishedFunc;
                super($project, $super_call_param$1, false, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                String string = ExportUtilsKt.access$createOutputText(this.$exportConfig, this.$executionDuration, this.$rootResultsNode, this.$runConfiguration, this.$devices, this.$toolWindowId);
                if (string == null) {
                    return;
                }
                String outputText = string;
                Pair pair = (Pair)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Pair<? extends VirtualFile, ? extends String>>(this.$exportFile, this, outputText){
                    final /* synthetic */ File $exportFile;
                    final /* synthetic */ exportAndroidTestMatrixResultXmlFile.2 this$0;
                    final /* synthetic */ String $outputText;
                    {
                        this.$exportFile = $exportFile;
                        this.this$0 = $receiver;
                        this.$outputText = $outputText;
                        super(0);
                    }

                    @NotNull
                    public final Pair<VirtualFile, String> invoke() {
                        File file2 = this.$exportFile;
                        exportAndroidTestMatrixResultXmlFile.2 var2_2 = this.this$0;
                        String string = this.$outputText;
                        boolean $i$f$runWriteAction = false;
                        return (Pair)ApplicationManager.getApplication().runWriteAction(new Computable(file2, var2_2, string){
                            final /* synthetic */ File $exportFile$inlined;
                            final /* synthetic */ exportAndroidTestMatrixResultXmlFile.2 this$0;
                            final /* synthetic */ String $outputText$inlined;
                            {
                                this.$exportFile$inlined = file2;
                                this.this$0 = var2_2;
                                this.$outputText$inlined = string;
                            }

                            public final T compute() {
                                Pair pair;
                                VirtualFile parent2;
                                boolean bl = false;
                                this.$exportFile$inlined.getParentFile().mkdirs();
                                VirtualFile virtualFile = parent2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.$exportFile$inlined.getParentFile());
                                if (!(virtualFile != null ? virtualFile.isValid() : false)) {
                                    Object[] objectArray = new Object[]{this.$exportFile$inlined.getPath()};
                                    Pair pair2 = new Pair(null, (Object)ExecutionBundle.message((String)"failed.to.create.output.file", (Object[])objectArray));
                                    pair = pair2;
                                } else {
                                    VirtualFile virtualFile2 = parent2.findChild(this.$exportFile$inlined.getName());
                                    if (virtualFile2 == null) {
                                        virtualFile2 = parent2.createChildData((Object)((Object)this.this$0), this.$exportFile$inlined.getName());
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"parent.findChild(exportF\u2026ta(this, exportFile.name)");
                                    VirtualFile resultFile = virtualFile2;
                                    VfsUtil.saveText((VirtualFile)resultFile, (String)this.$outputText$inlined);
                                    pair = new Pair((Object)resultFile, null);
                                }
                                return (T)pair;
                            }
                        });
                    }
                }), (int)1, null);
                VirtualFile resultFile = (VirtualFile)pair.component1();
                String errorMessage = (String)pair.component2();
                CharSequence charSequence = errorMessage;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    MessageType messageType = MessageType.ERROR;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                    Object[] objectArray = new Object[]{errorMessage};
                    String string2 = ExecutionBundle.message((String)"export.test.results.failed", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"export.test.res\u2026ts.failed\", errorMessage)");
                    ExportUtilsKt.access$showBalloon(this.$project, this.$toolWindowId, messageType, string2, null);
                    return;
                }
                if (resultFile == null) {
                    return;
                }
                if (this.$exportConfig.isOpenResults()) {
                    ExportUtilsKt.access$openEditorOrBrowser(resultFile, this.$project, this.$exportConfig.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                } else {
                    HyperlinkListener listener2 = new HyperlinkListener(resultFile, this.$project, this.$exportConfig){
                        final /* synthetic */ VirtualFile $resultFile;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ ExportTestResultsConfiguration $exportConfig;
                        {
                            this.$resultFile = $resultFile;
                            this.$project = $project;
                            this.$exportConfig = $exportConfig;
                        }

                        public final void hyperlinkUpdate(HyperlinkEvent e) {
                            if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                                ExportUtilsKt.access$openEditorOrBrowser(this.$resultFile, this.$project, this.$exportConfig.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                            }
                        }
                    };
                    MessageType messageType = MessageType.INFO;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                    Object[] objectArray = new Object[]{this.$exportFile.getName()};
                    String string3 = ExecutionBundle.message((String)"export.test.results.succeeded", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"export.test.res\u2026ceeded\", exportFile.name)");
                    ExportUtilsKt.access$showBalloon(this.$project, this.$toolWindowId, messageType, string3, listener2);
                }
            }

            public void onFinished() {
                this.$onFinishedFunc.invoke();
            }
        });
    }

    public static /* synthetic */ void exportAndroidTestMatrixResultXmlFile$default(Project project, String string, ExportTestResultsConfiguration exportTestResultsConfiguration, File file2, Duration duration2, AndroidTestResultsTreeNode androidTestResultsTreeNode, RunConfiguration runConfiguration, List list2, Function0 function0, int n, Object object) {
        if ((n & 0x100) != 0) {
            function0 = exportAndroidTestMatrixResultXmlFile.1.INSTANCE;
        }
        ExportUtilsKt.exportAndroidTestMatrixResultXmlFile(project, string, exportTestResultsConfiguration, file2, duration2, androidTestResultsTreeNode, runConfiguration, list2, (Function0<Unit>)function0);
    }

    @WorkerThread
    private static final String createOutputText(ExportTestResultsConfiguration exportConfig, Duration executionDuration, AndroidTestResultsTreeNode rootResultsNode, RunConfiguration runConfiguration, List<AndroidDevice> devices2, String toolWindowId) {
        TransformerHandler transformerHandler = ExportUtilsKt.createTransformerHandler(exportConfig, runConfiguration, toolWindowId);
        if (transformerHandler == null) {
            return null;
        }
        TransformerHandler transformerHandler2 = transformerHandler;
        StringWriter writer2 = new StringWriter();
        transformerHandler2.setResult(new StreamResult(writer2));
        new AndroidTestResultsXmlFormatter(executionDuration, rootResultsNode, devices2, runConfiguration, transformerHandler2, null, 32, null).execute();
        return writer2.toString();
    }

    @WorkerThread
    private static final TransformerHandler createTransformerHandler(ExportTestResultsConfiguration exportConfig, RunConfiguration runConfiguration, String toolWindowId) {
        TransformerHandler transformerHandler;
        TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
        Intrinsics.checkNotNull((Object)transformerFactory, (String)"null cannot be cast to non-null type javax.xml.transform.sax.SAXTransformerFactory");
        SAXTransformerFactory transformerFactory2 = (SAXTransformerFactory)transformerFactory;
        ExportTestResultsConfiguration.ExportFormat exportFormat = exportConfig.getExportFormat();
        switch (exportFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[exportFormat.ordinal()]) {
            case 1: {
                Transformer transformer;
                TransformerHandler transformerHandler2;
                TransformerHandler $this$createTransformerHandler_u24lambda_u241 = transformerHandler2 = transformerFactory2.newTransformerHandler();
                boolean bl = false;
                Transformer $this$createTransformerHandler_u24lambda_u241_u24lambda_u240 = transformer = $this$createTransformerHandler_u24lambda_u241.getTransformer();
                boolean bl2 = false;
                $this$createTransformerHandler_u24lambda_u241_u24lambda_u240.setOutputProperty("indent", "yes");
                $this$createTransformerHandler_u24lambda_u241_u24lambda_u240.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformerHandler = transformerHandler2;
                break;
            }
            case 2: {
                Transformer transformer;
                TransformerHandler transformerHandler3;
                StreamSource xslSource = new StreamSource(URLUtil.openStream((URL)ExportTestResultsAction.class.getResource("intellij-export.xsl")));
                TransformerHandler $this$createTransformerHandler_u24lambda_u243 = transformerHandler3 = transformerFactory2.newTransformerHandler(xslSource);
                boolean bl = false;
                Transformer $this$createTransformerHandler_u24lambda_u243_u24lambda_u242 = transformer = $this$createTransformerHandler_u24lambda_u243.getTransformer();
                boolean bl3 = false;
                Object[] objectArray = new Object[]{runConfiguration.getName(), runConfiguration.getType().getDisplayName()};
                $this$createTransformerHandler_u24lambda_u243_u24lambda_u242.setParameter("TITLE", ExecutionBundle.message((String)"export.test.results.filename", (Object[])objectArray));
                transformerHandler = transformerHandler3;
                break;
            }
            default: {
                Transformer transformer;
                TransformerHandler transformerHandler4;
                File xslFile = new File(exportConfig.getUserTemplatePath());
                if (!xslFile.isFile()) {
                    Project project = runConfiguration.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runConfiguration.project");
                    MessageType messageType = MessageType.ERROR;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                    Object[] $this$createTransformerHandler_u24lambda_u243 = new Object[]{xslFile.getPath()};
                    String string = ExecutionBundle.message((String)"export.test.results.custom.template.not.found", (Object[])$this$createTransformerHandler_u24lambda_u243);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"export.test.res\u2026not.found\", xslFile.path)");
                    ExportUtilsKt.showBalloon(project, toolWindowId, messageType, string, null);
                    return null;
                }
                TransformerHandler $this$createTransformerHandler_u24lambda_u245 = transformerHandler4 = transformerFactory2.newTransformerHandler(new StreamSource(xslFile));
                boolean bl = false;
                Transformer $this$createTransformerHandler_u24lambda_u245_u24lambda_u244 = transformer = $this$createTransformerHandler_u24lambda_u245.getTransformer();
                boolean bl4 = false;
                Object[] objectArray = new Object[]{runConfiguration.getName(), runConfiguration.getType().getDisplayName()};
                $this$createTransformerHandler_u24lambda_u245_u24lambda_u244.setParameter("TITLE", ExecutionBundle.message((String)"export.test.results.filename", (Object[])objectArray));
                transformerHandler = transformerHandler4;
            }
        }
        return transformerHandler;
    }

    @AnyThread
    private static final void showBalloon(Project project, String toolWindowId, MessageType type, String text2, HyperlinkListener listener2) {
        String string = toolWindowId;
        if (string == null) {
            return;
        }
        String toolWindowId2 = string;
        ApplicationManager.getApplication().invokeLater(new Runnable(project, toolWindowId2, type, text2, listener2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $toolWindowId;
            final /* synthetic */ MessageType $type;
            final /* synthetic */ String $text;
            final /* synthetic */ HyperlinkListener $listener;
            {
                this.$project = $project;
                this.$toolWindowId = $toolWindowId;
                this.$type = $type;
                this.$text = $text;
                this.$listener = $listener;
            }

            public final void run() {
                if (this.$project.isDisposed()) {
                    return;
                }
                if (ToolWindowManager.Companion.getInstance(this.$project).getToolWindow(this.$toolWindowId) != null) {
                    ToolWindowManager.Companion.getInstance(this.$project).notifyByBalloon(this.$toolWindowId, this.$type, this.$text, null, this.$listener);
                }
            }
        });
    }

    @UiThread
    private static final void openEditorOrBrowser(VirtualFile result2, Project project, boolean editor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(editor, project, result2){
            final /* synthetic */ boolean $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $result;
            {
                this.$editor = $editor;
                this.$project = $project;
                this.$result = $result;
            }

            public final void run() {
                if (this.$editor) {
                    FileEditorManager.getInstance((Project)this.$project).openFile(this.$result, true);
                } else {
                    BrowserUtil.browse((VirtualFile)this.$result);
                }
            }
        });
    }

    public static final /* synthetic */ String access$createOutputText(ExportTestResultsConfiguration exportConfig, Duration executionDuration, AndroidTestResultsTreeNode rootResultsNode, RunConfiguration runConfiguration, List devices2, String toolWindowId) {
        return ExportUtilsKt.createOutputText(exportConfig, executionDuration, rootResultsNode, runConfiguration, devices2, toolWindowId);
    }

    public static final /* synthetic */ void access$showBalloon(Project project, String toolWindowId, MessageType type, String text2, HyperlinkListener listener2) {
        ExportUtilsKt.showBalloon(project, toolWindowId, type, text2, listener2);
    }

    public static final /* synthetic */ void access$openEditorOrBrowser(VirtualFile result2, Project project, boolean editor) {
        ExportUtilsKt.openEditorOrBrowser(result2, project, editor);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExportTestResultsConfiguration.ExportFormat.values().length];
            try {
                nArray[ExportTestResultsConfiguration.ExportFormat.Xml.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportTestResultsConfiguration.ExportFormat.BundledTemplate.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

