/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.ArtifactFileResolver;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDeviceType;
import com.android.tools.utp.plugins.host.device.info.proto.AndroidTestDeviceInfoProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/AndroidDeviceResolver;", "", "artifactFileResolver", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;)V", "deviceMap", "", "Ljava/io/File;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "createAndroidDevice", "deviceInfo", "Lcom/android/tools/utp/plugins/host/device/info/proto/AndroidTestDeviceInfoProto$AndroidTestDeviceInfo;", "getAndroidDevice", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "displayName", "", "Companion", "intellij.android.core"})
final class AndroidDeviceResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArtifactFileResolver artifactFileResolver;
    @NotNull
    private final Map<File, AndroidDevice> deviceMap;
    @NotNull
    private static final String DEFAULT_DEVICE_NAME = "Unknown device";
    @NotNull
    private static final AndroidDeviceType DEFAULT_DEVICE_TYPE = AndroidDeviceType.LOCAL_PHYSICAL_DEVICE;
    @NotNull
    private static final AndroidDevice DEFAULT_ANDROID_DEVICE;

    public AndroidDeviceResolver(@NotNull ArtifactFileResolver artifactFileResolver) {
        Intrinsics.checkNotNullParameter((Object)artifactFileResolver, (String)"artifactFileResolver");
        this.artifactFileResolver = artifactFileResolver;
        this.deviceMap = new LinkedHashMap();
    }

    @NotNull
    public final AndroidDevice getAndroidDevice(@NotNull TestResultProto.TestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        File file2 = ArtifactFileResolver.getArtifactFile$default(this.artifactFileResolver, testResult, "device-info", null, 4, null);
        if (file2 == null) {
            return DEFAULT_ANDROID_DEVICE;
        }
        File resolvedFile = file2;
        AndroidDevice androidDevice = this.deviceMap.computeIfAbsent(resolvedFile, new Function(resolvedFile, this){
            final /* synthetic */ File $resolvedFile;
            final /* synthetic */ AndroidDeviceResolver this$0;
            {
                this.$resolvedFile = $resolvedFile;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final AndroidDevice apply(@NotNull File it) {
                AndroidTestDeviceInfoProto.AndroidTestDeviceInfo androidTestDeviceInfo;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Closeable closeable = new FileInputStream(this.$resolvedFile);
                Throwable throwable = null;
                try {
                    FileInputStream inputStream = (FileInputStream)closeable;
                    boolean bl = false;
                    androidTestDeviceInfo = AndroidTestDeviceInfoProto.AndroidTestDeviceInfo.parseFrom((InputStream)inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                AndroidTestDeviceInfoProto.AndroidTestDeviceInfo deviceInfo = androidTestDeviceInfo;
                Intrinsics.checkNotNullExpressionValue((Object)deviceInfo, (String)"deviceInfo");
                return AndroidDeviceResolver.access$createAndroidDevice(this.this$0, deviceInfo);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)androidDevice, (String)"fun getAndroidDevice(tes\u2026ice(deviceInfo)\n    }\n  }");
        return androidDevice;
    }

    private final AndroidDevice createAndroidDevice(AndroidTestDeviceInfoProto.AndroidTestDeviceInfo deviceInfo) {
        String string;
        String string2;
        Map<String, String> map2;
        AndroidDevice androidDevice;
        AndroidDeviceType androidDeviceType;
        String string3 = deviceInfo.getAvdName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"deviceInfo.avdName");
        if (((CharSequence)string3).length() == 0) {
            androidDeviceType = AndroidDeviceType.LOCAL_PHYSICAL_DEVICE;
        } else {
            String string4 = deviceInfo.getGradleDslDeviceName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"deviceInfo.gradleDslDeviceName");
            androidDeviceType = ((CharSequence)string4).length() == 0 ? AndroidDeviceType.LOCAL_EMULATOR : AndroidDeviceType.LOCAL_GRADLE_MANAGED_EMULATOR;
        }
        AndroidDeviceType deviceType = androidDeviceType;
        String string5 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"randomUUID().toString()");
        String string6 = this.displayName(deviceInfo);
        String string7 = deviceInfo.getAvdName();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"deviceInfo.avdName");
        AndroidDevice $this$createAndroidDevice_u24lambda_u240 = androidDevice = new AndroidDevice(string5, string6, string7, deviceType, new AndroidVersion(deviceInfo.getApiLevel()), null, 32, null);
        boolean bl = false;
        String string8 = deviceInfo.getManufacturer();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"deviceInfo.manufacturer");
        if (!StringsKt.isBlank((CharSequence)string8)) {
            map2 = $this$createAndroidDevice_u24lambda_u240.getAdditionalInfo();
            string2 = "Manufacturer";
            String string9 = deviceInfo.getManufacturer();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"deviceInfo.manufacturer");
            string = string9;
            map2.put(string2, string);
        }
        String string10 = deviceInfo.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"deviceInfo.model");
        if (!StringsKt.isBlank((CharSequence)string10)) {
            map2 = $this$createAndroidDevice_u24lambda_u240.getAdditionalInfo();
            string2 = "Model";
            String string11 = deviceInfo.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"deviceInfo.model");
            string = string11;
            map2.put(string2, string);
        }
        if (deviceInfo.getProcessorsCount() > 0) {
            map2 = $this$createAndroidDevice_u24lambda_u240.getAdditionalInfo();
            string2 = "Processor";
            ProtocolStringList protocolStringList = deviceInfo.getProcessorsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"deviceInfo.processorsList");
            string = CollectionsKt.joinToString$default((Iterable)((Iterable)protocolStringList), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            map2.put(string2, string);
        }
        if (deviceInfo.getRamInBytes() > 0L) {
            map2 = $this$createAndroidDevice_u24lambda_u240.getAdditionalInfo();
            string2 = "RAM";
            String string12 = "%.1f GB";
            Object[] objectArray = new Object[]{Float.valueOf((float)deviceInfo.getRamInBytes() / (float)1000 / (float)1000 / (float)1000)};
            String string13 = String.format(string12, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(format, *args)");
            string = string13;
            map2.put(string2, string);
        }
        return androidDevice;
    }

    private final String displayName(AndroidTestDeviceInfoProto.AndroidTestDeviceInfo $this$displayName) {
        Object object;
        String string = $this$displayName.getGradleDslDeviceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleDslDeviceName");
        if (((CharSequence)string).length() > 0) {
            object = "Gradle:" + $this$displayName.getGradleDslDeviceName();
        } else {
            String string2 = $this$displayName.getName();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      name\n    }");
        }
        return object;
    }

    public static final /* synthetic */ AndroidDevice access$createAndroidDevice(AndroidDeviceResolver $this, AndroidTestDeviceInfoProto.AndroidTestDeviceInfo deviceInfo) {
        return $this.createAndroidDevice(deviceInfo);
    }

    static {
        AndroidVersion androidVersion = AndroidVersion.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"DEFAULT");
        DEFAULT_ANDROID_DEVICE = new AndroidDevice(DEFAULT_DEVICE_NAME, DEFAULT_DEVICE_NAME, DEFAULT_DEVICE_NAME, DEFAULT_DEVICE_TYPE, androidVersion, null, 32, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/AndroidDeviceResolver$Companion;", "", "()V", "DEFAULT_ANDROID_DEVICE", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "DEFAULT_DEVICE_NAME", "", "DEFAULT_DEVICE_TYPE", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDeviceType;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

