/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.ui.ConsoleView;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AndroidTestListener
implements ITestRunListener {
    private static final String DISPLAY_PREFIX = "android.studio.display.";
    @NotNull
    private final ConsoleView myConsole;
    private long myTestStartingTime;
    private long myTestSuiteStartingTime;
    private String myTestClassName = null;

    public AndroidTestListener(@NotNull ConsoleView consoleView) {
        this.myConsole = consoleView;
    }

    public void testRunStopped(long elapsedTime) {
        ExecutionUtils.printlnError(this.myConsole, "Test run stopped.\n");
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.myTestClassName != null) {
            this.testSuiteFinished();
        }
        ExecutionUtils.println(this.myConsole, "Tests ran to completion.");
    }

    public void testRunFailed(String errorMessage) {
        ExecutionUtils.printlnError(this.myConsole, "Test running failed: " + errorMessage);
    }

    public void testRunStarted(String runName, int testCount) {
        ExecutionUtils.println(this.myConsole, "Started running tests");
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("enteredTheMatrix");
        ExecutionUtils.println(this.myConsole, builder2.toString());
    }

    public void testStarted(TestIdentifier test) {
        if (!Objects.equals(test.getClassName(), this.myTestClassName)) {
            if (this.myTestClassName != null) {
                this.testSuiteFinished();
            }
            this.myTestClassName = test.getClassName();
            this.testSuiteStarted();
        }
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testStarted");
        builder2.addAttribute("name", test.getTestName());
        builder2.addAttribute("locationHint", "android://" + test.getClassName() + "." + test.getTestName() + "()");
        ExecutionUtils.println(this.myConsole, builder2.toString());
        this.myTestStartingTime = System.currentTimeMillis();
    }

    private void testSuiteStarted() {
        this.myTestSuiteStartingTime = System.currentTimeMillis();
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testSuiteStarted");
        builder2.addAttribute("name", this.myTestClassName);
        builder2.addAttribute("locationHint", "android://" + this.myTestClassName);
        ExecutionUtils.println(this.myConsole, builder2.toString());
    }

    private void testSuiteFinished() {
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testSuiteFinished");
        builder2.addAttribute("name", this.myTestClassName);
        builder2.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestSuiteStartingTime));
        ExecutionUtils.println(this.myConsole, builder2.toString());
        this.myTestClassName = null;
    }

    public void testFailed(TestIdentifier test, String stackTrace) {
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testFailed");
        builder2.addAttribute("name", test.getTestName());
        builder2.addAttribute("message", "");
        builder2.addAttribute("details", stackTrace);
        builder2.addAttribute("error", "true");
        ExecutionUtils.println(this.myConsole, builder2.toString());
    }

    public void testAssumptionFailure(TestIdentifier test, String trace) {
        ServiceMessageBuilder builder2 = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        builder2.addAttribute("message", "Test ignored. Assumption Failed:");
        builder2.addAttribute("details", trace);
        ExecutionUtils.println(this.myConsole, builder2.toString());
    }

    public void testIgnored(TestIdentifier test) {
        ServiceMessageBuilder builder2 = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        ExecutionUtils.println(this.myConsole, builder2.toString());
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        if (((Boolean)StudioFlags.PRINT_INSTRUMENTATION_STATUS.get()).booleanValue()) {
            for (Map.Entry<String, String> entry : testMetrics.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(DISPLAY_PREFIX)) continue;
                ExecutionUtils.println(this.myConsole, key.substring(DISPLAY_PREFIX.length()) + ": " + entry.getValue());
            }
        }
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testFinished");
        builder2.addAttribute("name", test.getTestName());
        builder2.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestStartingTime));
        ExecutionUtils.println(this.myConsole, builder2.toString());
    }
}

