/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.actions;

import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.FutureStreamObserver;
import com.android.tools.idea.streaming.emulator.SkinDefinition;
import com.android.tools.idea.streaming.emulator.SkinLayout;
import com.android.tools.idea.streaming.emulator.actions.AbstractEmulatorAction;
import com.android.tools.idea.streaming.emulator.actions.AbstractEmulatorActionKt;
import com.android.tools.idea.streaming.emulator.actions.EmulatorScreenshotActionKt;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotPostprocessor;
import com.android.tools.idea.ui.screenshot.ScreenshotSupplier;
import com.android.tools.idea.ui.screenshot.ScreenshotViewer;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/emulator/actions/EmulatorScreenshotAction;", "Lcom/android/tools/idea/streaming/emulator/actions/AbstractEmulatorAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "MyScreenshotPostprocessor", "MyScreenshotSupplier", "ScreenshotReceiver", "intellij.android.streaming"})
public final class EmulatorScreenshotAction
extends AbstractEmulatorAction {
    public EmulatorScreenshotAction() {
        super(null, 1, null);
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Object object = event2.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event2);
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulatorController2 = emulatorController;
        ImageFormat imageFormat = EmulatorScreenshotActionKt.access$pngFormat();
        Intrinsics.checkNotNullExpressionValue((Object)imageFormat, (String)"pngFormat()");
        emulatorController2.getScreenshot(imageFormat, (StreamObserver<Image>)((StreamObserver)new ScreenshotReceiver(emulatorController2, project)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/streaming/emulator/actions/EmulatorScreenshotAction$MyScreenshotPostprocessor;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "skinDefinition", "Lcom/android/tools/idea/streaming/emulator/SkinDefinition;", "(Lcom/android/tools/idea/streaming/emulator/SkinDefinition;)V", "canClipToDisplayShape", "", "getCanClipToDisplayShape", "()Z", "getSkinDefinition", "()Lcom/android/tools/idea/streaming/emulator/SkinDefinition;", "addFrame", "Ljava/awt/image/BufferedImage;", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "framingOption", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "backgroundColor", "Ljava/awt/Color;", "intellij.android.streaming"})
    private static final class MyScreenshotPostprocessor
    implements ScreenshotPostprocessor {
        @NotNull
        private final SkinDefinition skinDefinition;

        public MyScreenshotPostprocessor(@NotNull SkinDefinition skinDefinition) {
            Intrinsics.checkNotNullParameter((Object)skinDefinition, (String)"skinDefinition");
            this.skinDefinition = skinDefinition;
        }

        @NotNull
        public final SkinDefinition getSkinDefinition() {
            return this.skinDefinition;
        }

        @Override
        @NotNull
        public BufferedImage addFrame(@NotNull ScreenshotImage screenshotImage, @Nullable FramingOption framingOption, @Nullable Color backgroundColor) {
            Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
            BufferedImage image = screenshotImage.getImage();
            int w = image.getWidth();
            int h = image.getHeight();
            SkinLayout skin = this.skinDefinition.createScaledLayout(w, h, screenshotImage.getScreenshotRotationQuadrants());
            if (framingOption == null) {
                BufferedImage result2 = new BufferedImage(w, h, 2);
                Graphics2D graphics = result2.createGraphics();
                graphics.drawImage(image, null, 0, 0);
                graphics.setComposite(AlphaComposite.getInstance(8));
                Rectangle displayRectangle = new Rectangle(0, 0, w, h);
                Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"graphics");
                skin.drawFrameAndMask(graphics, displayRectangle);
                if (backgroundColor != null) {
                    graphics.setColor(backgroundColor);
                    graphics.setComposite(AlphaComposite.getInstance(4));
                    graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
                }
                graphics.dispose();
                return result2;
            }
            Rectangle frameRectangle = skin.getFrameRectangle();
            BufferedImage result3 = new BufferedImage(frameRectangle.width, frameRectangle.height, 2);
            Graphics2D graphics = result3.createGraphics();
            Rectangle displayRectangle = new Rectangle(-frameRectangle.x, -frameRectangle.y, w, h);
            graphics.drawImage(image, null, displayRectangle.x, displayRectangle.y);
            Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"graphics");
            skin.drawFrameAndMask(graphics, displayRectangle);
            graphics.dispose();
            return result3;
        }

        @Override
        public boolean getCanClipToDisplayShape() {
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/streaming/emulator/actions/EmulatorScreenshotAction$MyScreenshotSupplier;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotSupplier;", "emulatorController", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "getEmulatorController", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "captureScreenshot", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "intellij.android.streaming"})
    private static final class MyScreenshotSupplier
    implements ScreenshotSupplier {
        @NotNull
        private final EmulatorController emulatorController;

        public MyScreenshotSupplier(@NotNull EmulatorController emulatorController) {
            Intrinsics.checkNotNullParameter((Object)emulatorController, (String)"emulatorController");
            this.emulatorController = emulatorController;
        }

        @NotNull
        public final EmulatorController getEmulatorController() {
            return this.emulatorController;
        }

        @Override
        @NotNull
        public ScreenshotImage captureScreenshot() {
            FutureStreamObserver receiver2 = new FutureStreamObserver();
            ImageFormat imageFormat = EmulatorScreenshotActionKt.access$pngFormat();
            Intrinsics.checkNotNullExpressionValue((Object)imageFormat, (String)"pngFormat()");
            this.emulatorController.getScreenshot(imageFormat, receiver2);
            try {
                Image screenshot = (Image)receiver2.getFutureResult().get();
                BufferedImage bufferedImage = ImageIO.read(screenshot.getImage().newInput());
                if (bufferedImage == null) {
                    throw new RuntimeException("Corrupted screenshot image");
                }
                BufferedImage image = bufferedImage;
                return new ScreenshotImage(image, screenshot.getFormat().getRotation().getRotationValue(), EmulatorScreenshotActionKt.access$deviceType(this.emulatorController), null, 8, null);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                Throwables.throwIfUnchecked((Throwable)throwable);
                Throwable throwable2 = e.getCause();
                Intrinsics.checkNotNull((Object)throwable2);
                throw new UncheckedExecutionException(throwable2);
            }
            catch (UncheckedExecutionException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw e;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J \u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J2\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/streaming/emulator/actions/EmulatorScreenshotAction$ScreenshotReceiver;", "Lcom/android/tools/idea/streaming/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/Image;", "emulatorController", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/intellij/openapi/project/Project;)V", "getEmulatorController", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "getProject", "()Lcom/intellij/openapi/project/Project;", "onNext", "", "response", "showScreenshotViewer", "screenshot", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "backingFile", "Ljava/nio/file/Path;", "screenshotSupplier", "Lcom/android/tools/idea/ui/screenshot/ScreenshotSupplier;", "screenshotPostprocessor", "Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorScreenshotAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorScreenshotAction.kt\ncom/android/tools/idea/streaming/emulator/actions/EmulatorScreenshotAction$ScreenshotReceiver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,195:1\n1#2:196\n8#3:197\n*S KotlinDebug\n*F\n+ 1 EmulatorScreenshotAction.kt\ncom/android/tools/idea/streaming/emulator/actions/EmulatorScreenshotAction$ScreenshotReceiver\n*L\n93#1:197\n*E\n"})
    private static final class ScreenshotReceiver
    extends EmptyStreamObserver<Image> {
        @NotNull
        private final EmulatorController emulatorController;
        @NotNull
        private final Project project;

        public ScreenshotReceiver(@NotNull EmulatorController emulatorController, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)emulatorController, (String)"emulatorController");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.emulatorController = emulatorController;
            this.project = project;
        }

        @NotNull
        public final EmulatorController getEmulatorController() {
            return this.emulatorController;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void onNext(@NotNull Image response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Unit>(this, response2){
                final /* synthetic */ ScreenshotReceiver this$0;
                final /* synthetic */ Image $response;
                {
                    this.this$0 = $receiver;
                    this.$response = $response;
                    super(0);
                }

                public final void invoke() {
                    ScreenshotReceiver.access$showScreenshotViewer(this.this$0, this.$response, this.this$0.getEmulatorController(), this.this$0.getProject());
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void showScreenshotViewer(Image screenshot, EmulatorController emulatorController, Project project) {
            try {
                MyScreenshotPostprocessor myScreenshotPostprocessor;
                ByteString imageBytes = screenshot.getImage();
                BufferedImage bufferedImage = ImageIO.read(imageBytes.newInput());
                if (bufferedImage == null) {
                    throw new IIOException("Corrupted screenshot image");
                }
                BufferedImage image = bufferedImage;
                Path backingFile = FileUtil.createTempFile((String)"screenshot", (String)".png").toPath();
                Closeable closeable = Files.newOutputStream(backingFile, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl = false;
                    imageBytes.writeTo(it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                ScreenshotImage screenshotImage = new ScreenshotImage(image, screenshot.getFormat().getRotation().getRotationValue(), EmulatorScreenshotActionKt.access$deviceType(emulatorController), null, 8, null);
                MyScreenshotSupplier screenshotSupplier = new MyScreenshotSupplier(emulatorController);
                SkinDefinition skinDefinition = emulatorController.getSkinDefinition$intellij_android_streaming();
                if (skinDefinition != null) {
                    SkinDefinition it = skinDefinition;
                    boolean bl = false;
                    myScreenshotPostprocessor = new MyScreenshotPostprocessor(it);
                } else {
                    myScreenshotPostprocessor = null;
                }
                MyScreenshotPostprocessor screenshotFramer = myScreenshotPostprocessor;
                ApplicationManager.getApplication().invokeLater(new Runnable(this, project, screenshotImage, backingFile, screenshotSupplier, screenshotFramer){
                    final /* synthetic */ ScreenshotReceiver this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ScreenshotImage $screenshotImage;
                    final /* synthetic */ Path $backingFile;
                    final /* synthetic */ MyScreenshotSupplier $screenshotSupplier;
                    final /* synthetic */ MyScreenshotPostprocessor $screenshotFramer;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$screenshotImage = $screenshotImage;
                        this.$backingFile = $backingFile;
                        this.$screenshotSupplier = $screenshotSupplier;
                        this.$screenshotFramer = $screenshotFramer;
                    }

                    public final void run() {
                        Path path2 = this.$backingFile;
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"backingFile");
                        ScreenshotReceiver.access$showScreenshotViewer(this.this$0, this.$project, this.$screenshotImage, path2, this.$screenshotSupplier, this.$screenshotFramer);
                    }
                });
            }
            catch (Exception e) {
                ScreenshotReceiver $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(ScreenshotReceiver.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.error("Error while displaying screenshot viewer: ", (Throwable)e);
            }
        }

        private final void showScreenshotViewer(Project project, ScreenshotImage screenshotImage, Path backingFile, ScreenshotSupplier screenshotSupplier, ScreenshotPostprocessor screenshotPostprocessor) {
            List list2 = CollectionsKt.listOf((Object)EmulatorScreenshotActionKt.access$getAvdFrame$p());
            EnumSet<ScreenshotViewer.Option> enumSet = EnumSet.noneOf(ScreenshotViewer.Option.class);
            ScreenshotViewer viewer2 = new ScreenshotViewer(project, screenshotImage, backingFile, screenshotSupplier, screenshotPostprocessor, list2, enumSet){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super($project, $screenshotImage, $backingFile, $screenshotSupplier, $screenshotPostprocessor, $super_call_param$1, 0, (Set<ScreenshotViewer.Option>)$super_call_param$2);
                }

                protected void doOKAction() {
                    block1: {
                        super.doOKAction();
                        Path path2 = this.getScreenshot();
                        if (path2 == null) break block1;
                        Path path3 = path2;
                        Project project = this.$project;
                        Path it = path3;
                        boolean bl = false;
                        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(it);
                        if (virtualFile != null) {
                            VirtualFile virtualFile2 = virtualFile;
                            boolean bl2 = false;
                            virtualFile2.refresh(false, false);
                            FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
                        }
                    }
                }
            };
            viewer2.show();
        }

        public static final /* synthetic */ void access$showScreenshotViewer(ScreenshotReceiver $this, Image screenshot, EmulatorController emulatorController, Project project) {
            $this.showScreenshotViewer(screenshot, emulatorController, project);
        }

        public static final /* synthetic */ void access$showScreenshotViewer(ScreenshotReceiver $this, Project project, ScreenshotImage screenshotImage, Path backingFile, ScreenshotSupplier screenshotSupplier, ScreenshotPostprocessor screenshotPostprocessor) {
            $this.showScreenshotViewer(project, screenshotImage, backingFile, screenshotSupplier, screenshotPostprocessor);
        }
    }
}

