/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.tools.idea.streaming.emulator.LayoutNode;
import com.android.tools.idea.streaming.emulator.MultiDisplayLayoutOptimizerKt;
import com.android.tools.idea.streaming.emulator.SplitType;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/streaming/emulator/SplitNode;", "Lcom/android/tools/idea/streaming/emulator/LayoutNode;", "splitType", "Lcom/android/tools/idea/streaming/emulator/SplitType;", "firstChild", "secondChild", "(Lcom/android/tools/idea/streaming/emulator/SplitType;Lcom/android/tools/idea/streaming/emulator/LayoutNode;Lcom/android/tools/idea/streaming/emulator/LayoutNode;)V", "getFirstChild", "()Lcom/android/tools/idea/streaming/emulator/LayoutNode;", "getSecondChild", "splitRatio", "", "getSplitRatio", "()D", "getSplitType", "()Lcom/android/tools/idea/streaming/emulator/SplitType;", "toString", "", "intellij.android.streaming"})
public final class SplitNode
extends LayoutNode {
    @NotNull
    private final SplitType splitType;
    @NotNull
    private final LayoutNode firstChild;
    @NotNull
    private final LayoutNode secondChild;
    private final double splitRatio;

    public SplitNode(@NotNull SplitType splitType, @NotNull LayoutNode firstChild, @NotNull LayoutNode secondChild) {
        Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"splitType");
        Intrinsics.checkNotNullParameter((Object)firstChild, (String)"firstChild");
        Intrinsics.checkNotNullParameter((Object)secondChild, (String)"secondChild");
        super(MultiDisplayLayoutOptimizerKt.access$computeSize(splitType, firstChild, secondChild), null);
        this.splitType = splitType;
        this.firstChild = firstChild;
        this.secondChild = secondChild;
        this.splitRatio = switch (WhenMappings.$EnumSwitchMapping$0[this.splitType.ordinal()]) {
            case 1 -> (double)this.firstChild.getSize().width / (double)(this.firstChild.getSize().width + this.secondChild.getSize().width);
            case 2 -> (double)this.firstChild.getSize().height / (double)(this.firstChild.getSize().height + this.secondChild.getSize().height);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final SplitType getSplitType() {
        return this.splitType;
    }

    @NotNull
    public final LayoutNode getFirstChild() {
        return this.firstChild;
    }

    @NotNull
    public final LayoutNode getSecondChild() {
        return this.secondChild;
    }

    public final double getSplitRatio() {
        return this.splitRatio;
    }

    @NotNull
    public String toString() {
        char splitChar = switch (WhenMappings.$EnumSwitchMapping$0[this.splitType.ordinal()]) {
            case 1 -> '|';
            case 2 -> '\u2014';
            default -> throw new NoWhenBranchMatchedException();
        };
        String string = "%.2g";
        Object[] objectArray = new Object[]{this.splitRatio};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String ratio = string2;
        return "[" + this.firstChild + "] " + splitChar + " [" + this.secondChild + "] " + ratio;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SplitType.values().length];
            try {
                nArray[SplitType.HORIZONTAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SplitType.VERTICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

