/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.Slow;
import com.android.io.Images;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.AnchorPoint;
import com.android.tools.idea.streaming.emulator.AnchoredImage;
import com.android.tools.idea.streaming.emulator.SkinLayout;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/streaming/emulator/SkinDefinition;", "", "layout", "Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "(Lcom/android/tools/idea/streaming/emulator/SkinLayout;)V", "getLayout", "()Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "createScaledLayout", "displayWidth", "", "displayHeight", "displayOrientationQuadrants", "getRotatedFrameSize", "Ljava/awt/Dimension;", "displayRotationQuadrants", "displaySize", "Companion", "Part", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nSkinDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/idea/streaming/emulator/SkinDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,470:1\n1603#2,9:471\n1851#2:480\n1852#2:482\n1612#2:483\n1603#2,9:484\n1851#2:493\n1852#2:495\n1612#2:496\n1#3:481\n1#3:494\n*S KotlinDebug\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/idea/streaming/emulator/SkinDefinition\n*L\n71#1:471,9\n71#1:480\n71#1:482\n71#1:483\n72#1:484,9\n72#1:493\n72#1:495\n72#1:496\n71#1:481\n72#1:494\n*E\n"})
public final class SkinDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkinLayout layout;
    private static final int ALPHA_MASK = -16777216;

    private SkinDefinition(SkinLayout layout) {
        this.layout = layout;
    }

    @NotNull
    public final SkinLayout getLayout() {
        return this.layout;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SkinLayout createScaledLayout(int displayWidth, int displayHeight, int displayOrientationQuadrants) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        if (displayOrientationQuadrants == 0 && displayWidth == this.layout.getDisplaySize().width && displayHeight == this.layout.getDisplaySize().height) {
            return this.layout;
        }
        Rectangle rotatedFrameRect = SkinDefinition.Companion.rotatedByQuadrants(this.layout.getFrameRectangle(), displayOrientationQuadrants, this.layout.getDisplaySize());
        Dimension rotatedDisplaySize = StreamingUtilsKt.rotatedByQuadrants(this.layout.getDisplaySize(), displayOrientationQuadrants);
        double scaleX = (double)displayWidth / (double)rotatedDisplaySize.width;
        double scaleY = (double)displayHeight / (double)rotatedDisplaySize.height;
        int frameX = StreamingUtilsKt.scaled(rotatedFrameRect.x, scaleX);
        int frameY = StreamingUtilsKt.scaled(rotatedFrameRect.y, scaleY);
        int frameWidth = -frameX + displayWidth + StreamingUtilsKt.scaled(SkinDefinition.Companion.getRight(rotatedFrameRect) - rotatedDisplaySize.width, scaleX);
        int frameHeight = -frameY + displayHeight + StreamingUtilsKt.scaled(SkinDefinition.Companion.getBottom(rotatedFrameRect) - rotatedDisplaySize.height, scaleY);
        Rectangle frameRect = new Rectangle(frameX, frameY, frameWidth, frameHeight);
        Iterable $this$mapNotNull$iv = this.layout.getFrameImages();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<AnchoredImage> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AnchoredImage it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AnchoredImage it = (AnchoredImage)element$iv$iv;
            boolean bl2 = false;
            if (it.rotatedAndScaled(displayOrientationQuadrants, scaleX, scaleY) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List frameImages = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = this.layout.getMaskImages();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator3.hasNext()) {
            AnchoredImage it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            AnchoredImage it = (AnchoredImage)element$iv$iv;
            boolean bl4 = false;
            if (it.rotatedAndScaled(displayOrientationQuadrants, scaleX, scaleY) == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List maskImages = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        return new SkinLayout(new Dimension(displayWidth, displayHeight), frameRect, frameImages, maskImages);
    }

    @NotNull
    public final Dimension getRotatedFrameSize(int displayRotationQuadrants, @NotNull Dimension displaySize) {
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        double scaleX = displaySize.getWidth() / this.layout.getDisplaySize().getWidth();
        double scaleY = displaySize.getHeight() / this.layout.getDisplaySize().getHeight();
        Rectangle frameRect = this.layout.getFrameRectangle();
        Dimension size = scaleX == 1.0 && scaleY == 1.0 ? frameRect.getSize() : new Dimension(-StreamingUtilsKt.scaled(frameRect.x, scaleX) + displaySize.width + StreamingUtilsKt.scaled(SkinDefinition.Companion.getRight(frameRect) - this.layout.getDisplaySize().width, scaleX), -StreamingUtilsKt.scaled(frameRect.y, scaleY) + displaySize.height + StreamingUtilsKt.scaled(SkinDefinition.Companion.getBottom(frameRect) - this.layout.getDisplaySize().height, scaleY));
        Intrinsics.checkNotNullExpressionValue((Object)size, (String)"size");
        return StreamingUtilsKt.rotatedByQuadrants(size, displayRotationQuadrants);
    }

    public static /* synthetic */ Dimension getRotatedFrameSize$default(SkinDefinition skinDefinition, int n, Dimension dimension2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            dimension2 = skinDefinition.layout.getDisplaySize();
        }
        return skinDefinition.getRotatedFrameSize(n, dimension2);
    }

    @Slow
    @JvmStatic
    @Nullable
    public static final SkinDefinition create(@NotNull Path skinFolder) {
        return Companion.create(skinFolder);
    }

    @JvmStatic
    private static final Rectangle rotatedByQuadrants(Rectangle $this$rotatedByQuadrants, int rotation, Dimension displaySize) {
        return SkinDefinition.Companion.rotatedByQuadrants($this$rotatedByQuadrants, rotation, displaySize);
    }

    @JvmStatic
    private static final Part createPart(SkinLayoutDefinition partNode, Path skinFolder) {
        return SkinDefinition.Companion.createPart(partNode, skinFolder);
    }

    @JvmStatic
    private static final URL getReferencedFile(SkinLayoutDefinition node, String propertyName, Path skinFolder) {
        return SkinDefinition.Companion.getReferencedFile(node, propertyName, skinFolder);
    }

    @JvmStatic
    private static final SkinLayout createLayout(Dimension displaySize, Rectangle frameRectangle, Part part) {
        return SkinDefinition.Companion.createLayout(displaySize, frameRectangle, part);
    }

    @JvmStatic
    private static final boolean isTransparentNearCenterOfDisplay(BufferedImage image, Dimension displaySize, Rectangle frameRectangle) {
        return SkinDefinition.Companion.isTransparentNearCenterOfDisplay(image, displaySize, frameRectangle);
    }

    @JvmStatic
    private static final List<AnchoredImage> disassembleFrame(BufferedImage background, Rectangle frameRectangle, Dimension displaySize) {
        return SkinDefinition.Companion.disassembleFrame(background, frameRectangle, displaySize);
    }

    @JvmStatic
    private static final List<AnchoredImage> disassembleMask(BufferedImage mask, Dimension displaySize) {
        return SkinDefinition.Companion.disassembleMask(mask, displaySize);
    }

    @JvmStatic
    private static final Sequence<Rectangle> cutHorizontally(BufferedImage image, Rectangle cropBounds) {
        return SkinDefinition.Companion.cutHorizontally(image, cropBounds);
    }

    @JvmStatic
    private static final Sequence<Rectangle> cutVertically(BufferedImage image, Rectangle cropBounds) {
        return SkinDefinition.Companion.cutVertically(image, cropBounds);
    }

    @JvmStatic
    private static final boolean isTransparentHorizontalLine(BufferedImage image, int startX, int endX, int y) {
        return SkinDefinition.Companion.isTransparentHorizontalLine(image, startX, endX, y);
    }

    @JvmStatic
    private static final boolean isTransparentVerticalLine(BufferedImage image, int x, int startY, int endY) {
        return SkinDefinition.Companion.isTransparentVerticalLine(image, x, startY, endY);
    }

    @JvmStatic
    private static final boolean isTransparentPixel(BufferedImage image, int x, int y) {
        return SkinDefinition.Companion.isTransparentPixel(image, x, y);
    }

    @JvmStatic
    private static final AnchoredImage createAnchoredImage(BufferedImage mask, Rectangle cropBounds, Dimension displaySize) {
        return SkinDefinition.Companion.createAnchoredImage(mask, cropBounds, displaySize);
    }

    @JvmStatic
    private static final Rectangle computeAdjustedFrameRectangle(Iterable<AnchoredImage> backgroundImages, Dimension displaySize) {
        return SkinDefinition.Companion.computeAdjustedFrameRectangle(backgroundImages, displaySize);
    }

    @JvmStatic
    private static final BufferedImage cropped(BufferedImage $this$cropped, Rectangle cropBounds) {
        return SkinDefinition.Companion.cropped($this$cropped, cropBounds);
    }

    @JvmStatic
    private static final Rectangle getCropBounds(BufferedImage image, Rectangle initialCrop) {
        return SkinDefinition.Companion.getCropBounds(image, initialCrop);
    }

    private static final int getRight(Rectangle $this$getRight) {
        return SkinDefinition.Companion.getRight($this$getRight);
    }

    private static final int getBottom(Rectangle $this$getBottom) {
        return SkinDefinition.Companion.getBottom($this$getBottom);
    }

    @JvmStatic
    private static final BufferedImage readImage(URL url) {
        return SkinDefinition.Companion.readImage(url);
    }

    public /* synthetic */ SkinDefinition(SkinLayout layout, DefaultConstructorMarker $constructor_marker) {
        this(layout);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0003J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0003J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0003J&\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110)2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110)2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u001c\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010\u0006H\u0003J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J(\u00103\u001a\u0002042\u0006\u0010&\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0003J \u00108\u001a\u0002042\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0006H\u0003J \u00109\u001a\u0002042\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0003J(\u0010;\u001a\u0002042\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0003J\u0012\u0010>\u001a\u0004\u0018\u00010\u001a2\u0006\u0010?\u001a\u00020/H\u0003J\u0014\u0010@\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0003J\u001c\u0010A\u001a\u00020\u0006*\u00020\u00062\u0006\u0010B\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u0004*\u00020\u00068BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u0004*\u00020\u00068BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\b\u001a\u0004\b\r\u0010\n\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/streaming/emulator/SkinDefinition$Companion;", "", "()V", "ALPHA_MASK", "", "bottom", "Ljava/awt/Rectangle;", "getBottom$annotations", "(Ljava/awt/Rectangle;)V", "getBottom", "(Ljava/awt/Rectangle;)I", "right", "getRight$annotations", "getRight", "computeAdjustedFrameRectangle", "backgroundImages", "", "Lcom/android/tools/idea/streaming/emulator/AnchoredImage;", "displaySize", "Ljava/awt/Dimension;", "create", "Lcom/android/tools/idea/streaming/emulator/SkinDefinition;", "skinFolder", "Ljava/nio/file/Path;", "createAnchoredImage", "mask", "Ljava/awt/image/BufferedImage;", "cropBounds", "createLayout", "Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "frameRectangle", "part", "Lcom/android/tools/idea/streaming/emulator/SkinDefinition$Part;", "createPart", "partNode", "Lcom/android/tools/idea/avdmanager/SkinLayoutDefinition;", "cutHorizontally", "Lkotlin/sequences/Sequence;", "image", "cutVertically", "disassembleFrame", "", "background", "disassembleMask", "getCropBounds", "initialCrop", "getReferencedFile", "Ljava/net/URL;", "node", "propertyName", "", "isTransparentHorizontalLine", "", "startX", "endX", "y", "isTransparentNearCenterOfDisplay", "isTransparentPixel", "x", "isTransparentVerticalLine", "startY", "endY", "readImage", "url", "cropped", "rotatedByQuadrants", "rotation", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nSkinDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/idea/streaming/emulator/SkinDefinition$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,470:1\n8#2:471\n8#2:472\n8#2:474\n1#3:473\n*S KotlinDebug\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/idea/streaming/emulator/SkinDefinition$Companion\n*L\n171#1:471\n174#1:472\n461#1:474\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Slow
        @JvmStatic
        @Nullable
        public final SkinDefinition create(@NotNull Path skinFolder) {
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            try {
                Path layoutFile = skinFolder.resolve("layout");
                byte[] byArray = Files.readAllBytes(layoutFile);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(layoutFile)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String contents = new String(byArray2, charset2);
                SkinLayoutDefinition skinLayoutDefinition = SkinLayoutDefinition.parseString(contents);
                Intrinsics.checkNotNullExpressionValue((Object)skinLayoutDefinition, (String)"parseString(contents)");
                SkinLayoutDefinition skin = skinLayoutDefinition;
                int displayWidth = 0;
                int displayHeight = 0;
                HashMap partsByName = new HashMap();
                Object object = skin.getNode("parts");
                if (object == null || (object = ((SkinLayoutDefinition)object).getChildren()) == null) {
                    return null;
                }
                Object partNodes = object;
                for (Map.Entry entry : partNodes.entrySet()) {
                    String name2 = (String)entry.getKey();
                    SkinLayoutDefinition node = (SkinLayoutDefinition)entry.getValue();
                    if (Intrinsics.areEqual((Object)name2, (Object)"onion") || Intrinsics.areEqual((Object)name2, (Object)"controls")) continue;
                    if (Intrinsics.areEqual((Object)name2, (Object)"device") || Intrinsics.areEqual((Object)name2, (Object)"primary") || displayWidth == 0 || displayHeight == 0) {
                        String string = node.getValue("display.width");
                        displayWidth = string != null ? Integer.parseInt(string) : 0;
                        String string2 = node.getValue("display.height");
                        displayHeight = string2 != null ? Integer.parseInt(string2) : 0;
                    }
                    Map map2 = partsByName;
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                    map2.put(name2, this.createPart(node, skinFolder));
                }
                if (displayWidth == 0 || displayHeight == 0) {
                    return null;
                }
                SkinLayout layout = null;
                Object object2 = skin.getNode("layouts");
                if (object2 == null || (object2 = ((SkinLayoutDefinition)object2).getChildren()) == null) {
                    return null;
                }
                Object layoutNodes = object2;
                block4: for (SkinLayoutDefinition layoutNode : layoutNodes.values()) {
                    String string = layoutNode.getValue("width");
                    if (string == null) {
                        continue;
                    }
                    int width = Integer.parseInt(string);
                    String string3 = layoutNode.getValue("height");
                    if (string3 == null) {
                        continue;
                    }
                    int height = Integer.parseInt(string3);
                    Part part = null;
                    int frameX = 0;
                    int frameY = 0;
                    int partX = 0;
                    int partY = 0;
                    for (SkinLayoutDefinition subnode : layoutNode.getChildren().values()) {
                        String name3;
                        int y;
                        String string4 = subnode.getValue("x");
                        int x = string4 != null ? Integer.parseInt(string4) : 0;
                        String string5 = subnode.getValue("y");
                        int n = y = string5 != null ? Integer.parseInt(string5) : 0;
                        if (subnode.getValue("name") == null) continue;
                        if (Intrinsics.areEqual((Object)name3, (Object)"device") || Intrinsics.areEqual((Object)name3, (Object)"primary")) {
                            int rotation;
                            String string6 = subnode.getValue("rotation");
                            int n2 = rotation = string6 != null ? Integer.parseInt(string6) : 0;
                            if (rotation != 0) continue block4;
                            frameX = -x;
                            frameY = -y;
                            continue;
                        }
                        if (part != null || (part = (Part)partsByName.get(name3)) == null) continue;
                        partX = x;
                        partY = y;
                    }
                    if (part == null) continue;
                    Rectangle frameRectangle = new Rectangle(frameX + partX, frameY + partY, width, height);
                    layout = this.createLayout(new Dimension(displayWidth, displayHeight), frameRectangle, part);
                }
                if (layout != null) {
                    return new SkinDefinition(layout, null);
                }
            }
            catch (NoSuchFileException e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.error("File not found: " + e.getFile());
            }
            catch (IOException e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger3 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(T::class.java)");
                logger3.error((Throwable)e);
            }
            return null;
        }

        @JvmStatic
        private final Rectangle rotatedByQuadrants(Rectangle $this$rotatedByQuadrants, int rotation, Dimension displaySize) {
            return switch (rotation) {
                case 1 -> new Rectangle($this$rotatedByQuadrants.y, displaySize.width - $this$rotatedByQuadrants.width - $this$rotatedByQuadrants.x, $this$rotatedByQuadrants.height, $this$rotatedByQuadrants.width);
                case 2 -> new Rectangle(displaySize.width - $this$rotatedByQuadrants.width - $this$rotatedByQuadrants.x, displaySize.height - $this$rotatedByQuadrants.height - $this$rotatedByQuadrants.y, $this$rotatedByQuadrants.width, $this$rotatedByQuadrants.height);
                case 3 -> new Rectangle(displaySize.height - $this$rotatedByQuadrants.height - $this$rotatedByQuadrants.y, $this$rotatedByQuadrants.x, $this$rotatedByQuadrants.height, $this$rotatedByQuadrants.width);
                default -> $this$rotatedByQuadrants;
            };
        }

        @JvmStatic
        private final Part createPart(SkinLayoutDefinition partNode, Path skinFolder) {
            URL background = this.getReferencedFile(partNode, "background.image", skinFolder);
            URL mask = this.getReferencedFile(partNode, "foreground.mask", skinFolder);
            return new Part(background, mask);
        }

        @JvmStatic
        private final URL getReferencedFile(SkinLayoutDefinition node, String propertyName, Path skinFolder) {
            String string = node.getValue(propertyName);
            if (string == null) {
                return null;
            }
            String filename = string;
            return skinFolder.resolve(filename).toUri().toURL();
        }

        @JvmStatic
        private final SkinLayout createLayout(Dimension displaySize, Rectangle frameRectangle, Part part) {
            List<AnchoredImage> list2;
            List<AnchoredImage> maskImages;
            List<AnchoredImage> backgroundImages;
            block14: {
                block13: {
                    BufferedImage mask;
                    block12: {
                        List<AnchoredImage> list3;
                        block11: {
                            BufferedImage bufferedImage;
                            backgroundImages = null;
                            maskImages = null;
                            URL uRL = part.getBackgroundFile();
                            if (uRL != null) {
                                URL it = uRL;
                                boolean bl = false;
                                bufferedImage = Companion.readImage(it);
                            } else {
                                bufferedImage = null;
                            }
                            BufferedImage background = bufferedImage;
                            if (background != null && this.isTransparentNearCenterOfDisplay(background, displaySize, frameRectangle)) {
                                Path maskFile;
                                BufferedImage bufferedImage2;
                                BufferedImage $this$createLayout_u24lambda_u241 = bufferedImage2 = this.cropped(background, new Rectangle(-frameRectangle.x, -frameRectangle.y, displaySize.width, displaySize.height));
                                boolean bl = false;
                                if (ApplicationManager.getApplication() == null && part.getMaskFile() != null && Files.notExists(maskFile = Paths.get(part.getMaskFile().toURI()), new LinkOption[0])) {
                                    RenderedImage renderedImage = $this$createLayout_u24lambda_u241;
                                    Intrinsics.checkNotNullExpressionValue((Object)maskFile, (String)"maskFile");
                                    Images.writeImage((RenderedImage)renderedImage, (String)"WEBP", (Path)maskFile);
                                }
                                v3 = bufferedImage2;
                            } else {
                                v3 = mask = part.getMaskFile() != null ? this.readImage(part.getMaskFile()) : null;
                            }
                            if ((list3 = background) == null) break block11;
                            BufferedImage it = list3;
                            boolean bl = false;
                            List<AnchoredImage> list4 = Companion.disassembleFrame(it, frameRectangle, displaySize);
                            list3 = list4;
                            if (list4 != null) break block12;
                        }
                        list3 = backgroundImages = CollectionsKt.emptyList();
                    }
                    if ((list2 = mask) == null) break block13;
                    BufferedImage it = list2;
                    boolean bl = false;
                    List<AnchoredImage> list5 = Companion.disassembleMask(it, displaySize);
                    list2 = list5;
                    if (list5 != null) break block14;
                }
                list2 = CollectionsKt.emptyList();
            }
            maskImages = list2;
            Rectangle adjustedFrameRectangle = this.computeAdjustedFrameRectangle((Iterable<AnchoredImage>)backgroundImages, displaySize);
            return new SkinLayout(displaySize, adjustedFrameRectangle, backgroundImages, maskImages);
        }

        @JvmStatic
        private final boolean isTransparentNearCenterOfDisplay(BufferedImage image, Dimension displaySize, Rectangle frameRectangle) {
            return this.isTransparentPixel(image, displaySize.width / 2 - frameRectangle.x, displaySize.height / 2 - frameRectangle.y);
        }

        @JvmStatic
        private final List<AnchoredImage> disassembleFrame(BufferedImage background, Rectangle frameRectangle, Dimension displaySize) {
            Point offset;
            BufferedImage image;
            Rectangle rect;
            Rectangle rectangle = this.getCropBounds(background, null);
            if (rectangle == null) {
                return CollectionsKt.emptyList();
            }
            Rectangle cropBounds = rectangle;
            int displayLeft = -frameRectangle.x;
            int displayRight = displayLeft + displaySize.width;
            int displayTop = -frameRectangle.y;
            int displayBottom = displayTop + displaySize.height;
            int marginLeft = displayLeft - cropBounds.x;
            int marginRight = this.getRight(cropBounds) - displayRight;
            int marginTop = displayTop - cropBounds.y;
            int marginBottom = this.getBottom(cropBounds) - displayBottom;
            List images = new ArrayList();
            if (marginRight > 0) {
                rect = new Rectangle(displayRight, displayTop, marginRight, displaySize.height);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayRight, rect.y - displayTop);
                Dimension dimension2 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension2, AnchorPoint.TOP_RIGHT, offset));
            }
            if (marginRight > 0 && marginTop > 0) {
                rect = new Rectangle(displayRight, cropBounds.y, marginRight, marginTop);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayRight, rect.y - displayTop);
                Dimension dimension3 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension3, AnchorPoint.TOP_RIGHT, offset));
            }
            if (marginTop > 0) {
                rect = new Rectangle(displayLeft, cropBounds.y, displaySize.width, marginTop);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayTop);
                Dimension dimension4 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension4, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension4, AnchorPoint.TOP_LEFT, offset));
            }
            if (marginLeft > 0 && marginTop > 0) {
                rect = new Rectangle(cropBounds.x, cropBounds.y, marginLeft, marginTop);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayTop);
                Dimension dimension5 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension5, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension5, AnchorPoint.TOP_LEFT, offset));
            }
            if (marginLeft > 0) {
                rect = new Rectangle(cropBounds.x, displayTop, marginLeft, displaySize.height);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayTop);
                Dimension dimension6 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension6, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension6, AnchorPoint.TOP_LEFT, offset));
            }
            if (marginLeft > 0 && marginBottom > 0) {
                rect = new Rectangle(cropBounds.x, displayBottom, marginLeft, marginBottom);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayBottom);
                Dimension dimension7 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension7, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension7, AnchorPoint.BOTTOM_LEFT, offset));
            }
            if (marginBottom > 0) {
                rect = new Rectangle(displayLeft, displayBottom, displaySize.width, marginBottom);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayBottom);
                Dimension dimension8 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension8, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension8, AnchorPoint.BOTTOM_LEFT, offset));
            }
            if (marginRight > 0 && marginBottom > 0) {
                rect = new Rectangle(displayRight, displayBottom, marginRight, marginBottom);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayRight, rect.y - displayBottom);
                Dimension dimension9 = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension9, (String)"rect.size");
                images.add(new AnchoredImage(image, dimension9, AnchorPoint.BOTTOM_RIGHT, offset));
            }
            return images;
        }

        @JvmStatic
        private final List<AnchoredImage> disassembleMask(BufferedImage mask, Dimension displaySize) {
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap(this.cutHorizontally(mask, new Rectangle(0, 0, mask.getWidth(), mask.getHeight())), (Function1)((Function1)new Function1<Rectangle, Sequence<? extends Rectangle>>(mask){
                final /* synthetic */ BufferedImage $mask;
                {
                    this.$mask = $mask;
                    super(1);
                }

                @NotNull
                public final Sequence<Rectangle> invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$cutVertically(SkinDefinition.Companion, this.$mask, it);
                }
            })), (Function1)((Function1)new Function1<Rectangle, AnchoredImage>(mask, displaySize){
                final /* synthetic */ BufferedImage $mask;
                final /* synthetic */ Dimension $displaySize;
                {
                    this.$mask = $mask;
                    this.$displaySize = $displaySize;
                    super(1);
                }

                @NotNull
                public final AnchoredImage invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$createAnchoredImage(SkinDefinition.Companion, this.$mask, it, this.$displaySize);
                }
            })));
        }

        @JvmStatic
        private final Sequence<Rectangle> cutHorizontally(BufferedImage image, Rectangle cropBounds) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object>(cropBounds, image, null){
                Object L$1;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Rectangle $cropBounds;
                final /* synthetic */ BufferedImage $image;
                {
                    this.$cropBounds = $cropBounds;
                    this.$image = $image;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block12: {
                        block10: {
                            block11: {
                                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                block0 : switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$sequence = (SequenceScope)this.L$0;
                                        bounds = this.$cropBounds;
lbl8:
                                        // 2 sources

                                        while (true) {
                                            y = bounds.y;
                                            var5_6 = com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getBottom(SkinDefinition.Companion, bounds);
lbl11:
                                            // 2 sources

                                            while (y < var5_6) {
                                                if (!com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$isTransparentHorizontalLine(SkinDefinition.Companion, this.$image, bounds.x, com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getRight(SkinDefinition.Companion, bounds), y)) break block10;
                                                piece = com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, this.$cropBounds.y, bounds.width, y - bounds.y));
                                                if (piece == null) break block0;
                                                $i$a$-let-SkinDefinition$Companion$cutHorizontally$1$1 = false;
                                                this.L$0 = $this$sequence;
                                                this.L$1 = bounds;
                                                this.I$0 = y;
                                                this.label = 1;
                                                v0 = $this$sequence.yield((Object)it, (Continuation)this);
                                                if (v0 == var9_2) {
                                                    return var9_2;
                                                }
                                                break block11;
                                            }
                                            break block12;
                                            break;
                                        }
                                    }
                                    case 1: {
                                        $i$a$-let-SkinDefinition$Companion$cutHorizontally$1$1 = false;
                                        y = this.I$0;
                                        bounds = (Rectangle)this.L$1;
                                        $this$sequence = (SequenceScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        break;
                                    }
                                }
                            }
                            if (com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, y + 1, this.$cropBounds.width, bounds.height - y - 1)) == null) {
                                return Unit.INSTANCE;
                            }
                            ** while (true)
                        }
                        ++y;
                        ** GOTO lbl11
                    }
                    this.L$0 = null;
                    this.L$1 = null;
                    this.label = 2;
                    v1 = $this$sequence.yield((Object)bounds, (Continuation)this);
                    if (v1 == var9_2) {
                        return var9_2;
                    }
                    ** GOTO lbl53
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl53:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Rectangle> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @JvmStatic
        private final Sequence<Rectangle> cutVertically(BufferedImage image, Rectangle cropBounds) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object>(cropBounds, image, null){
                Object L$1;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Rectangle $cropBounds;
                final /* synthetic */ BufferedImage $image;
                {
                    this.$cropBounds = $cropBounds;
                    this.$image = $image;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block12: {
                        block10: {
                            block11: {
                                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                block0 : switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$sequence = (SequenceScope)this.L$0;
                                        bounds = this.$cropBounds;
lbl8:
                                        // 2 sources

                                        while (true) {
                                            x = bounds.x;
                                            var5_6 = com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getRight(SkinDefinition.Companion, bounds);
lbl11:
                                            // 2 sources

                                            while (x < var5_6) {
                                                if (!com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$isTransparentVerticalLine(SkinDefinition.Companion, this.$image, x, bounds.y, com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getBottom(SkinDefinition.Companion, bounds))) break block10;
                                                piece = com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, this.$cropBounds.y, x - bounds.x, bounds.height));
                                                if (piece == null) break block0;
                                                $i$a$-let-SkinDefinition$Companion$cutVertically$1$1 = false;
                                                this.L$0 = $this$sequence;
                                                this.L$1 = bounds;
                                                this.I$0 = x;
                                                this.label = 1;
                                                v0 = $this$sequence.yield((Object)it, (Continuation)this);
                                                if (v0 == var9_2) {
                                                    return var9_2;
                                                }
                                                break block11;
                                            }
                                            break block12;
                                            break;
                                        }
                                    }
                                    case 1: {
                                        $i$a$-let-SkinDefinition$Companion$cutVertically$1$1 = false;
                                        x = this.I$0;
                                        bounds = (Rectangle)this.L$1;
                                        $this$sequence = (SequenceScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        break;
                                    }
                                }
                            }
                            if (com.android.tools.idea.streaming.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(x + 1, bounds.y, this.$cropBounds.width - x - 1, bounds.height)) == null) {
                                return Unit.INSTANCE;
                            }
                            ** while (true)
                        }
                        ++x;
                        ** GOTO lbl11
                    }
                    this.L$0 = null;
                    this.L$1 = null;
                    this.label = 2;
                    v1 = $this$sequence.yield((Object)bounds, (Continuation)this);
                    if (v1 == var9_2) {
                        return var9_2;
                    }
                    ** GOTO lbl53
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl53:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Rectangle> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @JvmStatic
        private final boolean isTransparentHorizontalLine(BufferedImage image, int startX, int endX, int y) {
            for (int x = startX; x < endX; ++x) {
                if (this.isTransparentPixel(image, x, y)) continue;
                return false;
            }
            return true;
        }

        @JvmStatic
        private final boolean isTransparentVerticalLine(BufferedImage image, int x, int startY, int endY) {
            for (int y = startY; y < endY; ++y) {
                if (this.isTransparentPixel(image, x, y)) continue;
                return false;
            }
            return true;
        }

        @JvmStatic
        private final boolean isTransparentPixel(BufferedImage image, int x, int y) {
            return (image.getRGB(x, y) & 0xFF000000) == 0;
        }

        @JvmStatic
        private final AnchoredImage createAnchoredImage(BufferedImage mask, Rectangle cropBounds, Dimension displaySize) {
            AnchorPoint anchorPoint = cropBounds.x > displaySize.width / 2 ? (cropBounds.y > displaySize.height / 2 ? AnchorPoint.BOTTOM_RIGHT : AnchorPoint.TOP_RIGHT) : (cropBounds.y > displaySize.height / 2 ? AnchorPoint.BOTTOM_LEFT : AnchorPoint.TOP_LEFT);
            Point offset = new Point(cropBounds.x - anchorPoint.getX() * displaySize.width, cropBounds.y - anchorPoint.getY() * displaySize.height);
            BufferedImage bufferedImage = this.cropped(mask, cropBounds);
            Dimension dimension2 = cropBounds.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"cropBounds.size");
            return new AnchoredImage(bufferedImage, dimension2, anchorPoint, offset);
        }

        @JvmStatic
        private final Rectangle computeAdjustedFrameRectangle(Iterable<AnchoredImage> backgroundImages, Dimension displaySize) {
            int left2 = 0;
            int top = 0;
            int right = displaySize.width;
            int bottom = displaySize.height;
            for (AnchoredImage image : backgroundImages) {
                left2 = RangesKt.coerceAtMost((int)left2, (int)(image.getOffset().x + displaySize.width * image.getAnchorPoint().getX()));
                right = RangesKt.coerceAtLeast((int)right, (int)(image.getOffset().x + image.getSize().width + displaySize.width * image.getAnchorPoint().getX()));
                top = RangesKt.coerceAtMost((int)top, (int)(image.getOffset().y + displaySize.height * image.getAnchorPoint().getY()));
                bottom = RangesKt.coerceAtLeast((int)bottom, (int)(image.getOffset().y + image.getSize().height + displaySize.height * image.getAnchorPoint().getY()));
            }
            return new Rectangle(left2, top, right - left2, bottom - top);
        }

        @JvmStatic
        private final BufferedImage cropped(BufferedImage $this$cropped, Rectangle cropBounds) {
            BufferedImage bufferedImage = ImageUtils.getCroppedImage((BufferedImage)$this$cropped, (Rectangle)cropBounds, (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"getCroppedImage(this, cropBounds, -1)");
            return bufferedImage;
        }

        @JvmStatic
        private final Rectangle getCropBounds(BufferedImage image, Rectangle initialCrop) {
            return ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, (Rectangle)initialCrop);
        }

        private final int getRight(Rectangle $this$right) {
            return $this$right.x + $this$right.width;
        }

        @JvmStatic
        private static /* synthetic */ void getRight$annotations(Rectangle rectangle) {
        }

        private final int getBottom(Rectangle $this$bottom) {
            return $this$bottom.y + $this$bottom.height;
        }

        @JvmStatic
        private static /* synthetic */ void getBottom$annotations(Rectangle rectangle) {
        }

        @JvmStatic
        private final BufferedImage readImage(URL url) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (image == null) {
                Path file2 = Paths.get(url.toURI());
                String detail = Files.notExists(file2, new LinkOption[0]) ? " - the file does not exist" : "";
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.warn("Failed to read Emulator skin image " + file2 + detail);
            }
            return image;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/streaming/emulator/SkinDefinition$Part;", "", "backgroundFile", "Ljava/net/URL;", "maskFile", "(Ljava/net/URL;Ljava/net/URL;)V", "getBackgroundFile", "()Ljava/net/URL;", "getMaskFile", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.streaming"})
    private static final class Part {
        @Nullable
        private final URL backgroundFile;
        @Nullable
        private final URL maskFile;

        public Part(@Nullable URL backgroundFile, @Nullable URL maskFile) {
            this.backgroundFile = backgroundFile;
            this.maskFile = maskFile;
        }

        @Nullable
        public final URL getBackgroundFile() {
            return this.backgroundFile;
        }

        @Nullable
        public final URL getMaskFile() {
            return this.maskFile;
        }

        @Nullable
        public final URL component1() {
            return this.backgroundFile;
        }

        @Nullable
        public final URL component2() {
            return this.maskFile;
        }

        @NotNull
        public final Part copy(@Nullable URL backgroundFile, @Nullable URL maskFile) {
            return new Part(backgroundFile, maskFile);
        }

        public static /* synthetic */ Part copy$default(Part part, URL uRL, URL uRL2, int n, Object object) {
            if ((n & 1) != 0) {
                uRL = part.backgroundFile;
            }
            if ((n & 2) != 0) {
                uRL2 = part.maskFile;
            }
            return part.copy(uRL, uRL2);
        }

        @NotNull
        public String toString() {
            return "Part(backgroundFile=" + this.backgroundFile + ", maskFile=" + this.maskFile + ")";
        }

        public int hashCode() {
            int result2 = this.backgroundFile == null ? 0 : this.backgroundFile.hashCode();
            result2 = result2 * 31 + (this.maskFile == null ? 0 : this.maskFile.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Part)) {
                return false;
            }
            Part part = (Part)other;
            if (!Intrinsics.areEqual((Object)this.backgroundFile, (Object)part.backgroundFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.maskFile, (Object)part.maskFile);
        }
    }
}

