/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.streaming.emulator.CommandLineDecoderUtils;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 82\u00020\u0001:\u000289B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0007J\b\u0010)\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020\u0014H\u0002J\u0012\u0010,\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010\u001eH\u0007J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\u0006\u0010-\u001a\u00020\u001eH\u0002J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\u001eH\u0002J\u0010\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0018H\u0007J\b\u00103\u001a\u00020%H\u0002J\u0010\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\u0014H\u0002J\b\u00105\u001a\u00020%H\u0002J\u0012\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b07R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog;", "Lcom/intellij/openapi/Disposable$Parent;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "dataLock", "Ljava/lang/Object;", "emulators", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "getEmulators", "()Ljava/util/Set;", "setEmulators", "(Ljava/util/Set;)V", "fileNamePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isDisposing", "", "lastUpdateDuration", "", "lastUpdateStartTime", "listeners", "", "Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Listener;", "nextScheduledUpdateTime", "pendingFutures", "", "Lcom/google/common/util/concurrent/SettableFuture;", "registrationDirectory", "Ljava/nio/file/Path;", "updateInterval", "updateIntervalsByListener", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "updateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addListener", "", "listener", "updateIntervalMillis", "", "beforeTreeDispose", "dispose", "getUpdateInterval", "overrideRegistrationDirectory", "directory", "readDirectoryContents", "readEmulatorInfo", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "file", "removeListener", "scheduleUpdate", "delay", "update", "updateNow", "Lcom/google/common/util/concurrent/ListenableFuture;", "Companion", "Listener", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nRunningEmulatorCatalog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,503:1\n1194#2,2:504\n1222#2,4:506\n8#3:510\n8#3:511\n1#4:512\n*S KotlinDebug\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog\n*L\n186#1:504,2\n186#1:506,4\n245#1:510\n266#1:511\n*E\n"})
public final class RunningEmulatorCatalog
implements Disposable.Parent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile Set<EmulatorController> emulators;
    private final Pattern fileNamePattern;
    @NotNull
    private final Alarm alarm;
    private volatile boolean isDisposing;
    @NotNull
    private final ReentrantReadWriteLock updateLock;
    @NotNull
    private final Object dataLock;
    private long lastUpdateStartTime;
    private long lastUpdateDuration;
    private long nextScheduledUpdateTime;
    @NotNull
    private List<? extends Listener> listeners;
    @NotNull
    private final Object2LongOpenHashMap<Listener> updateIntervalsByListener;
    private long updateInterval;
    @NotNull
    private List<SettableFuture<Set<EmulatorController>>> pendingFutures;
    @Nullable
    private Path registrationDirectory;
    @NotNull
    private static final String REGISTRATION_DIRECTORY_RELATIVE_PATH = "avd/running";

    public RunningEmulatorCatalog() {
        ImmutableSet immutableSet = ImmutableSet.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of()");
        this.emulators = (Set)immutableSet;
        this.fileNamePattern = Pattern.compile("pid_\\d+.ini");
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.updateLock = new ReentrantReadWriteLock();
        this.dataLock = new Object();
        this.nextScheduledUpdateTime = Long.MAX_VALUE;
        this.listeners = CollectionsKt.emptyList();
        this.updateIntervalsByListener = new Object2LongOpenHashMap();
        this.updateInterval = Long.MAX_VALUE;
        this.pendingFutures = new ArrayList();
        this.registrationDirectory = RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
    }

    @NotNull
    public final Set<EmulatorController> getEmulators() {
        return this.emulators;
    }

    public final void setEmulators(@NotNull Set<EmulatorController> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.emulators = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void addListener(@NotNull Listener listener2, int updateIntervalMillis) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (!(updateIntervalMillis > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            this.listeners = CollectionsKt.plus((Collection)this.listeners, (Object)listener2);
            ((Map)this.updateIntervalsByListener).put(listener2, this.updateInterval);
            if ((long)updateIntervalMillis < this.updateInterval) {
                this.updateInterval = updateIntervalMillis;
            }
            this.scheduleUpdate(this.updateInterval);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            this.listeners = CollectionsKt.minus((Iterable)this.listeners, (Object)listener2);
            long interval = this.updateIntervalsByListener.removeLong((Object)listener2);
            if (interval == this.updateInterval) {
                this.updateInterval = -1L;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleUpdate(long delay) {
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            long updateTime = System.currentTimeMillis() + delay;
            if (this.nextScheduledUpdateTime > updateTime) {
                if (this.nextScheduledUpdateTime != Long.MAX_VALUE) {
                    this.alarm.cancelAllRequests();
                }
                this.nextScheduledUpdateTime = updateTime;
                this.alarm.addRequest(new Runnable(this){
                    final /* synthetic */ RunningEmulatorCatalog this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        ReentrantReadWriteLock reentrantReadWriteLock = RunningEmulatorCatalog.access$getUpdateLock$p(this.this$0);
                        RunningEmulatorCatalog runningEmulatorCatalog = this.this$0;
                        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                        readLock.lock();
                        try {
                            boolean bl = false;
                            RunningEmulatorCatalog.access$update(runningEmulatorCatalog);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            readLock.unlock();
                        }
                    }
                }, delay);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void scheduleUpdate() {
        long delay = this.getUpdateInterval();
        if (delay != Long.MAX_VALUE) {
            this.scheduleUpdate(Math.max(delay, Math.min(this.lastUpdateDuration * (long)2, 1000L)));
        }
    }

    private final long getUpdateInterval() {
        if (this.updateInterval < 0L) {
            long value2 = Long.MAX_VALUE;
            LongIterator longIterator = ((LongCollection)this.updateIntervalsByListener.values()).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)longIterator, (String)"updateIntervalsByListener.values.iterator()");
            LongIterator iter = longIterator;
            while (iter.hasNext()) {
                value2 = RangesKt.coerceAtMost((long)value2, (long)iter.nextLong());
            }
            this.updateInterval = value2;
        }
        return this.updateInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ListenableFuture<Set<EmulatorController>> updateNow() {
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            SettableFuture settableFuture = SettableFuture.create();
            Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create()");
            SettableFuture future2 = settableFuture;
            this.pendingFutures.add((SettableFuture<Set<EmulatorController>>)future2);
            this.scheduleUpdate(0L);
            ListenableFuture listenableFuture = (ListenableFuture)future2;
            return listenableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update() {
        if (this.isDisposing) {
            return;
        }
        List<SettableFuture<Set<EmulatorController>>> futures = null;
        Path directory = null;
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            this.nextScheduledUpdateTime = Long.MAX_VALUE;
            if (this.pendingFutures.isEmpty()) {
                futures = CollectionsKt.emptyList();
            } else {
                futures = this.pendingFutures;
                this.pendingFutures = new ArrayList();
            }
            Path path2 = this.registrationDirectory;
            if (path2 == null) {
                return;
            }
            directory = path2;
            Unit $i$a$-synchronized-RunningEmulatorCatalog$update$2 = Unit.INSTANCE;
        }
        try {
            Iterator<Path> $this$associateByTo$iv$iv;
            long start2 = System.currentTimeMillis();
            List<Path> files2 = this.readDirectoryContents(directory);
            Iterable $this$associateBy$iv = this.emulators;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo232 = false;
            Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                EmulatorController emulatorController = (EmulatorController)t;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(emulatorController.getEmulatorId(), t);
            }
            Map oldEmulators = destination$iv$iv;
            ConcurrentHashMap<EmulatorId, EmulatorController> newEmulators = new ConcurrentHashMap<EmulatorId, EmulatorController>();
            if (!((Collection)files2).isEmpty() && !this.isDisposing) {
                CountDownLatch latch = new CountDownLatch(files2.size());
                ExecutorService executor2 = AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
                for (Path file2 : files2) {
                    executor2.submit(new Runnable(this, file2, oldEmulators, newEmulators, latch){
                        final /* synthetic */ RunningEmulatorCatalog this$0;
                        final /* synthetic */ Path $file;
                        final /* synthetic */ Map<EmulatorId, EmulatorController> $oldEmulators;
                        final /* synthetic */ ConcurrentHashMap<EmulatorId, EmulatorController> $newEmulators;
                        final /* synthetic */ CountDownLatch $latch;
                        {
                            this.this$0 = $receiver;
                            this.$file = $file;
                            this.$oldEmulators = $oldEmulators;
                            this.$newEmulators = $newEmulators;
                            this.$latch = $latch;
                        }

                        public final void run() {
                            EmulatorId emulatorId;
                            EmulatorController emulator = null;
                            boolean created = false;
                            if (!RunningEmulatorCatalog.access$isDisposing$p(this.this$0) && (emulatorId = RunningEmulatorCatalog.access$readEmulatorInfo(this.this$0, this.$file)) != null) {
                                emulator = this.$oldEmulators.get(emulatorId);
                                if (emulator == null) {
                                    T t = StudioFlags.EMBEDDED_EMULATOR_TRACE_DISCOVERY.get();
                                    Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_DISCOVERY.get()");
                                    if (((Boolean)t).booleanValue()) {
                                        RunningEmulatorCatalog $this$thisLogger$iv = this.this$0;
                                        boolean $i$f$thisLogger = false;
                                        Logger logger2 = Logger.getInstance(RunningEmulatorCatalog.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                                        logger2.info("Discovered emulator " + emulatorId);
                                    }
                                    emulator = new EmulatorController(emulatorId, (Disposable)this.this$0);
                                    created = true;
                                }
                                if (!RunningEmulatorCatalog.access$isDisposing$p(this.this$0)) {
                                    ((Map)this.$newEmulators).put(emulator.getEmulatorId(), emulator);
                                }
                            }
                            this.$latch.countDown();
                            if (emulator != null && created && emulator.getEmulatorId().isEmbedded()) {
                                emulator.connect();
                            }
                        }
                    });
                }
                latch.await();
            }
            Set set = newEmulators.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newEmulators.keys");
            Collection removedEmulators = MapsKt.minus((Map)oldEmulators, (Iterable)set).values();
            Collection addedEmulators = MapsKt.minus((Map)newEmulators, (Iterable)oldEmulators.keySet()).values();
            List<? extends Listener> listenersSnapshot = null;
            Object $i$f$associateByTo232 = this.dataLock;
            synchronized ($i$f$associateByTo232) {
                boolean bl = false;
                if (this.isDisposing) {
                    return;
                }
                this.lastUpdateStartTime = start2;
                this.lastUpdateDuration = System.currentTimeMillis() - start2;
                ImmutableSet immutableSet = ImmutableSet.copyOf(newEmulators.values());
                Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"copyOf(newEmulators.values)");
                this.emulators = (Set)immutableSet;
                listenersSnapshot = this.listeners;
                for (SettableFuture<Set<EmulatorController>> settableFuture : futures) {
                    settableFuture.set(this.emulators);
                }
                if (!this.isDisposing) {
                    this.scheduleUpdate();
                }
                Unit $i$a$-synchronized-RunningEmulatorCatalog$update$5 = Unit.INSTANCE;
            }
            if (!((Collection)listenersSnapshot).isEmpty()) {
                block14: for (EmulatorController emulator : removedEmulators) {
                    Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_DISCOVERY.get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_DISCOVERY.get()");
                    if (((Boolean)t).booleanValue()) {
                        RunningEmulatorCatalog $this$thisLogger$iv = this;
                        boolean bl = false;
                        Logger logger2 = Logger.getInstance(RunningEmulatorCatalog.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                        logger2.info("Emulator " + emulator.getEmulatorId() + " stopped");
                    }
                    for (Listener listener2 : listenersSnapshot) {
                        if (this.isDisposing) continue block14;
                        listener2.emulatorRemoved(emulator);
                    }
                }
                block16: for (EmulatorController emulator : addedEmulators) {
                    for (Listener listener3 : listenersSnapshot) {
                        if (this.isDisposing) continue block16;
                        listener3.emulatorAdded(emulator);
                    }
                }
            }
            for (EmulatorController emulator : removedEmulators) {
                Disposer.dispose((Disposable)emulator);
            }
        }
        catch (IOException e) {
            RunningEmulatorCatalog $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(RunningEmulatorCatalog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(T::class.java)");
            logger3.error("Running Emulator detection failed", (Throwable)e);
            Object object2 = this.dataLock;
            synchronized (object2) {
                boolean bl = false;
                for (SettableFuture<Set<EmulatorController>> future3 : futures) {
                    future3.setException((Throwable)e);
                }
                if (!this.isDisposing) {
                    this.scheduleUpdate();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> readDirectoryContents(Path directory) {
        List list2;
        try {
            List list3;
            AutoCloseable autoCloseable = Files.list(directory);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                List list4 = stream.filter(new Predicate(this){
                    final /* synthetic */ RunningEmulatorCatalog this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final boolean test(Path it) {
                        return RunningEmulatorCatalog.access$getFileNamePattern$p(this.this$0).matcher(((Object)it.getFileName()).toString()).matches();
                    }
                }).toList();
                list3 = list4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue(list3, (String)"{\n      Files.list(direc\u2026 }.toList()\n      }\n    }");
            list2 = list3;
        }
        catch (NoSuchFileException e) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final EmulatorId readEmulatorInfo(Path file2) {
        int grpcPort = 0;
        String grpcCertificate = null;
        String grpcToken = null;
        String avdId = null;
        String avdName = null;
        Path avdFolder = null;
        int serialPort = 0;
        int adbPort = 0;
        List<String> commandLine = CollectionsKt.emptyList();
        try {
            for (String line2 : Files.readAllLines(file2)) {
                Intrinsics.checkNotNullExpressionValue((Object)line2, (String)"line");
                if (StringsKt.startsWith$default((String)line2, (String)"grpc.port=", (boolean)false, (int)2, null)) {
                    String string = line2.substring(10);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    grpcPort = StringUtil.parseInt((String)string, (int)0);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"grpc.certificate=", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)line2.substring(17), (String)"this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"grpc.token=", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)line2.substring(11), (String)"this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"avd.id=", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)line2.substring(7), (String)"this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"avd.name=", (boolean)false, (int)2, null)) {
                    String name2;
                    Intrinsics.checkNotNullExpressionValue((Object)line2.substring(9), (String)"this as java.lang.String).substring(startIndex)");
                    avdName = StringsKt.contains$default((CharSequence)name2, (char)' ', (boolean)false, (int)2, null) ? name2 : StringsKt.replace$default((String)name2, (char)'_', (char)' ', (boolean)false, (int)4, null);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"avd.dir=", (boolean)false, (int)2, null)) {
                    String string = line2.substring(8);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    avdFolder = Paths.get(string, new String[0]);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"port.serial=", (boolean)false, (int)2, null)) {
                    String string = line2.substring(12);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    serialPort = StringUtil.parseInt((String)string, (int)0);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line2, (String)"port.adb=", (boolean)false, (int)2, null)) {
                    String string = line2.substring(9);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    adbPort = StringUtil.parseInt((String)string, (int)0);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)line2, (String)"cmdline=", (boolean)false, (int)2, null)) continue;
                String string = line2.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                commandLine = CommandLineDecoderUtils.decodeCommandLine(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (grpcPort <= 0 || avdId == null || avdName == null || avdFolder == null || serialPort <= 0 && adbPort <= 0 || commandLine.isEmpty()) {
            return null;
        }
        return new EmulatorId(grpcPort, grpcCertificate, grpcToken, avdId, avdName, avdFolder, serialPort, adbPort, commandLine, ((Object)file2.getFileName()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTreeDispose() {
        this.isDisposing = true;
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            for (EmulatorController emulator : this.emulators) {
                if (!emulator.getEmulatorId().isEmbedded()) continue;
                emulator.shutdown();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void overrideRegistrationDirectory(@Nullable Path directory) {
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            this.listeners = CollectionsKt.emptyList();
            this.updateIntervalsByListener.clear();
            this.emulators = SetsKt.emptySet();
            Path path2 = directory;
            if (path2 == null) {
                path2 = RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
            }
            this.registrationDirectory = path2;
            Unit unit = Unit.INSTANCE;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.updateLock;
        object = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            ((ReentrantReadWriteLock.ReadLock)object).unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                ((ReentrantReadWriteLock.ReadLock)object).lock();
            }
            writeLock.unlock();
        }
    }

    @JvmStatic
    @NotNull
    public static final RunningEmulatorCatalog getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    private static final Path computeRegistrationDirectory() {
        return RunningEmulatorCatalog.Companion.computeRegistrationDirectory();
    }

    @JvmStatic
    private static final Path computeRegistrationDirectoryContainer() {
        return RunningEmulatorCatalog.Companion.computeRegistrationDirectoryContainer();
    }

    @JvmStatic
    private static final Path resolvePath(String pattern) {
        return RunningEmulatorCatalog.Companion.resolvePath(pattern);
    }

    @JvmStatic
    private static final String getEnvironmentVariable(String name2) {
        return RunningEmulatorCatalog.Companion.getEnvironmentVariable(name2);
    }

    @JvmStatic
    private static final String getUid() {
        return RunningEmulatorCatalog.Companion.getUid();
    }

    public static final /* synthetic */ boolean access$isDisposing$p(RunningEmulatorCatalog $this) {
        return $this.isDisposing;
    }

    public static final /* synthetic */ EmulatorId access$readEmulatorInfo(RunningEmulatorCatalog $this, Path file2) {
        return $this.readEmulatorInfo(file2);
    }

    public static final /* synthetic */ ReentrantReadWriteLock access$getUpdateLock$p(RunningEmulatorCatalog $this) {
        return $this.updateLock;
    }

    public static final /* synthetic */ void access$update(RunningEmulatorCatalog $this) {
        $this.update();
    }

    public static final /* synthetic */ Pattern access$getFileNamePattern$p(RunningEmulatorCatalog $this) {
        return $this.fileNamePattern;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Companion;", "", "()V", "REGISTRATION_DIRECTORY_RELATIVE_PATH", "", "computeRegistrationDirectory", "Ljava/nio/file/Path;", "computeRegistrationDirectoryContainer", "getEnvironmentVariable", "name", "getInstance", "Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog;", "getUid", "resolvePath", "pattern", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nRunningEmulatorCatalog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,503:1\n8#2:504\n*S KotlinDebug\n*F\n+ 1 RunningEmulatorCatalog.kt\ncom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Companion\n*L\n415#1:504\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RunningEmulatorCatalog getInstance() {
            Object object = ApplicationManager.getApplication().getService(RunningEmulatorCatalog.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026latorCatalog::class.java)");
            return (RunningEmulatorCatalog)object;
        }

        @JvmStatic
        private final Path computeRegistrationDirectory() {
            Path container = this.computeRegistrationDirectoryContainer();
            if (container == null) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.error("Unable to determine Emulator registration directory");
            }
            Path path2 = container;
            return path2 != null ? path2.resolve(RunningEmulatorCatalog.REGISTRATION_DIRECTORY_RELATIVE_PATH) : null;
        }

        @JvmStatic
        private final Path computeRegistrationDirectoryContainer() {
            if (SystemInfo.isMac) {
                return this.resolvePath("{HOME}/Library/Caches/TemporaryItems");
            }
            if (SystemInfo.isWindows) {
                return this.resolvePath("{LOCALAPPDATA}/Temp");
            }
            String[] stringArray = new String[]{"{XDG_RUNTIME_DIR}", "/run/user/{UID}", "{HOME}/.android"};
            for (String pattern : stringArray) {
                Path dir;
                if (this.resolvePath(pattern) == null || !Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            return this.resolvePath(FileUtil.getTempDirectory() + "/android-{USER}");
        }

        @JvmStatic
        private final Path resolvePath(String pattern) {
            StringBuilder result2 = new StringBuilder();
            StringBuilder name2 = new StringBuilder();
            int braceDepth = 0;
            int n = pattern.length();
            for (int i = 0; i < n; ++i) {
                char c = pattern.charAt(i);
                if (c == '{') {
                    ++braceDepth;
                    continue;
                }
                if (c == '}') {
                    if (--braceDepth != 0 || !(((CharSequence)name2).length() > 0)) continue;
                    String string = name2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.toString()");
                    String value2 = this.getEnvironmentVariable(string);
                    result2.append(value2);
                    StringsKt.clear((StringBuilder)name2);
                    continue;
                }
                if (braceDepth > 0) {
                    name2.append(c);
                    continue;
                }
                result2.append(c);
            }
            return Paths.get(result2.toString(), new String[0]);
        }

        @JvmStatic
        private final String getEnvironmentVariable(String name2) {
            String value2 = System.getenv(name2);
            if (value2 == null && Intrinsics.areEqual((Object)name2, (Object)"UID")) {
                return this.getUid();
            }
            return value2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        private final String getUid() {
            try {
                String userName = System.getProperty("user.name");
                String command = "id -u " + userName;
                Process process2 = Runtime.getRuntime().exec(command);
                Closeable closeable = process2.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    String result2 = ((Object)StringsKt.trim((CharSequence)new String(byArray, charset2))).toString();
                    if (((CharSequence)result2).length() == 0) {
                        String string = null;
                        return string;
                    }
                    String string = result2;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Listener;", "", "emulatorAdded", "", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "emulatorRemoved", "intellij.android.streaming"})
    public static interface Listener {
        @AnyThread
        public void emulatorAdded(@NotNull EmulatorController var1);

        @AnyThread
        public void emulatorRemoved(@NotNull EmulatorController var1);
    }
}

