/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.streaming.emulator.EmulatorDisplayPanel;
import com.android.tools.idea.streaming.emulator.EmulatorPanelState;
import com.android.tools.idea.streaming.emulator.SplitNode;
import com.android.tools.idea.streaming.emulator.SplitType;
import com.intellij.ui.OnePixelSplitter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0006\u0010!\u001a\u00020\u001fR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorSplitPanel;", "Ljavax/swing/JPanel;", "layoutNode", "Lcom/android/tools/idea/streaming/emulator/SplitNode;", "(Lcom/android/tools/idea/streaming/emulator/SplitNode;)V", "splitType", "Lcom/android/tools/idea/streaming/emulator/SplitType;", "proportion", "", "(Lcom/android/tools/idea/streaming/emulator/SplitType;D)V", "value", "Ljavax/swing/JComponent;", "firstComponent", "getFirstComponent", "()Ljavax/swing/JComponent;", "setFirstComponent", "(Ljavax/swing/JComponent;)V", "getProportion", "()D", "setProportion", "(D)V", "secondComponent", "getSecondComponent", "setSecondComponent", "getSplitType", "()Lcom/android/tools/idea/streaming/emulator/SplitType;", "setSplitType", "(Lcom/android/tools/idea/streaming/emulator/SplitType;)V", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "getChildState", "Lcom/android/tools/idea/streaming/emulator/EmulatorPanelState;", "child", "getState", "intellij.android.streaming"})
public final class EmulatorSplitPanel
extends JPanel {
    @NotNull
    private final OnePixelSplitter splitter;

    public EmulatorSplitPanel(@NotNull SplitType splitType, double proportion) {
        Intrinsics.checkNotNullParameter((Object)((Object)splitType), (String)"splitType");
        super(new BorderLayout());
        this.splitter = new OnePixelSplitter(splitType == SplitType.VERTICAL, (float)proportion);
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.add((Component)this.splitter, "Center");
    }

    @NotNull
    public final SplitType getSplitType() {
        return this.splitter.getOrientation() ? SplitType.VERTICAL : SplitType.HORIZONTAL;
    }

    public final void setSplitType(@NotNull SplitType value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this.splitter.setOrientation(value2 == SplitType.VERTICAL);
    }

    public final double getProportion() {
        return this.splitter.getProportion();
    }

    public final void setProportion(double value2) {
        this.splitter.setProportion((float)value2);
    }

    @NotNull
    public final JComponent getFirstComponent() {
        JComponent jComponent = this.splitter.getFirstComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"splitter.firstComponent");
        return jComponent;
    }

    public final void setFirstComponent(@NotNull JComponent value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.splitter.setFirstComponent(value2);
    }

    @NotNull
    public final JComponent getSecondComponent() {
        JComponent jComponent = this.splitter.getSecondComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"splitter.secondComponent");
        return jComponent;
    }

    public final void setSecondComponent(@NotNull JComponent value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.splitter.setSecondComponent(value2);
    }

    public EmulatorSplitPanel(@NotNull SplitNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this(layoutNode.getSplitType(), layoutNode.getSplitRatio());
    }

    @NotNull
    public final EmulatorPanelState getState() {
        return new EmulatorPanelState(this.getSplitType(), this.getProportion(), this.getChildState(this.getFirstComponent()), this.getChildState(this.getSecondComponent()));
    }

    private final EmulatorPanelState getChildState(JComponent child) {
        EmulatorPanelState emulatorPanelState;
        JComponent jComponent = child;
        if (jComponent instanceof EmulatorDisplayPanel) {
            emulatorPanelState = new EmulatorPanelState(((EmulatorDisplayPanel)((Object)child)).getDisplayId());
        } else if (jComponent instanceof EmulatorSplitPanel) {
            emulatorPanelState = ((EmulatorSplitPanel)child).getState();
        } else {
            throw new IllegalArgumentException();
        }
        return emulatorPanelState;
    }
}

