/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.emulator.control.KeyboardEvent;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"EMULATOR_MODIFIER_KEYS", "", "Lkotlin/Pair;", "", "", "pressModifierKeys", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "modifiers", "releaseModifierKeys", "intellij.android.streaming"})
public final class EmulatorKeyStrokeKt {
    @NotNull
    private static final List<Pair<Integer, String>> EMULATOR_MODIFIER_KEYS;

    public static final void pressModifierKeys(@NotNull EmulatorController $this$pressModifierKeys, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$pressModifierKeys, (String)"<this>");
        if (modifiers != 0) {
            int currentModifiers = 0;
            KeyboardEvent.Builder event2 = KeyboardEvent.newBuilder().setEventType(KeyboardEvent.KeyEventType.keydown);
            for (Pair<Integer, String> pair : EMULATOR_MODIFIER_KEYS) {
                int modifier2 = ((Number)pair.component1()).intValue();
                String key = (String)pair.component2();
                if ((modifiers & modifier2) == 0) continue;
                KeyboardEvent keyboardEvent = event2.setKey(key).build();
                Intrinsics.checkNotNullExpressionValue((Object)keyboardEvent, (String)"event.setKey(key).build()");
                EmulatorController.sendKey$default($this$pressModifierKeys, keyboardEvent, null, 2, null);
                if ((currentModifiers |= modifier2) != modifiers) continue;
                break;
            }
        }
    }

    public static final void releaseModifierKeys(@NotNull EmulatorController $this$releaseModifierKeys, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$releaseModifierKeys, (String)"<this>");
        if (modifiers != 0) {
            int currentModifiers = modifiers;
            KeyboardEvent.Builder event2 = KeyboardEvent.newBuilder().setEventType(KeyboardEvent.KeyEventType.keyup);
            for (Pair pair : CollectionsKt.asReversed(EMULATOR_MODIFIER_KEYS)) {
                int modifier2 = ((Number)pair.component1()).intValue();
                String key = (String)pair.component2();
                if ((currentModifiers & modifier2) == 0) continue;
                KeyboardEvent keyboardEvent = event2.setKey(key).build();
                Intrinsics.checkNotNullExpressionValue((Object)keyboardEvent, (String)"event.setKey(key).build()");
                EmulatorController.sendKey$default($this$releaseModifierKeys, keyboardEvent, null, 2, null);
                if ((currentModifiers &= ~modifier2) != 0) continue;
                break;
            }
        }
    }

    static {
        Object[] objectArray = new Pair[]{new Pair((Object)512, (Object)"Alt"), new Pair((Object)64, (Object)"Shift"), new Pair((Object)128, (Object)"Control"), new Pair((Object)256, (Object)"Meta")};
        EMULATOR_MODIFIER_KEYS = CollectionsKt.listOf((Object[])objectArray);
    }
}

