/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.UiThread;
import com.android.emulator.control.ClipData;
import com.android.ide.common.util.Cancelable;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.Empty;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import java.awt.EventQueue;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0015H\u0003J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0007J\b\u0010#\u001a\u00020\u001eH\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0018\u00010\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer;", "Lcom/intellij/openapi/Disposable;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "parentDisposable", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/intellij/openapi/Disposable;)V", "active", "", "clipboardFeed", "Lcom/android/ide/common/util/Cancelable;", "clipboardReceiver", "Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver;", "connected", "getConnected", "()Z", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "kotlin.jvm.PlatformType", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "lastClipboardText", "", "lock", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "cancelClipboardFeed", "", "dispose", "getClipboardText", "requestClipboardFeed", "setDeviceClipboardAndKeepHostClipboardInSync", "stopKeepingHostClipboardInSync", "ClipboardReceiver", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nEmulatorClipboardSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n8#2:141\n12#2,5:142\n*S KotlinDebug\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer\n*L\n53#1:141\n74#1:142,5\n*E\n"})
public final class EmulatorClipboardSynchronizer
implements Disposable {
    @NotNull
    private final EmulatorController emulator;
    private final CopyPasteManager copyPasteManager;
    @Nullable
    private Cancelable clipboardFeed;
    @Nullable
    private ClipboardReceiver clipboardReceiver;
    private boolean active;
    @NotNull
    private final Object lock;
    @NotNull
    private String lastClipboardText;

    public EmulatorClipboardSynchronizer(@NotNull EmulatorController emulator, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.emulator = emulator;
        this.copyPasteManager = CopyPasteManager.getInstance();
        this.lock = new Object();
        this.lastClipboardText = "";
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public final EmulatorController getEmulator() {
        return this.emulator;
    }

    private final boolean getConnected() {
        return this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED;
    }

    private final Logger getLogger() {
        EmulatorClipboardSynchronizer $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(EmulatorClipboardSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        return logger2;
    }

    public void dispose() {
        this.cancelClipboardFeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void setDeviceClipboardAndKeepHostClipboardInSync() {
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-EmulatorClipboardSynchronizer$setDeviceClipboardAndKeepHostClipboardInSync$22 = false;
            this.active = true;
            Unit $i$a$-synchronized-EmulatorClipboardSynchronizer$setDeviceClipboardAndKeepHostClipboardInSync$22 = Unit.INSTANCE;
        }
        String text2 = this.getClipboardText();
        if (((CharSequence)text2).length() == 0 || Intrinsics.areEqual((Object)text2, (Object)this.lastClipboardText)) {
            this.requestClipboardFeed();
        } else {
            this.lastClipboardText = text2;
            Logger $this$debug_u24default$iv = this.getLogger();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("EmulatorClipboardSynchronizer.setDeviceClipboardAndKeepHostClipboardInSync: \"" + text2 + "\"", e$iv);
            }
            ClipData clipData = ClipData.newBuilder().setText(text2).build();
            Intrinsics.checkNotNullExpressionValue((Object)clipData, (String)"newBuilder().setText(text).build()");
            this.emulator.setClipboard(clipData, (StreamObserver<Empty>)new EmptyStreamObserver<Empty>(this){
                final /* synthetic */ EmulatorClipboardSynchronizer this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCompleted() {
                    EmulatorClipboardSynchronizer.access$requestClipboardFeed(this.this$0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void stopKeepingHostClipboardInSync() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.active = false;
            this.cancelClipboardFeed();
            this.lastClipboardText = "";
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cancelClipboardFeed() {
        this.clipboardReceiver = null;
        Cancelable cancelable = this.clipboardFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.clipboardFeed = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void requestClipboardFeed() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.active) {
                this.cancelClipboardFeed();
                if (this.getConnected()) {
                    ClipboardReceiver receiver2;
                    this.clipboardReceiver = receiver2 = new ClipboardReceiver();
                    this.clipboardFeed = this.emulator.streamClipboard((StreamObserver<ClipData>)((StreamObserver)receiver2));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @UiThread
    private final String getClipboardText() {
        String string;
        DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.stringFlavor};
        if (this.copyPasteManager.areDataFlavorsAvailable(dataFlavorArray)) {
            string = (String)this.copyPasteManager.getContents(DataFlavor.stringFlavor);
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    public static final /* synthetic */ void access$requestClipboardFeed(EmulatorClipboardSynchronizer $this) {
        $this.requestClipboardFeed();
    }

    public static final /* synthetic */ String access$getLastClipboardText$p(EmulatorClipboardSynchronizer $this) {
        return $this.lastClipboardText;
    }

    public static final /* synthetic */ void access$setLastClipboardText$p(EmulatorClipboardSynchronizer $this, String string) {
        $this.lastClipboardText = string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver;", "Lcom/android/tools/idea/streaming/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/ClipData;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer;)V", "onNext", "", "response", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorClipboardSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n12#2,5:141\n*S KotlinDebug\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver\n*L\n124#1:141,5\n*E\n"})
    private final class ClipboardReceiver
    extends EmptyStreamObserver<ClipData> {
        @Override
        public void onNext(@NotNull ClipData response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            Logger $this$debug_u24default$iv = EmulatorClipboardSynchronizer.this.getLogger();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("ClipboardReceiver.onNext: \"" + response2.getText() + "\"", e$iv);
            }
            if (!Intrinsics.areEqual((Object)EmulatorClipboardSynchronizer.this.clipboardReceiver, (Object)this)) {
                return;
            }
            String string = response2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.text");
            if (((CharSequence)string).length() > 0) {
                EventQueue.invokeLater(new Runnable(response2, EmulatorClipboardSynchronizer.this){
                    final /* synthetic */ ClipData $response;
                    final /* synthetic */ EmulatorClipboardSynchronizer this$0;
                    {
                        this.$response = $response;
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        if (!Intrinsics.areEqual((Object)this.$response.getText(), (Object)EmulatorClipboardSynchronizer.access$getLastClipboardText$p(this.this$0))) {
                            String string = this.$response.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.text");
                            EmulatorClipboardSynchronizer.access$setLastClipboardText$p(this.this$0, string);
                            StringSelection content2 = new StringSelection(this.$response.getText());
                            ClipboardSynchronizer.getInstance().setContent((Transferable)content2, (ClipboardOwner)content2);
                        }
                    }
                });
            }
        }
    }
}

