/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.ControlMessage;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/streaming/device/MotionEventMessage;", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "pointers", "", "Lcom/android/tools/idea/streaming/device/MotionEventMessage$Pointer;", "action", "", "displayId", "(Ljava/util/List;II)V", "getAction", "()I", "getDisplayId", "getPointers", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "toString", "", "Companion", "Pointer", "intellij.android.streaming"})
public final class MotionEventMessage
extends ControlMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pointer> pointers;
    private final int action;
    private final int displayId;
    public static final int TYPE = 1;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_SCROLL = 8;
    public static final int AXIS_VSCROLL = 9;
    public static final int AXIS_HSCROLL = 10;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;

    public MotionEventMessage(@NotNull List<Pointer> pointers, int action2, int displayId) {
        Intrinsics.checkNotNullParameter(pointers, (String)"pointers");
        super(1, null);
        this.pointers = pointers;
        this.action = action2;
        this.displayId = displayId;
    }

    @NotNull
    public final List<Pointer> getPointers() {
        return this.pointers;
    }

    public final int getAction() {
        return this.action;
    }

    public final int getDisplayId() {
        return this.displayId;
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super.serialize(stream);
        stream.writeInt(this.pointers.size());
        for (Pointer pointer : this.pointers) {
            pointer.serialize(stream);
        }
        stream.writeInt(this.action);
        stream.writeInt(this.displayId);
    }

    @Override
    @NotNull
    public String toString() {
        return "MotionEventMessage(pointers=" + this.pointers + ", action=" + this.action + ", displayId=" + this.displayId + ")";
    }

    @NotNull
    public final List<Pointer> component1() {
        return this.pointers;
    }

    public final int component2() {
        return this.action;
    }

    public final int component3() {
        return this.displayId;
    }

    @NotNull
    public final MotionEventMessage copy(@NotNull List<Pointer> pointers, int action2, int displayId) {
        Intrinsics.checkNotNullParameter(pointers, (String)"pointers");
        return new MotionEventMessage(pointers, action2, displayId);
    }

    public static /* synthetic */ MotionEventMessage copy$default(MotionEventMessage motionEventMessage, List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            list2 = motionEventMessage.pointers;
        }
        if ((n3 & 2) != 0) {
            n = motionEventMessage.action;
        }
        if ((n3 & 4) != 0) {
            n2 = motionEventMessage.displayId;
        }
        return motionEventMessage.copy(list2, n, n2);
    }

    @Override
    public int hashCode() {
        int result2 = ((Object)this.pointers).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.action);
        result2 = result2 * 31 + Integer.hashCode(this.displayId);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MotionEventMessage)) {
            return false;
        }
        MotionEventMessage motionEventMessage = (MotionEventMessage)other;
        if (!Intrinsics.areEqual(this.pointers, motionEventMessage.pointers)) {
            return false;
        }
        if (this.action != motionEventMessage.action) {
            return false;
        }
        return this.displayId == motionEventMessage.displayId;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/device/MotionEventMessage$Companion;", "Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "()V", "ACTION_CANCEL", "", "ACTION_DOWN", "ACTION_MASK", "ACTION_MOVE", "ACTION_OUTSIDE", "ACTION_POINTER_DOWN", "ACTION_POINTER_INDEX_MASK", "ACTION_POINTER_INDEX_SHIFT", "ACTION_POINTER_UP", "ACTION_SCROLL", "ACTION_UP", "AXIS_HSCROLL", "AXIS_VSCROLL", "TYPE", "deserialize", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "deserializePointer", "Lcom/android/tools/idea/streaming/device/MotionEventMessage$Pointer;", "intellij.android.streaming"})
    public static final class Companion
    implements ControlMessage.Deserializer {
        private Companion() {
        }

        @Override
        @NotNull
        public ControlMessage deserialize(@NotNull Base128InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int n = stream.readInt();
            ArrayList<Pointer> pointers = new ArrayList<Pointer>(n);
            for (int i = 0; i < n; ++i) {
                pointers.add(this.deserializePointer(stream));
            }
            int action2 = stream.readInt();
            int displayId = stream.readInt();
            return new MotionEventMessage((List<Pointer>)pointers, action2, displayId);
        }

        @NotNull
        public final Pointer deserializePointer(@NotNull Base128InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int x = stream.readInt();
            int y = stream.readInt();
            int pointerId = stream.readInt();
            Int2FloatOpenHashMap axisValues = null;
            int numAxisValues = stream.readInt();
            if (numAxisValues > 0) {
                axisValues = new Int2FloatOpenHashMap(numAxisValues);
                int n = 0;
                while (n < numAxisValues) {
                    int it = n++;
                    boolean bl = false;
                    axisValues.put(stream.readInt(), stream.readFloat());
                }
            }
            return new Pointer(x, y, pointerId, axisValues);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/streaming/device/MotionEventMessage$Pointer;", "", "x", "", "y", "pointerId", "axisValues", "Lit/unimi/dsi/fastutil/ints/Int2FloatOpenHashMap;", "(IIILit/unimi/dsi/fastutil/ints/Int2FloatOpenHashMap;)V", "getAxisValues", "()Lit/unimi/dsi/fastutil/ints/Int2FloatOpenHashMap;", "getPointerId", "()I", "getX", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "toString", "", "intellij.android.streaming"})
    public static final class Pointer {
        private final int x;
        private final int y;
        private final int pointerId;
        @Nullable
        private final Int2FloatOpenHashMap axisValues;

        public Pointer(int x, int y, int pointerId, @Nullable Int2FloatOpenHashMap axisValues) {
            this.x = x;
            this.y = y;
            this.pointerId = pointerId;
            this.axisValues = axisValues;
        }

        public /* synthetic */ Pointer(int n, int n2, int n3, Int2FloatOpenHashMap int2FloatOpenHashMap, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                int2FloatOpenHashMap = null;
            }
            this(n, n2, n3, int2FloatOpenHashMap);
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getPointerId() {
            return this.pointerId;
        }

        @Nullable
        public final Int2FloatOpenHashMap getAxisValues() {
            return this.axisValues;
        }

        public final void serialize(@NotNull Base128OutputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            stream.writeInt(this.x);
            stream.writeInt(this.y);
            stream.writeInt(this.pointerId);
            Int2FloatOpenHashMap int2FloatOpenHashMap = this.axisValues;
            stream.writeInt(int2FloatOpenHashMap != null ? int2FloatOpenHashMap.size() : 0);
            if (this.axisValues != null) {
                ObjectIterator iterator2 = this.axisValues.int2FloatEntrySet().fastIterator();
                while (iterator2.hasNext()) {
                    Int2FloatMap.Entry entry = (Int2FloatMap.Entry)iterator2.next();
                    stream.writeInt(entry.getIntKey());
                    stream.writeFloat(entry.getFloatValue());
                }
            }
        }

        @NotNull
        public String toString() {
            if (this.axisValues == null) {
                return "Pointer(x=" + this.x + ", y=" + this.y + ", pointerId=" + this.pointerId + ")";
            }
            return "Pointer(x=" + this.x + ", y=" + this.y + ", pointerId=" + this.pointerId + ", axisValues=" + this.axisValues + ")";
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.pointerId;
        }

        @Nullable
        public final Int2FloatOpenHashMap component4() {
            return this.axisValues;
        }

        @NotNull
        public final Pointer copy(int x, int y, int pointerId, @Nullable Int2FloatOpenHashMap axisValues) {
            return new Pointer(x, y, pointerId, axisValues);
        }

        public static /* synthetic */ Pointer copy$default(Pointer pointer, int n, int n2, int n3, Int2FloatOpenHashMap int2FloatOpenHashMap, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = pointer.x;
            }
            if ((n4 & 2) != 0) {
                n2 = pointer.y;
            }
            if ((n4 & 4) != 0) {
                n3 = pointer.pointerId;
            }
            if ((n4 & 8) != 0) {
                int2FloatOpenHashMap = pointer.axisValues;
            }
            return pointer.copy(n, n2, n3, int2FloatOpenHashMap);
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.x);
            result2 = result2 * 31 + Integer.hashCode(this.y);
            result2 = result2 * 31 + Integer.hashCode(this.pointerId);
            result2 = result2 * 31 + (this.axisValues == null ? 0 : this.axisValues.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pointer)) {
                return false;
            }
            Pointer pointer = (Pointer)other;
            if (this.x != pointer.x) {
                return false;
            }
            if (this.y != pointer.y) {
                return false;
            }
            if (this.pointerId != pointer.pointerId) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.axisValues, (Object)pointer.axisValues);
        }
    }
}

