/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.streaming.AbstractDisplayView;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.DeviceMirroringSettingsListener;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.AndroidKeyEventActionType;
import com.android.tools.idea.streaming.device.AndroidKeyStroke;
import com.android.tools.idea.streaming.device.AndroidKeyStrokeKt;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceClipboardSynchronizer;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.DeviceView;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import com.android.tools.idea.streaming.device.MotionEventMessage;
import com.android.tools.idea.streaming.device.SetMaxVideoResolutionMessage;
import com.android.tools.idea.streaming.device.TextInputMessage;
import com.android.tools.idea.streaming.device.VideoDecoder;
import com.android.tools.idea.streaming.device.VideoDecoderKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n*\u0001\r\b\u0000\u0018\u0000 e2\u00020\u00012\u00020\u00022\u00020\u0003:\u0006efghijB%\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0018H\u0007J\b\u0010=\u001a\u000200H\u0014J\b\u0010>\u001a\u00020 H\u0014J\u0010\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020\bH\u0002J!\u0010@\u001a\u00020;2\u0006\u0010A\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010D\u001a\u00020;H\u0002J\u001c\u0010E\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010GH\u0002J\b\u0010H\u001a\u00020;H\u0016J\u0010\u0010I\u001a\u0002002\u0006\u0010J\u001a\u00020KH\u0002J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010O\u001a\u000206H\u0002J \u0010P\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010O\u001a\u0002062\b\u0010Q\u001a\u0004\u0018\u00010RH\u0002J\u0010\u0010S\u001a\u00020;2\u0006\u0010T\u001a\u00020UH\u0014J\u0010\u0010V\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0018H\u0007J$\u0010W\u001a\u00020;2\u0006\u0010O\u001a\u0002062\u0006\u0010X\u001a\u00020\b2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010RH\u0002J$\u0010Y\u001a\u00020;2\u0006\u0010O\u001a\u0002062\u0006\u0010X\u001a\u00020\b2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010RH\u0002J(\u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\b2\u0006\u0010]\u001a\u00020\b2\u0006\u0010^\u001a\u00020\bH\u0016J\u0010\u0010_\u001a\u00020;2\u0006\u0010`\u001a\u00020aH\u0017J\b\u0010b\u001a\u00020;H\u0002J\b\u0010c\u001a\u00020;H\u0002J\b\u0010d\u001a\u00020;H\u0002R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001e\u0010(\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u000602R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00107\u001a\u0002002\u0006\u0010\u0011\u001a\u000200@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b8\u00109R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006k"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView;", "Lcom/android/tools/idea/streaming/AbstractDisplayView;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/streaming/DeviceMirroringSettingsListener;", "disposableParent", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "initialDisplayOrientation", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/device/DeviceClient;ILcom/intellij/openapi/project/Project;)V", "agentTerminationListener", "com/android/tools/idea/streaming/device/DeviceView$agentTerminationListener$1", "Lcom/android/tools/idea/streaming/device/DeviceView$agentTerminationListener$1;", "clipboardSynchronizer", "Lcom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer;", "value", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "connectionState", "setConnectionState", "(Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;)V", "connectionStateListeners", "", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionStateListener;", "getDeviceClient", "()Lcom/android/tools/idea/streaming/device/DeviceClient;", "deviceController", "Lcom/android/tools/idea/streaming/device/DeviceController;", "getDeviceController$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/device/DeviceController;", "deviceDisplaySize", "Ljava/awt/Dimension;", "getDeviceDisplaySize$intellij_android_streaming", "()Ljava/awt/Dimension;", "deviceSerialNumber", "", "getDeviceSerialNumber", "()Ljava/lang/String;", "<set-?>", "displayOrientationCorrectionQuadrants", "getDisplayOrientationCorrectionQuadrants$intellij_android_streaming", "()I", "displayOrientationQuadrants", "getDisplayOrientationQuadrants", "displayTransform", "Ljava/awt/geom/AffineTransform;", "disposed", "", "frameListener", "Lcom/android/tools/idea/streaming/device/DeviceView$MyFrameListener;", "isConnected", "()Z", "lastTouchCoordinates", "Ljava/awt/Point;", "multiTouchMode", "setMultiTouchMode", "(Z)V", "addConnectionStateListener", "", "listener", "canZoom", "computeActualSize", "rotationQuadrants", "connectToAgent", "maxOutputSize", "(Ljava/awt/Dimension;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectToAgentAsync", "connected", "disconnected", "exception", "", "dispose", "isInsideDisplay", "event", "Ljava/awt/event/MouseEvent;", "originalAndMirroredPointer", "", "Lcom/android/tools/idea/streaming/device/MotionEventMessage$Pointer;", "p", "originalPointer", "axisValues", "Lit/unimi/dsi/fastutil/ints/Int2FloatOpenHashMap;", "paintComponent", "g", "Ljava/awt/Graphics;", "removeConnectionStateListener", "sendMotionEvent", "action", "sendMotionEventDisplayCoordinates", "setBounds", "x", "y", "width", "height", "settingsChanged", "settings", "Lcom/android/tools/idea/streaming/DeviceMirroringSettings;", "startClipboardSynchronization", "stopClipboardSynchronization", "updateVideoSize", "Companion", "ConnectionState", "ConnectionStateListener", "MyFrameListener", "MyKeyListener", "MyMouseListener", "intellij.android.streaming"})
public final class DeviceView
extends AbstractDisplayView
implements Disposable,
DeviceMirroringSettingsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceClient deviceClient;
    private final int initialDisplayOrientation;
    @NotNull
    private final Project project;
    private int displayOrientationQuadrants;
    private int displayOrientationCorrectionQuadrants;
    @NotNull
    private ConnectionState connectionState;
    @NotNull
    private final Dimension deviceDisplaySize;
    @Nullable
    private DeviceClipboardSynchronizer clipboardSynchronizer;
    @NotNull
    private final List<ConnectionStateListener> connectionStateListeners;
    @NotNull
    private final agentTerminationListener.1 agentTerminationListener;
    @NotNull
    private final MyFrameListener frameListener;
    @NotNull
    private final AffineTransform displayTransform;
    private boolean disposed;
    private boolean multiTouchMode;
    @Nullable
    private Point lastTouchCoordinates;
    public static final float ANDROID_SCROLL_ADJUSTMENT_FACTOR = 0.125f;

    public DeviceView(@NotNull Disposable disposableParent, @NotNull DeviceClient deviceClient2, int initialDisplayOrientation, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)deviceClient2, (String)"deviceClient");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(0);
        this.deviceClient = deviceClient2;
        this.initialDisplayOrientation = initialDisplayOrientation;
        this.project = project;
        this.connectionState = ConnectionState.INITIAL;
        this.deviceDisplaySize = new Dimension();
        this.connectionStateListeners = new ArrayList();
        this.agentTerminationListener = new DeviceClient.AgentTerminationListener(this){
            final /* synthetic */ DeviceView this$0;
            {
                this.this$0 = $receiver;
            }

            public void agentTerminated(int exitCode2) {
                DeviceView.disconnected$default(this.this$0, DeviceView.access$getInitialDisplayOrientation$p(this.this$0), null, 2, null);
            }

            public void deviceDisconnected() {
                DeviceView.disconnected$default(this.this$0, DeviceView.access$getInitialDisplayOrientation$p(this.this$0), null, 2, null);
            }
        };
        this.frameListener = new MyFrameListener();
        this.displayTransform = new AffineTransform();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(@NotNull ComponentEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (this.getPhysicalWidth() > 0 && this.getPhysicalHeight() > 0 && connectionState == ConnectionState.INITIAL) {
                    this.connectToAgentAsync(initialDisplayOrientation);
                }
            }
        });
        MyMouseListener mouseListener2 = new MyMouseListener();
        this.addMouseListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
        this.addMouseWheelListener(mouseListener2);
        this.addKeyListener(new MyKeyListener());
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<DeviceMirroringSettingsListener> topic = DeviceMirroringSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    @NotNull
    public final DeviceClient getDeviceClient() {
        return this.deviceClient;
    }

    public final boolean isConnected() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    @Override
    @NotNull
    public String getDeviceSerialNumber() {
        return this.deviceClient.getDeviceSerialNumber();
    }

    @Override
    public int getDisplayOrientationQuadrants() {
        return this.displayOrientationQuadrants;
    }

    public final int getDisplayOrientationCorrectionQuadrants$intellij_android_streaming() {
        return this.displayOrientationCorrectionQuadrants;
    }

    private final void setConnectionState(ConnectionState value2) {
        if (this.connectionState != value2) {
            this.connectionState = value2;
            for (ConnectionStateListener listener2 : this.connectionStateListeners) {
                listener2.connectionStateChanged(this.getDeviceSerialNumber(), this.connectionState);
            }
        }
    }

    @Nullable
    public final DeviceController getDeviceController$intellij_android_streaming() {
        return this.deviceClient.getDeviceController();
    }

    @Override
    @NotNull
    public Dimension getDeviceDisplaySize$intellij_android_streaming() {
        return this.deviceDisplaySize;
    }

    private final void setMultiTouchMode(boolean value2) {
        if (value2 != this.multiTouchMode) {
            this.multiTouchMode = value2;
            this.repaint();
            Point point = this.lastTouchCoordinates;
            if (point != null) {
                int action2 = value2 ? 5 : 6;
                DeviceView.sendMotionEvent$default(this, point, action2, null, 4, null);
            }
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean resized = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (resized && this.getPhysicalWidth() > 0 && this.getPhysicalHeight() > 0) {
            if (this.connectionState == ConnectionState.INITIAL) {
                this.connectToAgentAsync(this.initialDisplayOrientation);
            } else {
                this.updateVideoSize();
            }
        }
    }

    private final void connectToAgentAsync(int initialDisplayOrientation) {
        this.setConnectionState(ConnectionState.CONNECTING);
        Dimension maxOutputSize = this.getPhysicalSize();
        BuildersKt.launch$default((CoroutineScope)CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, maxOutputSize, initialDisplayOrientation, null){
            int label;
            final /* synthetic */ DeviceView this$0;
            final /* synthetic */ Dimension $maxOutputSize;
            final /* synthetic */ int $initialDisplayOrientation;
            {
                this.this$0 = $receiver;
                this.$maxOutputSize = $maxOutputSize;
                this.$initialDisplayOrientation = $initialDisplayOrientation;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DeviceView.access$connectToAgent(this.this$0, this.$maxOutputSize, this.$initialDisplayOrientation, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object connectToAgent(Dimension var1_1, int var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof connectToAgent.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceView this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeviceView.access$connectToAgent(this.this$0, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.deviceClient.addAgentTerminationListener(this.agentTerminationListener);
                $continuation.L$0 = this;
                $continuation.I$0 = initialDisplayOrientation;
                $continuation.label = 1;
                v0 = this.deviceClient.establishAgentConnection((Dimension)maxOutputSize, initialDisplayOrientation, true, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var7_6) goto lbl21
lbl20:
                // 1 sources

                return var7_6;
lbl21:
                // 1 sources

                ** GOTO lbl29
            }
            case 1: {
                initialDisplayOrientation = $continuation.I$0;
                this = (DeviceView)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    v1 = this.deviceClient.getVideoDecoder();
                    if (v1 == null) {
                        return Unit.INSTANCE;
                    }
                    videoDecoder = v1;
                    videoDecoder.addFrameListener(this.frameListener);
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                        final /* synthetic */ DeviceView this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final void run() {
                            if (!DeviceView.access$getDisposed$p(this.this$0)) {
                                DeviceView.access$connected(this.this$0);
                                if (DeviceMirroringSettings.Companion.getInstance().getSynchronizeClipboard()) {
                                    DeviceView.access$startClipboardSynchronization(this.this$0);
                                    DeviceView.access$setClipboardSynchronizer$p(this.this$0, new DeviceClipboardSynchronizer(this.this$0, this.this$0.getDeviceClient()));
                                }
                                this.this$0.repaint();
                                DeviceView.access$updateVideoSize(this.this$0);
                            }
                        }
                    });
                }
                catch (CancellationException videoDecoder) {
                }
                catch (Throwable e) {
                    this.disconnected(initialDisplayOrientation, e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateVideoSize() {
        block2: {
            VideoDecoder videoDecoder = this.deviceClient.getVideoDecoder();
            if (videoDecoder == null) {
                return;
            }
            VideoDecoder videoDecoder2 = videoDecoder;
            if (Intrinsics.areEqual((Object)videoDecoder2.getMaxOutputSize(), (Object)this.getPhysicalSize())) break block2;
            videoDecoder2.setMaxOutputSize(this.getPhysicalSize());
            DeviceController deviceController = this.getDeviceController$intellij_android_streaming();
            if (deviceController != null) {
                deviceController.sendControlMessage(new SetMaxVideoResolutionMessage(this.getPhysicalWidth(), this.getPhysicalHeight()));
            }
        }
    }

    private final void connected() {
        if (this.connectionState == ConnectionState.CONNECTING) {
            this.hideDisconnectedStateMessage();
            this.setConnectionState(ConnectionState.CONNECTED);
        }
    }

    private final void disconnected(int initialDisplayOrientation, Throwable exception) {
        this.deviceClient.removeAgentTerminationListener(this.agentTerminationListener);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, exception, initialDisplayOrientation){
            final /* synthetic */ DeviceView this$0;
            final /* synthetic */ Throwable $exception;
            final /* synthetic */ int $initialDisplayOrientation;
            {
                this.this$0 = $receiver;
                this.$exception = $exception;
                this.$initialDisplayOrientation = $initialDisplayOrientation;
            }

            public final void run() {
                if (DeviceView.access$getDisposed$p(this.this$0)) {
                    return;
                }
                DeviceView.access$stopClipboardSynchronization(this.this$0);
                String message2 = null;
                AbstractDisplayView.Reconnector reconnector = null;
                switch (disconnected.WhenMappings.$EnumSwitchMapping$0[DeviceView.access$getConnectionState$p(this.this$0).ordinal()]) {
                    case 1: {
                        DeviceView $this$thisLogger$iv = this.this$0;
                        boolean $i$f$thisLogger = false;
                        Logger logger2 = Logger.getInstance(DeviceView.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                        logger2.error("Failed to initialize the screen sharing agent", this.$exception);
                        message2 = "Failed to initialize the device agent. See the error log.";
                        reconnector = this.this$0.new AbstractDisplayView.Reconnector("Retry", "Connecting to the device", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, this.$initialDisplayOrientation, null){
                            int label;
                            final /* synthetic */ DeviceView this$0;
                            final /* synthetic */ int $initialDisplayOrientation;
                            {
                                this.this$0 = $receiver;
                                this.$initialDisplayOrientation = $initialDisplayOrientation;
                                super(1, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DeviceView.access$connectToAgentAsync(this.this$0, this.$initialDisplayOrientation);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        break;
                    }
                    case 2: {
                        message2 = "Lost connection to the device. See the error log.";
                        reconnector = this.this$0.new AbstractDisplayView.Reconnector("Reconnect", "Attempting to reconnect", (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DeviceView this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DeviceView.access$connectToAgentAsync(this.this$0, -1);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                DeviceView.access$setConnectionState(this.this$0, ConnectionState.DISCONNECTED);
                DeviceView.access$showDisconnectedStateMessage(this.this$0, message2, reconnector);
            }
        });
    }

    static /* synthetic */ void disconnected$default(DeviceView deviceView, int n, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            throwable = null;
        }
        deviceView.disconnected(n, throwable);
    }

    public void dispose() {
        this.deviceClient.stopVideoStream();
        this.deviceClient.removeAgentTerminationListener(this.agentTerminationListener);
        this.disposed = true;
    }

    @Override
    protected boolean canZoom() {
        return this.connectionState == ConnectionState.CONNECTED;
    }

    @Override
    @NotNull
    protected Dimension computeActualSize() {
        return this.computeActualSize(this.getDisplayOrientationQuadrants());
    }

    private final Dimension computeActualSize(int rotationQuadrants) {
        return StreamingUtilsKt.rotatedByQuadrants(this.getDeviceDisplaySize$intellij_android_streaming(), rotationQuadrants);
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        VideoDecoder videoDecoder = this.deviceClient.getVideoDecoder();
        if (videoDecoder == null) {
            return;
        }
        VideoDecoder decoder = videoDecoder;
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        double physicalToVirtualScale = 1.0 / this.getScreenScale();
        ((Graphics2D)g).scale(physicalToVirtualScale, physicalToVirtualScale);
        decoder.consumeDisplayFrame(new Consumer(this, g){
            final /* synthetic */ DeviceView this$0;
            final /* synthetic */ Graphics $g;
            {
                this.this$0 = $receiver;
                this.$g = $g;
            }

            public final void accept(@NotNull VideoDecoder.VideoFrame displayFrame) {
                Intrinsics.checkNotNullParameter((Object)displayFrame, (String)"displayFrame");
                if (this.this$0.getDisplayOrientationQuadrants() != displayFrame.getOrientation() || this.this$0.getDeviceDisplaySize$intellij_android_streaming().width != 0 && this.this$0.getDeviceDisplaySize$intellij_android_streaming().width != displayFrame.getDisplaySize().width || this.this$0.getDeviceDisplaySize$intellij_android_streaming().height != 0 && this.this$0.getDeviceDisplaySize$intellij_android_streaming().height != displayFrame.getDisplaySize().height) {
                    this.this$0.zoom(ZoomType.FIT);
                }
                Dimension rotatedDisplaySize = StreamingUtilsKt.rotatedByQuadrants(displayFrame.getDisplaySize(), displayFrame.getOrientation());
                Dimension maxSize = DeviceView.access$computeMaxImageSize(this.this$0);
                double scale = DeviceView.access$roundScale(this.this$0, Math.min((double)maxSize.width / (double)rotatedDisplaySize.width, (double)maxSize.height / (double)rotatedDisplaySize.height));
                int w = RangesKt.coerceAtMost((int)StreamingUtilsKt.scaled(rotatedDisplaySize.width, scale), (int)DeviceView.access$getPhysicalWidth(this.this$0));
                int h = RangesKt.coerceAtMost((int)StreamingUtilsKt.scaled(rotatedDisplaySize.height, scale), (int)DeviceView.access$getPhysicalHeight(this.this$0));
                Rectangle displayRect = new Rectangle((DeviceView.access$getPhysicalWidth(this.this$0) - w) / 2, (DeviceView.access$getPhysicalHeight(this.this$0) - h) / 2, w, h);
                DeviceView.access$setDisplayRectangle(this.this$0, displayRect);
                BufferedImage image = displayFrame.getImage();
                if (displayRect.width == image.getWidth() && displayRect.height == image.getHeight()) {
                    ((Graphics2D)this.$g).drawImage(image, null, displayRect.x, displayRect.y);
                } else {
                    DeviceView.access$getDisplayTransform$p(this.this$0).setToTranslation(displayRect.x, displayRect.y);
                    DeviceView.access$getDisplayTransform$p(this.this$0).scale((double)displayRect.width / (double)image.getWidth(), (double)displayRect.height / (double)image.getHeight());
                    ((Graphics2D)this.$g).drawImage(image, DeviceView.access$getDisplayTransform$p(this.this$0), null);
                }
                this.this$0.getDeviceDisplaySize$intellij_android_streaming().setSize(displayFrame.getDisplaySize());
                DeviceView.access$setDisplayOrientationQuadrants$p(this.this$0, displayFrame.getOrientation());
                DeviceView.access$setDisplayOrientationCorrectionQuadrants$p(this.this$0, displayFrame.getOrientationCorrection());
                DeviceView.access$setFrameNumber(this.this$0, displayFrame.getFrameNumber());
                DeviceView.access$notifyFrameListeners(this.this$0, displayRect, displayFrame.getImage());
                DeviceClient $this$accept_u24lambda_u240 = this.this$0.getDeviceClient();
                boolean bl = false;
                if ($this$accept_u24lambda_u240.getStartTime$intellij_android_streaming() != 0L) {
                    long delay = System.currentTimeMillis() - $this$accept_u24lambda_u240.getStartTime$intellij_android_streaming();
                    long pushDelay = $this$accept_u24lambda_u240.getPushEndTime$intellij_android_streaming() - $this$accept_u24lambda_u240.getStartTime$intellij_android_streaming();
                    long agentStartDelay = $this$accept_u24lambda_u240.getStartAgentTime$intellij_android_streaming() - $this$accept_u24lambda_u240.getStartTime$intellij_android_streaming();
                    long connectionDelay = $this$accept_u24lambda_u240.getChannelConnectedTime$intellij_android_streaming() - $this$accept_u24lambda_u240.getStartTime$intellij_android_streaming();
                    long firstPacketDelay = VideoDecoderKt.getFirstPacketArrival() - $this$accept_u24lambda_u240.getStartTime$intellij_android_streaming();
                    String string = "Initialization took " + delay + " ms, push took " + pushDelay + " ms, agent was started after " + agentStartDelay + " ms, connected after " + connectionDelay + " ms, first video packet arrived after " + firstPacketDelay + " ms";
                    System.out.println((Object)string);
                    $this$accept_u24lambda_u240.setStartTime$intellij_android_streaming(0L);
                }
                DeviceView.access$paintDecorations(this.this$0, this.$g, displayRect);
                if (DeviceView.access$getMultiTouchMode$p(this.this$0)) {
                    DeviceView.access$drawMultiTouchFeedback(this.this$0, (Graphics2D)this.$g, displayRect, DeviceView.access$getLastTouchCoordinates$p(this.this$0) != null);
                }
            }
        });
    }

    @Override
    @UiThread
    public void settingsChanged(@NotNull DeviceMirroringSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (this.disposed || this.getDeviceController$intellij_android_streaming() == null) {
            return;
        }
        if (settings.getSynchronizeClipboard()) {
            this.startClipboardSynchronization();
        } else {
            this.stopClipboardSynchronization();
        }
    }

    private final void startClipboardSynchronization() {
        DeviceClipboardSynchronizer synchronizer = this.clipboardSynchronizer;
        if (synchronizer == null) {
            this.clipboardSynchronizer = new DeviceClipboardSynchronizer(this, this.deviceClient);
        } else {
            synchronizer.setDeviceClipboard(true);
        }
    }

    private final void stopClipboardSynchronization() {
        block0: {
            DeviceClipboardSynchronizer deviceClipboardSynchronizer = this.clipboardSynchronizer;
            if (deviceClipboardSynchronizer == null) break block0;
            DeviceClipboardSynchronizer it = deviceClipboardSynchronizer;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
            this.clipboardSynchronizer = null;
        }
    }

    private final void sendMotionEvent(Point p, int action2, Int2FloatOpenHashMap axisValues) {
        Point point = this.toDeviceDisplayCoordinates$intellij_android_streaming(p);
        if (point == null) {
            return;
        }
        Point displayCoordinates = point;
        if (StreamingUtilsKt.contains(this.getDeviceDisplaySize$intellij_android_streaming(), displayCoordinates)) {
            this.sendMotionEventDisplayCoordinates(displayCoordinates, action2, axisValues);
        } else if (action2 == 2) {
            this.lastTouchCoordinates = null;
            Point adjusted = StreamingUtilsKt.constrainInside(displayCoordinates, this.getDeviceDisplaySize$intellij_android_streaming());
            DeviceView.sendMotionEventDisplayCoordinates$default(this, adjusted, action2, null, 4, null);
            DeviceView.sendMotionEventDisplayCoordinates$default(this, adjusted, 1, null, 4, null);
        }
    }

    static /* synthetic */ void sendMotionEvent$default(DeviceView deviceView, Point point, int n, Int2FloatOpenHashMap int2FloatOpenHashMap, int n2, Object object) {
        if ((n2 & 4) != 0) {
            int2FloatOpenHashMap = null;
        }
        deviceView.sendMotionEvent(point, n, int2FloatOpenHashMap);
    }

    private final void sendMotionEventDisplayCoordinates(Point p, int action2, Int2FloatOpenHashMap axisValues) {
        block1: {
            if (!this.isConnected()) {
                return;
            }
            MotionEventMessage message2 = action2 == 5 || action2 == 6 ? new MotionEventMessage(this.originalAndMirroredPointer(p), action2 | 0x100, this.getDisplayId()) : (this.multiTouchMode ? new MotionEventMessage(this.originalAndMirroredPointer(p), action2, this.getDisplayId()) : new MotionEventMessage(this.originalPointer(p, axisValues), action2, this.getDisplayId()));
            DeviceController deviceController = this.getDeviceController$intellij_android_streaming();
            if (deviceController == null) break block1;
            deviceController.sendControlMessage(message2);
        }
    }

    static /* synthetic */ void sendMotionEventDisplayCoordinates$default(DeviceView deviceView, Point point, int n, Int2FloatOpenHashMap int2FloatOpenHashMap, int n2, Object object) {
        if ((n2 & 4) != 0) {
            int2FloatOpenHashMap = null;
        }
        deviceView.sendMotionEventDisplayCoordinates(point, n, int2FloatOpenHashMap);
    }

    private final List<MotionEventMessage.Pointer> originalPointer(Point p, Int2FloatOpenHashMap axisValues) {
        return CollectionsKt.listOf((Object)new MotionEventMessage.Pointer(p.x, p.y, 0, axisValues));
    }

    private final List<MotionEventMessage.Pointer> originalAndMirroredPointer(Point p) {
        Object[] objectArray = new MotionEventMessage.Pointer[]{new MotionEventMessage.Pointer(p.x, p.y, 0, null, 8, null), new MotionEventMessage.Pointer(this.getDeviceDisplaySize$intellij_android_streaming().width - p.x, this.getDeviceDisplaySize$intellij_android_streaming().height - p.y, 1, null, 8, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean isInsideDisplay(MouseEvent event2) {
        Rectangle rectangle = this.getDisplayRectangle();
        return rectangle != null ? rectangle.contains((double)event2.getX() * this.getScreenScale(), (double)event2.getY() * this.getScreenScale()) : false;
    }

    @UiThread
    public final void addConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.add(listener2);
    }

    @UiThread
    public final void removeConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.remove(listener2);
    }

    public static final /* synthetic */ Object access$connectToAgent(DeviceView $this, Dimension maxOutputSize, int initialDisplayOrientation, Continuation $completion) {
        return $this.connectToAgent(maxOutputSize, initialDisplayOrientation, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$getDisposed$p(DeviceView $this) {
        return $this.disposed;
    }

    public static final /* synthetic */ void access$connected(DeviceView $this) {
        $this.connected();
    }

    public static final /* synthetic */ void access$startClipboardSynchronization(DeviceView $this) {
        $this.startClipboardSynchronization();
    }

    public static final /* synthetic */ void access$setClipboardSynchronizer$p(DeviceView $this, DeviceClipboardSynchronizer deviceClipboardSynchronizer) {
        $this.clipboardSynchronizer = deviceClipboardSynchronizer;
    }

    public static final /* synthetic */ void access$updateVideoSize(DeviceView $this) {
        $this.updateVideoSize();
    }

    public static final /* synthetic */ void access$stopClipboardSynchronization(DeviceView $this) {
        $this.stopClipboardSynchronization();
    }

    public static final /* synthetic */ void access$setConnectionState(DeviceView $this, ConnectionState value2) {
        $this.setConnectionState(value2);
    }

    public static final /* synthetic */ void access$showDisconnectedStateMessage(DeviceView $this, String message2, AbstractDisplayView.Reconnector reconnector) {
        $this.showDisconnectedStateMessage(message2, reconnector);
    }

    public static final /* synthetic */ Dimension access$computeMaxImageSize(DeviceView $this) {
        return $this.computeMaxImageSize();
    }

    public static final /* synthetic */ double access$roundScale(DeviceView $this, double value2) {
        return $this.roundScale(value2);
    }

    public static final /* synthetic */ void access$setDisplayRectangle(DeviceView $this, Rectangle rectangle) {
        $this.setDisplayRectangle(rectangle);
    }

    public static final /* synthetic */ AffineTransform access$getDisplayTransform$p(DeviceView $this) {
        return $this.displayTransform;
    }

    public static final /* synthetic */ void access$setDisplayOrientationQuadrants$p(DeviceView $this, int n) {
        $this.displayOrientationQuadrants = n;
    }

    public static final /* synthetic */ void access$setDisplayOrientationCorrectionQuadrants$p(DeviceView $this, int n) {
        $this.displayOrientationCorrectionQuadrants = n;
    }

    public static final /* synthetic */ void access$setFrameNumber(DeviceView $this, int n) {
        $this.setFrameNumber(n);
    }

    public static final /* synthetic */ void access$notifyFrameListeners(DeviceView $this, Rectangle displayRectangle, BufferedImage frame) {
        $this.notifyFrameListeners(displayRectangle, frame);
    }

    public static final /* synthetic */ void access$paintDecorations(DeviceView $this, Graphics graphics, Rectangle displayRectangle) {
        $this.paintDecorations(graphics, displayRectangle);
    }

    public static final /* synthetic */ void access$drawMultiTouchFeedback(DeviceView $this, Graphics2D graphics, Rectangle displayRectangle, boolean dragging) {
        $this.drawMultiTouchFeedback(graphics, displayRectangle, dragging);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$Companion;", "", "()V", "ANDROID_SCROLL_ADJUSTMENT_FACTOR", "", "getANDROID_SCROLL_ADJUSTMENT_FACTOR$intellij_android_streaming$annotations", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getANDROID_SCROLL_ADJUSTMENT_FACTOR$intellij_android_streaming$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONNECTING", "CONNECTED", "DISCONNECTED", "intellij.android.streaming"})
    public static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState INITIAL = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTING = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTED = new ConnectionState();
        public static final /* enum */ ConnectionState DISCONNECTED = new ConnectionState();
        private static final /* synthetic */ ConnectionState[] $VALUES;

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String value2) {
            return Enum.valueOf(ConnectionState.class, value2);
        }

        static {
            $VALUES = connectionStateArray = new ConnectionState[]{ConnectionState.INITIAL, ConnectionState.CONNECTING, ConnectionState.CONNECTED, ConnectionState.DISCONNECTED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionStateListener;", "", "connectionStateChanged", "", "deviceSerialNumber", "", "connectionState", "Lcom/android/tools/idea/streaming/device/DeviceView$ConnectionState;", "intellij.android.streaming"})
    public static interface ConnectionStateListener {
        @AnyThread
        public void connectionStateChanged(@NotNull String var1, @NotNull ConnectionState var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyFrameListener;", "Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "onEndOfVideoStream", "", "onNewFrameAvailable", "intellij.android.streaming"})
    private final class MyFrameListener
    implements VideoDecoder.FrameListener {
        @Override
        public void onNewFrameAvailable() {
            EventQueue.invokeLater(new Runnable(DeviceView.this){
                final /* synthetic */ DeviceView this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    DeviceView.access$connected(this.this$0);
                    if (this.this$0.getWidth() != 0 && this.this$0.getHeight() != 0) {
                        this.this$0.repaint();
                    }
                }
            });
        }

        @Override
        public void onEndOfVideoStream() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J(\u0010\u001e\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0002R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyKeyListener;", "Ljava/awt/event/KeyAdapter;", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "cachedKeyStrokeMap", "", "Ljavax/swing/KeyStroke;", "Lcom/android/tools/idea/streaming/device/AndroidKeyStroke;", "getCachedKeyStrokeMap", "()Ljava/util/Map;", "setCachedKeyStrokeMap", "(Ljava/util/Map;)V", "keyStrokeMap", "getKeyStrokeMap", "buildKeyStrokeMap", "hostKeyCodeToDeviceKeyCode", "", "hostKeyCode", "hostKeyStrokeToAndroidKeyStroke", "modifiers", "keyPressed", "", "event", "Ljava/awt/event/KeyEvent;", "keyPressedOrReleased", "keyReleased", "keyTyped", "modifierToMetaState", "modifierMask", "metaState", "modifiersToMetaState", "addKeyStrokesForAction", "", "actionId", "", "androidKeyStroke", "intellij.android.streaming"})
    private final class MyKeyListener
    extends KeyAdapter {
        @Nullable
        private Map<KeyStroke, AndroidKeyStroke> cachedKeyStrokeMap;

        public MyKeyListener() {
            DeviceView.this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(@NotNull FocusEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    this.setCachedKeyStrokeMap(null);
                }
            });
        }

        @Nullable
        public final Map<KeyStroke, AndroidKeyStroke> getCachedKeyStrokeMap() {
            return this.cachedKeyStrokeMap;
        }

        public final void setCachedKeyStrokeMap(@Nullable Map<KeyStroke, AndroidKeyStroke> map2) {
            this.cachedKeyStrokeMap = map2;
        }

        private final Map<KeyStroke, AndroidKeyStroke> getKeyStrokeMap() {
            Map<KeyStroke, AndroidKeyStroke> map2 = this.cachedKeyStrokeMap;
            if (map2 == null) {
                this.cachedKeyStrokeMap = map2 = this.buildKeyStrokeMap();
            }
            return map2;
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event2) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (!DeviceView.this.isConnected()) {
                    return;
                }
                char c = event2.getKeyChar();
                if (c == '\uffff' || Character.isISOControl(c)) {
                    return;
                }
                TextInputMessage message2 = new TextInputMessage(String.valueOf(c));
                DeviceController deviceController = DeviceView.this.getDeviceController$intellij_android_streaming();
                if (deviceController == null) break block2;
                deviceController.sendControlMessage(message2);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            this.keyPressedOrReleased(event2);
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            this.keyPressedOrReleased(event2);
        }

        private final void keyPressedOrReleased(KeyEvent event2) {
            int keyCode = event2.getKeyCode();
            int modifiers = event2.getModifiersEx();
            if (keyCode == 17) {
                if (modifiers == 128) {
                    DeviceView.this.setMultiTouchMode(true);
                } else if ((modifiers & 0x80) == 0) {
                    DeviceView.this.setMultiTouchMode(false);
                }
            }
            if (keyCode == 9 && modifiers == 64) {
                if (event2.getID() == 401) {
                    KeyEvent tabEvent = new KeyEvent(event2.getComponent(), event2.getID(), event2.getWhen(), 0, keyCode, event2.getKeyChar(), event2.getKeyLocation());
                    DeviceView.this.traverseFocusLocally(tabEvent);
                }
                return;
            }
            if (!DeviceView.this.isConnected()) {
                return;
            }
            AndroidKeyStroke androidKeyStroke = this.hostKeyStrokeToAndroidKeyStroke(keyCode, modifiers);
            if (androidKeyStroke == null) {
                int androidKeyCode;
                if (modifiers == 0 && (androidKeyCode = this.hostKeyCodeToDeviceKeyCode(keyCode)) != 0) {
                    AndroidKeyEventActionType action2 = event2.getID() == 401 ? AndroidKeyEventActionType.ACTION_DOWN : AndroidKeyEventActionType.ACTION_UP;
                    DeviceController deviceController = DeviceView.this.getDeviceController$intellij_android_streaming();
                    if (deviceController != null) {
                        deviceController.sendControlMessage(new KeyEventMessage(action2, androidKeyCode, this.modifiersToMetaState(modifiers)));
                    }
                }
            } else if (event2.getID() == 401) {
                DeviceController deviceController = DeviceView.this.getDeviceController$intellij_android_streaming();
                if (deviceController != null) {
                    AndroidKeyStrokeKt.sendKeyStroke(deviceController, androidKeyStroke);
                }
            }
            event2.consume();
        }

        private final AndroidKeyStroke hostKeyStrokeToAndroidKeyStroke(int hostKeyCode, int modifiers) {
            int canonicalKeyCode = switch (hostKeyCode) {
                case 226 -> 37;
                case 227 -> 39;
                case 224 -> 38;
                case 225 -> 40;
                default -> hostKeyCode;
            };
            return this.getKeyStrokeMap().get(KeyStroke.getKeyStroke(canonicalKeyCode, modifiers));
        }

        private final int hostKeyCodeToDeviceKeyCode(int hostKeyCode) {
            return switch (hostKeyCode) {
                case 8 -> 67;
                case 127 -> {
                    if (SystemInfo.isMac) {
                        yield 67;
                    }
                    yield 112;
                }
                case 10 -> 66;
                case 27 -> 111;
                case 9 -> 61;
                default -> 0;
            };
        }

        private final int modifiersToMetaState(int modifiers) {
            return this.modifierToMetaState(modifiers, 64, 1) | this.modifierToMetaState(modifiers, 128, 4096) | this.modifierToMetaState(modifiers, 256, 65536) | this.modifierToMetaState(modifiers, 512, 2);
        }

        private final int modifierToMetaState(int modifiers, int modifierMask, int metaState) {
            return (modifiers & modifierMask) != 0 ? metaState : 0;
        }

        private final Map<KeyStroke, AndroidKeyStroke> buildKeyStrokeMap() {
            Map map2;
            Map $this$buildKeyStrokeMap_u24lambda_u240 = map2 = (Map)new LinkedHashMap();
            boolean bl = false;
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Cut", new AndroidKeyStroke(277, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Copy", new AndroidKeyStroke(278, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Paste", new AndroidKeyStroke(279, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$SelectAll", new AndroidKeyStroke(29, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLeft", new AndroidKeyStroke(21, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorRight", new AndroidKeyStroke(22, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLeftWithSelection", new AndroidKeyStroke(21, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorRightWithSelection", new AndroidKeyStroke(22, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorUp", new AndroidKeyStroke(19, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorDown", new AndroidKeyStroke(20, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorUpWithSelection", new AndroidKeyStroke(19, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorDownWithSelection", new AndroidKeyStroke(20, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPreviousWord", new AndroidKeyStroke(21, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorNextWord", new AndroidKeyStroke(22, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPreviousWordWithSelection", new AndroidKeyStroke(21, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorNextWordWithSelection", new AndroidKeyStroke(22, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineStart", new AndroidKeyStroke(122, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineEnd", new AndroidKeyStroke(123, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineStartWithSelection", new AndroidKeyStroke(122, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineEndWithSelection", new AndroidKeyStroke(123, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageUp", new AndroidKeyStroke(92, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageDown", new AndroidKeyStroke(93, 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageUpWithSelection", new AndroidKeyStroke(92, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageDownWithSelection", new AndroidKeyStroke(93, 1));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextStart", new AndroidKeyStroke(122, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextEnd", new AndroidKeyStroke(123, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextStartWithSelection", new AndroidKeyStroke(122, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextEndWithSelection", new AndroidKeyStroke(123, 4097));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Undo", new AndroidKeyStroke(54, 4096));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Redo", new AndroidKeyStroke(54, 4097));
            return map2;
        }

        private final void addKeyStrokesForAction(Map<KeyStroke, AndroidKeyStroke> $this$addKeyStrokesForAction, String actionId, AndroidKeyStroke androidKeyStroke) {
            for (KeyStroke keyStroke : KeymapUtil.getKeyStrokes((ShortcutSet)KeymapUtil.getActiveKeymapShortcuts((String)actionId))) {
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"keyStroke");
                $this$addKeyStrokesForAction.put(keyStroke, androidKeyStroke);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\rH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceView$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/android/tools/idea/streaming/device/DeviceView;)V", "mouseDragged", "", "event", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "updateMultiTouchMode", "getNormalizedScrollAmount", "", "intellij.android.streaming"})
    private final class MyMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            DeviceView.this.requestFocusInWindow();
            if (DeviceView.this.isInsideDisplay(event2) && event2.getButton() == 1) {
                Point point = StreamingUtilsKt.getLocation(event2);
                DeviceView deviceView = DeviceView.this;
                Point it = point;
                boolean bl = false;
                deviceView.lastTouchCoordinates = it;
                this.updateMultiTouchMode(event2);
                DeviceView.sendMotionEvent$default(deviceView, it, 0, null, 4, null);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (event2.getButton() == 1) {
                DeviceView.this.lastTouchCoordinates = null;
                this.updateMultiTouchMode(event2);
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event2), 1, null, 4, null);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            this.updateMultiTouchMode(event2);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if ((event2.getModifiersEx() & 0x400) != 0 && DeviceView.this.lastTouchCoordinates != null) {
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event2), 2, null, 4, null);
            }
            DeviceView.this.lastTouchCoordinates = null;
            DeviceView.this.setMultiTouchMode(false);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            this.updateMultiTouchMode(event2);
            if ((event2.getModifiersEx() & 0x400) != 0 && DeviceView.this.lastTouchCoordinates != null) {
                DeviceView.sendMotionEvent$default(DeviceView.this, StreamingUtilsKt.getLocation(event2), 2, null, 4, null);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            this.updateMultiTouchMode(event2);
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (!DeviceView.this.isInsideDisplay(event2)) {
                return;
            }
            int axis = event2.isShiftDown() ? 10 : 9;
            int direction = axis == 9 ^ event2.getPreciseWheelRotation() > 0.0 ? 1 : -1;
            for (float remainingRotation = this.getNormalizedScrollAmount(event2); remainingRotation > 0.0f; remainingRotation -= 1.0f) {
                float scrollAmount = RangesKt.coerceAtMost((float)remainingRotation, (float)1.0f) * (float)direction;
                Int2FloatOpenHashMap axisValues = new Int2FloatOpenHashMap(1);
                axisValues.put(axis, scrollAmount);
                DeviceView.this.sendMotionEvent(StreamingUtilsKt.getLocation(event2), 8, axisValues);
            }
        }

        private final float getNormalizedScrollAmount(MouseWheelEvent $this$getNormalizedScrollAmount) {
            if ($this$getNormalizedScrollAmount.getScrollType() != 0) {
                return 1.0f;
            }
            return (float)Math.abs($this$getNormalizedScrollAmount.getPreciseWheelRotation() * (double)$this$getNormalizedScrollAmount.getScrollAmount()) * 0.125f;
        }

        private final void updateMultiTouchMode(MouseEvent event2) {
            boolean oldMultiTouchMode = DeviceView.this.multiTouchMode;
            DeviceView.this.setMultiTouchMode(DeviceView.this.isInsideDisplay(event2) && (event2.getModifiersEx() & 0x80) != 0);
            if (DeviceView.this.multiTouchMode && oldMultiTouchMode) {
                DeviceView.this.repaint();
            }
        }
    }
}

