/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.idea.deviceprovisioner.DeviceHandleConstantsKt;
import com.android.tools.idea.streaming.AbstractDisplayPanel;
import com.android.tools.idea.streaming.DeviceFileDropHandlerKt;
import com.android.tools.idea.streaming.DeviceId;
import com.android.tools.idea.streaming.RunningDevicePanel;
import com.android.tools.idea.streaming.StreamingConstants;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceConfiguration;
import com.android.tools.idea.streaming.device.DeviceConfigurationKt;
import com.android.tools.idea.streaming.device.DeviceConstants;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.DeviceDisplayPanel;
import com.android.tools.idea.streaming.device.DeviceInfoExtensionsKt;
import com.android.tools.idea.streaming.device.DeviceToolWindowPanelKt;
import com.android.tools.idea.streaming.device.DeviceView;
import com.android.tools.idea.streaming.device.screenshot.DeviceScreenshotOptions;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderAction;
import com.android.tools.idea.ui.screenshot.ScreenshotAction;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.DeviceMirroringSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001d2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u0012H\u0016J\b\u00104\u001a\u000205H\u0014J\u0010\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020\u001dH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0014R$\u0010&\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001d@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001e\"\u0004\b(\u0010)\u00a8\u00069"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceToolWindowPanel;", "Lcom/android/tools/idea/streaming/RunningDevicePanel;", "project", "Lcom/intellij/openapi/project/Project;", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/streaming/device/DeviceClient;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "contentDisposable", "Lcom/intellij/openapi/Disposable;", "deviceConfig", "Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "getDeviceConfig", "()Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "deviceSerialNumber", "", "getDeviceSerialNumber", "()Ljava/lang/String;", "displayPanel", "Lcom/android/tools/idea/streaming/device/DeviceDisplayPanel;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "isClosable", "", "()Z", "preferredFocusableComponent", "getPreferredFocusableComponent", "primaryDeviceView", "Lcom/android/tools/idea/streaming/device/DeviceView;", "title", "getTitle", "value", "zoomToolbarVisible", "getZoomToolbarVisible", "setZoomToolbarVisible", "(Z)V", "createContent", "", "deviceFrameVisible", "savedUiState", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "destroyContent", "Lcom/android/tools/idea/streaming/device/DeviceToolWindowPanel$DeviceUiState;", "getData", "", "dataId", "getDeviceInfo", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "setDeviceFrameVisible", "visible", "DeviceUiState", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nDeviceToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceToolWindowPanel.kt\ncom/android/tools/idea/streaming/device/DeviceToolWindowPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class DeviceToolWindowPanel
extends RunningDevicePanel {
    @NotNull
    private final Project project;
    @NotNull
    private final DeviceClient deviceClient;
    @Nullable
    private DeviceDisplayPanel displayPanel;
    @Nullable
    private Disposable contentDisposable;
    @Nullable
    private DeviceView primaryDeviceView;
    private final boolean isClosable;
    private boolean zoomToolbarVisible;

    public DeviceToolWindowPanel(@NotNull Project project, @NotNull DeviceClient deviceClient2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deviceClient2, (String)"deviceClient");
        super(DeviceId.Companion.ofPhysicalDevice(deviceClient2.getDeviceSerialNumber()), "StreamingToolbarPhysicalDevice", "StreamingToolbarSecondary");
        this.project = project;
        this.deviceClient = deviceClient2;
    }

    private final String getDeviceSerialNumber() {
        return this.deviceClient.getDeviceSerialNumber();
    }

    private final DeviceConfiguration getDeviceConfig() {
        return this.deviceClient.getDeviceConfig();
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.deviceClient.getDeviceName();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return DeviceToolWindowPanelKt.access$getICON$p();
    }

    @Override
    public boolean isClosable() {
        return this.isClosable;
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)((Object)this);
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        DeviceView deviceView = this.primaryDeviceView;
        return deviceView != null ? (JComponent)((Object)deviceView) : (JComponent)((Object)this);
    }

    @Override
    public boolean getZoomToolbarVisible() {
        return this.zoomToolbarVisible;
    }

    @Override
    public void setZoomToolbarVisible(boolean value2) {
        this.zoomToolbarVisible = value2;
        DeviceDisplayPanel deviceDisplayPanel = this.displayPanel;
        if (deviceDisplayPanel != null) {
            deviceDisplayPanel.setZoomToolbarVisible(value2);
        }
    }

    @Override
    public void setDeviceFrameVisible(boolean visible) {
    }

    @Override
    @NotNull
    protected DeviceInfo getDeviceInfo() {
        DeviceInfo.Builder builder2 = DeviceInfo.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()");
        DeviceInfo deviceInfo = DeviceInfoExtensionsKt.fillMdnsConnectionType(DeviceConfigurationKt.fillFrom(builder2, this.getDeviceConfig()), this.getDeviceSerialNumber()).build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceInfo, (String)"newBuilder()\n        .fi\u2026lNumber)\n        .build()");
        return deviceInfo;
    }

    @Override
    public void createContent(boolean deviceFrameVisible, @Nullable RunningDevicePanel.UiState savedUiState) {
        DeviceView deviceView;
        Disposable disposable2;
        this.mirroringStarted();
        Disposable disposable3 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"newDisposable()");
        this.contentDisposable = disposable2 = disposable3;
        DeviceUiState cfr_ignored_0 = (DeviceUiState)savedUiState;
        DeviceUiState deviceUiState = (DeviceUiState)savedUiState;
        int initialOrientation = deviceUiState != null ? deviceUiState.getOrientation() : -1;
        DeviceDisplayPanel primaryDisplayPanel = new DeviceDisplayPanel(disposable2, this.deviceClient, initialOrientation, this.project, this.getZoomToolbarVisible());
        Object object = (DeviceUiState)savedUiState;
        if (object != null && (object = ((DeviceUiState)object).getZoomScrollState()) != null) {
            Object it = object;
            boolean bl = false;
            primaryDisplayPanel.setZoomScrollState$intellij_android_streaming((AbstractDisplayPanel.ZoomScrollState)it);
        }
        this.displayPanel = primaryDisplayPanel;
        this.primaryDeviceView = deviceView = (DeviceView)primaryDisplayPanel.getDisplayView();
        this.getMainToolbar().setTargetComponent((JComponent)((Object)deviceView));
        this.getSecondaryToolbar().setTargetComponent((JComponent)((Object)deviceView));
        this.getCenterPanel().addToCenter((Component)((Object)primaryDisplayPanel));
        deviceView.addConnectionStateListener(new DeviceView.ConnectionStateListener(this){
            final /* synthetic */ DeviceToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            @AnyThread
            public void connectionStateChanged(@NotNull String deviceSerialNumber, @NotNull DeviceView.ConnectionState connectionState) {
                Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
                Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
                EventQueue.invokeLater(new Runnable(this.this$0){
                    final /* synthetic */ DeviceToolWindowPanel this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        DeviceToolWindowPanel.access$getMainToolbar(this.this$0).updateActionsImmediately();
                        DeviceToolWindowPanel.access$getSecondaryToolbar(this.this$0).updateActionsImmediately();
                    }
                });
            }
        });
        DeviceFileDropHandlerKt.installFileDropHandler((JComponent)((Object)this), this.getId().getSerialNumber(), deviceView, this.project);
    }

    @Override
    @NotNull
    public DeviceUiState destroyContent() {
        this.mirroringEnded(DeviceMirroringSession.DeviceKind.PHYSICAL);
        DeviceUiState uiState = new DeviceUiState();
        DeviceView deviceView = this.primaryDeviceView;
        uiState.setOrientation(deviceView != null ? deviceView.getDisplayOrientationQuadrants() : 0);
        DeviceDisplayPanel deviceDisplayPanel = this.displayPanel;
        uiState.setZoomScrollState(deviceDisplayPanel != null ? deviceDisplayPanel.getZoomScrollState$intellij_android_streaming() : null);
        Disposable disposable2 = this.contentDisposable;
        if (disposable2 != null) {
            Disposable it = disposable2;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.contentDisposable = null;
        this.getCenterPanel().removeAll();
        this.displayPanel = null;
        this.primaryDeviceView = null;
        this.getMainToolbar().setTargetComponent((JComponent)((Object)this));
        this.getSecondaryToolbar().setTargetComponent((JComponent)((Object)this));
        return uiState;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String string = dataId;
        if ((Intrinsics.areEqual((Object)string, (Object)DeviceConstants.DEVICE_VIEW_KEY.getName()) ? true : Intrinsics.areEqual((Object)string, (Object)StreamingConstants.DISPLAY_VIEW_KEY.getName())) ? true : Intrinsics.areEqual((Object)string, (Object)ZoomableKt.ZOOMABLE_KEY.getName())) {
            object = this.primaryDeviceView;
        } else if (Intrinsics.areEqual((Object)string, (Object)DeviceConstants.DEVICE_CLIENT_KEY.getName())) {
            object = this.deviceClient;
        } else if (Intrinsics.areEqual((Object)string, (Object)DeviceConstants.DEVICE_CONTROLLER_KEY.getName())) {
            object = this.deviceClient.getDeviceController();
        } else if (Intrinsics.areEqual((Object)string, (Object)DeviceHandleConstantsKt.DEVICE_HANDLE_KEY.getName())) {
            object = this.deviceClient.getDeviceHandle();
        } else if (Intrinsics.areEqual((Object)string, (Object)ScreenshotAction.Companion.getSCREENSHOT_OPTIONS_KEY().getName())) {
            DeviceView deviceView = this.primaryDeviceView;
            if (deviceView != null) {
                DeviceView it = deviceView;
                boolean bl = false;
                object = it.isConnected() ? new DeviceScreenshotOptions(this.getDeviceSerialNumber(), this.getDeviceConfig(), it) : null;
            } else {
                object = null;
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)ScreenRecorderAction.Companion.getSCREEN_RECORDER_PARAMETERS_KEY().getName())) {
            DeviceController deviceController = this.deviceClient.getDeviceController();
            if (deviceController != null) {
                DeviceController it = deviceController;
                boolean bl = false;
                object = new ScreenRecorderAction.Parameters(this.deviceClient.getDeviceName(), this.getDeviceSerialNumber(), this.getDeviceConfig().getFeatureLevel(), null, it);
            } else {
                object = null;
            }
        } else {
            object = super.getData(dataId);
        }
        return object;
    }

    public static final /* synthetic */ ActionToolbar access$getMainToolbar(DeviceToolWindowPanel $this) {
        return $this.getMainToolbar();
    }

    public static final /* synthetic */ ActionToolbar access$getSecondaryToolbar(DeviceToolWindowPanel $this) {
        return $this.getSecondaryToolbar();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceToolWindowPanel$DeviceUiState;", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "()V", "orientation", "", "getOrientation", "()I", "setOrientation", "(I)V", "zoomScrollState", "Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "getZoomScrollState", "()Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "setZoomScrollState", "(Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;)V", "intellij.android.streaming"})
    public static final class DeviceUiState
    implements RunningDevicePanel.UiState {
        private int orientation;
        @Nullable
        private AbstractDisplayPanel.ZoomScrollState zoomScrollState;

        public final int getOrientation() {
            return this.orientation;
        }

        public final void setOrientation(int n) {
            this.orientation = n;
        }

        @Nullable
        public final AbstractDisplayPanel.ZoomScrollState getZoomScrollState() {
            return this.zoomScrollState;
        }

        public final void setZoomScrollState(@Nullable AbstractDisplayPanel.ZoomScrollState zoomScrollState) {
            this.zoomScrollState = zoomScrollState;
        }
    }
}

