/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.ide.common.util.DeviceUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.android.sdklib.devices.Abi;
import com.android.tools.analytics.CommonMetricsData;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.openapi.util.text.Strings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"getMdnsConnectionType", "Lcom/google/wireless/android/sdk/stats/DeviceInfo$MdnsConnectionType;", "deviceSerialNumber", "", "fillFrom", "Lcom/google/wireless/android/sdk/stats/DeviceInfo$Builder;", "deviceProperties", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "fillMdnsConnectionType", "getDeviceInfoType", "Lcom/google/wireless/android/sdk/stats/DeviceInfo$DeviceType;", "intellij.android.streaming"})
public final class DeviceInfoExtensionsKt {
    @NotNull
    public static final DeviceInfo.Builder fillFrom(@NotNull DeviceInfo.Builder $this$fillFrom, @NotNull DeviceProperties deviceProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$fillFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceProperties, (String)"deviceProperties");
        $this$fillFrom.setManufacturer(Strings.notNullize((String)deviceProperties.getManufacturer()));
        $this$fillFrom.setModel(Strings.notNullize((String)deviceProperties.getModel()));
        $this$fillFrom.setBuildVersionRelease(Strings.notNullize((String)deviceProperties.getAndroidRelease()));
        AndroidVersion androidVersion = deviceProperties.getAndroidVersion();
        $this$fillFrom.setBuildApiLevelFull(Strings.notNullize((String)(androidVersion != null ? androidVersion.getApiString() : null)));
        Abi abi = deviceProperties.getAbi();
        $this$fillFrom.setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)(abi != null ? abi.toString() : null)));
        $this$fillFrom.setDeviceType(DeviceInfoExtensionsKt.getDeviceInfoType(deviceProperties));
        return $this$fillFrom;
    }

    @NotNull
    public static final DeviceInfo.Builder fillMdnsConnectionType(@NotNull DeviceInfo.Builder $this$fillMdnsConnectionType, @NotNull String deviceSerialNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$fillMdnsConnectionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        $this$fillMdnsConnectionType.setMdnsConnectionType(DeviceInfoExtensionsKt.getMdnsConnectionType(deviceSerialNumber));
        return $this$fillMdnsConnectionType;
    }

    private static final DeviceInfo.DeviceType getDeviceInfoType(DeviceProperties $this$getDeviceInfoType) {
        DeviceInfo.DeviceType deviceType;
        Boolean bl = $this$getDeviceInfoType.isVirtual();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            deviceType = DeviceInfo.DeviceType.LOCAL_EMULATOR;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            deviceType = DeviceInfo.DeviceType.LOCAL_PHYSICAL;
        } else if (bl == null) {
            deviceType = DeviceInfo.DeviceType.UNKNOWN_DEVICE_TYPE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return deviceType;
    }

    private static final DeviceInfo.MdnsConnectionType getMdnsConnectionType(String deviceSerialNumber) {
        return DeviceUtils.isMdnsAutoConnectUnencrypted((String)deviceSerialNumber) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_UNENCRYPTED : (DeviceUtils.isMdnsAutoConnectTls((String)deviceSerialNumber) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_TLS : DeviceInfo.MdnsConnectionType.MDNS_NONE);
    }
}

