/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "", "deviceProperties", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "useTitleAsName", "", "(Lcom/android/sdklib/deviceprovisioner/DeviceProperties;Z)V", "apiLevel", "", "getApiLevel", "()I", "deviceModel", "", "getDeviceModel", "()Ljava/lang/String;", "deviceName", "getDeviceName", "getDeviceProperties", "()Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "featureLevel", "getFeatureLevel", "hasOrientationSensors", "getHasOrientationSensors", "()Z", "isAutomotive", "isWatch", "intellij.android.streaming"})
public final class DeviceConfiguration {
    @NotNull
    private final DeviceProperties deviceProperties;
    @NotNull
    private final String deviceName;
    private final boolean hasOrientationSensors;

    public DeviceConfiguration(@NotNull DeviceProperties deviceProperties, boolean useTitleAsName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)deviceProperties, (String)"deviceProperties");
        this.deviceProperties = deviceProperties;
        this.hasOrientationSensors = true;
        if (useTitleAsName) {
            string = this.deviceProperties.getTitle();
        } else {
            StringBuilder name2 = new StringBuilder();
            String model2 = this.getDeviceModel();
            CharSequence charSequence = model2;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String manufacturer;
                CharSequence charSequence2;
                if (!(StringsKt.startsWith$default((String)model2, (String)"Pixel", (boolean)false, (int)2, null) || (charSequence2 = (CharSequence)(manufacturer = this.deviceProperties.getManufacturer())) == null || StringsKt.isBlank((CharSequence)charSequence2) || Intrinsics.areEqual((Object)manufacturer, (Object)"unknown"))) {
                    name2.append(StringUtil.capitalize((String)manufacturer)).append(' ');
                }
                name2.append(this.getDeviceModel());
            } else {
                name2.append("unknown");
            }
            name2.append(" API ").append(this.getApiLevel());
            String string2 = name2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      val name = Strin\u2026    name.toString()\n    }");
            string = string2;
        }
        this.deviceName = string;
    }

    public /* synthetic */ DeviceConfiguration(DeviceProperties deviceProperties, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(deviceProperties, bl);
    }

    @NotNull
    public final DeviceProperties getDeviceProperties() {
        return this.deviceProperties;
    }

    public final int getApiLevel() {
        AndroidVersion androidVersion = this.deviceProperties.getAndroidVersion();
        return androidVersion != null ? androidVersion.getApiLevel() : 33;
    }

    public final int getFeatureLevel() {
        AndroidVersion androidVersion = this.deviceProperties.getAndroidVersion();
        return androidVersion != null ? androidVersion.getFeatureLevel() : 33;
    }

    @Nullable
    public final String getDeviceModel() {
        return this.deviceProperties.getModel();
    }

    public final boolean isWatch() {
        return this.deviceProperties.getDeviceType() == DeviceType.WEAR;
    }

    public final boolean isAutomotive() {
        return this.deviceProperties.getDeviceType() == DeviceType.AUTOMOTIVE;
    }

    @NotNull
    public final String getDeviceName() {
        return this.deviceName;
    }

    public final boolean getHasOrientationSensors() {
        return this.hasOrientationSensors;
    }
}

