/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.StartClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StopClipboardSyncMessage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0017J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012H\u0017J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0012*\u00020\u0016H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/streaming/device/DeviceClipboardSynchronizer;", "Lcom/intellij/openapi/ide/CopyPasteManager$ContentChangedListener;", "Lcom/android/tools/idea/streaming/device/DeviceController$DeviceClipboardListener;", "Lcom/intellij/openapi/Disposable;", "disposableParent", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/device/DeviceClient;)V", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "kotlin.jvm.PlatformType", "deviceController", "Lcom/android/tools/idea/streaming/device/DeviceController;", "getDeviceController", "()Lcom/android/tools/idea/streaming/device/DeviceController;", "focusOwnerListener", "Ljava/beans/PropertyChangeListener;", "lastClipboardText", "", "contentChanged", "", "oldTransferable", "Ljava/awt/datatransfer/Transferable;", "newTransferable", "dispose", "getClipboardText", "onDeviceClipboardChanged", "text", "setDeviceClipboard", "forceSend", "", "getText", "intellij.android.streaming"})
public final class DeviceClipboardSynchronizer
implements CopyPasteManager.ContentChangedListener,
DeviceController.DeviceClipboardListener,
Disposable {
    @NotNull
    private final DeviceClient deviceClient;
    private final CopyPasteManager copyPasteManager;
    @NotNull
    private String lastClipboardText;
    @NotNull
    private final PropertyChangeListener focusOwnerListener;

    public DeviceClipboardSynchronizer(@NotNull Disposable disposableParent, @NotNull DeviceClient deviceClient2) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)deviceClient2, (String)"deviceClient");
        this.deviceClient = deviceClient2;
        this.copyPasteManager = CopyPasteManager.getInstance();
        this.lastClipboardText = "";
        this.focusOwnerListener = new PropertyChangeListener(this){
            final /* synthetic */ DeviceClipboardSynchronizer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void propertyChange(PropertyChangeEvent event2) {
                if (event2.getNewValue() != null && event2.getOldValue() == null) {
                    this.this$0.setDeviceClipboard(false);
                }
            }
        };
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.copyPasteManager.addContentChangedListener((CopyPasteManager.ContentChangedListener)this, (Disposable)this);
        DeviceController deviceController = this.getDeviceController();
        if (deviceController != null) {
            deviceController.addDeviceClipboardListener(this);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusOwnerListener);
        this.setDeviceClipboard(true);
    }

    private final DeviceController getDeviceController() {
        return this.deviceClient.getDeviceController();
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusOwnerListener);
        DeviceController deviceController = this.getDeviceController();
        if (deviceController != null) {
            deviceController.removeDeviceClipboardListener(this);
        }
        DeviceController deviceController2 = this.getDeviceController();
        if (deviceController2 != null) {
            deviceController2.sendControlMessage(StopClipboardSyncMessage.Companion.getInstance());
        }
        this.lastClipboardText = "";
    }

    public final void setDeviceClipboard(boolean forceSend) {
        String text2 = this.getClipboardText();
        this.setDeviceClipboard(text2, forceSend);
    }

    private final void setDeviceClipboard(String text2, boolean forceSend) {
        block9: {
            String string;
            int maxSyncedClipboardLength;
            block8: {
                maxSyncedClipboardLength = DeviceMirroringSettings.Companion.getInstance().getMaxSyncedClipboardLength();
                if (forceSend) break block8;
                if (!(((CharSequence)text2).length() > 0) || Intrinsics.areEqual((Object)text2, (Object)this.lastClipboardText)) break block9;
            }
            if (text2.length() <= maxSyncedClipboardLength) {
                string = text2;
            } else if (forceSend) {
                string = "";
            } else {
                return;
            }
            String adjustedText = string;
            StartClipboardSyncMessage message2 = new StartClipboardSyncMessage(maxSyncedClipboardLength, adjustedText);
            DeviceController deviceController = this.getDeviceController();
            if (deviceController != null) {
                deviceController.sendControlMessage(message2);
            }
            this.lastClipboardText = adjustedText;
        }
    }

    private final String getClipboardText() {
        String string;
        DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.stringFlavor};
        if (this.copyPasteManager.areDataFlavorsAvailable(dataFlavorArray)) {
            string = (String)this.copyPasteManager.getContents(DataFlavor.stringFlavor);
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    @AnyThread
    public void contentChanged(@Nullable Transferable oldTransferable, @Nullable Transferable newTransferable) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(newTransferable, this){
            final /* synthetic */ Transferable $newTransferable;
            final /* synthetic */ DeviceClipboardSynchronizer this$0;
            {
                this.$newTransferable = $newTransferable;
                this.this$0 = $receiver;
            }

            public final void run() {
                block0: {
                    String string;
                    Transferable transferable2 = this.$newTransferable;
                    if (transferable2 == null || (string = DeviceClipboardSynchronizer.access$getText(this.this$0, transferable2)) == null) break block0;
                    String string2 = string;
                    DeviceClipboardSynchronizer deviceClipboardSynchronizer = this.this$0;
                    String it = string2;
                    boolean bl = false;
                    DeviceClipboardSynchronizer.access$setDeviceClipboard(deviceClipboardSynchronizer, it, false);
                }
            }
        });
    }

    @Override
    @AnyThread
    public void onDeviceClipboardChanged(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(text2, this){
            final /* synthetic */ String $text;
            final /* synthetic */ DeviceClipboardSynchronizer this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void run() {
                if (!Intrinsics.areEqual((Object)this.$text, (Object)DeviceClipboardSynchronizer.access$getLastClipboardText$p(this.this$0))) {
                    DeviceClipboardSynchronizer.access$setLastClipboardText$p(this.this$0, this.$text);
                    DeviceClipboardSynchronizer.access$getCopyPasteManager$p(this.this$0).setContents((Transferable)new StringSelection(this.$text));
                }
            }
        });
    }

    private final String getText(Transferable $this$getText) {
        Object object;
        try {
            object = $this$getText.getTransferData(DataFlavor.stringFlavor);
            object = object instanceof String ? (String)object : null;
        }
        catch (UnsupportedFlavorException e) {
            object = null;
        }
        catch (IOException e) {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ String access$getText(DeviceClipboardSynchronizer $this, Transferable $receiver) {
        return $this.getText($receiver);
    }

    public static final /* synthetic */ void access$setDeviceClipboard(DeviceClipboardSynchronizer $this, String text2, boolean forceSend) {
        $this.setDeviceClipboard(text2, forceSend);
    }

    public static final /* synthetic */ String access$getLastClipboardText$p(DeviceClipboardSynchronizer $this) {
        return $this.lastClipboardText;
    }

    public static final /* synthetic */ void access$setLastClipboardText$p(DeviceClipboardSynchronizer $this, String string) {
        $this.lastClipboardText = string;
    }

    public static final /* synthetic */ CopyPasteManager access$getCopyPasteManager$p(DeviceClipboardSynchronizer $this) {
        return $this.copyPasteManager;
    }
}

