/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.ClipboardChangedNotification;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import com.android.tools.idea.streaming.device.MotionEventMessage;
import com.android.tools.idea.streaming.device.SetDeviceOrientationMessage;
import com.android.tools.idea.streaming.device.SetMaxVideoResolutionMessage;
import com.android.tools.idea.streaming.device.StartClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StartVideoStreamMessage;
import com.android.tools.idea.streaming.device.StopClipboardSyncMessage;
import com.android.tools.idea.streaming.device.StopVideoStreamMessage;
import com.android.tools.idea.streaming.device.TextInputMessage;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\n\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage;", "", "type", "", "(I)V", "getType", "()I", "equals", "", "other", "hashCode", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "toString", "", "Companion", "Deserializer", "Lcom/android/tools/idea/streaming/device/ClipboardChangedNotification;", "Lcom/android/tools/idea/streaming/device/KeyEventMessage;", "Lcom/android/tools/idea/streaming/device/MotionEventMessage;", "Lcom/android/tools/idea/streaming/device/SetDeviceOrientationMessage;", "Lcom/android/tools/idea/streaming/device/SetMaxVideoResolutionMessage;", "Lcom/android/tools/idea/streaming/device/StartClipboardSyncMessage;", "Lcom/android/tools/idea/streaming/device/StartVideoStreamMessage;", "Lcom/android/tools/idea/streaming/device/StopClipboardSyncMessage;", "Lcom/android/tools/idea/streaming/device/StopVideoStreamMessage;", "Lcom/android/tools/idea/streaming/device/TextInputMessage;", "intellij.android.streaming"})
public abstract class ControlMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int type;

    private ControlMessage(int type) {
        this.type = type;
    }

    public final int getType() {
        return this.type;
    }

    public void serialize(@NotNull Base128OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeInt(this.type);
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    public /* synthetic */ ControlMessage(int type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage$Companion;", "Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "()V", "deserialize", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static final class Companion
    implements Deserializer {
        private Companion() {
        }

        @Override
        @NotNull
        public ControlMessage deserialize(@NotNull Base128InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int type = stream.readInt();
            return switch (type) {
                case 1 -> MotionEventMessage.Companion.deserialize(stream);
                case 2 -> KeyEventMessage.Companion.deserialize(stream);
                case 3 -> TextInputMessage.Companion.deserialize(stream);
                case 4 -> SetDeviceOrientationMessage.Companion.deserialize(stream);
                case 5 -> SetMaxVideoResolutionMessage.Companion.deserialize(stream);
                case 6 -> StartVideoStreamMessage.Companion.deserialize(stream);
                case 7 -> StopVideoStreamMessage.Companion.deserialize(stream);
                case 8 -> StartClipboardSyncMessage.Companion.deserialize(stream);
                case 9 -> StopClipboardSyncMessage.Companion.deserialize(stream);
                case 10 -> ClipboardChangedNotification.Companion.deserialize(stream);
                default -> throw new Base128InputStream.StreamFormatException("Unrecognized control message type " + type);
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "", "deserialize", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static interface Deserializer {
        @NotNull
        public ControlMessage deserialize(@NotNull Base128InputStream var1);
    }
}

