/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.AndroidKeyEventActionType;
import com.android.tools.idea.streaming.device.AndroidKeyStroke;
import com.android.tools.idea.streaming.device.DeviceController;
import com.android.tools.idea.streaming.device.KeyEventMessage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\t\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"ANDROID_META_KEYS", "", "Lcom/android/tools/idea/streaming/device/AndroidKeyStroke;", "pressMetaKeys", "", "Lcom/android/tools/idea/streaming/device/DeviceController;", "metaState", "", "releaseMetaKeys", "sendKeyStroke", "keyStroke", "intellij.android.streaming"})
public final class AndroidKeyStrokeKt {
    @NotNull
    private static final List<AndroidKeyStroke> ANDROID_META_KEYS;

    public static final void sendKeyStroke(@NotNull DeviceController $this$sendKeyStroke, @NotNull AndroidKeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)$this$sendKeyStroke, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        AndroidKeyStrokeKt.pressMetaKeys($this$sendKeyStroke, keyStroke.getMetaState());
        $this$sendKeyStroke.sendControlMessage(new KeyEventMessage(AndroidKeyEventActionType.ACTION_DOWN_AND_UP, keyStroke.getKeyCode(), keyStroke.getMetaState()));
        AndroidKeyStrokeKt.releaseMetaKeys($this$sendKeyStroke, keyStroke.getMetaState());
    }

    private static final void pressMetaKeys(DeviceController $this$pressMetaKeys, int metaState) {
        if (metaState != 0) {
            int currentMetaState = 0;
            for (AndroidKeyStroke androidKeyStroke : ANDROID_META_KEYS) {
                int key = androidKeyStroke.component1();
                int state2 = androidKeyStroke.component2();
                if ((metaState & state2) == 0) continue;
                $this$pressMetaKeys.sendControlMessage(new KeyEventMessage(AndroidKeyEventActionType.ACTION_DOWN, key, currentMetaState |= state2));
                if (currentMetaState != metaState) continue;
                break;
            }
        }
    }

    private static final void releaseMetaKeys(DeviceController $this$releaseMetaKeys, int metaState) {
        if (metaState != 0) {
            int currentMetaState = metaState;
            for (AndroidKeyStroke androidKeyStroke : CollectionsKt.asReversed(ANDROID_META_KEYS)) {
                int key = androidKeyStroke.component1();
                int state2 = androidKeyStroke.component2();
                if ((currentMetaState & state2) == 0) continue;
                $this$releaseMetaKeys.sendControlMessage(new KeyEventMessage(AndroidKeyEventActionType.ACTION_UP, key, currentMetaState &= ~state2));
                if (currentMetaState != 0) continue;
                break;
            }
        }
    }

    static {
        Object[] objectArray = new AndroidKeyStroke[]{new AndroidKeyStroke(57, 2), new AndroidKeyStroke(59, 1), new AndroidKeyStroke(113, 4096), new AndroidKeyStroke(117, 65536)};
        ANDROID_META_KEYS = CollectionsKt.listOf((Object[])objectArray);
    }
}

