/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.android.sdklib.deviceprovisioner.DeviceProvisioner;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdLaunchListener;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.android.tools.idea.run.DeviceHeadsUpListener;
import com.android.tools.idea.streaming.ConnectedDevice;
import com.android.tools.idea.streaming.DeviceId;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.DeviceMirroringSettingsListener;
import com.android.tools.idea.streaming.EmptyStatePanel;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.RunningDevicePanel;
import com.android.tools.idea.streaming.StreamingToolWindowManager;
import com.android.tools.idea.streaming.StreamingToolWindowManagerKt;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.DeviceConfiguration;
import com.android.tools.idea.streaming.device.DeviceToolWindowPanel;
import com.android.tools.idea.streaming.device.dialogs.MirroringConfirmationDialog;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.android.tools.idea.streaming.emulator.EmulatorToolWindowPanel;
import com.android.tools.idea.streaming.emulator.RunningEmulatorCatalog;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b*\u0002\u000b\u0010\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0004pqrsB\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\"H\u0002J\u0010\u0010F\u001a\u00020D2\u0006\u0010G\u001a\u00020,H\u0002J\u0010\u0010H\u001a\u00020D2\u0006\u0010I\u001a\u00020\u0015H\u0002J\b\u0010J\u001a\u00020DH\u0002J\b\u0010K\u001a\u00020DH\u0002J\b\u0010L\u001a\u00020DH\u0002J\b\u0010M\u001a\u00020DH\u0016J\u0010\u0010N\u001a\u00020D2\u0006\u0010E\u001a\u00020\"H\u0017J\u0010\u0010O\u001a\u00020D2\u0006\u0010E\u001a\u00020\"H\u0017J\u0012\u0010P\u001a\u0004\u0018\u00010,2\u0006\u0010Q\u001a\u00020\u0014H\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010,2\u0006\u0010S\u001a\u00020&H\u0002J\u0012\u0010T\u001a\u0004\u0018\u00010,2\u0006\u0010U\u001a\u00020VH\u0002J\u0012\u0010W\u001a\u0004\u0018\u00010,2\u0006\u0010X\u001a\u00020\u0014H\u0002J\b\u0010Y\u001a\u00020ZH\u0002J\u0012\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010]\u001a\u00020\u0014H\u0002J\b\u0010^\u001a\u00020DH\u0002J\u0010\u0010_\u001a\u00020D2\u0006\u0010`\u001a\u00020\u0014H\u0002J\u0010\u0010a\u001a\u00020D2\u0006\u0010Q\u001a\u00020\u0014H\u0002J\u001e\u0010a\u001a\u00020D2\u0006\u0010`\u001a\u00020\u00142\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\"0cH\u0002J\u0010\u0010d\u001a\u00020D2\u0006\u0010`\u001a\u00020\u0014H\u0002J\b\u0010e\u001a\u00020DH\u0002J\u0010\u0010f\u001a\u00020D2\u0006\u0010E\u001a\u00020\"H\u0002J\u0010\u0010g\u001a\u00020D2\u0006\u0010G\u001a\u00020,H\u0002J\u0010\u0010h\u001a\u00020D2\u0006\u0010G\u001a\u00020iH\u0002J\u0010\u0010h\u001a\u00020D2\u0006\u0010X\u001a\u00020\u0014H\u0002J\u0010\u0010j\u001a\u00020D2\u0006\u0010G\u001a\u00020,H\u0002J\u0010\u0010k\u001a\u00020D2\u0006\u0010l\u001a\u00020\u001dH\u0016J\b\u0010m\u001a\u00020DH\u0002J\b\u0010n\u001a\u00020DH\u0002J\f\u0010o\u001a\u00020D*\u00020\u0006H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u0012\u0012\u0004\u0012\u00020,0+j\b\u0012\u0004\u0012\u00020,`-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0018\u00010/R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u00100\u001a\u000701\u00a2\u0006\u0002\b28CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0016\u00105\u001a\n 7*\u0004\u0018\u00010606X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u00108\u001aB\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014 7* \u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014\u0018\u00010909X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010:\u001aB\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014 7* \u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00140\u0014\u0018\u00010909X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010;\u001a\u001e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020=0<j\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020=`>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010@\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010\u0019\"\u0004\bB\u0010\u001b\u00a8\u0006t"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager;", "Lcom/android/tools/idea/streaming/emulator/RunningEmulatorCatalog$Listener;", "Lcom/android/tools/idea/streaming/DeviceMirroringSettingsListener;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/Disposable;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/wm/ToolWindow;)V", "alarm", "Lcom/intellij/util/Alarm;", "connectionStateListener", "com/android/tools/idea/streaming/StreamingToolWindowManager$connectionStateListener$1", "Lcom/android/tools/idea/streaming/StreamingToolWindowManager$connectionStateListener$1;", "contentCreated", "", "contentManagerListener", "com/android/tools/idea/streaming/StreamingToolWindowManager$contentManagerListener$1", "Lcom/android/tools/idea/streaming/StreamingToolWindowManager$contentManagerListener$1;", "deviceClients", "", "", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "value", "deviceFrameVisible", "getDeviceFrameVisible", "()Z", "setDeviceFrameVisible", "(Z)V", "deviceMirroringSettings", "Lcom/android/tools/idea/streaming/DeviceMirroringSettings;", "emulatorSettings", "Lcom/android/tools/idea/streaming/EmulatorSettings;", "emulators", "Ljava/util/HashSet;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "Lkotlin/collections/HashSet;", "initialized", "lastSelectedDeviceId", "Lcom/android/tools/idea/streaming/DeviceId;", "mirroredDevices", "", "mirroringConfirmationDialogShowing", "panels", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/streaming/RunningDevicePanel;", "Lkotlin/collections/ArrayList;", "physicalDeviceWatcher", "Lcom/android/tools/idea/streaming/StreamingToolWindowManager$PhysicalDeviceWatcher;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "recentAttentionRequests", "Lcom/google/common/cache/Cache;", "recentEmulatorLaunches", "savedUiState", "Ljava/util/HashMap;", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "Lkotlin/collections/HashMap;", "selectedPanel", "zoomToolbarIsVisible", "getZoomToolbarIsVisible", "setZoomToolbarIsVisible", "addEmulatorPanel", "", "emulator", "addPanel", "panel", "addPhysicalDevicePanel", "deviceClient", "createContent", "createEmptyStatePanel", "destroyContent", "dispose", "emulatorAdded", "emulatorRemoved", "findPanelByAvdId", "avdId", "findPanelByDeviceId", "deviceId", "findPanelByEmulatorId", "emulatorId", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "findPanelBySerialNumber", "serialNumber", "getContentManager", "Lcom/intellij/ui/content/ContentManager;", "getDataFromSelectedPanel", "", "dataId", "hideLiveIndicator", "onDeviceHeadsUp", "deviceSerialNumber", "onEmulatorHeadsUp", "runningEmulators", "", "onPhysicalDeviceHeadsUp", "removeAllPhysicalDevicePanels", "removeEmulatorPanel", "removePanel", "removePhysicalDevicePanel", "Lcom/android/tools/idea/streaming/device/DeviceToolWindowPanel;", "selectPanel", "settingsChanged", "settings", "showLiveIndicator", "viewSelectionChanged", "showAndActivate", "MyDeviceHeadsUpListener", "PhysicalDeviceWatcher", "ToggleDeviceFrameAction", "ToggleZoomToolbarAction", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nStreamingToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingToolWindowManager.kt\ncom/android/tools/idea/streaming/StreamingToolWindowManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,797:1\n1#2:798\n766#3:799\n857#3,2:800\n800#3,11:802\n1851#3,2:813\n288#3,2:815\n288#3,2:817\n288#3,2:819\n288#3,2:821\n*S KotlinDebug\n*F\n+ 1 StreamingToolWindowManager.kt\ncom/android/tools/idea/streaming/StreamingToolWindowManager\n*L\n321#1:799\n321#1:800,2\n470#1:802,11\n470#1:813,2\n524#1:815,2\n528#1:817,2\n532#1:819,2\n536#1:821,2\n*E\n"})
public final class StreamingToolWindowManager
implements RunningEmulatorCatalog.Listener,
DeviceMirroringSettingsListener,
DumbAware,
Disposable {
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final EmulatorSettings emulatorSettings;
    @NotNull
    private final DeviceMirroringSettings deviceMirroringSettings;
    private boolean initialized;
    private boolean contentCreated;
    private boolean mirroringConfirmationDialogShowing;
    @Nullable
    private PhysicalDeviceWatcher physicalDeviceWatcher;
    @NotNull
    private final ArrayList<RunningDevicePanel> panels;
    @Nullable
    private RunningDevicePanel selectedPanel;
    @Nullable
    private DeviceId lastSelectedDeviceId;
    @NotNull
    private final HashMap<DeviceId, RunningDevicePanel.UiState> savedUiState;
    @NotNull
    private final HashSet<EmulatorController> emulators;
    @NotNull
    private Map<String, DeviceClient> deviceClients;
    @NotNull
    private Set<String> mirroredDevices;
    private final PropertiesComponent properties;
    private final Cache<String, String> recentAttentionRequests;
    private final Cache<String, String> recentEmulatorLaunches;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final contentManagerListener.1 contentManagerListener;
    @NotNull
    private final connectionStateListener.1 connectionStateListener;

    @AnyThread
    public StreamingToolWindowManager(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.toolWindow = toolWindow;
        this.emulatorSettings = EmulatorSettings.Companion.getInstance();
        this.deviceMirroringSettings = DeviceMirroringSettings.Companion.getInstance();
        this.panels = new ArrayList();
        this.savedUiState = new HashMap();
        this.emulators = new HashSet();
        this.deviceClients = new LinkedHashMap();
        this.mirroredDevices = new LinkedHashSet();
        this.properties = PropertiesComponent.getInstance((Project)this.getProject());
        this.recentAttentionRequests = CacheBuilder.newBuilder().expireAfterWrite(StreamingToolWindowManagerKt.access$getATTENTION_REQUEST_EXPIRATION$p()).build();
        this.recentEmulatorLaunches = CacheBuilder.newBuilder().expireAfterWrite(StreamingToolWindowManagerKt.access$getATTENTION_REQUEST_EXPIRATION$p()).build();
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ StreamingToolWindowManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                StreamingToolWindowManager.access$viewSelectionChanged(this.this$0);
            }

            public void contentRemoveQuery(@NotNull ContentManagerEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                JComponent jComponent = event2.getContent().getComponent();
                RunningDevicePanel runningDevicePanel = jComponent instanceof RunningDevicePanel ? (RunningDevicePanel)((Object)jComponent) : null;
                if (runningDevicePanel == null) {
                    return;
                }
                RunningDevicePanel panel2 = runningDevicePanel;
                if (panel2 instanceof EmulatorToolWindowPanel) {
                    ((EmulatorToolWindowPanel)panel2).getEmulator().shutdown();
                }
                StreamingToolWindowManager.access$getPanels$p(this.this$0).remove((Object)((Object)panel2));
                StreamingToolWindowManager.access$getSavedUiState$p(this.this$0).remove(panel2.getId());
                if (StreamingToolWindowManager.access$getPanels$p(this.this$0).isEmpty()) {
                    StreamingToolWindowManager.access$createEmptyStatePanel(this.this$0);
                    StreamingToolWindowManager.access$hideLiveIndicator(this.this$0);
                }
            }
        };
        this.connectionStateListener = new EmulatorController.ConnectionStateListener(this){
            final /* synthetic */ StreamingToolWindowManager this$0;
            {
                this.this$0 = $receiver;
            }

            @AnyThread
            public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
                Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
                Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
                if (connectionState == EmulatorController.ConnectionState.DISCONNECTED) {
                    EventQueue.invokeLater(new Runnable(this.this$0, emulator){
                        final /* synthetic */ StreamingToolWindowManager this$0;
                        final /* synthetic */ EmulatorController $emulator;
                        {
                            this.this$0 = $receiver;
                            this.$emulator = $emulator;
                        }

                        public final void run() {
                            if (StreamingToolWindowManager.access$getContentCreated$p(this.this$0) && StreamingToolWindowManager.access$getEmulators$p(this.this$0).remove(this.$emulator)) {
                                StreamingToolWindowManager.access$removeEmulatorPanel(this.this$0, this.$emulator);
                            }
                        }
                    });
                }
            }
        };
        Disposer.register((Disposable)this.toolWindow.getDisposable(), (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection2.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = toolWindowManager.getToolWindow("Running Devices");
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                toolWindowManager.invokeLater(new Runnable(toolWindow2, this){
                    final /* synthetic */ ToolWindow $toolWindow;
                    final /* synthetic */ StreamingToolWindowManager this$0;
                    {
                        this.$toolWindow = $toolWindow;
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        if (!this.$toolWindow.isDisposed()) {
                            if (this.$toolWindow.isVisible()) {
                                StreamingToolWindowManager.access$createContent(this.this$0);
                            } else {
                                StreamingToolWindowManager.access$destroyContent(this.this$0);
                            }
                        }
                    }
                });
            }
        });
        Topic<AvdLaunchListener> topic2 = AvdLaunchListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new AvdLaunchListener(){

            @Override
            public final void avdLaunched(final @NotNull AvdInfo avd, @NotNull GeneralCommandLine commandLine, final @NotNull AvdLaunchListener.RequestType requestType, @Nullable Project project) {
                Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
                Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
                Intrinsics.checkNotNullParameter((Object)((Object)requestType), (String)"requestType");
                if (Intrinsics.areEqual((Object)project, (Object)toolWindow.getProject()) && StreamingToolWindowManagerKt.access$isEmbeddedEmulator(commandLine)) {
                    RunningEmulatorCatalog.Companion.getInstance().updateNow();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            this.showLiveIndicator();
                            if (requestType == AvdLaunchListener.RequestType.DIRECT) {
                                String string = avd.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"avd.name");
                                this.onEmulatorHeadsUp(string);
                            }
                        }
                    });
                }
            }
        });
        Topic<DeviceHeadsUpListener> topic3 = DeviceHeadsUpListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        messageBusConnection2.subscribe(topic3, (Object)new MyDeviceHeadsUpListener());
        Topic<DeviceMirroringSettingsListener> topic4 = DeviceMirroringSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic4, (String)"TOPIC");
        messageBusConnection2.subscribe(topic4, (Object)this);
        if (this.deviceMirroringSettings.getDeviceMirroringEnabled()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public final void run() {
                    if (!toolWindow.isDisposed()) {
                        physicalDeviceWatcher = new PhysicalDeviceWatcher(this);
                    }
                }
            });
        }
    }

    @AnyThread
    private final Project getProject() {
        Project project = this.toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"toolWindow.project");
        return project;
    }

    private final boolean getDeviceFrameVisible() {
        return this.properties.getBoolean("com.android.tools.idea.streaming.emulator.frame.visible", true);
    }

    private final void setDeviceFrameVisible(boolean value2) {
        this.properties.setValue("com.android.tools.idea.streaming.emulator.frame.visible", value2, true);
        for (RunningDevicePanel panel2 : this.panels) {
            panel2.setDeviceFrameVisible(value2);
        }
    }

    private final boolean getZoomToolbarIsVisible() {
        return this.properties.getBoolean("com.android.tools.idea.streaming.emulator.zoom.toolbar.visible", true);
    }

    private final void setZoomToolbarIsVisible(boolean value2) {
        this.properties.setValue("com.android.tools.idea.streaming.emulator.zoom.toolbar.visible", value2, true);
        for (RunningDevicePanel panel2 : this.panels) {
            panel2.setZoomToolbarVisible(value2);
        }
    }

    private final void onDeviceHeadsUp(String deviceSerialNumber) {
        if (this.deviceClients.containsKey(deviceSerialNumber)) {
            this.onPhysicalDeviceHeadsUp(deviceSerialNumber);
        } else {
            this.recentAttentionRequests.put((Object)deviceSerialNumber, (Object)deviceSerialNumber);
            Cache<String, String> cache2 = this.recentAttentionRequests;
            Intrinsics.checkNotNullExpressionValue(cache2, (String)"recentAttentionRequests");
            Cache<String, String> cache3 = cache2;
            this.alarm.addRequest(new Runnable(cache3){
                final /* synthetic */ Cache<String, String> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    this.$tmp0.cleanUp();
                }
            }, StreamingToolWindowManagerKt.access$getATTENTION_REQUEST_EXPIRATION$p().toMillis());
            if (StreamingToolWindowManagerKt.access$isEmulator(deviceSerialNumber)) {
                ListenableFuture<Set<EmulatorController>> future2 = RunningEmulatorCatalog.Companion.getInstance().updateNow();
                EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"getInstance()");
                FutureUtils.addCallback(future2, (Executor)((Executor)edtExecutorService), (Function1)((Function1)new Function1<Set<? extends EmulatorController>, Unit>(this, deviceSerialNumber){
                    final /* synthetic */ StreamingToolWindowManager this$0;
                    final /* synthetic */ String $deviceSerialNumber;
                    {
                        this.this$0 = $receiver;
                        this.$deviceSerialNumber = $deviceSerialNumber;
                        super(1);
                    }

                    public final void invoke(@Nullable Set<EmulatorController> emulators) {
                        if (emulators != null) {
                            StreamingToolWindowManager.access$onEmulatorHeadsUp(this.this$0, this.$deviceSerialNumber, emulators);
                        }
                    }
                }), (Function1)onDeviceHeadsUp.3.INSTANCE);
            }
        }
    }

    private final void onPhysicalDeviceHeadsUp(String deviceSerialNumber) {
        if (!this.toolWindow.isVisible()) {
            this.lastSelectedDeviceId = DeviceId.Companion.ofPhysicalDevice(deviceSerialNumber);
            this.showAndActivate(this.toolWindow);
        } else {
            RunningDevicePanel panel2 = this.findPanelBySerialNumber(deviceSerialNumber);
            if (panel2 != null) {
                this.selectPanel(panel2);
                this.showAndActivate(this.toolWindow);
            }
        }
    }

    private final void onEmulatorHeadsUp(String deviceSerialNumber, Set<EmulatorController> runningEmulators) {
        Object v0;
        block3: {
            Iterable iterable = runningEmulators;
            for (Object t : iterable) {
                EmulatorController it = (EmulatorController)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEmulatorId().getSerialNumber(), (Object)deviceSerialNumber)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        EmulatorController emulatorController = v0;
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulator = emulatorController;
        if (emulator.getEmulatorId().isEmbedded()) {
            this.onEmulatorHeadsUp(emulator.getEmulatorId().getAvdId());
        }
    }

    private final void onEmulatorHeadsUp(String avdId) {
        this.showAndActivate(this.toolWindow);
        RunningDevicePanel panel2 = this.findPanelByAvdId(avdId);
        if (panel2 == null) {
            RunningEmulatorCatalog.Companion.getInstance().updateNow();
            this.recentEmulatorLaunches.put((Object)avdId, (Object)avdId);
            Cache<String, String> cache2 = this.recentEmulatorLaunches;
            Intrinsics.checkNotNullExpressionValue(cache2, (String)"recentEmulatorLaunches");
            Cache<String, String> cache3 = cache2;
            this.alarm.addRequest(new Runnable(cache3){
                final /* synthetic */ Cache<String, String> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    this.$tmp0.cleanUp();
                }
            }, StreamingToolWindowManagerKt.access$getATTENTION_REQUEST_EXPIRATION$p().toMillis());
        } else {
            this.selectPanel(panel2);
        }
    }

    private final void selectPanel(RunningDevicePanel panel2) {
        if (!Intrinsics.areEqual((Object)((Object)this.selectedPanel), (Object)((Object)panel2))) {
            ContentManager contentManager = this.toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
            ContentManager contentManager2 = contentManager;
            Content content2 = contentManager2.getContent((JComponent)((Object)panel2));
            contentManager2.setSelectedContent(content2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createContent() {
        DeviceClient deviceClient2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!this.initialized) {
            this.initialized = true;
            this.toolWindow.getContentManager().addDataProvider(new DataProvider(this){
                final /* synthetic */ StreamingToolWindowManager this$0;
                {
                    this.this$0 = $receiver;
                }

                @Nullable
                public final Object getData(@NotNull String dataId) {
                    Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                    return StreamingToolWindowManager.access$getDataFromSelectedPanel(this.this$0, dataId);
                }
            });
            DefaultActionGroup actionGroup2 = new DefaultActionGroup();
            actionGroup2.addAction((AnAction)new ToggleZoomToolbarAction());
            actionGroup2.addAction((AnAction)new ToggleDeviceFrameAction());
            this.toolWindow.setAdditionalGearActions((ActionGroup)actionGroup2);
        }
        if (this.contentCreated) {
            return;
        }
        this.contentCreated = true;
        RunningEmulatorCatalog emulatorCatalog = RunningEmulatorCatalog.Companion.getInstance();
        emulatorCatalog.updateNow();
        emulatorCatalog.addListener(this, 1000);
        Iterable iterable = emulatorCatalog.getEmulators();
        HashSet<EmulatorController> hashSet = this.emulators;
        boolean $i$f$filter = false;
        void var4_9 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EmulatorController it = (EmulatorController)element$iv$iv;
            boolean bl = false;
            if (!it.getEmulatorId().isEmbedded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv);
        Iterator<Map.Entry<String, DeviceClient>> activeDeviceId = this.lastSelectedDeviceId;
        if (activeDeviceId instanceof DeviceId.EmulatorDeviceId) {
            Iterator<Object> iterator2;
            block12: {
                destination$iv$iv = this.emulators;
                for (Iterator<Object> iterator3 : destination$iv$iv) {
                    EmulatorController it = (EmulatorController)((Object)iterator3);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEmulatorId(), (Object)((DeviceId.EmulatorDeviceId)((Object)activeDeviceId)).getEmulatorId())) continue;
                    iterator2 = iterator3;
                    break block12;
                }
                iterator2 = null;
            }
            EmulatorController activeEmulator = (EmulatorController)((Object)iterator2);
            if (activeEmulator != null && !activeEmulator.isShuttingDown()) {
                this.addEmulatorPanel(activeEmulator);
            }
        } else if (activeDeviceId instanceof DeviceId.PhysicalDeviceId && (deviceClient2 = this.deviceClients.get(((DeviceId.PhysicalDeviceId)((Object)activeDeviceId)).getSerialNumber())) != null) {
            PhysicalDeviceWatcher physicalDeviceWatcher = this.physicalDeviceWatcher;
            if (physicalDeviceWatcher != null) {
                physicalDeviceWatcher.deviceConnected(((DeviceId.PhysicalDeviceId)((Object)activeDeviceId)).getSerialNumber(), deviceClient2);
            }
        }
        for (EmulatorController emulator : this.emulators) {
            DeviceId deviceId = this.lastSelectedDeviceId;
            if (Intrinsics.areEqual((Object)emulator.getEmulatorId().getSerialNumber(), (Object)(deviceId != null ? deviceId.getSerialNumber() : null)) || emulator.isShuttingDown()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)emulator, (String)"emulator");
            this.addEmulatorPanel(emulator);
        }
        for (Map.Entry<String, DeviceClient> entry : this.deviceClients.entrySet()) {
            String serialNumber = entry.getKey();
            DeviceClient deviceClient3 = entry.getValue();
            DeviceId deviceId = this.lastSelectedDeviceId;
            if (Intrinsics.areEqual((Object)serialNumber, (Object)(deviceId != null ? deviceId.getSerialNumber() : null))) continue;
            PhysicalDeviceWatcher physicalDeviceWatcher = this.physicalDeviceWatcher;
            if (physicalDeviceWatcher == null) continue;
            physicalDeviceWatcher.deviceConnected(serialNumber, deviceClient3);
        }
        this.lastSelectedDeviceId = null;
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        if (contentManager2.getContentCount() == 0) {
            this.createEmptyStatePanel();
        }
        contentManager2.addContentManagerListener((ContentManagerListener)this.contentManagerListener);
        this.viewSelectionChanged();
    }

    private final void destroyContent() {
        if (!this.contentCreated) {
            return;
        }
        this.contentCreated = false;
        RunningDevicePanel runningDevicePanel = this.selectedPanel;
        this.lastSelectedDeviceId = runningDevicePanel != null ? runningDevicePanel.getId() : null;
        RunningEmulatorCatalog.Companion.getInstance().removeListener(this);
        for (EmulatorController emulator : this.emulators) {
            emulator.removeConnectionStateListener(this.connectionStateListener);
        }
        this.emulators.clear();
        this.mirroredDevices.clear();
        RunningDevicePanel runningDevicePanel2 = this.selectedPanel;
        if (runningDevicePanel2 != null) {
            RunningDevicePanel it = runningDevicePanel2;
            boolean bl = false;
            ((Map)this.savedUiState).put(it.getId(), it.destroyContent());
        }
        this.selectedPanel = null;
        this.panels.clear();
        this.recentAttentionRequests.invalidateAll();
        this.recentEmulatorLaunches.invalidateAll();
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        contentManager2.removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        contentManager2.removeAllContents(true);
    }

    private final void addEmulatorPanel(EmulatorController emulator) {
        emulator.addConnectionStateListener(this.connectionStateListener);
        this.addPanel(new EmulatorToolWindowPanel(this.getProject(), emulator));
    }

    private final void addPhysicalDevicePanel(DeviceClient deviceClient2) {
        this.addPanel(new DeviceToolWindowPanel(this.getProject(), deviceClient2));
    }

    private final void addPanel(RunningDevicePanel panel2) {
        block5: {
            String avdId;
            DeviceId deviceId;
            boolean bl;
            Content content2;
            ContentManager contentManager = this.toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
            ContentManager contentManager2 = contentManager;
            Content placeholderContent2 = null;
            if (this.panels.isEmpty()) {
                this.showLiveIndicator();
                if (!contentManager2.isEmpty()) {
                    placeholderContent2 = contentManager2.getContent(0);
                }
            }
            ContentFactory contentFactory = ContentFactory.getInstance();
            Object $this$addPanel_u24lambda_u244 = content2 = contentFactory.createContent((JComponent)((Object)panel2), panel2.getTitle(), false);
            boolean bl2 = false;
            $this$addPanel_u24lambda_u244.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
            $this$addPanel_u24lambda_u244.setCloseable(panel2.isClosable());
            $this$addPanel_u24lambda_u244.setTabName(panel2.getTitle());
            $this$addPanel_u24lambda_u244.setIcon(panel2.getIcon());
            $this$addPanel_u24lambda_u244.setPopupIcon(panel2.getIcon());
            PropertyReference0Impl propertyReference0Impl = new PropertyReference0Impl((Object)panel2){

                @Nullable
                public Object get() {
                    return ((RunningDevicePanel)((Object)this.receiver)).getPreferredFocusableComponent();
                }
            };
            $this$addPanel_u24lambda_u244.setPreferredFocusedComponent(new Computable((Function0)propertyReference0Impl){
                private final /* synthetic */ Function0 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object compute() {
                    return this.function.invoke();
                }
            });
            $this$addPanel_u24lambda_u244.putUserData(StreamingToolWindowManagerKt.access$getID_KEY$p(), (Object)panel2.getId());
            Content content3 = content2;
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"contentFactory.createCon\u2026a(ID_KEY, panel.id)\n    }");
            Content content4 = content3;
            panel2.setZoomToolbarVisible(this.getZoomToolbarIsVisible());
            int index2 = ~CollectionsKt.binarySearch$default((List)this.panels, (Object)((Object)panel2), (Comparator)StreamingToolWindowManagerKt.access$getPANEL_COMPARATOR$p(), (int)0, (int)0, (int)12, null);
            boolean bl3 = bl = index2 >= 0;
            if (_Assertions.ENABLED && !bl) {
                $this$addPanel_u24lambda_u244 = "Assertion failed";
                throw new AssertionError($this$addPanel_u24lambda_u244);
            }
            if (index2 < 0) break block5;
            this.panels.add(index2, panel2);
            contentManager2.addContent(content4, index2);
            if (!Intrinsics.areEqual((Object)((Object)this.selectedPanel), (Object)((Object)panel2)) && (deviceId = panel2.getId()) instanceof DeviceId.EmulatorDeviceId && this.recentEmulatorLaunches.getIfPresent((Object)(avdId = ((DeviceId.EmulatorDeviceId)deviceId).getEmulatorId().getAvdId())) != null) {
                this.recentEmulatorLaunches.invalidate((Object)avdId);
                contentManager2.setSelectedContent(content4);
            }
            Content content5 = placeholderContent2;
            if (content5 != null) {
                Content it = content5;
                boolean bl4 = false;
                contentManager2.removeContent(it, true);
            }
        }
    }

    private final void removeEmulatorPanel(EmulatorController emulator) {
        emulator.removeConnectionStateListener(this.connectionStateListener);
        RunningDevicePanel runningDevicePanel = this.findPanelByEmulatorId(emulator.getEmulatorId());
        if (runningDevicePanel == null) {
            return;
        }
        RunningDevicePanel panel2 = runningDevicePanel;
        this.removePanel(panel2);
    }

    private final void removePhysicalDevicePanel(String serialNumber) {
        RunningDevicePanel runningDevicePanel = this.findPanelBySerialNumber(serialNumber);
        DeviceToolWindowPanel deviceToolWindowPanel = runningDevicePanel instanceof DeviceToolWindowPanel ? (DeviceToolWindowPanel)runningDevicePanel : null;
        if (deviceToolWindowPanel == null) {
            return;
        }
        DeviceToolWindowPanel panel2 = deviceToolWindowPanel;
        this.removePhysicalDevicePanel(panel2);
    }

    private final void removePhysicalDevicePanel(DeviceToolWindowPanel panel2) {
        String serialNumber = panel2.getId().getSerialNumber();
        DeviceClient deviceClient2 = this.deviceClients.remove(serialNumber);
        if (deviceClient2 != null) {
            DeviceClient it = deviceClient2;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.mirroredDevices.remove(serialNumber);
        this.removePanel(panel2);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllPhysicalDevicePanels() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.panels;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DeviceToolWindowPanel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeviceToolWindowPanel p0 = (DeviceToolWindowPanel)((Object)element$iv);
            boolean bl = false;
            this.removePhysicalDevicePanel(p0);
        }
    }

    private final void removePanel(RunningDevicePanel panel2) {
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content2 = contentManager2.getContent((JComponent)((Object)panel2));
        if (content2 != null) {
            contentManager2.removeContent(content2, true);
        }
    }

    private final void createEmptyStatePanel() {
        Content content2;
        EmptyStatePanel panel2 = new EmptyStatePanel(this.getProject());
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content $this$createEmptyStatePanel_u24lambda_u247 = content2 = contentFactory.createContent((JComponent)((Object)panel2), null, false);
        boolean bl = false;
        $this$createEmptyStatePanel_u24lambda_u247.setCloseable(false);
        Content content3 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"contentFactory.createCon\u2026isCloseable = false\n    }");
        Content content4 = content3;
        ContentManager contentManager = this.getContentManager();
        try {
            contentManager.addContent(content4);
            contentManager.setSelectedContent(content4);
        }
        catch (IncorrectOperationException e) {
            Disposer.dispose((Disposable)((Disposable)content4));
        }
    }

    private final void viewSelectionChanged() {
        Content content2;
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content3 = content2 = contentManager2.getSelectedContent();
        DeviceId id2 = content3 != null ? (DeviceId)content3.getUserData(StreamingToolWindowManagerKt.access$getID_KEY$p()) : null;
        RunningDevicePanel runningDevicePanel = this.selectedPanel;
        if (!Intrinsics.areEqual((Object)id2, (Object)(runningDevicePanel != null ? runningDevicePanel.getId() : null))) {
            RunningDevicePanel runningDevicePanel2 = this.selectedPanel;
            if (runningDevicePanel2 != null) {
                RunningDevicePanel panel2 = runningDevicePanel2;
                boolean bl = false;
                ((Map)this.savedUiState).put(panel2.getId(), panel2.destroyContent());
                this.selectedPanel = null;
            }
            if (id2 != null) {
                RunningDevicePanel runningDevicePanel3 = this.selectedPanel = this.findPanelByDeviceId(id2);
                if (runningDevicePanel3 != null) {
                    runningDevicePanel3.createContent(this.getDeviceFrameVisible(), this.savedUiState.remove(id2));
                }
                ToggleToolbarAction.setToolbarVisible((ToolWindow)this.toolWindow, (PropertiesComponent)PropertiesComponent.getInstance((Project)this.getProject()), null);
            }
        }
    }

    private final Object getDataFromSelectedPanel(String dataId) {
        Content content2 = this.toolWindow.getContentManager().getSelectedContent();
        if (content2 == null) {
            return null;
        }
        Content selectedContent = content2;
        DeviceId deviceId = (DeviceId)selectedContent.getUserData(StreamingToolWindowManagerKt.access$getID_KEY$p());
        if (deviceId == null) {
            return null;
        }
        DeviceId panelId = deviceId;
        RunningDevicePanel runningDevicePanel = this.findPanelByDeviceId(panelId);
        if (runningDevicePanel == null) {
            return null;
        }
        RunningDevicePanel panel2 = runningDevicePanel;
        return panel2.getData(dataId);
    }

    private final RunningDevicePanel findPanelByDeviceId(DeviceId deviceId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)deviceId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RunningDevicePanel findPanelByEmulatorId(EmulatorId emulatorId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!(it.getId() instanceof DeviceId.EmulatorDeviceId && Intrinsics.areEqual((Object)((DeviceId.EmulatorDeviceId)it.getId()).getEmulatorId(), (Object)emulatorId))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RunningDevicePanel findPanelByAvdId(String avdId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!(it.getId() instanceof DeviceId.EmulatorDeviceId && Intrinsics.areEqual((Object)((DeviceId.EmulatorDeviceId)it.getId()).getEmulatorId().getAvdId(), (Object)avdId))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RunningDevicePanel findPanelBySerialNumber(String serialNumber) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunningDevicePanel it = (RunningDevicePanel)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId().getSerialNumber(), (Object)serialNumber)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ContentManager getContentManager() {
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        return contentManager;
    }

    private final void showLiveIndicator() {
        this.toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.EMULATOR));
    }

    private final void hideLiveIndicator() {
        this.toolWindow.setIcon(StudioIcons.Shell.ToolWindows.EMULATOR);
    }

    @Override
    @AnyThread
    public void emulatorAdded(@NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        if (emulator.getEmulatorId().isEmbedded()) {
            EventQueue.invokeLater(new Runnable(this, emulator){
                final /* synthetic */ StreamingToolWindowManager this$0;
                final /* synthetic */ EmulatorController $emulator;
                {
                    this.this$0 = $receiver;
                    this.$emulator = $emulator;
                }

                public final void run() {
                    if (StreamingToolWindowManager.access$getContentCreated$p(this.this$0) && StreamingToolWindowManager.access$getEmulators$p(this.this$0).add(this.$emulator)) {
                        StreamingToolWindowManager.access$addEmulatorPanel(this.this$0, this.$emulator);
                    }
                }
            });
        }
    }

    @Override
    @AnyThread
    public void emulatorRemoved(@NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        if (emulator.getEmulatorId().isEmbedded()) {
            EventQueue.invokeLater(new Runnable(this, emulator){
                final /* synthetic */ StreamingToolWindowManager this$0;
                final /* synthetic */ EmulatorController $emulator;
                {
                    this.this$0 = $receiver;
                    this.$emulator = $emulator;
                }

                public final void run() {
                    if (StreamingToolWindowManager.access$getContentCreated$p(this.this$0) && StreamingToolWindowManager.access$getEmulators$p(this.this$0).remove(this.$emulator)) {
                        StreamingToolWindowManager.access$removeEmulatorPanel(this.this$0, this.$emulator);
                    }
                }
            });
        }
    }

    @Override
    public void settingsChanged(@NotNull DeviceMirroringSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (settings.getDeviceMirroringEnabled()) {
            if (this.physicalDeviceWatcher == null) {
                this.physicalDeviceWatcher = new PhysicalDeviceWatcher(this);
            }
        } else {
            PhysicalDeviceWatcher physicalDeviceWatcher = this.physicalDeviceWatcher;
            if (physicalDeviceWatcher != null) {
                PhysicalDeviceWatcher it = physicalDeviceWatcher;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.physicalDeviceWatcher = null;
        }
    }

    private final void showAndActivate(ToolWindow $this$showAndActivate) {
        if ($this$showAndActivate.isVisible()) {
            $this$showAndActivate.activate(null);
        } else {
            $this$showAndActivate.show(new Runnable($this$showAndActivate){
                final /* synthetic */ ToolWindow $this_showAndActivate;
                {
                    this.$this_showAndActivate = $receiver;
                }

                public final void run() {
                    this.$this_showAndActivate.activate(null);
                }
            });
        }
    }

    public void dispose() {
        this.destroyContent();
    }

    public static final /* synthetic */ void access$onEmulatorHeadsUp(StreamingToolWindowManager $this, String deviceSerialNumber, Set runningEmulators) {
        $this.onEmulatorHeadsUp(deviceSerialNumber, runningEmulators);
    }

    public static final /* synthetic */ Object access$getDataFromSelectedPanel(StreamingToolWindowManager $this, String dataId) {
        return $this.getDataFromSelectedPanel(dataId);
    }

    public static final /* synthetic */ void access$addEmulatorPanel(StreamingToolWindowManager $this, EmulatorController emulator) {
        $this.addEmulatorPanel(emulator);
    }

    public static final /* synthetic */ void access$removeEmulatorPanel(StreamingToolWindowManager $this, EmulatorController emulator) {
        $this.removeEmulatorPanel(emulator);
    }

    public static final /* synthetic */ void access$onDeviceHeadsUp(StreamingToolWindowManager $this, String deviceSerialNumber) {
        $this.onDeviceHeadsUp(deviceSerialNumber);
    }

    public static final /* synthetic */ Cache access$getRecentAttentionRequests$p(StreamingToolWindowManager $this) {
        return $this.recentAttentionRequests;
    }

    public static final /* synthetic */ void access$setLastSelectedDeviceId$p(StreamingToolWindowManager $this, DeviceId deviceId) {
        $this.lastSelectedDeviceId = deviceId;
    }

    public static final /* synthetic */ void access$showAndActivate(StreamingToolWindowManager $this, ToolWindow $receiver) {
        $this.showAndActivate($receiver);
    }

    public static final /* synthetic */ void access$viewSelectionChanged(StreamingToolWindowManager $this) {
        $this.viewSelectionChanged();
    }

    public static final /* synthetic */ ArrayList access$getPanels$p(StreamingToolWindowManager $this) {
        return $this.panels;
    }

    public static final /* synthetic */ HashMap access$getSavedUiState$p(StreamingToolWindowManager $this) {
        return $this.savedUiState;
    }

    public static final /* synthetic */ void access$createEmptyStatePanel(StreamingToolWindowManager $this) {
        $this.createEmptyStatePanel();
    }

    public static final /* synthetic */ void access$createContent(StreamingToolWindowManager $this) {
        $this.createContent();
    }

    public static final /* synthetic */ void access$destroyContent(StreamingToolWindowManager $this) {
        $this.destroyContent();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$MyDeviceHeadsUpListener;", "Lcom/android/tools/idea/run/DeviceHeadsUpListener;", "(Lcom/android/tools/idea/streaming/StreamingToolWindowManager;)V", "launchingApp", "", "deviceSerialNumber", "", "project", "Lcom/intellij/openapi/project/Project;", "launchingTest", "userInvolvementRequired", "intellij.android.streaming"})
    private final class MyDeviceHeadsUpListener
    implements DeviceHeadsUpListener {
        @Override
        public void userInvolvementRequired(@NotNull String deviceSerialNumber, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (Intrinsics.areEqual((Object)project, (Object)StreamingToolWindowManager.this.toolWindow.getProject())) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(StreamingToolWindowManager.this, deviceSerialNumber){
                    final /* synthetic */ StreamingToolWindowManager this$0;
                    final /* synthetic */ String $deviceSerialNumber;
                    {
                        this.this$0 = $receiver;
                        this.$deviceSerialNumber = $deviceSerialNumber;
                    }

                    public final void run() {
                        StreamingToolWindowManager.access$onDeviceHeadsUp(this.this$0, this.$deviceSerialNumber);
                    }
                });
            }
        }

        @Override
        public void launchingApp(@NotNull String deviceSerialNumber, @NotNull Project project) {
            boolean activate;
            Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean bl = activate = StreamingToolWindowManagerKt.access$isEmulator(deviceSerialNumber) ? StreamingToolWindowManager.this.emulatorSettings.getActivateOnAppLaunch() : StreamingToolWindowManager.this.deviceMirroringSettings.getActivateOnAppLaunch();
            if (activate) {
                this.userInvolvementRequired(deviceSerialNumber, project);
            }
        }

        @Override
        public void launchingTest(@NotNull String deviceSerialNumber, @NotNull Project project) {
            boolean activate;
            Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            boolean bl = activate = StreamingToolWindowManagerKt.access$isEmulator(deviceSerialNumber) ? StreamingToolWindowManager.this.emulatorSettings.getActivateOnTestLaunch() : StreamingToolWindowManager.this.deviceMirroringSettings.getActivateOnTestLaunch();
            if (activate) {
                this.userInvolvementRequired(deviceSerialNumber, project);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000bH\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$PhysicalDeviceWatcher;", "Lcom/intellij/openapi/Disposable;", "disposableParent", "(Lcom/android/tools/idea/streaming/StreamingToolWindowManager;Lcom/intellij/openapi/Disposable;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "deviceProvisioner", "Lcom/android/sdklib/deviceprovisioner/DeviceProvisioner;", "onlineDevices", "", "", "Lcom/android/tools/idea/streaming/ConnectedDevice;", "deviceConnected", "", "serialNumber", "device", "deviceSerialNumber", "deviceClient", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "dispose", "onlineDevicesChanged", "startMirroring", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nStreamingToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingToolWindowManager.kt\ncom/android/tools/idea/streaming/StreamingToolWindowManager$PhysicalDeviceWatcher\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,797:1\n29#2,3:798\n1#3:801\n*S KotlinDebug\n*F\n+ 1 StreamingToolWindowManager.kt\ncom/android/tools/idea/streaming/StreamingToolWindowManager$PhysicalDeviceWatcher\n*L\n662#1:798,3\n*E\n"})
    private final class PhysicalDeviceWatcher
    implements Disposable {
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private Map<String, ConnectedDevice> onlineDevices;
        @NotNull
        private DeviceProvisioner deviceProvisioner;

        public PhysicalDeviceWatcher(Disposable disposableParent) {
            Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
            this.onlineDevices = MapsKt.emptyMap();
            ComponentManager $this$service$iv = (ComponentManager)StreamingToolWindowManager.this.getProject();
            boolean $i$f$service = false;
            Class<DeviceProvisionerService> serviceClass$iv = DeviceProvisionerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            this.deviceProvisioner = ((DeviceProvisionerService)object).getDeviceProvisioner();
            Disposer.register((Disposable)disposableParent, (Disposable)this);
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"EmulatorToolWindowManager.PhysicalDeviceWatcher", (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026hysicalDeviceWatcher\", 1)");
            ExecutorService executor2 = executorService;
            this.coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope((Disposable)this, (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executor2)));
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ PhysicalDeviceWatcher this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = StreamingToolWindowManagerKt.access$mirrorableDevicesBySerialNumber(this.this$0.deviceProvisioner).collect(new FlowCollector(){

                                @Nullable
                                public final Object emit(final @NotNull Map<String, ConnectedDevice> newOnlineDevices, @NotNull Continuation<? super Unit> $completion) {
                                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                        @Override
                                        public final void run() {
                                            this$0.onlineDevices = newOnlineDevices;
                                            this$0.onlineDevicesChanged();
                                        }
                                    });
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void onlineDevicesChanged() {
            Set removed = SetsKt.minus(StreamingToolWindowManager.this.deviceClients.keySet(), (Iterable)this.onlineDevices.keySet());
            for (String entry : removed) {
                StreamingToolWindowManager.this.removePhysicalDevicePanel(entry);
            }
            if (!StreamingToolWindowManager.this.toolWindow.isVisible() && StreamingToolWindowManager.this.deviceClients.isEmpty() && StreamingToolWindowManager.this.emulators.isEmpty() && !((Collection)removed).isEmpty()) {
                StreamingToolWindowManager.this.hideLiveIndicator();
            }
            for (Map.Entry entry : this.onlineDevices.entrySet()) {
                String serialNumber = (String)entry.getKey();
                ConnectedDevice device3 = (ConnectedDevice)entry.getValue();
                if (StreamingToolWindowManager.this.mirroredDevices.contains(serialNumber)) continue;
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, serialNumber, device3, null){
                    int label;
                    final /* synthetic */ PhysicalDeviceWatcher this$0;
                    final /* synthetic */ String $serialNumber;
                    final /* synthetic */ ConnectedDevice $device;
                    {
                        this.this$0 = $receiver;
                        this.$serialNumber = $serialNumber;
                        this.$device = $device;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                PhysicalDeviceWatcher.access$deviceConnected(this.this$0, this.$serialNumber, this.$device);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }

        @AnyThread
        private final void deviceConnected(String serialNumber, ConnectedDevice device2) {
            DeviceProperties properties2 = device2.getState().getProperties();
            DeviceConfiguration config2 = new DeviceConfiguration(properties2, StreamingToolWindowManagerKt.access$isEmulator(serialNumber));
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, serialNumber, StreamingToolWindowManager.this, device2, config2, properties2){
                final /* synthetic */ PhysicalDeviceWatcher this$0;
                final /* synthetic */ String $serialNumber;
                final /* synthetic */ StreamingToolWindowManager this$1;
                final /* synthetic */ ConnectedDevice $device;
                final /* synthetic */ DeviceConfiguration $config;
                final /* synthetic */ DeviceProperties $properties;
                {
                    this.this$0 = $receiver;
                    this.$serialNumber = $serialNumber;
                    this.this$1 = $receiver2;
                    this.$device = $device;
                    this.$config = $config;
                    this.$properties = $properties;
                }

                public final void run() {
                    if (PhysicalDeviceWatcher.access$getOnlineDevices$p(this.this$0).containsKey(this.$serialNumber)) {
                        V v = StreamingToolWindowManager.access$getDeviceClients$p(this.this$1).computeIfAbsent(this.$serialNumber, new Function(this.this$0, this.$device, this.$config, this.$properties, this.this$1){
                            final /* synthetic */ PhysicalDeviceWatcher this$0;
                            final /* synthetic */ ConnectedDevice $device;
                            final /* synthetic */ DeviceConfiguration $config;
                            final /* synthetic */ DeviceProperties $properties;
                            final /* synthetic */ StreamingToolWindowManager this$1;
                            {
                                this.this$0 = $receiver;
                                this.$device = $device;
                                this.$config = $config;
                                this.$properties = $properties;
                                this.this$1 = $receiver2;
                            }

                            @NotNull
                            public final DeviceClient apply(@NotNull String serial) {
                                DeviceClient deviceClient2;
                                Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
                                DeviceClient $this$apply_u24lambda_u240 = deviceClient2 = new DeviceClient(this.this$0, serial, this.$device.getHandle(), this.$config, String.valueOf(this.$properties.getAbi()), StreamingToolWindowManager.access$getProject(this.this$1));
                                boolean bl = false;
                                $this$apply_u24lambda_u240.establishAgentConnectionWithoutVideoStreamAsync();
                                return deviceClient2;
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue(v, (String)"@UiThread\ninternal class\u2026evicePanels()\n    }\n  }\n}");
                        DeviceClient deviceClient2 = (DeviceClient)v;
                        StreamingToolWindowManager.access$showLiveIndicator(this.this$1);
                        if (StreamingToolWindowManager.access$getContentCreated$p(this.this$1)) {
                            this.this$0.deviceConnected(this.$serialNumber, deviceClient2);
                        } else if (StreamingToolWindowManager.access$getDeviceMirroringSettings$p(this.this$1).getActivateOnConnection() || StreamingToolWindowManager.access$getRecentAttentionRequests$p(this.this$1).getIfPresent((Object)this.$serialNumber) != null) {
                            StreamingToolWindowManager.access$getRecentAttentionRequests$p(this.this$1).invalidate((Object)this.$serialNumber);
                            StreamingToolWindowManager.access$setLastSelectedDeviceId$p(this.this$1, DeviceId.Companion.ofPhysicalDevice(this.$serialNumber));
                            StreamingToolWindowManager.access$showAndActivate(this.this$1, StreamingToolWindowManager.access$getToolWindow$p(this.this$1));
                        }
                    }
                }
            });
        }

        public final void deviceConnected(@NotNull String deviceSerialNumber, @NotNull DeviceClient deviceClient2) {
            Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
            Intrinsics.checkNotNullParameter((Object)deviceClient2, (String)"deviceClient");
            if (!StreamingToolWindowManager.this.mirroredDevices.contains(deviceSerialNumber)) {
                if (StreamingToolWindowManager.this.deviceMirroringSettings.getConfirmationDialogShown()) {
                    this.startMirroring(deviceSerialNumber, deviceClient2);
                } else if (!StreamingToolWindowManager.this.mirroringConfirmationDialogShowing) {
                    DialogWrapper dialogWrapper2;
                    StreamingToolWindowManager.this.mirroringConfirmationDialogShowing = true;
                    String title = "About to Start Mirroring of " + deviceClient2.getDeviceName();
                    DialogWrapper $this$deviceConnected_u24lambda_u240 = dialogWrapper2 = MirroringConfirmationDialog.createWrapper$default(new MirroringConfirmationDialog(title), StreamingToolWindowManager.this.getProject(), null, 2, null);
                    boolean bl = false;
                    $this$deviceConnected_u24lambda_u240.show();
                    DialogWrapper dialogWrapper3 = dialogWrapper2;
                    StreamingToolWindowManager.this.mirroringConfirmationDialogShowing = false;
                    switch (dialogWrapper3.getExitCode()) {
                        case 0: {
                            this.startMirroring(deviceSerialNumber, deviceClient2);
                            break;
                        }
                        case 2: {
                            StreamingToolWindowManager.this.deviceMirroringSettings.setDeviceMirroringEnabled(false);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    StreamingToolWindowManager.this.deviceMirroringSettings.setConfirmationDialogShown(true);
                }
            }
        }

        private final void startMirroring(String deviceSerialNumber, DeviceClient deviceClient2) {
            if (this.onlineDevices.containsKey(deviceSerialNumber) && StreamingToolWindowManager.this.mirroredDevices.add(deviceSerialNumber) && StreamingToolWindowManager.this.contentCreated) {
                StreamingToolWindowManager.this.addPhysicalDevicePanel(deviceClient2);
            }
        }

        public void dispose() {
            StreamingToolWindowManager.this.deviceClients.clear();
            StreamingToolWindowManager.this.removeAllPhysicalDevicePanels();
        }

        public static final /* synthetic */ void access$deviceConnected(PhysicalDeviceWatcher $this, String serialNumber, ConnectedDevice device2) {
            $this.deviceConnected(serialNumber, device2);
        }

        public static final /* synthetic */ Map access$getOnlineDevices$p(PhysicalDeviceWatcher $this) {
            return $this.onlineDevices;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$ToggleDeviceFrameAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/android/tools/idea/streaming/StreamingToolWindowManager;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.streaming"})
    private final class ToggleDeviceFrameAction
    extends ToggleAction
    implements DumbAware {
        public ToggleDeviceFrameAction() {
            super("Show Device Frame");
        }

        public void update(@NotNull AnActionEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            super.update(event2);
            RunningDevicePanel panel2 = StreamingToolWindowManager.this.selectedPanel;
            event2.getPresentation().setEnabledAndVisible(panel2 instanceof EmulatorToolWindowPanel && ((EmulatorToolWindowPanel)panel2).getEmulator().getEmulatorConfig().getSkinFolder() != null);
        }

        public boolean isSelected(@NotNull AnActionEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            return StreamingToolWindowManager.this.getDeviceFrameVisible();
        }

        public void setSelected(@NotNull AnActionEvent event2, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            StreamingToolWindowManager.this.setDeviceFrameVisible(state2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/StreamingToolWindowManager$ToggleZoomToolbarAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/android/tools/idea/streaming/StreamingToolWindowManager;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.streaming"})
    private final class ToggleZoomToolbarAction
    extends ToggleAction
    implements DumbAware {
        public ToggleZoomToolbarAction() {
            super("Show Zoom Controls");
        }

        public boolean isSelected(@NotNull AnActionEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            return StreamingToolWindowManager.this.getZoomToolbarIsVisible();
        }

        public void setSelected(@NotNull AnActionEvent event2, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            StreamingToolWindowManager.this.setZoomToolbarIsVisible(state2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }
}

