/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.streaming.DeviceId;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.android.tools.idea.streaming.StreamingConstants;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.DeviceMirroringSession;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00132\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,H&J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u00020,H&J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u0006H\u0016J\b\u00104\u001a\u000205H$J\u0010\u00106\u001a\u00020)2\u0006\u00107\u001a\u000208H\u0004J\b\u00109\u001a\u00020)H\u0004J\u0010\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020\u0013H&R\u0014\u0010\t\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0012\u0010!\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\u00020\u0013X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u0014\"\u0004\b&\u0010'\u00a8\u0006="}, d2={"Lcom/android/tools/idea/streaming/RunningDevicePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "id", "Lcom/android/tools/idea/streaming/DeviceId;", "mainToolbarId", "", "secondaryToolbarId", "(Lcom/android/tools/idea/streaming/DeviceId;Ljava/lang/String;Ljava/lang/String;)V", "centerPanel", "getCenterPanel", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getId", "()Lcom/android/tools/idea/streaming/DeviceId;", "isClosable", "", "()Z", "mainToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getMainToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "mirroringStartTime", "", "preferredFocusableComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "()Ljavax/swing/JComponent;", "secondaryToolbar", "getSecondaryToolbar", "title", "getTitle", "()Ljava/lang/String;", "zoomToolbarVisible", "getZoomToolbarVisible", "setZoomToolbarVisible", "(Z)V", "createContent", "", "deviceFrameVisible", "savedUiState", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "createToolbar", "toolbarId", "horizontal", "destroyContent", "getData", "", "dataId", "getDeviceInfo", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "mirroringEnded", "deviceKind", "Lcom/google/wireless/android/sdk/stats/DeviceMirroringSession$DeviceKind;", "mirroringStarted", "setDeviceFrameVisible", "visible", "UiState", "intellij.android.streaming"})
public abstract class RunningDevicePanel
extends BorderLayoutPanel
implements DataProvider {
    @NotNull
    private final DeviceId id;
    @NotNull
    private final ActionToolbar mainToolbar;
    @NotNull
    private final ActionToolbar secondaryToolbar;
    @NotNull
    private final BorderLayoutPanel centerPanel;
    private long mirroringStartTime;

    public RunningDevicePanel(@NotNull DeviceId id2, @NotNull String mainToolbarId, @NotNull String secondaryToolbarId) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)mainToolbarId, (String)"mainToolbarId");
        Intrinsics.checkNotNullParameter((Object)secondaryToolbarId, (String)"secondaryToolbarId");
        this.id = id2;
        this.centerPanel = new BorderLayoutPanel();
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.mainToolbar = this.createToolbar(mainToolbarId, true);
        this.secondaryToolbar = this.createToolbar(secondaryToolbarId, true);
        this.addToCenter((Component)this.centerPanel);
        BorderLayoutPanel toolbarPanel = new BorderLayoutPanel();
        this.mainToolbar.setOrientation(0);
        this.secondaryToolbar.setOrientation(0);
        toolbarPanel.add((Component)this.mainToolbar.getComponent(), (Object)"Center");
        toolbarPanel.add((Component)this.secondaryToolbar.getComponent(), (Object)"East");
        this.centerPanel.setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)2));
        this.addToTop((Component)toolbarPanel);
    }

    @NotNull
    public final DeviceId getId() {
        return this.id;
    }

    @NotNull
    public abstract String getTitle();

    @NotNull
    public abstract Icon getIcon();

    public abstract boolean isClosable();

    @NotNull
    public abstract JComponent getPreferredFocusableComponent();

    public abstract boolean getZoomToolbarVisible();

    public abstract void setZoomToolbarVisible(boolean var1);

    @NotNull
    protected final ActionToolbar getMainToolbar() {
        return this.mainToolbar;
    }

    @NotNull
    protected final ActionToolbar getSecondaryToolbar() {
        return this.secondaryToolbar;
    }

    @NotNull
    protected final BorderLayoutPanel getCenterPanel() {
        return this.centerPanel;
    }

    public abstract void createContent(boolean var1, @Nullable UiState var2);

    public static /* synthetic */ void createContent$default(RunningDevicePanel runningDevicePanel, boolean bl, UiState uiState, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createContent");
        }
        if ((n & 2) != 0) {
            uiState = null;
        }
        runningDevicePanel.createContent(bl, uiState);
    }

    @NotNull
    public abstract UiState destroyContent();

    public abstract void setDeviceFrameVisible(boolean var1);

    @NotNull
    protected abstract DeviceInfo getDeviceInfo();

    protected final void mirroringStarted() {
        this.mirroringStartTime = System.currentTimeMillis();
    }

    protected final void mirroringEnded(@NotNull DeviceMirroringSession.DeviceKind deviceKind) {
        Intrinsics.checkNotNullParameter((Object)deviceKind, (String)"deviceKind");
        long durationSec = (System.currentTimeMillis() - this.mirroringStartTime) / (long)1000;
        this.mirroringStartTime = 0L;
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_MIRRORING_SESSION).setDeviceMirroringSession(DeviceMirroringSession.newBuilder().setDeviceKind(deviceKind).setDurationSec(durationSec)).setDeviceInfo(this.getDeviceInfo());
        Intrinsics.checkNotNullExpressionValue((Object)studioEvent, (String)"studioEvent");
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String string = dataId;
        return Intrinsics.areEqual((Object)string, (Object)RunningDevicesConstants.SERIAL_NUMBER_KEY.getName()) ? (Serializable)((Object)this.id.getSerialNumber()) : (Intrinsics.areEqual((Object)string, (Object)StreamingConstants.STREAMING_CONTENT_PANEL_KEY.getName()) ? (Serializable)this.centerPanel : null);
    }

    private final ActionToolbar createToolbar(String toolbarId, boolean horizontal) {
        AnAction anAction = CustomActionsSchema.getInstance().getCorrectedAction(toolbarId);
        Intrinsics.checkNotNull((Object)anAction);
        List actions2 = CollectionsKt.listOf((Object)anAction);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(toolbarId, (ActionGroup)new DefaultActionGroup(actions2), horizontal);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"getInstance().createActi\u2026oup(actions), horizontal)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setLayoutPolicy(2);
        toolbar2.setTargetComponent((JComponent)((Object)this));
        ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)toolbar2);
        return toolbar2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "", "intellij.android.streaming"})
    public static interface UiState {
    }
}

