/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.annotations.concurrency.AnyThread;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.streaming.DeviceMirroringSettings;
import com.android.tools.idea.streaming.DeviceMirroringSettingsListener;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.EmulatorSettingsListener;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.settings.DeviceMirroringSettingsPage;
import com.android.tools.idea.streaming.emulator.settings.EmulatorSettingsPage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/streaming/EmptyStatePanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "deviceMirroringEnabled", "", "disposed", "emulatorLaunchesInToolWindow", "emulatorVersionIsSufficient", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "createContent", "", "createSpacer", "dispose", "localPackagesUpdated", "packages", "Lcom/android/repository/impl/meta/RepositoryPackages;", "updateContent", "updateUI", "intellij.android.streaming"})
public final class EmptyStatePanel
extends JBPanel<EmptyStatePanel>
implements Disposable {
    private boolean emulatorLaunchesInToolWindow;
    private boolean deviceMirroringEnabled;
    private boolean emulatorVersionIsSufficient;
    @NotNull
    private HyperlinkListener hyperlinkListener;
    private boolean disposed;

    public EmptyStatePanel(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new GridBagLayout());
        Disposer.register((Disposable)StreamingUtilsKt.getEarlyDisposable(project), (Disposable)this);
        this.setOpaque(true);
        this.setBackground(StandardColors.BACKGROUND_COLOR);
        this.setBorder((Border)JBUI.Borders.empty());
        this.setFocusable(true);
        this.emulatorLaunchesInToolWindow = EmulatorSettings.Companion.getInstance().getLaunchInToolWindow();
        this.deviceMirroringEnabled = DeviceMirroringSettings.Companion.getInstance().getDeviceMirroringEnabled();
        this.emulatorVersionIsSufficient = true;
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public final void hyperlinkUpdate(HyperlinkEvent event2) {
                block16: {
                    String string;
                    if (!Intrinsics.areEqual((Object)event2.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) || (string = event2.getDescription()) == null) break block16;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -254444240: {
                            if (string.equals("DeviceMirroringSettings")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1778371976: {
                            if (string.equals("EmulatorSettings")) {
                                n = 2;
                            }
                            break;
                        }
                        case 515705943: {
                            if (string.equals("DeviceManager")) {
                                n = 3;
                            }
                            break;
                        }
                        case 1975805674: {
                            if (string.equals("CheckForUpdate")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            AnAction action2 = ActionManager.getInstance().getAction("Android.DeviceManager");
                            ActionUtil.invokeAction((AnAction)action2, (DataContext)SimpleDataContext.getProjectContext((Project)project), (String)"unknown", null, null);
                            break;
                        }
                        case 4: {
                            AnAction action3 = ActionManager.getInstance().getAction("CheckForUpdate");
                            ActionUtil.invokeAction((AnAction)action3, (DataContext)SimpleDataContext.getProjectContext((Project)project), (String)"unknown", null, null);
                            break;
                        }
                        case 2: {
                            ShowSettingsUtil.getInstance().showSettingsDialog(project, EmulatorSettingsPage.class);
                            break;
                        }
                        case 1: {
                            ShowSettingsUtil.getInstance().showSettingsDialog(project, DeviceMirroringSettingsPage.class);
                        }
                    }
                }
            }
        };
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        Topic<EmulatorSettingsListener> topic = EmulatorSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection2.subscribe(topic, (Object)new EmulatorSettingsListener(){

            @Override
            public final void settingsChanged(@NotNull EmulatorSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                emulatorLaunchesInToolWindow = settings.getLaunchInToolWindow();
                this.updateContent();
            }
        });
        Topic<DeviceMirroringSettingsListener> topic2 = DeviceMirroringSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new DeviceMirroringSettingsListener(){

            @Override
            public final void settingsChanged(@NotNull DeviceMirroringSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                deviceMirroringEnabled = settings.getDeviceMirroringEnabled();
                this.updateContent();
            }
        });
        AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor().execute(new Runnable(){

            @Override
            public final void run() {
                AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
                AndroidSdkHandler sdkHandler = androidSdkHandler;
                ProgressIndicator progress2 = (ProgressIndicator)new StudioLoggerProgressIndicator(AvdManagerConnection.class);
                final RepoManager sdkManager = sdkHandler.getSdkManager(progress2);
                final RepoManager.RepoLoadedListener listener2 = new RepoManager.RepoLoadedListener(this){
                    final /* synthetic */ EmptyStatePanel this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void loaded(RepositoryPackages packages) {
                        Intrinsics.checkNotNullExpressionValue((Object)packages, (String)"packages");
                        EmptyStatePanel.access$localPackagesUpdated(this.this$0, packages);
                    }
                };
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public final void run() {
                        if (!disposed) {
                            sdkManager.addLocalChangeListener(listener2);
                            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                                public final void dispose() {
                                    sdkManager.removeLocalChangeListener(listener2);
                                }
                            });
                            RepositoryPackages repositoryPackages = sdkManager.getPackages();
                            Intrinsics.checkNotNullExpressionValue((Object)repositoryPackages, (String)"sdkManager.packages");
                            this.localPackagesUpdated(repositoryPackages);
                        }
                    }
                });
            }
        });
        this.updateContent();
    }

    @AnyThread
    private final void localPackagesUpdated(RepositoryPackages packages) {
        LocalPackage localPackage = (LocalPackage)packages.getLocalPackages().get("emulator");
        if (localPackage == null) {
            return;
        }
        LocalPackage emulatorPackage = localPackage;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(emulatorPackage, this){
            final /* synthetic */ LocalPackage $emulatorPackage;
            final /* synthetic */ EmptyStatePanel this$0;
            {
                this.$emulatorPackage = $emulatorPackage;
                this.this$0 = $receiver;
            }

            public final void run() {
                boolean sufficient;
                boolean bl = sufficient = this.$emulatorPackage.getVersion().compareTo(Revision.parseRevision((String)"31.3.10")) >= 0;
                if (EmptyStatePanel.access$getEmulatorVersionIsSufficient$p(this.this$0) != sufficient) {
                    EmptyStatePanel.access$setEmulatorVersionIsSufficient$p(this.this$0, sufficient);
                    EmptyStatePanel.access$updateContent(this.this$0);
                }
            }
        });
    }

    private final void createContent() {
        Object object;
        String string = Integer.toString(JBUI.CurrentTheme.Link.Foreground.ENABLED.getRGB() & 0xFFFFFF, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        String linkColorString = string;
        String html = this.emulatorLaunchesInToolWindow && this.emulatorVersionIsSufficient && this.deviceMirroringEnabled ? StringsKt.trimIndent((String)("\n        <center>\n        <p>To launch a&nbsp;virtual device, use\n        the&nbsp;<font color = " + linkColorString + "><a href='DeviceManager'>Device&nbsp;Manager</a></font>\n        or run your app while targeting a&nbsp;virtual device.</p>\n        <p/>\n        <p>To mirror a&nbsp;physical device, connect it via USB cable or over WiFi.</p>\n        </center>\n        ")) : (this.emulatorLaunchesInToolWindow && this.emulatorVersionIsSufficient && !this.deviceMirroringEnabled ? StringsKt.trimIndent((String)("\n        <center>\n        <p>To launch a&nbsp;virtual device, use\n        the&nbsp;<font color = " + linkColorString + "><a href='DeviceManager'>Device&nbsp;Manager</a></font>\n        or run your app while targeting a&nbsp;virtual device.</p>\n        <p/>\n        <p>To mirror physical devices, select the&nbsp;<i>Enable mirroring of physical Android devices</i> option\n        in&nbsp;the&nbsp;<font color = " + linkColorString + "><a href='DeviceMirroringSettings'>Device&nbsp;Mirroring&nbsp;settings</a></font>.\n        </p>\n        </center>\n        ")) : (this.emulatorLaunchesInToolWindow && !this.emulatorVersionIsSufficient && this.deviceMirroringEnabled ? StringsKt.trimIndent((String)("\n        <center>\n        <p>To launch virtual devices in this window, install Android Emulator 31.3.10 or higher.\n        Please <font color = " + linkColorString + "><a href='CheckForUpdate'>check for&nbsp;updates</a></font> and install\n        the&nbsp;latest version of the&nbsp;Android&nbsp;Emulator.</p>\n        <p/>\n        <p>To mirror a&nbsp;physical device, connect it via USB cable or over WiFi.</p>\n        </center>\n        ")) : (this.emulatorLaunchesInToolWindow && !this.emulatorVersionIsSufficient && !this.deviceMirroringEnabled ? StringsKt.trimIndent((String)("\n        <center>\n        <p>To launch virtual devices in this window, install Android Emulator 31.3.10 or higher.\n        Please <font color = " + linkColorString + "><a href='CheckForUpdate'>check for&nbsp;updates</a></font> and install\n        the&nbsp;latest version of the&nbsp;Android&nbsp;Emulator.</p>\n        <p/>\n        <p>To mirror physical devices, select the&nbsp;<i>Enable mirroring of physical Android devices</i> option\n        in&nbsp;the&nbsp;<font color = " + linkColorString + "><a href='DeviceMirroringSettings'>Device&nbsp;Mirroring&nbsp;settings</a></font>.\n        </p>\n        </center>\n        ")) : (this.deviceMirroringEnabled ? StringsKt.trimIndent((String)("\n        <center>\n        <p>To launch virtual devices in this window, select the&nbsp;<i>Launch in&nbsp;a&nbsp;tool window</i> option\n        in&nbsp;the&nbsp;<font color = " + linkColorString + "><a href='EmulatorSettings'>Emulator&nbsp;settings</a></font>.</p>\n        <p/>\n        <p>To mirror a&nbsp;physical device, connect it via USB cable or over WiFi.</p>\n        </center>\n        ")) : StringsKt.trimIndent((String)("\n        <center>\n        <p>To launch virtual devices in this window, select the&nbsp;<i>Launch in&nbsp;a&nbsp;tool window</i> option\n        in&nbsp;the&nbsp;<font color = " + linkColorString + "><a href='EmulatorSettings'>Emulator&nbsp;settings</a></font>.</p>\n        <p/>\n        <p>To mirror physical devices, select the&nbsp;<i>Enable mirroring of physical Android devices</i> option\n        in&nbsp;the&nbsp;<font color = " + linkColorString + "><a href='DeviceMirroringSettings'>Device&nbsp;Mirroring&nbsp;settings</a></font>.\n        </p>\n        </center>\n        "))))));
        Object object2 = JBUI.Fonts.label((float)13.0f);
        Color color = StandardColors.PLACEHOLDER_TEXT_COLOR;
        HyperlinkListener hyperlinkListener = this.hyperlinkListener;
        Object $this$createContent_u24lambda_u240 = object2 = ComponentsKt.htmlComponent$default((String)html, (Font)((Font)object2), null, (Color)color, (boolean)true, (HyperlinkListener)hyperlinkListener, (int)4, null);
        boolean bl = false;
        ((JComponent)$this$createContent_u24lambda_u240).setOpaque(false);
        ((Component)$this$createContent_u24lambda_u240).setFocusable(false);
        ((JComponent)$this$createContent_u24lambda_u240).setBorder((Border)JBUI.Borders.empty());
        Object text2 = object2;
        Object $this$createContent_u24lambda_u241 = $this$createContent_u24lambda_u240 = new GridBagConstraints();
        boolean bl2 = false;
        ((GridBagConstraints)$this$createContent_u24lambda_u241).fill = 1;
        ((GridBagConstraints)$this$createContent_u24lambda_u241).gridx = 1;
        ((GridBagConstraints)$this$createContent_u24lambda_u241).gridy = 0;
        ((GridBagConstraints)$this$createContent_u24lambda_u241).weightx = 0.7;
        ((GridBagConstraints)$this$createContent_u24lambda_u241).weighty = 0.45;
        Object c = $this$createContent_u24lambda_u240;
        JBLabel icon2 = new JBLabel(AndroidIcons.Explorer.DevicesLineup);
        icon2.setHorizontalAlignment(0);
        icon2.setVerticalAlignment(3);
        this.add((Component)icon2, c);
        Object $this$createContent_u24lambda_u242 = object = c;
        boolean bl3 = false;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).gridx = 0;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).gridy = 1;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).weightx = 0.15;
        ((GridBagConstraints)$this$createContent_u24lambda_u242).weighty = 0.55;
        this.add((Component)this.createSpacer(), c);
        Object $this$createContent_u24lambda_u243 = object = c;
        boolean bl4 = false;
        ((GridBagConstraints)$this$createContent_u24lambda_u243).gridx = 2;
        this.add((Component)this.createSpacer(), c);
        Object $this$createContent_u24lambda_u244 = object = c;
        boolean bl5 = false;
        ((GridBagConstraints)$this$createContent_u24lambda_u244).gridx = 1;
        this.add((Component)text2, c);
    }

    private final JBPanel<?> createSpacer() {
        JBPanel jBPanel = new JBPanel().withBorder((Border)JBUI.Borders.empty()).withMinimumWidth(0).withMinimumHeight(0).withPreferredSize(0, 0).andTransparent();
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"JBPanel<JBPanel<*>>()\n  \u2026)\n      .andTransparent()");
        return jBPanel;
    }

    private final void updateContent() {
        this.removeAll();
        this.createContent();
        this.validate();
    }

    public void updateUI() {
        super.updateUI();
        this.updateContent();
    }

    public void dispose() {
        this.disposed = true;
    }

    public static final /* synthetic */ boolean access$getEmulatorVersionIsSufficient$p(EmptyStatePanel $this) {
        return $this.emulatorVersionIsSufficient;
    }

    public static final /* synthetic */ void access$setEmulatorVersionIsSufficient$p(EmptyStatePanel $this, boolean bl) {
        $this.emulatorVersionIsSufficient = bl;
    }
}

