/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.streaming.StreamingLoadingPanel;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.ZoomablePanel;
import com.android.tools.idea.streaming.emulator.NotificationHolderPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0003fghB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\bJ\u0015\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b/J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0004H\u0002J \u00105\u001a\u00020+2\u0006\u00106\u001a\u0002072\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u00108\u001a\u000209H\u0004J\u001c\u0010:\u001a\u0004\u0018\u0001H;\"\n\b\u0000\u0010;\u0018\u0001*\u00020<H\u0082\b\u00a2\u0006\u0002\u0010=J\n\u0010>\u001a\u0004\u0018\u00010?H\u0002J\n\u0010@\u001a\u0004\u0018\u00010AH\u0004J\b\u0010B\u001a\u00020+H\u0004J\r\u0010C\u001a\u00020+H\u0000\u00a2\u0006\u0002\bDJ\r\u0010E\u001a\u00020+H\u0000\u00a2\u0006\u0002\bFJ\u0018\u0010G\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010H\u001a\u00020IH\u0004J\u0018\u0010J\u001a\u00020+2\u0006\u00106\u001a\u00020K2\u0006\u0010\u001c\u001a\u00020\u001bH\u0004J0\u0010L\u001a\u00020+2\u0006\u0010M\u001a\u0002072\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J\u000e\u0010R\u001a\u00020+2\u0006\u0010,\u001a\u00020\bJ\u0015\u0010S\u001a\u00020+2\u0006\u0010.\u001a\u00020\"H\u0000\u00a2\u0006\u0002\bTJ\u0010\u0010U\u001a\u00020Q2\u0006\u0010V\u001a\u00020QH\u0004J \u0010W\u001a\u00020+2\u0006\u0010X\u001a\u00020\u000e2\u000e\b\u0002\u0010Y\u001a\b\u0018\u00010ZR\u00020\u0000H\u0004J\u0015\u0010[\u001a\u00020+2\u0006\u0010\\\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b]J\u0017\u0010^\u001a\u0004\u0018\u0001032\u0006\u0010_\u001a\u000203H\u0000\u00a2\u0006\u0002\b`J\u0010\u0010a\u001a\u00020+2\u0006\u0010b\u001a\u00020cH\u0004J\u001c\u0010d\u001a\u00020+*\u00020K2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0004H\u0002J\u001c\u0010e\u001a\u00020+*\u00020K2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R:\u0010!\u001a.\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\"0\" \u0015*\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\"0\"0$\u00a2\u0006\u0002\b#0\u0007\u00a2\u0006\u0002\b#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010%\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00048G@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010\u0005R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayView;", "Lcom/android/tools/idea/streaming/ZoomablePanel;", "Lcom/intellij/openapi/Disposable;", "displayId", "", "(I)V", "decorationPainters", "", "Lcom/android/tools/idea/streaming/AbstractDisplayView$DecorationPainter;", "deviceDisplaySize", "Ljava/awt/Dimension;", "getDeviceDisplaySize$intellij_android_streaming", "()Ljava/awt/Dimension;", "deviceSerialNumber", "", "getDeviceSerialNumber", "()Ljava/lang/String;", "disconnectedStateMessage", "Lcom/intellij/ui/components/JBLabel;", "disconnectedStatePanel", "Ljavax/swing/Box;", "kotlin.jvm.PlatformType", "getDisplayId", "()I", "displayOrientationQuadrants", "getDisplayOrientationQuadrants", "<set-?>", "Ljava/awt/Rectangle;", "displayRectangle", "getDisplayRectangle", "()Ljava/awt/Rectangle;", "setDisplayRectangle", "(Ljava/awt/Rectangle;)V", "frameListeners", "Lcom/android/tools/idea/streaming/AbstractDisplayView$FrameListener;", "Lorg/jetbrains/annotations/NotNull;", "", "frameNumber", "getFrameNumber", "setFrameNumber", "reconnectButton", "Ljavax/swing/JButton;", "addDecorationRenderer", "", "decorationPainter", "addFrameListener", "listener", "addFrameListener$intellij_android_streaming", "createCircle", "Ljava/awt/geom/Ellipse2D;", "center", "Ljava/awt/Point;", "radius", "drawMultiTouchFeedback", "graphics", "Ljava/awt/Graphics2D;", "dragging", "", "findContainingComponent", "T", "Ljavax/swing/JComponent;", "()Ljavax/swing/JComponent;", "findLoadingPanel", "Lcom/android/tools/idea/streaming/StreamingLoadingPanel;", "findNotificationHolderPanel", "Lcom/android/tools/idea/streaming/emulator/NotificationHolderPanel;", "hideDisconnectedStateMessage", "hideLongRunningOperationIndicator", "hideLongRunningOperationIndicator$intellij_android_streaming", "hideLongRunningOperationIndicatorInstantly", "hideLongRunningOperationIndicatorInstantly$intellij_android_streaming", "notifyFrameListeners", "frame", "Ljava/awt/image/BufferedImage;", "paintDecorations", "Ljava/awt/Graphics;", "paintTouchBackground", "g", "color", "Ljava/awt/Color;", "intensity", "", "removeDecorationRenderer", "removeFrameListener", "removeFrameListener$intellij_android_streaming", "roundScale", "value", "showDisconnectedStateMessage", "message", "reconnector", "Lcom/android/tools/idea/streaming/AbstractDisplayView$Reconnector;", "showLongRunningOperationIndicator", "text", "showLongRunningOperationIndicator$intellij_android_streaming", "toDeviceDisplayCoordinates", "p", "toDeviceDisplayCoordinates$intellij_android_streaming", "traverseFocusLocally", "event", "Ljava/awt/event/KeyEvent;", "drawCircle", "fillCircle", "DecorationPainter", "FrameListener", "Reconnector", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nAbstractDisplayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDisplayView.kt\ncom/android/tools/idea/streaming/AbstractDisplayView\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n242#1,8:349\n242#1,8:357\n8#2:347\n1#3:348\n*S KotlinDebug\n*F\n+ 1 AbstractDisplayView.kt\ncom/android/tools/idea/streaming/AbstractDisplayView\n*L\n237#1:349,8\n239#1:357,8\n203#1:347\n*E\n"})
public abstract class AbstractDisplayView
extends ZoomablePanel
implements Disposable {
    private final int displayId;
    @Nullable
    private Rectangle displayRectangle;
    private int frameNumber;
    @NotNull
    private final JBLabel disconnectedStateMessage;
    @NotNull
    private final JButton reconnectButton;
    private final Box disconnectedStatePanel;
    @NotNull
    private final List<DecorationPainter> decorationPainters;
    @NotNull
    private final List<FrameListener> frameListeners;

    /*
     * WARNING - void declaration
     */
    public AbstractDisplayView(int displayId) {
        void $this$disconnectedStatePanel_u24lambda_u240;
        Box box;
        this.displayId = displayId;
        this.disconnectedStateMessage = new JBLabel("", 0);
        this.reconnectButton = new JButton("Reconnect");
        Box box2 = box = Box.createVerticalBox();
        AbstractDisplayView abstractDisplayView = this;
        boolean bl = false;
        $this$disconnectedStatePanel_u24lambda_u240.setVisible(false);
        $this$disconnectedStatePanel_u24lambda_u240.add(Box.createVerticalGlue());
        this.disconnectedStateMessage.setAlignmentX(0.5f);
        $this$disconnectedStatePanel_u24lambda_u240.add((Component)this.disconnectedStateMessage);
        $this$disconnectedStatePanel_u24lambda_u240.add(Box.createVerticalStrut(JBUIScale.scale((int)20)));
        this.reconnectButton.setAlignmentX(0.5f);
        $this$disconnectedStatePanel_u24lambda_u240.add(this.reconnectButton);
        $this$disconnectedStatePanel_u24lambda_u240.add(Box.createVerticalGlue());
        abstractDisplayView.disconnectedStatePanel = box;
        this.decorationPainters = new ArrayList();
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList<FrameListener>()");
        this.frameListeners = list2;
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.addToCenter(this.disconnectedStatePanel);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    public final int getDisplayId() {
        return this.displayId;
    }

    @NotNull
    public abstract String getDeviceSerialNumber();

    @Nullable
    public final Rectangle getDisplayRectangle() {
        return this.displayRectangle;
    }

    protected final void setDisplayRectangle(@Nullable Rectangle rectangle) {
        this.displayRectangle = rectangle;
    }

    public abstract int getDisplayOrientationQuadrants();

    @NotNull
    public abstract Dimension getDeviceDisplaySize$intellij_android_streaming();

    @VisibleForTesting
    public final int getFrameNumber() {
        return this.frameNumber;
    }

    protected final void setFrameNumber(int n) {
        this.frameNumber = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void traverseFocusLocally(@NotNull KeyEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.getFocusTraversalKeysEnabled()) {
            this.setFocusTraversalKeysEnabled(true);
            try {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().processKeyEvent((Component)((Object)this), event2);
            }
            finally {
                this.setFocusTraversalKeysEnabled(false);
            }
        }
        this.revalidate();
        this.repaint();
    }

    protected final void drawMultiTouchFeedback(@NotNull Graphics2D graphics, @NotNull Rectangle displayRectangle, boolean dragging) {
        Area area;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(mouseLocation, (Component)((Object)this));
        Intrinsics.checkNotNullExpressionValue((Object)mouseLocation, (String)"mouseLocation");
        Point touchPoint = StreamingUtilsKt.scaled(mouseLocation, this.getScreenScale());
        if (!displayRectangle.contains(touchPoint)) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON), TuplesKt.to((Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY)};
        g.setRenderingHints(new RenderingHints(MapsKt.mapOf((Pair[])pairArray)));
        g.setClip(displayRectangle);
        Point centerPoint = new Point(displayRectangle.x + displayRectangle.width / 2, displayRectangle.y + displayRectangle.height / 2);
        Point mirrorPoint = new Point(centerPoint.x * 2 - touchPoint.x, centerPoint.y * 2 - touchPoint.y);
        int r1 = MathKt.roundToInt((double)((double)Math.max(displayRectangle.width, displayRectangle.height) * 0.015));
        int r2 = r1 / 4;
        Ellipse2D touchCircle = this.createCircle(touchPoint, r1);
        Ellipse2D mirrorCircle = this.createCircle(mirrorPoint, r1);
        Ellipse2D centerCircle = this.createCircle(centerPoint, r2);
        Area $this$drawMultiTouchFeedback_u24lambda_u241 = area = new Area(displayRectangle);
        boolean bl = false;
        $this$drawMultiTouchFeedback_u24lambda_u241.subtract(new Area(touchCircle));
        $this$drawMultiTouchFeedback_u24lambda_u241.subtract(new Area(mirrorCircle));
        $this$drawMultiTouchFeedback_u24lambda_u241.subtract(new Area(centerCircle));
        Area clip = area;
        g.setClip(clip);
        Color darkColor = new Color(0, 154, 133, 157);
        Color lightColor = new Color(255, 255, 255, 157);
        g.setColor(darkColor);
        g.drawLine(touchPoint.x, touchPoint.y, mirrorPoint.x, mirrorPoint.y);
        g.setClip(displayRectangle);
        this.fillCircle(g, centerPoint, r2 * 3 / 4);
        double backgroundIntensity = dragging ? 0.8 : 0.3;
        this.paintTouchBackground(g, touchPoint, r1, darkColor, backgroundIntensity);
        this.paintTouchBackground(g, mirrorPoint, r1, darkColor, backgroundIntensity);
        g.setColor(lightColor);
        this.drawCircle(g, touchPoint, r1);
        this.drawCircle(g, mirrorPoint, r1);
        this.drawCircle(g, centerPoint, r2);
    }

    private final void paintTouchBackground(Graphics2D g, Point center, int radius, Color color, double intensity) {
        if (!(0.0 < intensity && intensity <= 1.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int r = radius * 5 / 4;
        Color intenseColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), MathKt.roundToInt((double)((double)color.getAlpha() * intensity)));
        Color subtleColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), MathKt.roundToInt((double)((double)color.getAlpha() * intensity * 0.15)));
        Object[] objectArray = new float[]{0.0f, 0.8f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[3];
        objectArray[0] = (float)subtleColor;
        objectArray[1] = (float)intenseColor;
        objectArray[2] = (float)subtleColor;
        g.setPaint(new RadialGradientPaint(center, r, fArray, (Color[])objectArray));
        this.fillCircle(g, center, r);
    }

    private final Ellipse2D createCircle(Point center, int radius) {
        double diameter = (double)radius * 2.0;
        return new Ellipse2D.Double(center.x - radius, center.y - radius, diameter, diameter);
    }

    private final void drawCircle(Graphics $this$drawCircle, Point center, int radius) {
        $this$drawCircle.drawOval(center.x - radius, center.y - radius, radius * 2, radius * 2);
    }

    private final void fillCircle(Graphics $this$fillCircle, Point center, int radius) {
        $this$fillCircle.fillOval(center.x - radius, center.y - radius, radius * 2, radius * 2);
    }

    public final void showLongRunningOperationIndicator$intellij_android_streaming(@NotNull String text2) {
        block0: {
            StreamingLoadingPanel streamingLoadingPanel;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            StreamingLoadingPanel streamingLoadingPanel2 = this.findLoadingPanel();
            if (streamingLoadingPanel2 == null) break block0;
            StreamingLoadingPanel $this$showLongRunningOperationIndicator_u24lambda_u242 = streamingLoadingPanel = streamingLoadingPanel2;
            boolean bl = false;
            $this$showLongRunningOperationIndicator_u24lambda_u242.setLoadingText(text2);
            $this$showLongRunningOperationIndicator_u24lambda_u242.startLoading();
        }
    }

    public final void hideLongRunningOperationIndicator$intellij_android_streaming() {
        block0: {
            StreamingLoadingPanel streamingLoadingPanel = this.findLoadingPanel();
            if (streamingLoadingPanel == null) break block0;
            streamingLoadingPanel.stopLoading();
        }
    }

    public final void hideLongRunningOperationIndicatorInstantly$intellij_android_streaming() {
        block0: {
            StreamingLoadingPanel streamingLoadingPanel = this.findLoadingPanel();
            if (streamingLoadingPanel == null) break block0;
            streamingLoadingPanel.stopLoadingInstantly();
        }
    }

    protected final void paintDecorations(@NotNull Graphics graphics, @NotNull Rectangle displayRectangle) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        for (DecorationPainter painter2 : this.decorationPainters) {
            try {
                Graphics graphics2 = graphics.create();
                Intrinsics.checkNotNullExpressionValue((Object)graphics2, (String)"graphics.create()");
                painter2.paintDecorations(graphics2, displayRectangle, this.getDeviceDisplaySize$intellij_android_streaming(), this.getDisplayOrientationQuadrants());
            }
            catch (Throwable t) {
                AbstractDisplayView $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(AbstractDisplayView.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.error(t);
            }
        }
    }

    protected final void showDisconnectedStateMessage(@NotNull String message2, @Nullable Reconnector reconnector) {
        JButton jButton;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
        this.zoom(ZoomType.FIT);
        this.disconnectedStateMessage.setText(message2);
        JButton $this$showDisconnectedStateMessage_u24lambda_u244 = jButton = this.reconnectButton;
        boolean bl = false;
        if (reconnector == null) {
            $this$showDisconnectedStateMessage_u24lambda_u244.setVisible(false);
        } else {
            $this$showDisconnectedStateMessage_u24lambda_u244.setVisible(true);
            Object object = reconnector.getReconnectLabel();
            $this$showDisconnectedStateMessage_u24lambda_u244.setAction(new AbstractAction(reconnector, (String)object){
                final /* synthetic */ Reconnector $reconnector;
                {
                    this.$reconnector = $reconnector;
                    super($super_call_param$1);
                }

                public void actionPerformed(@NotNull ActionEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    this.$reconnector.start$intellij_android_streaming();
                }
            });
            Object object2 = object = SwingUtilities.getRootPane($this$showDisconnectedStateMessage_u24lambda_u244);
            if (object2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getRootPane(this)");
                Object it = object;
                boolean bl2 = false;
                ((JRootPane)it).setDefaultButton($this$showDisconnectedStateMessage_u24lambda_u244);
            }
        }
        this.disconnectedStatePanel.setVisible(true);
        this.revalidate();
    }

    public static /* synthetic */ void showDisconnectedStateMessage$default(AbstractDisplayView abstractDisplayView, String string, Reconnector reconnector, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showDisconnectedStateMessage");
        }
        if ((n & 2) != 0) {
            reconnector = null;
        }
        abstractDisplayView.showDisconnectedStateMessage(string, reconnector);
    }

    protected final void hideDisconnectedStateMessage() {
        this.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
        this.disconnectedStatePanel.setVisible(false);
        this.reconnectButton.setAction(null);
        this.revalidate();
    }

    private final StreamingLoadingPanel findLoadingPanel() {
        JComponent jComponent;
        block1: {
            AbstractDisplayView this_$iv = this;
            boolean $i$f$findContainingComponent = false;
            for (Container component$iv = this_$iv.getParent(); component$iv != null; component$iv = component$iv.getParent()) {
                if (!(component$iv instanceof StreamingLoadingPanel)) continue;
                jComponent = (JComponent)component$iv;
                break block1;
            }
            jComponent = null;
        }
        return (StreamingLoadingPanel)((Object)jComponent);
    }

    @Nullable
    protected final NotificationHolderPanel findNotificationHolderPanel() {
        JComponent jComponent;
        block1: {
            AbstractDisplayView this_$iv = this;
            boolean $i$f$findContainingComponent = false;
            for (Container component$iv = this_$iv.getParent(); component$iv != null; component$iv = component$iv.getParent()) {
                if (!(component$iv instanceof NotificationHolderPanel)) continue;
                jComponent = (JComponent)component$iv;
                break block1;
            }
            jComponent = null;
        }
        return (NotificationHolderPanel)((Object)jComponent);
    }

    private final /* synthetic */ <T extends JComponent> T findContainingComponent() {
        boolean $i$f$findContainingComponent = false;
        for (Container component2 = this.getParent(); component2 != null; component2 = component2.getParent()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(component2 instanceof JComponent)) continue;
            return (T)((JComponent)component2);
        }
        return null;
    }

    protected final double roundScale(double value2) {
        if (value2 >= 1.0) {
            return Math.floor(value2);
        }
        int logScale = -MathKt.roundToInt((double)MathKt.log2((double)value2)) + 7;
        int multiplier = 2 << logScale + 7;
        return Math.rint(value2 * (double)multiplier) / (double)multiplier;
    }

    protected final void notifyFrameListeners(@NotNull Rectangle displayRectangle, @NotNull BufferedImage frame) {
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        for (FrameListener listener2 : this.frameListeners) {
            listener2.frameRendered(this.frameNumber, displayRectangle, this.getDisplayOrientationQuadrants(), frame);
        }
    }

    public final void addDecorationRenderer(@NotNull DecorationPainter decorationPainter2) {
        Intrinsics.checkNotNullParameter((Object)decorationPainter2, (String)"decorationPainter");
        this.decorationPainters.add(decorationPainter2);
    }

    public final void removeDecorationRenderer(@NotNull DecorationPainter decorationPainter2) {
        Intrinsics.checkNotNullParameter((Object)decorationPainter2, (String)"decorationPainter");
        this.decorationPainters.remove(decorationPainter2);
    }

    public final void addFrameListener$intellij_android_streaming(@NotNull FrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.frameListeners.add(listener2);
    }

    public final void removeFrameListener$intellij_android_streaming(@NotNull FrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.frameListeners.remove(listener2);
    }

    @Nullable
    public final Point toDeviceDisplayCoordinates$intellij_android_streaming(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Rectangle rectangle = this.displayRectangle;
        if (rectangle == null) {
            return null;
        }
        Rectangle displayRectangle = rectangle;
        Dimension dimension2 = displayRectangle.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"displayRectangle.size");
        Dimension imageSize = StreamingUtilsKt.rotatedByQuadrants(dimension2, this.getDisplayOrientationQuadrants());
        Point normalized = new Point();
        switch (this.getDisplayOrientationQuadrants()) {
            case 0: {
                normalized.x = StreamingUtilsKt.scaled(p.x, this.getScreenScale()) - displayRectangle.x;
                normalized.y = StreamingUtilsKt.scaled(p.y, this.getScreenScale()) - displayRectangle.y;
                break;
            }
            case 1: {
                normalized.x = StreamingUtilsKt.getBottom(displayRectangle) - StreamingUtilsKt.scaled(p.y, this.getScreenScale());
                normalized.y = StreamingUtilsKt.scaled(p.x, this.getScreenScale()) - displayRectangle.x;
                break;
            }
            case 2: {
                normalized.x = StreamingUtilsKt.getRight(displayRectangle) - StreamingUtilsKt.scaled(p.x, this.getScreenScale());
                normalized.y = StreamingUtilsKt.getBottom(displayRectangle) - StreamingUtilsKt.scaled(p.y, this.getScreenScale());
                break;
            }
            default: {
                normalized.x = StreamingUtilsKt.scaled(p.y, this.getScreenScale()) - displayRectangle.y;
                normalized.y = StreamingUtilsKt.getRight(displayRectangle) - StreamingUtilsKt.scaled(p.x, this.getScreenScale());
            }
        }
        return StreamingUtilsKt.scaledUnbiased(normalized, imageSize, this.getDeviceDisplaySize$intellij_android_streaming());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayView$DecorationPainter;", "", "paintDecorations", "", "graphics", "Ljava/awt/Graphics;", "displayRectangle", "Ljava/awt/Rectangle;", "deviceDisplaySize", "Ljava/awt/Dimension;", "displayOrientationQuadrants", "", "intellij.android.streaming"})
    public static interface DecorationPainter {
        public void paintDecorations(@NotNull Graphics var1, @NotNull Rectangle var2, @NotNull Dimension var3, int var4);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayView$FrameListener;", "", "frameRendered", "", "frameNumber", "", "displayRectangle", "Ljava/awt/Rectangle;", "displayOrientationQuadrants", "displayImage", "Ljava/awt/image/BufferedImage;", "intellij.android.streaming"})
    public static interface FrameListener {
        public void frameRendered(int var1, @NotNull Rectangle var2, int var3, @NotNull BufferedImage var4);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0084\u0004\u0018\u00002\u00020\u0001B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u001c\u0010\u0005\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0010\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR,\u0010\u0005\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/streaming/AbstractDisplayView$Reconnector;", "", "reconnectLabel", "", "progressMessage", "reconnect", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/android/tools/idea/streaming/AbstractDisplayView;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getProgressMessage", "()Ljava/lang/String;", "getReconnect", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function1;", "getReconnectLabel", "start", "start$intellij_android_streaming", "intellij.android.streaming"})
    protected final class Reconnector {
        @NotNull
        private final String reconnectLabel;
        @NotNull
        private final String progressMessage;
        @NotNull
        private final Function1<Continuation<? super Unit>, Object> reconnect;

        public Reconnector(@NotNull String reconnectLabel, @NotNull String progressMessage, Function1<? super Continuation<? super Unit>, ? extends Object> reconnect) {
            Intrinsics.checkNotNullParameter((Object)reconnectLabel, (String)"reconnectLabel");
            Intrinsics.checkNotNullParameter((Object)progressMessage, (String)"progressMessage");
            Intrinsics.checkNotNullParameter(reconnect, (String)"reconnect");
            this.reconnectLabel = reconnectLabel;
            this.progressMessage = progressMessage;
            this.reconnect = reconnect;
        }

        @NotNull
        public final String getReconnectLabel() {
            return this.reconnectLabel;
        }

        @NotNull
        public final String getProgressMessage() {
            return this.progressMessage;
        }

        @NotNull
        public final Function1<Continuation<? super Unit>, Object> getReconnect() {
            return this.reconnect;
        }

        public final void start$intellij_android_streaming() {
            AbstractDisplayView.this.hideDisconnectedStateMessage();
            AbstractDisplayView.this.showLongRunningOperationIndicator$intellij_android_streaming(this.progressMessage);
            BuildersKt.launch$default((CoroutineScope)CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)AbstractDisplayView.this, null, (int)2, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ Reconnector this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getReconnect().invoke((Object)((Object)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }
}

