/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.ToolWindowState;
import com.android.tools.idea.stats.ToolWindowTrackerServiceKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.StudioToolWindowActionStats;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "stateMap", "Ljava/util/HashMap;", "", "Lcom/android/tools/idea/stats/ToolWindowState;", "Lkotlin/collections/HashMap;", "stateChanged", "", "toolWindowRegistered", "id", "Companion", "intellij.android.core"})
public final class ToolWindowTrackerService
implements ToolWindowManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<String, ToolWindowState> stateMap;

    public ToolWindowTrackerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.stateMap = new HashMap();
    }

    public void toolWindowRegistered(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        ((Map)this.stateMap).put(id2, ToolWindowTrackerServiceKt.access$getToolWindowState(ToolWindowManager.Companion.getInstance(this.project).getToolWindow(id2)));
    }

    public void stateChanged() {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
        for (Map.Entry entry : ((Map)this.stateMap).entrySet()) {
            String id2 = (String)entry.getKey();
            ToolWindowState previousState = (ToolWindowState)entry.getValue();
            ToolWindow window2 = toolWindowManager.getToolWindow(id2);
            ToolWindowState currentState = ToolWindowTrackerServiceKt.access$getToolWindowState(window2);
            if (Intrinsics.areEqual((Object)currentState, (Object)previousState)) continue;
            StudioToolWindowActionStats stats = StudioToolWindowActionStats.newBuilder().setToolWindowId(id2).setEventType(currentState.getEventType()).setToolWindowType(ToolWindowTrackerServiceKt.access$getToolWindowType(window2)).build();
            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_TOOL_WINDOW_ACTION_STATS).setStudioToolWindowActionStats(stats);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
            ((Map)this.stateMap).put(id2, currentState);
        }
    }

    @JvmStatic
    @NotNull
    public static final ToolWindowTrackerService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/stats/ToolWindowTrackerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nToolWindowTrackerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowTrackerService.kt\ncom/android/tools/idea/stats/ToolWindowTrackerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,102:1\n29#2,3:103\n*S KotlinDebug\n*F\n+ 1 ToolWindowTrackerService.kt\ncom/android/tools/idea/stats/ToolWindowTrackerService$Companion\n*L\n43#1:103,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ToolWindowTrackerService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ToolWindowTrackerService> serviceClass$iv = ToolWindowTrackerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ToolWindowTrackerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

