/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.IntellijProjectSizeStats;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Processor;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/stats/ReportProjectSizeTask;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "fileCount", "", "fileType", "Lcom/android/tools/idea/stats/ReportProjectSizeTask$FileType;", "run", "", "FileType", "intellij.android.core"})
public final class ReportProjectSizeTask
implements Runnable {
    @NotNull
    private final Project project;

    public ReportProjectSizeTask(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void run() {
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.INTELLIJ_PROJECT_SIZE_STATS);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n      .setK\u2026ELLIJ_PROJECT_SIZE_STATS)");
        AndroidStudioEvent.Builder builder3 = UsageTrackerUtils.withProjectId(builder2, this.project);
        for (FileType fileType : FileType.values()) {
            Integer n;
            try {
                n = (Integer)ReadAction.nonBlocking((Callable)new Callable(this, fileType){
                    final /* synthetic */ ReportProjectSizeTask this$0;
                    final /* synthetic */ FileType $fileType;
                    {
                        this.this$0 = $receiver;
                        this.$fileType = $fileType;
                    }

                    public final Integer call() {
                        return ReportProjectSizeTask.access$fileCount(this.this$0, this.$fileType);
                    }
                }).inSmartMode(this.project).expireWith((Disposable)this.project).executeSynchronously();
            }
            catch (Exception e) {
                n = -1;
            }
            Integer fileCount2 = n;
            IntellijProjectSizeStats.Builder builder4 = IntellijProjectSizeStats.newBuilder().setScope(IntellijProjectSizeStats.Scope.PROJECT).setType(fileType.statsFileType());
            Intrinsics.checkNotNullExpressionValue((Object)fileCount2, (String)"fileCount");
            builder3.addIntellijProjectSizeStats(builder4.setCount(fileCount2.intValue()));
        }
        UsageTracker.log((AndroidStudioEvent.Builder)builder3);
    }

    private final int fileCount(FileType fileType) {
        if (fileType.languageFileType() instanceof PlainTextFileType) {
            return 0;
        }
        int cap = ServerFlagService.Companion.getInstance().getInt("analytics/projectsize/filecap", 60000);
        Ref.IntRef numFiles = new Ref.IntRef();
        FileTypeIndex.processFiles((com.intellij.openapi.fileTypes.FileType)fileType.languageFileType(), (Processor)new Processor(numFiles, cap){
            final /* synthetic */ Ref.IntRef $numFiles;
            final /* synthetic */ int $cap;
            {
                this.$numFiles = $numFiles;
                this.$cap = $cap;
            }

            public final boolean process(VirtualFile it) {
                int n = this.$numFiles.element;
                this.$numFiles.element = n + 1;
                return this.$numFiles.element < this.$cap;
            }
        }, (GlobalSearchScope)ProjectScope.getProjectScope((Project)this.project));
        return numFiles.element;
    }

    public static final /* synthetic */ int access$fileCount(ReportProjectSizeTask $this, FileType fileType) {
        return $this.fileCount(fileType);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/stats/ReportProjectSizeTask$FileType;", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "statsFileType", "Lcom/google/wireless/android/sdk/stats/IntellijProjectSizeStats$FileType;", "(Ljava/lang/String;ILcom/intellij/openapi/fileTypes/FileType;Lcom/google/wireless/android/sdk/stats/IntellijProjectSizeStats$FileType;)V", "languageFileType", "JAVA", "XML", "JAVA_CLASS", "KOTLIN", "NATIVE", "intellij.android.core"})
    private static final class FileType
    extends Enum<FileType> {
        @NotNull
        private final com.intellij.openapi.fileTypes.FileType fileType;
        @NotNull
        private final IntellijProjectSizeStats.FileType statsFileType;
        public static final /* enum */ FileType JAVA;
        public static final /* enum */ FileType XML;
        public static final /* enum */ FileType JAVA_CLASS;
        public static final /* enum */ FileType KOTLIN;
        public static final /* enum */ FileType NATIVE;
        private static final /* synthetic */ FileType[] $VALUES;

        private FileType(com.intellij.openapi.fileTypes.FileType fileType, IntellijProjectSizeStats.FileType statsFileType) {
            this.fileType = fileType;
            this.statsFileType = statsFileType;
        }

        @NotNull
        public final com.intellij.openapi.fileTypes.FileType languageFileType() {
            return this.fileType;
        }

        @NotNull
        public final IntellijProjectSizeStats.FileType statsFileType() {
            return this.statsFileType;
        }

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String value2) {
            return Enum.valueOf(FileType.class, value2);
        }

        static {
            JavaFileType javaFileType = JavaFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"INSTANCE");
            JAVA = new FileType((com.intellij.openapi.fileTypes.FileType)javaFileType, IntellijProjectSizeStats.FileType.JAVA);
            XmlFileType xmlFileType = XmlFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)xmlFileType, (String)"INSTANCE");
            XML = new FileType((com.intellij.openapi.fileTypes.FileType)xmlFileType, IntellijProjectSizeStats.FileType.XML);
            JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaClassFileType, (String)"INSTANCE");
            JAVA_CLASS = new FileType((com.intellij.openapi.fileTypes.FileType)javaClassFileType, IntellijProjectSizeStats.FileType.DOT_CLASS);
            com.intellij.openapi.fileTypes.FileType fileType = FileTypeRegistry.getInstance().findFileTypeByName("Kotlin");
            if (fileType == null) {
                fileType = (com.intellij.openapi.fileTypes.FileType)PlainTextFileType.INSTANCE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"FileTypeRegistry.getInst\u2026lainTextFileType.INSTANCE");
            KOTLIN = new FileType(fileType, IntellijProjectSizeStats.FileType.KOTLIN);
            com.intellij.openapi.fileTypes.FileType fileType2 = FileTypeRegistry.getInstance().findFileTypeByName("ObjectiveC");
            if (fileType2 == null) {
                fileType2 = (com.intellij.openapi.fileTypes.FileType)PlainTextFileType.INSTANCE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"FileTypeRegistry.getInst\u2026lainTextFileType.INSTANCE");
            NATIVE = new FileType(fileType2, IntellijProjectSizeStats.FileType.NATIVE);
            $VALUES = fileTypeArray = new FileType[]{FileType.JAVA, FileType.XML, FileType.JAVA_CLASS, FileType.KOTLIN, FileType.NATIVE};
        }
    }
}

