/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.actions.FeatureSurveyNotificationAction;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.FeatureSurveyConfig;
import com.android.tools.idea.serverflags.protos.Survey;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.ChoiceLogger;
import com.android.tools.idea.stats.ChoiceLoggerImpl;
import com.android.tools.idea.stats.DefaultSatisfactionSurveyKt;
import com.android.tools.idea.stats.FeatureSurveys;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/stats/FeatureSurveys;", "", "()V", "config", "Lcom/android/tools/idea/serverflags/protos/FeatureSurveyConfig;", "getConfig", "()Lcom/android/tools/idea/serverflags/protos/FeatureSurveyConfig;", "config$delegate", "Lkotlin/Lazy;", "isFeatureSurveyPending", "", "lock", "processEvent", "", "event", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "shouldInvokeFeatureSurvey", "name", "", "triggerSurveyByName", "surveyFileName", "FeatureSurveyChoiceLogger", "intellij.android.core"})
public final class FeatureSurveys {
    @NotNull
    public static final FeatureSurveys INSTANCE = new FeatureSurveys();
    private static boolean isFeatureSurveyPending;
    @NotNull
    private static final Object lock;
    @NotNull
    private static final Lazy config$delegate;

    private FeatureSurveys() {
    }

    public final void processEvent(@NotNull AndroidStudioEvent.Builder event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        String string = event2.getKind().getValueDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.kind.valueDescriptor.name");
        this.triggerSurveyByName(string);
    }

    public final void triggerSurveyByName(@NotNull String surveyFileName) {
        Intrinsics.checkNotNullParameter((Object)surveyFileName, (String)"surveyFileName");
        String name2 = "analytics/surveys/feature/" + surveyFileName;
        Survey survey = (Survey)ServerFlagService.Companion.getInstance().getProtoOrNull(name2, (Message)DefaultSatisfactionSurveyKt.getDEFAULT_SATISFACTION_SURVEY());
        if (survey == null) {
            return;
        }
        Survey survey2 = survey;
        if (!this.shouldInvokeFeatureSurvey(name2)) {
            return;
        }
        NotificationGroup notificationGroup2 = NotificationGroupManager.getInstance().getNotificationGroup("Feature Survey");
        if (notificationGroup2 == null) {
            return;
        }
        NotificationGroup notificationGroup3 = notificationGroup2;
        String string = survey2.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"survey.title");
        Notification notification = notificationGroup3.createNotification(string, "Would you like to take a 1-question survey based on your recent activity to help us improve Android Studio?", NotificationType.INFORMATION);
        notification.addAction((AnAction)new FeatureSurveyNotificationAction(surveyFileName, survey2));
        ApplicationManager.getApplication().invokeLater(new Runnable(notification){
            final /* synthetic */ Notification $notification;
            {
                this.$notification = $notification;
            }

            public final void run() {
                Notifications.Bus.notify((Notification)this.$notification);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean shouldInvokeFeatureSurvey(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!AnalyticsSettings.getOptedIn() || isFeatureSurveyPending) {
            return false;
        }
        Date now = AnalyticsSettings.getDateProvider().now();
        Date date = AnalyticsSettings.getNextFeatureSurveyDate();
        if (date != null) {
            Date it = date;
            boolean bl = false;
            if (now.before(it)) {
                return false;
            }
        }
        Map map2 = AnalyticsSettings.getNextFeatureSurveyDateMap();
        if (map2 != null) {
            Map map3 = map2;
            boolean bl = false;
            Date date2 = (Date)map3.get(name2);
            if (date2 != null) {
                Date it = date2;
                boolean bl2 = false;
                if (now.before(it)) {
                    return false;
                }
            }
        }
        Object object = lock;
        synchronized (object) {
            block10: {
                boolean bl = false;
                if (!isFeatureSurveyPending) break block10;
                boolean bl3 = false;
                return bl3;
            }
            isFeatureSurveyPending = true;
            Unit unit = Unit.INSTANCE;
        }
        return true;
    }

    @NotNull
    public final FeatureSurveyConfig getConfig() {
        Lazy lazy = config$delegate;
        return (FeatureSurveyConfig)lazy.getValue();
    }

    static {
        lock = new Object();
        config$delegate = LazyKt.lazy((Function0)config.2.INSTANCE);
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/stats/FeatureSurveys$FeatureSurveyChoiceLogger;", "Lcom/android/tools/idea/stats/ChoiceLogger;", "()V", "cancel", "", "name", "", "featureSurveyInvoked", "generalInterval", "", "specificInterval", "log", "result", "", "intellij.android.core"})
    public static final class FeatureSurveyChoiceLogger
    implements ChoiceLogger {
        @NotNull
        public static final FeatureSurveyChoiceLogger INSTANCE = new FeatureSurveyChoiceLogger();

        private FeatureSurveyChoiceLogger() {
        }

        @Override
        public void log(@NotNull String name2, @NotNull List<Integer> result2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            ChoiceLoggerImpl.INSTANCE.log(name2, result2);
            this.featureSurveyInvoked(name2, INSTANCE.getConfig().getGeneralIntervalCompleted(), INSTANCE.getConfig().getSpecificIntervalCompleted());
        }

        @Override
        public void cancel(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            ChoiceLoggerImpl.INSTANCE.cancel(name2);
            this.featureSurveyInvoked(name2, INSTANCE.getConfig().getGeneralIntervalCancelled(), INSTANCE.getConfig().getGeneralIntervalCancelled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public final void featureSurveyInvoked(@NotNull String name2, int generalInterval, int specificInterval) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Date now = AnalyticsSettings.getDateProvider().now();
            Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
            AnalyticsSettings.setNextFeatureSurveyDate((Date)AndroidStudioUsageTracker.INSTANCE.daysFromNow(now, generalInterval));
            Map map2 = AnalyticsSettings.getNextFeatureSurveyDateMap();
            if (map2 == null) {
                map2 = new LinkedHashMap();
            }
            Map map3 = map2;
            map3.put(name2, AndroidStudioUsageTracker.INSTANCE.daysFromNow(now, specificInterval));
            AnalyticsSettings.setNextFeatureSurveyDateMap((Map)map3);
            AnalyticsSettings.saveSettings();
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                isFeatureSurveyPending = false;
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

