/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndex;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.sdk.AndroidPlatform;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSpecificInitializer
implements ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance(GradleSpecificInitializer.class);

    public void componentsInitialized() {
        block6: {
            block7: {
                GradleSpecificInitializer.checkInstallPath();
                if (AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
                    try {
                        GradleSpecificInitializer.setupSdks();
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
                    }
                    GradleSpecificInitializer.checkAndSetAndroidSdkSources();
                }
                IdeInfo ideInfo = IdeInfo.getInstance();
                if (!ConfigImportHelper.isConfigImported()) break block6;
                if (ideInfo.isAndroidStudio()) break block7;
                if (!ideInfo.isGameTools()) break block6;
            }
            ApplicationManager.getApplication().invokeLaterOnWriteThread(IdeSdks.getInstance()::recreateProjectJdkTable);
        }
        this.useIdeGooglePlaySdkIndexInGradleDetector();
        Registry.get((String)"gradle.version.catalogs.dynamic.support").setValue(true);
    }

    private static void checkInstallPath() {
        if (PathManager.getHomePath().contains("!")) {
            String message2 = String.format("%1$s must not be installed in a path containing '!' or Gradle sync will fail!", ApplicationNamesInfo.getInstance().getProductName());
            Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification(message2, NotificationType.ERROR);
            notification.setImportant(true);
            Notifications.Bus.notify((Notification)notification);
        }
    }

    private static void notifyInvalidSdk() {
        String key = "android.invalid.sdk.message";
        String message2 = AndroidBundle.message(key, new Object[0]);
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                SdkQuickfixUtils.showAndroidSdkManager();
                notification.expire();
            }
        };
        GradleSpecificInitializer.addStartupWarning(message2, (NotificationListener)listener2);
    }

    private static void addStartupWarning(@NotNull String message2, @Nullable NotificationListener listener2) {
        Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification("SDK Validation", message2, NotificationType.WARNING, listener2);
        notification.setImportant(true);
        Notifications.Bus.notify((Notification)notification);
    }

    private static NotificationGroup getNotificationGroup() {
        NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)"System Health");
        if (group2 == null) {
            group2 = new NotificationGroup("Gradle Initializer", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginId.getId((String)"org.jetbrains.android"));
        }
        return group2;
    }

    private static void setupSdks() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        File androidHome = ideSdks.getAndroidSdkPath();
        if (androidHome != null) {
            Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(androidHome.toPath());
            Validator.Severity severity = result2.getSeverity();
            if (severity == Validator.Severity.ERROR) {
                GradleSpecificInitializer.notifyInvalidSdk();
            }
            return;
        }
        Sdk sdk = GradleSpecificInitializer.findFirstAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> ideSdks.createAndroidSdkPerAndroidTarget(FilePaths.stringToFile((String)sdkHomePath)));
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            File androidSdkPath = GradleSpecificInitializer.getAndroidSdkPath();
            if (androidSdkPath == null) {
                return;
            }
            FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
            boolean promptSdkSelection = wizardMode == null;
            Sdk sdk1 = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
            if (sdk1 != null) {
                String sdkNamePrefix = "Android ";
                if (sdk1.getName().startsWith(sdkNamePrefix)) {
                    SdkModificator sdkModificator = sdk1.getSdkModificator();
                    sdkModificator.setName(sdkNamePrefix + sdk1.getName().substring(sdkNamePrefix.length()));
                    sdkModificator.commitChanges();
                    ideSdks.createAndroidSdkPerAndroidTarget(androidSdkPath);
                }
            }
        });
    }

    @Nullable
    private static Sdk findFirstAndroidSdk() {
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        if (!sdks.isEmpty()) {
            return sdks.get(0);
        }
        return null;
    }

    @Nullable
    private static File getAndroidSdkPath() {
        return AndroidSdkInitializer.findValidAndroidSdkPath();
    }

    private static void checkAndSetAndroidSdkSources() {
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            GradleSpecificInitializer.checkAndSetSources(sdk);
        }
    }

    private static void checkAndSetSources(@NotNull Sdk sdk) {
        VirtualFile[] storedSources = sdk.getRootProvider().getFiles(OrderRootType.SOURCES);
        if (storedSources.length > 0) {
            return;
        }
        AndroidPlatform platform = AndroidPlatforms.getInstance(sdk);
        if (platform != null) {
            if (ApplicationManager.getApplication().isWriteThread()) {
                GradleSpecificInitializer.setSources(sdk, platform);
            } else {
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> GradleSpecificInitializer.setSources(sdk, platform));
            }
        }
    }

    private static void setSources(@NotNull Sdk sdk, @NotNull AndroidPlatform platform) {
        SdkModificator sdkModificator = sdk.getSdkModificator();
        IAndroidTarget target2 = platform.getTarget();
        AndroidSdks.getInstance().findAndSetPlatformSources(target2, sdkModificator);
        sdkModificator.commitChanges();
    }

    private void useIdeGooglePlaySdkIndexInGradleDetector() {
        GradleDetector.setPlaySdkIndexFactory((path2, client2) -> {
            IdeGooglePlaySdkIndex playIndex = IdeGooglePlaySdkIndex.INSTANCE;
            playIndex.initializeAndSetFlags();
            return playIndex;
        });
    }
}

