/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.analytics.SystemInfoStatsMonitor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.install.patch.PatchInstallingRestarter;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(AndroidSdkInitializer.class);
    @NonNls
    private static final String ANDROID_SDK_FOLDER_NAME = "sdk";
    private static final String[] ANDROID_SDK_RELATIVE_PATHS = new String[]{"sdk", File.separator + ".." + File.separator + "sdk"};

    @NonNls
    private static String getAndroidSdkDefaultInstallDir() {
        return SystemInfo.isWindows ? FileUtil.join((String[])new String[]{System.getenv("LOCALAPPDATA"), "Android", "Sdk"}) : (SystemInfo.isMac ? FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), "Library", "Android", ANDROID_SDK_FOLDER_NAME}) : FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), "Android", "Sdk"}));
    }

    @Override
    public void run() {
        if (!AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            return;
        }
        if (GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        IdeSdks ideSdks = IdeSdks.getInstance();
        File androidSdkPath = ideSdks.getAndroidSdkPath();
        if (androidSdkPath == null) {
            try {
                AndroidSdkInitializer.setUpSdks();
                androidSdkPath = ideSdks.getAndroidSdkPath();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
            }
        }
        if (androidSdkPath != null) {
            int androidPlatformToAutocreate = (Integer)StudioFlags.ANDROID_PLATFORM_TO_AUTOCREATE.get();
            if (androidPlatformToAutocreate != 0) {
                LOG.info(String.format(Locale.US, "Automatically creating an Android platform using SDK path==%s and SDK version==%d", androidSdkPath, androidPlatformToAutocreate));
                AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.toString(), false);
            }
            AndroidSdkHandler handler2 = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)androidSdkPath.toPath());
            new PatchInstallingRestarter(handler2).restartAndInstallIfNecessary();
            new SystemInfoStatsMonitor().start();
        }
    }

    private static void setUpSdks() {
        Sdk sdk = AndroidSdkInitializer.findFirstAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            IdeSdks.getInstance().createAndroidSdkPerAndroidTarget(FilePaths.stringToFile((String)sdkHomePath));
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            File androidSdkPath = AndroidSdkInitializer.findValidAndroidSdkPath();
            if (androidSdkPath == null) {
                return;
            }
            FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
            boolean promptSdkSelection = wizardMode == null;
            Sdk newSdk = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
            if (newSdk != null) {
                String sdkNamePrefix = "Android ";
                if (newSdk.getName().startsWith(sdkNamePrefix)) {
                    SdkModificator sdkModificator = newSdk.getSdkModificator();
                    sdkModificator.setName(sdkNamePrefix + newSdk.getName().substring(sdkNamePrefix.length()));
                    sdkModificator.commitChanges();
                    IdeSdks.getInstance().createAndroidSdkPerAndroidTarget(androidSdkPath);
                }
            }
        });
    }

    @Nullable
    private static Sdk findFirstAndroidSdk() {
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @Nullable
    public static File findValidAndroidSdkPath() {
        File candidate = AndroidSdkInitializer.getAndroidSdkPathOrDefault();
        return AndroidSdkType.getInstance().isValidSdkHome(candidate.getPath()) ? candidate : null;
    }

    @NotNull
    public static File getAndroidSdkPathOrDefault() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
        } else {
            LOG.info(String.format("Found Studio home directory at: '%1$s'", studioHome));
            for (String path2 : ANDROID_SDK_RELATIVE_PATHS) {
                File dir = new File(studioHome, path2);
                String absolutePath = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
                LOG.info(String.format("Looking for Android SDK at '%1$s'", absolutePath));
                if (!AndroidSdkType.getInstance().isValidSdkHome(absolutePath)) continue;
                LOG.info(String.format("Found Android SDK at '%1$s'", absolutePath));
                return new File(absolutePath);
            }
        }
        LOG.info("Unable to locate SDK within the Android studio installation.");
        return AndroidSdkInitializer.getAndroidSdkOrDefault(System.getenv(), AndroidSdkType.getInstance());
    }

    @NotNull
    private static File getAndroidSdkOrDefault(Map<String, String> env, AndroidSdkType instance2) {
        return AndroidSdkInitializer.getAndroidSdkOrDefault(env, instance2, IdeInfo.getInstance());
    }

    @VisibleForTesting
    @NotNull
    static File getAndroidSdkOrDefault(Map<String, String> env, AndroidSdkType instance2, IdeInfo ideInfo) {
        LinkedHashMap<String, Callable<String>> sdkLocationCandidates = new LinkedHashMap<String, Callable<String>>();
        sdkLocationCandidates.put("ANDROID_HOME environment variable", () -> (String)env.get("ANDROID_HOME"));
        sdkLocationCandidates.put("ANDROID_SDK_ROOT environment variable", () -> (String)env.get("ANDROID_SDK_ROOT"));
        for (Map.Entry locationCandidate : sdkLocationCandidates.entrySet()) {
            try {
                String msg;
                String pathDescription = (String)locationCandidate.getKey();
                String sdkPath = (String)((Callable)locationCandidate.getValue()).call();
                if (!StringUtil.isEmpty((String)sdkPath) && (instance2.isValidSdkHome(sdkPath) || ideInfo.isGameTools())) {
                    msg = String.format("%1$s: '%2$s'", pathDescription, sdkPath);
                } else {
                    msg = String.format("Examined and not found a valid Android SDK path: %1$s", pathDescription);
                    sdkPath = null;
                }
                LOG.info(msg);
                if (sdkPath == null) continue;
                return FilePaths.stringToFile((String)sdkPath);
            }
            catch (Exception e) {
                LOG.info("Exception during SDK lookup", (Throwable)e);
            }
        }
        String defaultDir = AndroidSdkInitializer.getAndroidSdkDefaultInstallDir();
        LOG.info("Using default SDK path: " + defaultDir);
        return FilePaths.stringToFile((String)defaultDir);
    }
}

