/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.tableView;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.SqliteColumnValue;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.tableView.OrderBy;
import com.android.tools.idea.sqlite.ui.tableView.RowDiffOperation;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.android.tools.idea.sqlite.ui.tableView.ViewColumn;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005]^_`aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020\u0016H\u0016J\b\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020 2\u0006\u0010:\u001a\u00020\u0016H\u0016J\u001a\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020\u001b2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\b\u0010B\u001a\u00020 H\u0016J\b\u0010C\u001a\u00020 H\u0016J\b\u0010D\u001a\u00020 H\u0002J\u0010\u0010E\u001a\u00020 2\u0006\u0010$\u001a\u00020#H\u0016J\u0010\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u00020\u0010H\u0002J\u0010\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020\u0010H\u0016J\u0010\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020\u001bH\u0016J\u0010\u0010L\u001a\u00020 2\u0006\u0010M\u001a\u00020\u0010H\u0016J\u0010\u0010N\u001a\u00020 2\u0006\u0010M\u001a\u00020\u0010H\u0016J\u0010\u0010O\u001a\u00020 2\u0006\u0010P\u001a\u00020\u0010H\u0016J\u0010\u0010Q\u001a\u00020 2\u0006\u0010P\u001a\u00020\u0010H\u0016J\u0010\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020)H\u0016J\b\u0010T\u001a\u00020 H\u0002J\u0010\u0010U\u001a\u00020 2\u0006\u0010V\u001a\u00020)H\u0016J\u0016\u0010W\u001a\u00020 2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010X\u001a\u00020 H\u0016J\b\u0010Y\u001a\u00020 H\u0016J\u0016\u0010Z\u001a\u00020 2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\f0\u001b\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020)0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00106\u001a\f0\u001b\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "()V", "centerPanel", "Ljavax/swing/JPanel;", "columns", "", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "exportButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "firstRowsPageButton", "isLoading", "", "lastRowsPageButton", "layeredPane", "Ljavax/swing/JLayeredPane;", "listeners", "", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView$Listener;", "liveUpdatesCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "liveUpdatesEnabled", "loadingTableDataText", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "myRevertLastTableCellEdit", "Lkotlin/Function0;", "", "nextRowsPageButton", "<set-?>", "Lcom/android/tools/idea/sqlite/ui/tableView/OrderBy;", "orderBy", "getOrderBy", "()Lcom/android/tools/idea/sqlite/ui/tableView/OrderBy;", "pageSizeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "pageSizeDefaultValues", "previousRowsPageButton", "progressBar", "Ljavax/swing/JProgressBar;", "readOnlyLabel", "Ljavax/swing/JLabel;", "refreshButton", "refreshEnabled", "rootPanel", "table", "Lcom/intellij/ui/table/JBTable;", "tableHadFocus", "tableIsEmptyText", "tableScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "addListener", "listener", "createPagingControlsPanel", "Ljava/awt/Component;", "removeListener", "reportError", "message", "t", "", "resetView", "revertLastTableCellEdit", "setAutoResizeMode", "setColumnSortIndicator", "setControlButtonsEnabled", "enabled", "setEditable", "isEditable", "setEmptyText", "text", "setFetchNextRowsButtonState", "enable", "setFetchPreviousRowsButtonState", "setLiveUpdatesButtonState", "state", "setRefreshButtonState", "setRowOffset", "rowOffset", "setUpPopUp", "showPageSizeValue", "maxRowCount", "showTableColumns", "startTableLoading", "stopTableLoading", "updateRows", "rowDiffOperations", "Lcom/android/tools/idea/sqlite/ui/tableView/RowDiffOperation;", "MatchParentLayoutManager", "MyColoredTableCellRenderer", "MyRow", "MyTableHeaderRenderer", "MyTableModel", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,722:1\n1#2:723\n1851#3,2:724\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl\n*L\n288#1:724,2\n*E\n"})
public final class TableViewImpl
implements TableView {
    @NotNull
    private final String tableIsEmptyText = DatabaseInspectorBundle.INSTANCE.message("table.is.empty", new String[0]);
    @NotNull
    private final String loadingTableDataText = DatabaseInspectorBundle.INSTANCE.message("loading.data", new String[0]);
    @NotNull
    private final List<TableView.Listener> listeners = new ArrayList();
    @NotNull
    private final List<Integer> pageSizeDefaultValues;
    @Nullable
    private List<ViewColumn> columns;
    @NotNull
    private final JPanel rootPanel;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JLabel readOnlyLabel;
    @NotNull
    private final CommonButton firstRowsPageButton;
    @NotNull
    private final CommonButton lastRowsPageButton;
    @NotNull
    private final CommonButton previousRowsPageButton;
    @NotNull
    private final CommonButton nextRowsPageButton;
    @NotNull
    private final ComboBox<Integer> pageSizeComboBox;
    @NotNull
    private final CommonButton refreshButton;
    @NotNull
    private final JBCheckBox liveUpdatesCheckBox;
    @NotNull
    private final CommonButton exportButton;
    @NotNull
    private final JBTable table;
    @NotNull
    private final JBScrollPane tableScrollPane;
    @NotNull
    private final JProgressBar progressBar;
    @NotNull
    private final JPanel centerPanel;
    @NotNull
    private final JLayeredPane layeredPane;
    @Nullable
    private Function0<Unit> myRevertLastTableCellEdit;
    private boolean isLoading;
    private boolean tableHadFocus;
    @NotNull
    private OrderBy orderBy;
    private boolean liveUpdatesEnabled;
    private boolean refreshEnabled;

    public TableViewImpl() {
        JPanel jPanel;
        Object[] objectArray = new Integer[]{5, 10, 20, 25, 50};
        this.pageSizeDefaultValues = CollectionsKt.listOf((Object[])objectArray);
        this.rootPanel = new JPanel(new BorderLayout());
        this.component = this.rootPanel;
        this.readOnlyLabel = new JLabel("Results are read-only");
        this.firstRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.GO_TO_START);
        this.lastRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.GO_TO_END);
        this.previousRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.PREVIOUS_TICK);
        this.nextRowsPageButton = new CommonButton(StudioIcons.LayoutEditor.Motion.NEXT_TICK);
        this.pageSizeComboBox = new ComboBox();
        this.refreshButton = new CommonButton(AllIcons.Actions.Refresh);
        this.liveUpdatesCheckBox = new JBCheckBox(DatabaseInspectorBundle.INSTANCE.message("action.live.updates", new String[0]));
        this.exportButton = new CommonButton(AllIcons.ToolbarDecorator.Export);
        this.table = new JBTable();
        this.tableScrollPane = new JBScrollPane((Component)this.table);
        this.progressBar = new JProgressBar();
        this.centerPanel = new JPanel(new BorderLayout());
        this.layeredPane = new JLayeredPane();
        this.orderBy = OrderBy.NotOrdered.INSTANCE;
        this.liveUpdatesEnabled = true;
        this.refreshEnabled = true;
        JPanel it = jPanel = new JPanel();
        boolean bl = false;
        it.setLayout(new BoxLayout(it, 0));
        JPanel tableActionsPanel = jPanel;
        this.rootPanel.add((Component)tableActionsPanel, "North");
        this.rootPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        tableActionsPanel.setName("table-actions-panel");
        tableActionsPanel.setBorder(JBUI.Borders.merge((Border)BorderFactory.createEmptyBorder(2, 0, 2, 0), (Border)IdeBorderFactory.createBorder((int)8), (boolean)true));
        Component pagingControlsPanel = this.createPagingControlsPanel();
        this.setFetchNextRowsButtonState(false);
        this.setFetchPreviousRowsButtonState(false);
        this.refreshButton.setName("refresh-button");
        this.refreshButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Actions.Refresh));
        this.refreshButton.setToolTipText("Refresh table");
        this.refreshButton.setEnabled(false);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add((Component)this.refreshButton);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.refreshDataInvoked();
                }
            }
        });
        this.liveUpdatesCheckBox.setName("live-updates-checkbox");
        this.liveUpdatesCheckBox.setEnabled(false);
        this.liveUpdatesCheckBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.toggleLiveUpdatesInvoked();
                }
            }
        });
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add((Component)this.liveUpdatesCheckBox);
        new HelpTooltip().setDescription(DatabaseInspectorBundle.INSTANCE.message("action.live.updates.desc", new String[0])).setLink(DatabaseInspectorBundle.INSTANCE.message("learn.more", new String[0]), (Runnable)3.INSTANCE).installOn((JComponent)this.liveUpdatesCheckBox);
        this.exportButton.setName("export-button");
        this.exportButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.exportButton.getIcon()));
        this.exportButton.setEnabled(false);
        new HelpTooltip().setTitle(DatabaseInspectorBundle.INSTANCE.message("action.export.button.tooltip.title", new String[0])).installOn((JComponent)this.exportButton);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add((Component)this.exportButton);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.showExportToFileDialogInvoked();
                }
            }
        });
        this.readOnlyLabel.setVisible(false);
        this.readOnlyLabel.setName("read-only-label");
        this.readOnlyLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.readOnlyLabel.setOpaque(true);
        this.readOnlyLabel.setBackground((Color)new JBColor(new Color(14478846), new Color(4606541)));
        tableActionsPanel.add(Box.createHorizontalGlue());
        tableActionsPanel.add(this.readOnlyLabel);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        tableActionsPanel.add(pagingControlsPanel);
        tableActionsPanel.add(Box.createHorizontalStrut(4));
        this.table.resetDefaultFocusTraversalKeys();
        this.table.setStriped(true);
        this.table.getEmptyText().setText(this.tableIsEmptyText);
        this.table.getEmptyText().setShowAboveCenter(false);
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new MyColoredTableCellRenderer()));
        this.table.getTableHeader().setDefaultRenderer(new MyTableHeaderRenderer());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (isLoading) {
                    return;
                }
                TableCellEditor tableCellEditor = table.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                int columnIndex = table.columnAtPoint(e.getPoint());
                if (columnIndex <= 0) {
                    return;
                }
                Iterable iterable = listeners;
                TableViewImpl tableViewImpl = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it = (TableView.Listener)element$iv;
                    boolean bl = false;
                    List list2 = tableViewImpl.columns;
                    Intrinsics.checkNotNull((Object)list2);
                    it.toggleOrderByColumnInvoked((ViewColumn)list2.get(columnIndex - 1));
                }
            }
        });
        this.table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                TableCellEditor tableCellEditor = table.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                Point mousePoint = new Point(x, y);
                int viewRowIndex = table.rowAtPoint(mousePoint);
                int viewColumnIndex = table.columnAtPoint(mousePoint);
                if (viewRowIndex < 0 || viewColumnIndex < 0) {
                    return;
                }
                table.clearSelection();
                table.addRowSelectionInterval(viewRowIndex, viewRowIndex);
                table.addColumnSelectionInterval(viewColumnIndex, viewColumnIndex);
            }
        });
        this.tableScrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setAutoResizeMode();
            }
        });
        this.centerPanel.add((Component)this.layeredPane, "Center");
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)this.tableScrollPane, "Center");
        this.tableScrollPane.setBorder((Border)JBUI.Borders.empty());
        JPanel progressBarPanel = new JPanel(new BorderLayout());
        progressBarPanel.add((Component)this.progressBar, "North");
        progressBarPanel.setOpaque(false);
        this.layeredPane.add(tablePanel);
        this.layeredPane.add(progressBarPanel);
        this.layeredPane.setLayout(new MatchParentLayoutManager());
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(true);
        this.progressBar.putClientProperty("ProgressBar.flatEnds", Boolean.TRUE);
        this.progressBar.putClientProperty("ProgressBar.stripeWidth", JBUI.scale((int)2));
        this.setUpPopUp();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @TestOnly
    @NotNull
    public final OrderBy getOrderBy() {
        return this.orderBy;
    }

    private final Component createPagingControlsPanel() {
        JPanel jPanel;
        JPanel it = jPanel = new JPanel();
        boolean bl = false;
        it.setLayout(new BoxLayout(it, 0));
        JPanel pagingControlsPanel = jPanel;
        this.firstRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.LayoutEditor.Motion.GO_TO_START));
        this.firstRowsPageButton.setToolTipText("Go to first page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.firstRowsPageButton);
        this.firstRowsPageButton.addActionListener(new ActionListener(this){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = TableViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadFirstRowsInvoked();
                }
            }
        });
        this.previousRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.LayoutEditor.Motion.PREVIOUS_TICK));
        this.previousRowsPageButton.setToolTipText("Go to previous page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.previousRowsPageButton);
        this.previousRowsPageButton.addActionListener(new ActionListener(this){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = TableViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadPreviousRowsInvoked();
                }
            }
        });
        this.pageSizeComboBox.setName("page-size-combo-box");
        this.pageSizeComboBox.setEnabled(false);
        this.pageSizeComboBox.setEditable(true);
        Iterable $this$forEach$iv = this.pageSizeDefaultValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it2 = ((Number)element$iv).intValue();
            boolean bl2 = false;
            this.pageSizeComboBox.addItem((Object)it2);
        }
        this.pageSizeComboBox.setSelectedIndex(this.pageSizeDefaultValues.size() - 1);
        this.pageSizeComboBox.setPreferredSize((Dimension)JBUI.size((int)80, (int)30));
        this.pageSizeComboBox.setMaximumSize(this.pageSizeComboBox.getPreferredSize());
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.pageSizeComboBox);
        this.pageSizeComboBox.addActionListener(new ActionListener(this){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void actionPerformed(ActionEvent it) {
                void $this$forEach$iv;
                Iterable iterable = TableViewImpl.access$getListeners$p(this.this$0);
                TableViewImpl tableViewImpl = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    Object object = TableViewImpl.access$getPageSizeComboBox$p(tableViewImpl).getSelectedItem();
                    Intrinsics.checkNotNull((Object)object);
                    it2.rowCountChanged(object.toString());
                }
            }
        });
        this.nextRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.LayoutEditor.Motion.NEXT_TICK));
        this.nextRowsPageButton.setToolTipText("Go to next page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.nextRowsPageButton);
        this.nextRowsPageButton.addActionListener(new ActionListener(this){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = TableViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadNextRowsInvoked();
                }
            }
        });
        this.lastRowsPageButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.LayoutEditor.Motion.GO_TO_END));
        this.lastRowsPageButton.setToolTipText("Go to last page");
        pagingControlsPanel.add(Box.createHorizontalStrut(2));
        pagingControlsPanel.add((Component)this.lastRowsPageButton);
        this.lastRowsPageButton.addActionListener(new ActionListener(this){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = TableViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadLastRowsInvoked();
                }
            }
        });
        return pagingControlsPanel;
    }

    @Override
    public void showPageSizeValue(int maxRowCount) {
        Object currentRowCount = this.pageSizeComboBox.getSelectedItem();
        if (!Intrinsics.areEqual((Object)currentRowCount, (Object)maxRowCount)) {
            this.pageSizeComboBox.setSelectedItem((Object)maxRowCount);
        }
    }

    @Override
    public void resetView() {
        this.columns = null;
        this.table.setModel((TableModel)new MyTableModel(CollectionsKt.emptyList()));
        this.table.getEmptyText().setText(this.tableIsEmptyText);
        this.orderBy = OrderBy.NotOrdered.INSTANCE;
        this.setEditable(true);
        this.setControlButtonsEnabled(false);
        this.setFetchNextRowsButtonState(false);
        this.setFetchPreviousRowsButtonState(false);
    }

    @Override
    public void startTableLoading() {
        this.setControlButtonsEnabled(false);
        this.progressBar.setVisible(true);
        this.table.setEnabled(false);
        this.table.getEmptyText().setText(this.loadingTableDataText);
        this.tableHadFocus = this.table.hasFocus();
        if (this.table.hasFocus()) {
            this.progressBar.requestFocusInWindow();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.isLoading = true;
    }

    @Override
    public void stopTableLoading() {
        this.myRevertLastTableCellEdit = null;
        this.setControlButtonsEnabled(true);
        this.table.getEmptyText().setText(this.tableIsEmptyText);
        this.isLoading = false;
        this.progressBar.setVisible(false);
        this.table.setEnabled(true);
        if (this.progressBar.hasFocus() && this.tableHadFocus) {
            this.table.requestFocusInWindow();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    @Override
    public void showTableColumns(@NotNull List<ViewColumn> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        if (Intrinsics.areEqual(this.columns, columns2)) {
            return;
        }
        this.columns = columns2;
        this.table.setModel((TableModel)new MyTableModel(columns2));
        if (!((Collection)columns2).isEmpty()) {
            this.table.getColumnModel().getColumn(0).setMaxWidth(JBUI.scale((int)60));
            this.table.getColumnModel().getColumn(0).setResizable(false);
            int n = this.table.getColumnModel().getColumnCount();
            for (int i = 1; i < n; ++i) {
                this.table.getColumnModel().getColumn(i).setMinWidth(JBUI.scale((int)65));
            }
            this.setAutoResizeMode();
        }
    }

    @Override
    public void updateRows(@NotNull List<? extends RowDiffOperation> rowDiffOperations) {
        Intrinsics.checkNotNullParameter(rowDiffOperations, (String)"rowDiffOperations");
        TableModel tableModel2 = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
        ((MyTableModel)tableModel2).applyRowsDiff(rowDiffOperations);
    }

    @Override
    public void setEmptyText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.table.getEmptyText().setText(text2);
    }

    @Override
    public void setRowOffset(int rowOffset) {
        TableModel tableModel2 = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
        ((MyTableModel)tableModel2).setRowOffset(rowOffset);
    }

    @Override
    public void revertLastTableCellEdit() {
        Function0<Unit> function0 = this.myRevertLastTableCellEdit;
        if (function0 != null) {
            function0.invoke();
        }
        this.myRevertLastTableCellEdit = null;
    }

    @Override
    public void setColumnSortIndicator(@NotNull OrderBy orderBy) {
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        this.orderBy = orderBy;
    }

    @Override
    public void setLiveUpdatesButtonState(boolean state2) {
        this.liveUpdatesEnabled = state2;
    }

    @Override
    public void setRefreshButtonState(boolean state2) {
        this.refreshEnabled = state2;
    }

    @Override
    public void reportError(@NotNull String message2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        UtilsKt.notifyError(message2, t);
    }

    @Override
    public void setFetchPreviousRowsButtonState(boolean enable) {
        this.previousRowsPageButton.setEnabled(enable);
        this.firstRowsPageButton.setEnabled(enable);
    }

    @Override
    public void setFetchNextRowsButtonState(boolean enable) {
        this.nextRowsPageButton.setEnabled(enable);
        this.lastRowsPageButton.setEnabled(enable);
    }

    @Override
    public void setEditable(boolean isEditable) {
        TableModel tableModel2 = this.table.getModel();
        MyTableModel myTableModel = tableModel2 instanceof MyTableModel ? (MyTableModel)tableModel2 : null;
        if (myTableModel != null) {
            myTableModel.setEditable(isEditable);
        }
        this.readOnlyLabel.setVisible(!isEditable);
    }

    @Override
    public void addListener(@NotNull TableView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull TableView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    private final void setControlButtonsEnabled(boolean enabled2) {
        this.liveUpdatesCheckBox.setEnabled(this.liveUpdatesEnabled && enabled2);
        this.refreshButton.setEnabled(this.refreshEnabled && enabled2);
        this.exportButton.setEnabled(enabled2);
        this.pageSizeComboBox.setEnabled(enabled2);
    }

    private final void setAutoResizeMode() {
        if (this.table.getPreferredSize().width < this.table.getParent().getWidth()) {
            this.table.setAutoResizeMode(2);
        } else {
            this.table.setAutoResizeMode(0);
            int n = this.table.getColumnModel().getColumnCount();
            for (int i = 1; i < n; ++i) {
                this.table.getColumnModel().getColumn(i).setPreferredWidth(JBUI.scale((int)85));
            }
        }
    }

    private final void setUpPopUp() {
        String string = DatabaseInspectorBundle.INSTANCE.message("action.set.to.null", new String[0]);
        AnAction setNullAction2 = new AnAction(this, string){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int rowIndex = TableViewImpl.access$getTable$p(this.this$0).getSelectedRow();
                int columnIndex = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                if (columnIndex > 0) {
                    TableModel tableModel2 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                    Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                    ((MyTableModel)tableModel2).setValueAt(null, rowIndex, columnIndex);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int columnIndex = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                if (columnIndex > 0) {
                    TableModel tableModel2 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                    Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                    ViewColumn column2 = ((MyTableModel)tableModel2).getColumns().get(columnIndex - 1);
                    bl = column2.isNullable();
                } else {
                    bl = false;
                }
                boolean isNullable = bl;
                TableModel tableModel3 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                MyTableModel myTableModel = tableModel3 instanceof MyTableModel ? (MyTableModel)tableModel3 : null;
                e.getPresentation().setEnabled((myTableModel != null ? myTableModel.isEditable() : false) && isNullable);
                super.update(e);
            }
        };
        Shortcut[] shortcutArray = DatabaseInspectorBundle.INSTANCE.message("action.copy.to.clipboard", new String[0]);
        AnAction copyToClipboardAction2 = new AnAction(this, (String)shortcutArray){
            final /* synthetic */ TableViewImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row2 = TableViewImpl.access$getTable$p(this.this$0).getSelectedRow();
                int column2 = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                TableModel tableModel2 = TableViewImpl.access$getTable$p(this.this$0).getModel();
                Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                String value2 = ((MyTableModel)tableModel2).getValueAt(row2, column2);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(value2), null);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int column2 = TableViewImpl.access$getTable$p(this.this$0).getSelectedColumn();
                e.getPresentation().setEnabled(column2 > 0);
                super.update(e);
            }
        };
        shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(78, 576), null)};
        setNullAction2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)this.table);
        shortcutArray = new AnAction[]{copyToClipboardAction2, setNullAction2};
        PopupHandler.installPopupMenu((JComponent)((JComponent)this.table), (ActionGroup)((ActionGroup)new DefaultActionGroup((AnAction[])shortcutArray)), (String)"SqliteTablePopup");
    }

    public static final /* synthetic */ ComboBox access$getPageSizeComboBox$p(TableViewImpl $this) {
        return $this.pageSizeComboBox;
    }

    public static final /* synthetic */ void access$setMyRevertLastTableCellEdit$p(TableViewImpl $this, Function0 function0) {
        $this.myRevertLastTableCellEdit = function0;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MatchParentLayoutManager;", "Ljava/awt/LayoutManager;", "()V", "addLayoutComponent", "", "name", "", "comp", "Ljava/awt/Component;", "layoutContainer", "parent", "Ljava/awt/Container;", "minimumLayoutSize", "Ljava/awt/Dimension;", "preferredLayoutSize", "removeLayoutComponent", "app-inspection.inspectors.database"})
    @SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MatchParentLayoutManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,722:1\n13543#2,2:723\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MatchParentLayoutManager\n*L\n702#1:723,2\n*E\n"})
    private static final class MatchParentLayoutManager
    implements LayoutManager {
        @Override
        public void layoutContainer(@NotNull Container parent2) {
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            Rectangle parentBounds = parent2.getBounds();
            if (parent2.isPreferredSizeSet()) {
                parentBounds.setSize(parent2.getPreferredSize());
            }
            Component[] componentArray = parent2.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"parent.components");
            Object[] $this$forEach$iv = componentArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                it.setBounds(parentBounds);
            }
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container parent2) {
            Dimension dimension2;
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            if (parent2.isPreferredSizeSet()) {
                Dimension dimension3 = parent2.getPreferredSize();
                dimension2 = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"parent.preferredSize");
            } else {
                dimension2 = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return dimension2;
        }

        @Override
        @NotNull
        public Dimension minimumLayoutSize(@NotNull Container parent2) {
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            return new Dimension(0, 0);
        }

        @Override
        public void addLayoutComponent(@Nullable String name2, @Nullable Component comp) {
        }

        @Override
        public void removeLayoutComponent(@Nullable Component comp) {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyColoredTableCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "()V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "focused", "viewRowIndex", "", "viewColumnIndex", "app-inspection.inspectors.database"})
    private static final class MyColoredTableCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 == null) {
                this.append("NULL", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            } else {
                this.append(StringUtils.abbreviate((String)((String)value2), (int)200));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow;", "", "values", "", "Lcom/android/tools/idea/sqlite/model/SqliteValue;", "(Ljava/util/List;)V", "getValues", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "app-inspection.inspectors.database"})
    private static final class MyRow {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<SqliteValue> values;

        public MyRow(@NotNull List<SqliteValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.values = values;
        }

        @NotNull
        public final List<SqliteValue> getValues() {
            return this.values;
        }

        @NotNull
        public final List<SqliteValue> component1() {
            return this.values;
        }

        @NotNull
        public final MyRow copy(@NotNull List<SqliteValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new MyRow(values);
        }

        public static /* synthetic */ MyRow copy$default(MyRow myRow, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = myRow.values;
            }
            return myRow.copy(list2);
        }

        @NotNull
        public String toString() {
            return "MyRow(values=" + this.values + ")";
        }

        public int hashCode() {
            return ((Object)this.values).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyRow)) {
                return false;
            }
            MyRow myRow = (MyRow)other;
            return Intrinsics.areEqual(this.values, myRow.values);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow$Companion;", "", "()V", "fromSqliteRow", "Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow;", "sqliteRow", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "app-inspection.inspectors.database"})
        @SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,722:1\n1549#2:723\n1620#2,3:724\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow$Companion\n*L\n717#1:723\n717#1:724,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MyRow fromSqliteRow(@NotNull SqliteRow sqliteRow) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)sqliteRow, (String)"sqliteRow");
                Iterable $this$map$iv = sqliteRow.getValues();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SqliteColumnValue sqliteColumnValue = (SqliteColumnValue)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getValue());
                }
                List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                return new MyRow(list2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableHeaderRenderer;", "Ljavax/swing/table/TableCellRenderer;", "(Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;)V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "focused", "viewRowIndex", "", "viewColumnIndex", "app-inspection.inspectors.database"})
    private final class MyTableHeaderRenderer
    implements TableCellRenderer {
        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            DefaultTableCellRenderer columnNameLabel = new DefaultTableCellRenderer();
            DefaultTableCellRenderer sortIcon = new DefaultTableCellRenderer();
            if (viewColumnIndex == 0) {
                columnNameLabel.setIcon(null);
                columnNameLabel.setIconTextGap(0);
                columnNameLabel.setText("");
            } else {
                Icon icon2;
                TableModel tableModel2 = table2.getModel();
                Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
                List<ViewColumn> columns2 = ((MyTableModel)tableModel2).getColumns();
                boolean inPk = columns2.get(viewColumnIndex - 1).getInPrimaryKey();
                if (inPk) {
                    columnNameLabel.setIcon(StudioIcons.DatabaseInspector.PRIMARY_KEY);
                    columnNameLabel.setIconTextGap(8);
                } else {
                    columnNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                }
                OrderBy o = TableViewImpl.this.getOrderBy();
                if (o instanceof OrderBy.NotOrdered) {
                    icon2 = AllIcons.General.ArrowSplitCenterV;
                } else if (o instanceof OrderBy.Asc) {
                    icon2 = Intrinsics.areEqual((Object)((OrderBy.Asc)o).getColumnName(), (Object)((String)value2)) ? AllIcons.General.ArrowDown : AllIcons.General.ArrowSplitCenterV;
                } else if (o instanceof OrderBy.Desc) {
                    icon2 = Intrinsics.areEqual((Object)((OrderBy.Desc)o).getColumnName(), (Object)((String)value2)) ? AllIcons.General.ArrowUp : AllIcons.General.ArrowSplitCenterV;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                sortIcon.setIcon(icon2);
                columnNameLabel.setText((String)value2);
            }
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBackground(new Color(0, 0, 0, 0));
            panel2.add((Component)columnNameLabel, "Center");
            panel2.add((Component)sortIcon, "East");
            return panel2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0003J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\"\u0010$\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableModel;", "Ljavax/swing/table/AbstractTableModel;", "columns", "", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "(Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;Ljava/util/List;)V", "getColumns", "()Ljava/util/List;", "isEditable", "", "()Z", "setEditable", "(Z)V", "rowOffset", "", "getRowOffset", "()I", "setRowOffset", "(I)V", "rows", "", "Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyRow;", "applyRowsDiff", "", "rowDiffOperations", "Lcom/android/tools/idea/sqlite/ui/tableView/RowDiffOperation;", "getColumnClass", "Ljava/lang/Class;", "", "modelColumnIndex", "getColumnCount", "getColumnName", "getRowCount", "getValueAt", "modelRowIndex", "isCellEditable", "setValueAt", "newValue", "", "app-inspection.inspectors.database"})
    @SourceDebugExtension(value={"SMAP\nTableViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,722:1\n1#2:723\n1851#3,2:724\n*S KotlinDebug\n*F\n+ 1 TableViewImpl.kt\ncom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableModel\n*L\n664#1:724,2\n*E\n"})
    private final class MyTableModel
    extends AbstractTableModel {
        @NotNull
        private final List<ViewColumn> columns;
        @NotNull
        private final List<MyRow> rows;
        private boolean isEditable;
        private int rowOffset;

        public MyTableModel(List<ViewColumn> columns2) {
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            this.columns = columns2;
            this.rows = new ArrayList();
        }

        @NotNull
        public final List<ViewColumn> getColumns() {
            return this.columns;
        }

        public final boolean isEditable() {
            return this.isEditable;
        }

        public final void setEditable(boolean bl) {
            this.isEditable = bl;
        }

        public final int getRowOffset() {
            return this.rowOffset;
        }

        public final void setRowOffset(int n) {
            this.rowOffset = n;
        }

        @Override
        @NotNull
        public String getColumnName(int modelColumnIndex) {
            return modelColumnIndex == 0 ? "" : this.columns.get(modelColumnIndex - 1).getName();
        }

        @NotNull
        public Class<String> getColumnClass(int modelColumnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.columns.isEmpty() ? 0 : this.columns.size() + 1;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        @Nullable
        public String getValueAt(int modelRowIndex, int modelColumnIndex) {
            String string;
            if (modelColumnIndex == 0) {
                string = String.valueOf(this.rowOffset + modelRowIndex + 1);
            } else {
                SqliteValue value2 = this.rows.get(modelRowIndex).getValues().get(modelColumnIndex - 1);
                if (value2 instanceof SqliteValue.StringValue) {
                    string = ((SqliteValue.StringValue)value2).getValue();
                } else if (value2 instanceof SqliteValue.NullValue) {
                    string = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void setValueAt(@Nullable Object newValue, int modelRowIndex, int modelColumnIndex) {
            v0 = var4_4 = modelColumnIndex > 0;
            if (_Assertions.ENABLED && !var4_4) {
                $i$a$-assert-TableViewImpl$MyTableModel$setValueAt$1 = false;
                $i$a$-assert-TableViewImpl$MyTableModel$setValueAt$1 = "Setting value of column at index 0 is not allowed";
                throw new AssertionError((Object)$i$a$-assert-TableViewImpl$MyTableModel$setValueAt$1);
            }
            oldValue = this.getValueAt(modelRowIndex, modelColumnIndex);
            if (Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
                return;
            }
            if (oldValue != null) ** GOTO lbl-1000
            v1 = newValue instanceof String != false ? (String)newValue : null;
            v2 = v1 != null ? ((CharSequence)v1).length() == 0 : false;
            if (v2) {
                v3 = SqliteValue.NullValue.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v3 = SqliteValue.Companion.fromAny(newValue);
            }
            newSqliteValue = v3;
            actualColumnIndex = modelColumnIndex - 1;
            column = this.columns.get(actualColumnIndex);
            this.rows.get(modelRowIndex).getValues().set(actualColumnIndex, newSqliteValue);
            this.fireTableCellUpdated(modelRowIndex, actualColumnIndex);
            TableViewImpl.access$setMyRevertLastTableCellEdit$p(TableViewImpl.this, (Function0)new Function0<Unit>(this, modelRowIndex, actualColumnIndex, oldValue){
                final /* synthetic */ MyTableModel this$0;
                final /* synthetic */ int $modelRowIndex;
                final /* synthetic */ int $actualColumnIndex;
                final /* synthetic */ String $oldValue;
                {
                    this.this$0 = $receiver;
                    this.$modelRowIndex = $modelRowIndex;
                    this.$actualColumnIndex = $actualColumnIndex;
                    this.$oldValue = $oldValue;
                    super(0);
                }

                public final void invoke() {
                    ((MyRow)MyTableModel.access$getRows$p(this.this$0).get(this.$modelRowIndex)).getValues().set(this.$actualColumnIndex, SqliteValue.Companion.fromAny(this.$oldValue));
                    this.this$0.fireTableCellUpdated(this.$modelRowIndex, this.$actualColumnIndex);
                }
            });
            $this$forEach$iv = TableViewImpl.access$getListeners$p(TableViewImpl.this);
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (TableView.Listener)element$iv;
                $i$a$-forEach-TableViewImpl$MyTableModel$setValueAt$3 = false;
                it.updateCellInvoked(modelRowIndex, column, newSqliteValue);
            }
        }

        @Override
        public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
            return modelColumnIndex != 0 && this.isEditable;
        }

        public final void applyRowsDiff(@NotNull List<? extends RowDiffOperation> rowDiffOperations) {
            Intrinsics.checkNotNullParameter(rowDiffOperations, (String)"rowDiffOperations");
            for (RowDiffOperation rowDiffOperation : rowDiffOperations) {
                RowDiffOperation rowDiffOperation2 = rowDiffOperation;
                if (rowDiffOperation2 instanceof RowDiffOperation.UpdateCell) {
                    this.rows.get(((RowDiffOperation.UpdateCell)rowDiffOperation).getRowIndex()).getValues().set(((RowDiffOperation.UpdateCell)rowDiffOperation).getColIndex(), ((RowDiffOperation.UpdateCell)rowDiffOperation).getNewValue().getValue());
                    this.fireTableCellUpdated(((RowDiffOperation.UpdateCell)rowDiffOperation).getRowIndex(), ((RowDiffOperation.UpdateCell)rowDiffOperation).getColIndex() + 1);
                    continue;
                }
                if (rowDiffOperation2 instanceof RowDiffOperation.AddRow) {
                    this.rows.add(MyRow.Companion.fromSqliteRow(((RowDiffOperation.AddRow)rowDiffOperation).getRow()));
                    this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
                    continue;
                }
                if (!(rowDiffOperation2 instanceof RowDiffOperation.RemoveLastRows)) continue;
                int oldRowsSize = this.rows.size();
                int i = oldRowsSize - 1;
                int n = ((RowDiffOperation.RemoveLastRows)rowDiffOperation).getStartIndex();
                if (n <= i) {
                    while (true) {
                        this.rows.remove(i);
                        if (i == n) break;
                        --i;
                    }
                }
                this.fireTableRowsDeleted(((RowDiffOperation.RemoveLastRows)rowDiffOperation).getStartIndex(), oldRowsSize - 1);
            }
        }

        public static final /* synthetic */ List access$getRows$p(MyTableModel $this) {
            return $this.rows;
        }
    }
}

