/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.sqliteEvaluator;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.Chunk;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.EmptyStatePanel;
import com.android.tools.adtui.stdui.LabelData;
import com.android.tools.adtui.stdui.NewLineChunk;
import com.android.tools.adtui.stdui.TextChunk;
import com.android.tools.idea.lang.androidSql.AndroidSqlLanguage;
import com.android.tools.idea.sqlite.SchemaProvider;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.sqlLanguage.SqliteSchemaContext;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.QueryHistoryView;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorViewImpl;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u001cH\u0016J\b\u0010+\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u001cH\u0016J\u001a\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0014H\u0016J \u00105\u001a\u00020\n2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0014072\b\u00108\u001a\u0004\u0018\u00010\u0014H\u0016J\u0016\u00109\u001a\u00020\n2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020/07H\u0016J\u0010\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0019H\u0016J\b\u0010=\u001a\u00020\nH\u0002J\u0010\u0010>\u001a\u00020\n2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020/H\u0016J\b\u0010A\u001a\u00020\nH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006B"}, d2={"Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;", "project", "Lcom/intellij/openapi/project/Project;", "tableView", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "schemaProvider", "Lcom/android/tools/idea/sqlite/SchemaProvider;", "dropPsiCaches", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/ui/tableView/TableView;Lcom/android/tools/idea/sqlite/SchemaProvider;Lkotlin/jvm/functions/Function0;)V", "bottomPanel", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "databaseComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "editorTextField", "Lcom/intellij/ui/EditorTextField;", "Lorg/jetbrains/annotations/NotNull;", "evaluateSqliteStatementEnabled", "", "listeners", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "queryHistoryButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "queryHistoryView", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/QueryHistoryView;", "runButton", "Ljavax/swing/JButton;", "splitterPanel", "Lcom/intellij/ui/OnePixelSplitter;", "getTableView", "()Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "addListener", "listener", "evaluateSqliteExpression", "removeListener", "reportError", "message", "", "t", "", "resetBottomPanelAndAddView", "schemaChanged", "databaseId", "setDatabases", "databaseIds", "", "selected", "setQueryHistory", "queries", "setRunSqliteStatementEnabled", "enabled", "setSchemaFromSelectedItem", "showMessagePanel", "showSqliteStatement", "sqliteStatement", "showTableView", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nSqliteEvaluatorViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteEvaluatorViewImpl.kt\ncom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,316:1\n1851#2,2:317\n1851#2,2:319\n37#3,2:321\n*S KotlinDebug\n*F\n+ 1 SqliteEvaluatorViewImpl.kt\ncom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl\n*L\n239#1:317,2\n293#1:319,2\n298#1:321,2\n*E\n"})
public final class SqliteEvaluatorViewImpl
implements SqliteEvaluatorView {
    @NotNull
    private final Project project;
    @NotNull
    private final TableView tableView;
    @NotNull
    private final SchemaProvider schemaProvider;
    @NotNull
    private final Function0<Unit> dropPsiCaches;
    @NotNull
    private final OnePixelSplitter splitterPanel;
    @NotNull
    private final JPanel bottomPanel;
    @NotNull
    private final JComponent component;
    @NotNull
    private final ComboBox<SqliteDatabaseId> databaseComboBox;
    @NotNull
    private final EditorTextField editorTextField;
    @NotNull
    private final ArrayList<SqliteEvaluatorView.Listener> listeners;
    @NotNull
    private final CommonButton queryHistoryButton;
    @NotNull
    private final JButton runButton;
    private boolean evaluateSqliteStatementEnabled;
    @NotNull
    private final QueryHistoryView queryHistoryView;

    public SqliteEvaluatorViewImpl(@NotNull Project project, @NotNull TableView tableView, @NotNull SchemaProvider schemaProvider, @NotNull Function0<Unit> dropPsiCaches) {
        JButton jButton;
        CommonButton commonButton;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableView, (String)"tableView");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter(dropPsiCaches, (String)"dropPsiCaches");
        this.project = project;
        this.tableView = tableView;
        this.schemaProvider = schemaProvider;
        this.dropPsiCaches = dropPsiCaches;
        this.splitterPanel = new OnePixelSplitter(true);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.component = (JComponent)this.splitterPanel;
        this.databaseComboBox = new ComboBox();
        EditorTextField editorTextField2 = EditorTextFieldProvider.getInstance().getEditorField((Language)AndroidSqlLanguage.INSTANCE, this.getProject(), (Iterable)CollectionsKt.listOf((Object)editorTextField.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"getInstance()\n      .get\u2026rders.empty()) })\n      )");
        this.editorTextField = editorTextField2;
        this.listeners = new ArrayList();
        this.queryHistoryButton = new CommonButton(AllIcons.Vcs.History);
        this.runButton = new JButton("Run");
        this.queryHistoryView = new QueryHistoryView(this.editorTextField);
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel controlsPanel = new JPanel(new BorderLayout());
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        topPanel.add((Component)this.editorTextField, "Center");
        topPanel.add((Component)controlsPanel, "South");
        CommonButton $this$_init__u24lambda_u240 = commonButton = this.splitterPanel;
        boolean bl = false;
        $this$_init__u24lambda_u240.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        $this$_init__u24lambda_u240.setFocusCycleRoot(false);
        $this$_init__u24lambda_u240.setProportion(0.3f);
        $this$_init__u24lambda_u240.setFirstComponent((JComponent)topPanel);
        $this$_init__u24lambda_u240.setSecondComponent((JComponent)this.bottomPanel);
        topPanel.setBorder(JBUI.Borders.empty((int)6));
        controlsPanel.setBorder((Border)JBUI.Borders.empty((int)6, (int)0, (int)0, (int)0));
        this.bottomPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        topPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        controlsPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        controlsPanel.add((Component)this.databaseComboBox);
        controlsPanel.add(Box.createRigidArea((Dimension)JBDimension.size((Dimension)new Dimension(5, 0))));
        controlsPanel.add((Component)this.queryHistoryButton);
        controlsPanel.add(Box.createHorizontalGlue());
        controlsPanel.add(this.runButton);
        CommonButton $this$_init__u24lambda_u241 = commonButton = this.databaseComboBox;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.addActionListener(new ActionListener(this){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                SqliteEvaluatorViewImpl.access$setSchemaFromSelectedItem(this.this$0);
                Object object = SqliteEvaluatorViewImpl.access$getDatabaseComboBox$p(this.this$0).getSelectedItem();
                SqliteDatabaseId sqliteDatabaseId = object instanceof SqliteDatabaseId ? (SqliteDatabaseId)object : null;
                if (sqliteDatabaseId == null) {
                    return;
                }
                SqliteDatabaseId sqliteDatabaseId2 = sqliteDatabaseId;
                Iterable $this$forEach$iv = SqliteEvaluatorViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqliteEvaluatorView.Listener it2 = (SqliteEvaluatorView.Listener)element$iv;
                    boolean bl = false;
                    it2.onDatabaseSelected(sqliteDatabaseId2);
                }
            }
        });
        $this$_init__u24lambda_u241.setMinimumAndPreferredWidth(JBUI.scale((int)300));
        $this$_init__u24lambda_u241.setMaximumSize((Dimension)JBUI.size((int)300, (int)this.databaseComboBox.getPreferredSize().height));
        $this$_init__u24lambda_u241.setRenderer((ListCellRenderer)new ColoredListCellRenderer<SqliteDatabaseId>(){

            protected void customizeCellRenderer(@NotNull JList<? extends SqliteDatabaseId> list2, @Nullable SqliteDatabaseId sqliteDatabase, int index2, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                if (sqliteDatabase != null) {
                    Icon icon2;
                    SqliteDatabaseId sqliteDatabaseId = sqliteDatabase;
                    if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
                        icon2 = StudioIcons.DatabaseInspector.DATABASE;
                    } else if (sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
                        icon2 = StudioIcons.DatabaseInspector.DATABASE_OFFLINE;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    this.setIcon(icon2);
                    this.append(sqliteDatabase.getName());
                } else {
                    this.setIcon(null);
                    this.append(DatabaseInspectorBundle.INSTANCE.message("no.databases.available", new String[0]));
                }
            }
        });
        CommonButton $this$_init__u24lambda_u242 = commonButton = this.queryHistoryButton;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Vcs.History));
        $this$_init__u24lambda_u242.setToolTipText("Show query history");
        $this$_init__u24lambda_u242.addActionListener(new ActionListener(this, topPanel, controlsPanel){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            final /* synthetic */ JPanel $topPanel;
            final /* synthetic */ JPanel $controlsPanel;
            {
                this.this$0 = $receiver;
                this.$topPanel = $topPanel;
                this.$controlsPanel = $controlsPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                SqliteEvaluatorViewImpl.access$getQueryHistoryView$p(this.this$0).show(this.this$0.getComponent(), SqliteEvaluatorViewImpl.access$getQueryHistoryButton$p(this.this$0).getX() + SqliteEvaluatorViewImpl.access$getQueryHistoryButton$p(this.this$0).getWidth() / 2, this.$topPanel.getHeight() - this.$topPanel.getBorder().getBorderInsets((Component)((Component)this.$controlsPanel)).bottom);
            }
        });
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getInstance().activeKeymap");
        Keymap active = keymap;
        Shortcut[] shortcutsMultiline = active.getShortcuts("Console.Execute.Multiline");
        KeyStroke keyStroke = KeymapUtil.getKeyStroke((ShortcutSet)((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcutsMultiline, shortcutsMultiline.length))));
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        KeyStroke keyStrokeMultiline = keyStroke;
        String string = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)((ShortcutSet)new CustomShortcutSet(keyStrokeMultiline)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcut\u2026tSet(keyStrokeMultiline))");
        String shortcutText = string;
        JButton $this$_init__u24lambda_u243 = jButton = this.runButton;
        boolean bl4 = false;
        $this$_init__u24lambda_u243.setToolTipText("Run SQLite expression (" + shortcutText + ")");
        $this$_init__u24lambda_u243.setEnabled(false);
        $this$_init__u24lambda_u243.addActionListener(new ActionListener(this){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                SqliteEvaluatorViewImpl.access$evaluateSqliteExpression(this.this$0);
            }
        });
        $this$_init__u24lambda_u243.setName("run-button");
        $this$_init__u24lambda_u243.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        JButton $this$_init__u24lambda_u244 = jButton = this.editorTextField;
        boolean bl5 = false;
        $this$_init__u24lambda_u244.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        $this$_init__u24lambda_u244.setName("editor");
        $this$_init__u24lambda_u244.setPlaceholder("Enter query...");
        DumbAwareAction.create((Consumer)new Consumer(this){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void consume(AnActionEvent it) {
                SqliteEvaluatorViewImpl.access$evaluateSqliteExpression(this.this$0);
            }
        }).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStrokeMultiline), (JComponent)this.editorTextField);
        $this$_init__u24lambda_u244.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                Iterable $this$forEach$iv = SqliteEvaluatorViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqliteEvaluatorView.Listener it = (SqliteEvaluatorView.Listener)element$iv;
                    boolean bl = false;
                    String string = event2.getDocument().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.document.text");
                    it.sqliteStatementTextChangedInvoked(string);
                }
            }
        });
    }

    public /* synthetic */ SqliteEvaluatorViewImpl(final Project project, TableView tableView, SchemaProvider schemaProvider, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = (Function0)new Function0<Unit>(){

                public final void invoke() {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(new Runnable(){

                        @Override
                        public final void run() {
                            PsiManager.getInstance((Project)project).dropPsiCaches();
                        }
                    });
                }
            };
        }
        this(project, tableView, schemaProvider, (Function0<Unit>)function0);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public TableView getTableView() {
        return this.tableView;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void schemaChanged(@NotNull SqliteDatabaseId databaseId) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Object object = this.databaseComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteDatabaseId");
        if (Intrinsics.areEqual((Object)((SqliteDatabaseId)object), (Object)databaseId)) {
            this.setSchemaFromSelectedItem();
        }
    }

    @Override
    public void setRunSqliteStatementEnabled(boolean enabled2) {
        this.evaluateSqliteStatementEnabled = enabled2;
        this.runButton.setEnabled(enabled2);
    }

    private final void evaluateSqliteExpression() {
        if (!this.evaluateSqliteStatementEnabled) {
            return;
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteEvaluatorView.Listener it = (SqliteEvaluatorView.Listener)element$iv;
            boolean bl = false;
            it.evaluateCurrentStatement();
        }
    }

    private final void setSchemaFromSelectedItem() {
        if (this.databaseComboBox.getSelectedIndex() < 0) {
            return;
        }
        Object object = this.databaseComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteDatabaseId");
        SqliteDatabaseId database = (SqliteDatabaseId)object;
        SqliteSchema schema = this.schemaProvider.getSchema(database);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance()");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        VirtualFile virtualFile = fileDocumentManager2.getFile(this.editorTextField.getDocument());
        if (virtualFile != null) {
            virtualFile.putUserData(SqliteSchemaContext.Companion.getSQLITE_SCHEMA_KEY(), (Object)schema);
        }
        this.dropPsiCaches.invoke();
    }

    @Override
    public void setDatabases(@NotNull List<? extends SqliteDatabaseId> databaseIds, @Nullable SqliteDatabaseId selected) {
        Intrinsics.checkNotNullParameter(databaseIds, (String)"databaseIds");
        this.databaseComboBox.removeAllItems();
        this.databaseComboBox.setEnabled(!((Collection)databaseIds).isEmpty());
        for (SqliteDatabaseId sqliteDatabaseId : databaseIds) {
            this.databaseComboBox.addItem((Object)sqliteDatabaseId);
        }
        if (!Intrinsics.areEqual((Object)this.databaseComboBox.getSelectedItem(), (Object)selected)) {
            this.databaseComboBox.setSelectedItem((Object)selected);
        }
    }

    @Override
    public void addListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void showSqliteStatement(@NotNull String sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        this.editorTextField.setText(sqliteStatement);
    }

    @Override
    public void reportError(@NotNull String message2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        UtilsKt.notifyError(message2, t);
    }

    @Override
    public void setQueryHistory(@NotNull List<String> queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        this.queryHistoryView.setQueryHistory(queries);
    }

    @Override
    public void showMessagePanel(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        List chunks = new ArrayList();
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)message2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            chunks.add(new TextChunk(it));
            chunks.add(NewLineChunk.INSTANCE);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.dropLast((List)chunks, (int)1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Chunk[] chunkArray = thisCollection$iv.toArray(new Chunk[0]);
        EmptyStatePanel enterOfflineModePanel2 = new EmptyStatePanel(new LabelData(Arrays.copyOf(chunkArray, chunkArray.length)), null, null, null, 14, null);
        enterOfflineModePanel2.setName("message-panel");
        this.resetBottomPanelAndAddView((JComponent)enterOfflineModePanel2);
    }

    @Override
    public void showTableView() {
        this.resetBottomPanelAndAddView(this.getTableView().getComponent());
    }

    private final void resetBottomPanelAndAddView(JComponent component2) {
        this.bottomPanel.removeAll();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)component2, "Center");
        this.bottomPanel.revalidate();
        this.bottomPanel.repaint();
    }

    public static final /* synthetic */ void access$setSchemaFromSelectedItem(SqliteEvaluatorViewImpl $this) {
        $this.setSchemaFromSelectedItem();
    }

    public static final /* synthetic */ ComboBox access$getDatabaseComboBox$p(SqliteEvaluatorViewImpl $this) {
        return $this.databaseComboBox;
    }

    public static final /* synthetic */ ArrayList access$getListeners$p(SqliteEvaluatorViewImpl $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ QueryHistoryView access$getQueryHistoryView$p(SqliteEvaluatorViewImpl $this) {
        return $this.queryHistoryView;
    }

    public static final /* synthetic */ CommonButton access$getQueryHistoryButton$p(SqliteEvaluatorViewImpl $this) {
        return $this.queryHistoryButton;
    }

    public static final /* synthetic */ void access$evaluateSqliteExpression(SqliteEvaluatorViewImpl $this) {
        $this.evaluateSqliteExpression();
    }
}

