/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.exportToFile;

import com.android.tools.idea.io.IdeFileUtils;
import com.android.tools.idea.sqlite.ui.exportToFile.IOUtils;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/sqlite/ui/exportToFile/IOUtils;", "", "()V", "endsWithSeparatorChar", "", "path", "", "getDefaultBaseDir", "Ljava/nio/file/Path;", "getHomeDir", "isValidDestinationFilePath", "pathFromText", "text", "resolveHomeDir", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nExportToFileDialogViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/IOUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,457:1\n1785#2,3:458\n*S KotlinDebug\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/IOUtils\n*L\n450#1:458,3\n*E\n"})
final class IOUtils {
    @NotNull
    public static final IOUtils INSTANCE = new IOUtils();

    private IOUtils() {
    }

    @Nullable
    public final Path pathFromText(@NotNull String text2) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (StringsKt.isBlank((CharSequence)text2)) {
            return null;
        }
        try {
            Path rawPath = Paths.get(text2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)rawPath, (String)"rawPath");
            path2 = this.resolveHomeDir(rawPath);
        }
        catch (Exception ignored) {
            path2 = null;
        }
        return path2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValidDestinationFilePath(@Nullable Path path2) {
        if (path2 == null) return false;
        if (PathKt.isDirectory((Path)path2)) return false;
        if (path2.getParent() == null) return false;
        Path path3 = path2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.parent");
        if (!PathKt.isDirectory((Path)path3)) return false;
        Path path4 = path2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path.parent");
        if (!PathKt.exists((Path)path4)) return false;
        return true;
    }

    public final boolean endsWithSeparatorChar(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return StringsKt.endsWith$default((CharSequence)((Object)StringsKt.trimEnd((CharSequence)path2)).toString(), (char)File.separatorChar, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Path resolveHomeDir(Path path2) {
        List dirs2 = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)path2, (Function1)resolveHomeDir.dirs.1.INSTANCE)));
        Path path3 = (Path)CollectionsKt.firstOrNull((List)dirs2);
        if (!Intrinsics.areEqual((Object)(path3 != null ? ((Object)path3).toString() : null), (Object)"~")) {
            return path2;
        }
        Path path4 = this.getHomeDir();
        if (path4 == null) {
            return path2;
        }
        Path homeDir = path4;
        Iterable $this$fold$iv = CollectionsKt.drop((Iterable)dirs2, (int)1);
        boolean $i$f$fold = false;
        Path accumulator$iv = homeDir;
        for (Object element$iv : $this$fold$iv) {
            void next;
            Path path5 = (Path)element$iv;
            Path acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.resolve(next.getFileName()), (String)"acc.resolve(next.fileName)");
        }
        return accumulator$iv;
    }

    private final Path getHomeDir() {
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        return virtualFile != null ? virtualFile.toNioPath() : null;
    }

    @Nullable
    public final Path getDefaultBaseDir() {
        Path path2 = IdeFileUtils.getDesktopDirectory();
        if (path2 == null) {
            path2 = this.getHomeDir();
        }
        return path2;
    }
}

