/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.exportToFile;

import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.Delimiter;
import com.android.tools.idea.sqlite.model.ExportDialogParams;
import com.android.tools.idea.sqlite.model.ExportFormat;
import com.android.tools.idea.sqlite.model.ExportRequest;
import com.android.tools.idea.sqlite.model.ModelKt;
import com.android.tools.idea.sqlite.ui.exportToFile.ExportToFileDialogLayout;
import com.android.tools.idea.sqlite.ui.exportToFile.ExportToFileDialogView;
import com.android.tools.idea.sqlite.ui.exportToFile.ExportToFileDialogViewImpl;
import com.android.tools.idea.sqlite.ui.exportToFile.IOUtils;
import com.intellij.CommonBundle;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.io.PathKt;
import com.jgoodies.common.base.Strings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020&H\u0014J\n\u0010'\u001a\u0004\u0018\u00010(H\u0002J\b\u0010)\u001a\u00020\fH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001eH\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020#H\u0014J\b\u00101\u001a\u00020\fH\u0014J\b\u00102\u001a\u000203H\u0014J\n\u00104\u001a\u0004\u0018\u00010.H\u0002J\u0010\u00105\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013H\u0016J\b\u00106\u001a\u00020\u001eH\u0002J\b\u00107\u001a\u00020\fH\u0002J\u0010\u00108\u001a\u00020#2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020#H\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010>\u001a\u00020.H\u0002J\b\u0010?\u001a\u00020#H\u0002J\b\u0010@\u001a\u00020#H\u0002J\b\u0010A\u001a\u00020#H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u00020\f*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001a\u001a\u00020\f*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001fR\u0018\u0010 \u001a\u00020\f*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\u00a8\u0006B"}, d2={"Lcom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogViewImpl;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogView;", "project", "Lcom/intellij/openapi/project/Project;", "params", "Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/model/ExportDialogParams;)V", "analyticsTracker", "Lcom/android/tools/idea/sqlite/DatabaseInspectorAnalyticsTracker;", "delimiterComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "delimiterLabel", "Lcom/intellij/ui/components/JBLabel;", "formatButtonGroup", "Ljavax/swing/ButtonGroup;", "listeners", "", "Lcom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogView$Listener;", "getParams", "()Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "getProject", "()Lcom/intellij/openapi/project/Project;", "saveLocationTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "displayName", "Lcom/android/tools/idea/sqlite/model/Delimiter;", "getDisplayName", "(Lcom/android/tools/idea/sqlite/model/Delimiter;)Ljava/lang/String;", "Lcom/android/tools/idea/sqlite/model/ExportFormat;", "(Lcom/android/tools/idea/sqlite/model/ExportFormat;)Ljava/lang/String;", "fileExtension", "getFileExtension", "addListener", "", "listener", "createCenterPanel", "Ljavax/swing/JComponent;", "createExportRequest", "Lcom/android/tools/idea/sqlite/model/ExportRequest;", "createFileName", "createFormatButton", "Ljavax/swing/JRadioButton;", "format", "createSuggestedPath", "Ljava/nio/file/Path;", "delimiterFromDisplayName", "doOKAction", "getHelpId", "getStyle", "Lcom/intellij/openapi/ui/DialogWrapper$DialogStyle;", "parseSaveLocationTextFieldPath", "removeListener", "selectedFormat", "selectedFormatExtension", "setUpSaveLocationValidation", "locationTextField", "Ljavax/swing/JTextField;", "show", "showConfirmOverwriteDialog", "", "file", "showSaveFileDialog", "updateDelimiterEnabled", "updateDestinationExtension", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nExportToFileDialogViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n1851#2,2:458\n1851#2,2:471\n123#3,2:460\n179#3,2:469\n11335#4:462\n11670#4,3:463\n1109#4,2:473\n37#5,2:466\n1#6:468\n*S KotlinDebug\n*F\n+ 1 ExportToFileDialogViewImpl.kt\ncom/android/tools/idea/sqlite/ui/exportToFile/ExportToFileDialogViewImpl\n*L\n117#1:458,2\n374#1:471,2\n124#1:460,2\n309#1:469,2\n127#1:462\n127#1:463,3\n392#1:473,2\n127#1:466,2\n*E\n"})
public final class ExportToFileDialogViewImpl
extends DialogWrapper
implements ExportToFileDialogView {
    @NotNull
    private final Project project;
    @NotNull
    private final ExportDialogParams params;
    @NotNull
    private final List<ExportToFileDialogView.Listener> listeners;
    @NotNull
    private final DatabaseInspectorAnalyticsTracker analyticsTracker;
    private ButtonGroup formatButtonGroup;
    private JBLabel delimiterLabel;
    private ComboBox<String> delimiterComboBox;
    private TextFieldWithBrowseButton saveLocationTextField;

    public ExportToFileDialogViewImpl(@NotNull Project project, @NotNull ExportDialogParams params2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        super(project, true);
        this.project = project;
        this.params = params2;
        this.listeners = new ArrayList();
        this.analyticsTracker = DatabaseInspectorAnalyticsTracker.Companion.getInstance(this.project);
        ExportDialogParams exportDialogParams = this.params;
        if (exportDialogParams instanceof ExportDialogParams.ExportDatabaseDialogParams) {
            string = "Database";
        } else if (exportDialogParams instanceof ExportDialogParams.ExportTableDialogParams) {
            string = "Table";
        } else if (exportDialogParams instanceof ExportDialogParams.ExportQueryResultsDialogParams) {
            string = "Query Results";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String source = string;
        this.setTitle("Export " + source);
        this.setOKButtonText("Export");
        this.setCancelButtonText("Cancel");
        super.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ExportDialogParams getParams() {
        return this.params;
    }

    @Override
    public void show() {
        this.analyticsTracker.trackExportDialogOpened(this.params.getActionOrigin());
        super.show();
    }

    @NotNull
    protected String getHelpId() {
        return "org.jetbrains.android./r/studio-ui/db-inspector-help";
    }

    @Override
    public void addListener(@NotNull ExportToFileDialogView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull ExportToFileDialogView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        ComboBox<String> comboBox2;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object e2;
        Delimiter[] $this$first$iv;
        JRadioButton formatCsvRadioButton;
        JRadioButton formatSqlRadioButton;
        JRadioButton formatDbRadioButton;
        JBLabel formatLabel;
        block15: {
            boolean bl;
            formatLabel = new JBLabel("File type:");
            this.formatButtonGroup = new ButtonGroup();
            formatDbRadioButton = this.createFormatButton(ExportFormat.DB.INSTANCE);
            formatSqlRadioButton = this.createFormatButton(ExportFormat.SQL.INSTANCE);
            formatCsvRadioButton = this.createFormatButton(new ExportFormat.CSV(Delimiter.SEMICOLON));
            Object[] objectArray = new JRadioButton[]{formatDbRadioButton, formatSqlRadioButton, formatCsvRadioButton};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                JRadioButton button = (JRadioButton)t;
                bl = false;
                ButtonGroup buttonGroup = this.formatButtonGroup;
                if (buttonGroup == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"formatButtonGroup");
                    buttonGroup = null;
                }
                buttonGroup.add(button);
                button.addActionListener(new ActionListener(this){
                    final /* synthetic */ ExportToFileDialogViewImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void actionPerformed(ActionEvent it) {
                        ExportToFileDialogViewImpl.access$updateDelimiterEnabled(this.this$0);
                        ExportToFileDialogViewImpl.access$updateDestinationExtension(this.this$0);
                    }
                });
            }
            ButtonGroup buttonGroup = this.formatButtonGroup;
            if (buttonGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"formatButtonGroup");
                buttonGroup = null;
            }
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"formatButtonGroup.elements");
            $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$first = false;
            for (Object e2 : $this$first$iv) {
                AbstractButton it = (AbstractButton)e2;
                bl = false;
                if (!it.isVisible()) continue;
                break block15;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        ((AbstractButton)e2).setSelected(true);
        $this$first$iv = Delimiter.values();
        ExportToFileDialogViewImpl exportToFileDialogViewImpl = this;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection collection2 = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_19 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection3 = collection2;
            boolean bl = false;
            collection3.add(this.getDisplayName((Delimiter)it));
        }
        $this$map$iv = (List)collection2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        exportToFileDialogViewImpl.delimiterComboBox = new ComboBox(objectArray);
        this.delimiterLabel = new JBLabel(DatabaseInspectorBundle.INSTANCE.message("export.dialog.delimiter.label", new String[0]));
        JBLabel jBLabel = this.delimiterLabel;
        if (jBLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterLabel");
            jBLabel = null;
        }
        if ((comboBox2 = this.delimiterComboBox) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
            comboBox2 = null;
        }
        jBLabel.setLabelFor((Component)comboBox2);
        this.updateDelimiterEnabled();
        this.saveLocationTextField = new TextFieldWithBrowseButton();
        JBLabel saveLocationLabel = new JBLabel(DatabaseInspectorBundle.INSTANCE.message("export.dialog.output.location.label", new String[0]));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.saveLocationTextField;
        if (textFieldWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton2 = null;
        }
        saveLocationLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        Path path2 = this.createSuggestedPath();
        if (path2 != null) {
            Path path3 = path2;
            boolean bl = false;
            TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.saveLocationTextField;
            if (textFieldWithBrowseButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
                textFieldWithBrowseButton3 = null;
            }
            textFieldWithBrowseButton3.setText(((Object)path3).toString());
        }
        if ((textFieldWithBrowseButton = this.saveLocationTextField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ExportToFileDialogViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                ExportToFileDialogViewImpl.access$showSaveFileDialog(this.this$0);
            }
        });
        TextFieldWithBrowseButton textFieldWithBrowseButton4 = this.saveLocationTextField;
        if (textFieldWithBrowseButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton4 = null;
        }
        JTextField jTextField = textFieldWithBrowseButton4.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"saveLocationTextField.textField");
        this.setUpSaveLocationValidation(jTextField);
        JComponent jComponent = (JComponent)formatLabel;
        JComponent jComponent2 = formatDbRadioButton;
        JComponent jComponent3 = formatSqlRadioButton;
        JComponent jComponent4 = formatCsvRadioButton;
        JBLabel jBLabel2 = this.delimiterLabel;
        if (jBLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterLabel");
            jBLabel2 = null;
        }
        JComponent jComponent5 = (JComponent)jBLabel2;
        ComboBox<String> comboBox3 = this.delimiterComboBox;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
            comboBox3 = null;
        }
        JComponent jComponent6 = (JComponent)comboBox3;
        JComponent jComponent7 = (JComponent)saveLocationLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton5 = this.saveLocationTextField;
        if (textFieldWithBrowseButton5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton5 = null;
        }
        return ExportToFileDialogLayout.INSTANCE.createLayout(jComponent, jComponent2, jComponent3, jComponent4, jComponent5, jComponent6, jComponent7, (JComponent)textFieldWithBrowseButton5);
    }

    private final void setUpSaveLocationValidation(JTextField locationTextField) {
        new ComponentValidator(this.getDisposable()).withValidator(new Supplier(this, locationTextField){
            final /* synthetic */ ExportToFileDialogViewImpl this$0;
            final /* synthetic */ JTextField $locationTextField;
            {
                this.this$0 = $receiver;
                this.$locationTextField = $locationTextField;
            }

            @Nullable
            public final ValidationInfo get() {
                ValidationInfo validationError = ExportToFileDialogViewImpl.access$setUpSaveLocationValidation$getValidationError(this.this$0, this.$locationTextField);
                this.this$0.setOKActionEnabled(validationError == null);
                return validationError;
            }
        }).installOn((JComponent)locationTextField);
        locationTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(locationTextField){
            final /* synthetic */ JTextField $locationTextField;
            {
                this.$locationTextField = $locationTextField;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ExportToFileDialogViewImpl.access$setUpSaveLocationValidation$runValidator(this.$locationTextField);
            }
        });
        ExportToFileDialogViewImpl.setUpSaveLocationValidation$runValidator(locationTextField);
    }

    private final void showSaveFileDialog() {
        VirtualFileWrapper selectedFile;
        String[] stringArray = new String[]{this.selectedFormatExtension()};
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save as...", "", stringArray), (Component)this.getContentPanel());
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"getInstance()\n        .c\u2026   contentPanel\n        )");
        FileSaverDialog dialog2 = fileSaverDialog;
        Path pathSuggestion = this.createSuggestedPath();
        Path parent2 = pathSuggestion == null ? IOUtils.INSTANCE.getDefaultBaseDir() : (PathKt.isDirectory((Path)pathSuggestion) ? pathSuggestion : (pathSuggestion.getParent() == null ? IOUtils.INSTANCE.getDefaultBaseDir() : pathSuggestion.getParent()));
        String fileName = pathSuggestion == null || PathKt.isDirectory((Path)pathSuggestion) ? this.createFileName() : ((Object)pathSuggestion.getFileName()).toString();
        VirtualFileWrapper virtualFileWrapper = selectedFile = dialog2.save(parent2, fileName);
        if (virtualFileWrapper != null) {
            VirtualFileWrapper it = virtualFileWrapper;
            boolean bl = false;
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.saveLocationTextField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
                textFieldWithBrowseButton = null;
            }
            textFieldWithBrowseButton.setText(it.getFile().getAbsolutePath());
        }
        this.toFront();
    }

    private final JRadioButton createFormatButton(ExportFormat format) {
        JRadioButton jRadioButton;
        boolean isSupported = ModelKt.isInMemoryDatabase(this.params.getSrcDatabase()) ? format instanceof ExportFormat.CSV : (format instanceof ExportFormat.DB ? this.params instanceof ExportDialogParams.ExportDatabaseDialogParams : (format instanceof ExportFormat.SQL ? !(this.params instanceof ExportDialogParams.ExportQueryResultsDialogParams) : format instanceof ExportFormat.CSV));
        JRadioButton $this$createFormatButton_u24lambda_u245 = jRadioButton = new JRadioButton(this.getDisplayName(format));
        boolean bl = false;
        $this$createFormatButton_u24lambda_u245.setVisible(isSupported);
        $this$createFormatButton_u24lambda_u245.setEnabled(isSupported);
        return jRadioButton;
    }

    private final void updateDelimiterEnabled() {
        boolean enabled2 = this.selectedFormat() instanceof ExportFormat.CSV;
        JBLabel jBLabel = this.delimiterLabel;
        if (jBLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterLabel");
            jBLabel = null;
        }
        jBLabel.setEnabled(enabled2);
        ComboBox<String> comboBox2 = this.delimiterComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
            comboBox2 = null;
        }
        comboBox2.setEnabled(enabled2);
    }

    private final Path parseSaveLocationTextFieldPath() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.saveLocationTextField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton = null;
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"saveLocationTextField.text");
        return IOUtils.INSTANCE.pathFromText(string);
    }

    private final Path createSuggestedPath() {
        Path path2 = this.parseSaveLocationTextFieldPath();
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            return it;
        }
        Path path3 = IOUtils.INSTANCE.getDefaultBaseDir();
        if (path3 == null) {
            return null;
        }
        Path baseDir2 = path3;
        String fileName = this.createFileName();
        return baseDir2.resolve(fileName);
    }

    private final String createFileName() {
        Object object;
        String databaseName = this.params.getSrcDatabase().getName();
        ExportDialogParams exportDialogParams = this.params;
        if (exportDialogParams instanceof ExportDialogParams.ExportDatabaseDialogParams) {
            object = databaseName;
        } else if (exportDialogParams instanceof ExportDialogParams.ExportTableDialogParams) {
            object = databaseName + "-" + ((ExportDialogParams.ExportTableDialogParams)this.params).getSrcTable();
        } else if (exportDialogParams instanceof ExportDialogParams.ExportQueryResultsDialogParams) {
            object = databaseName + "-query-results";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string = FileUtil.sanitizeFileName((String)object, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(\n      \u2026 },\n        false\n      )");
        String baseFileName = string;
        String extension = this.selectedFormatExtension();
        Object extensionPart = StringsKt.isBlank((CharSequence)extension) ? "" : "." + extension;
        return baseFileName + (String)extensionPart;
    }

    private final void updateDestinationExtension() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.saveLocationTextField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton = null;
        }
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"saveLocationTextField.text");
        if (StringsKt.isBlank((CharSequence)string)) {
            return;
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.saveLocationTextField;
        if (textFieldWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton2 = null;
        }
        File currentPath = new File(textFieldWithBrowseButton2.getText());
        String fileName = currentPath.getName();
        String fileNameNoExt = FilesKt.getNameWithoutExtension((File)currentPath);
        String newExtension = this.selectedFormatExtension();
        String newFileName2 = fileNameNoExt + "." + newExtension;
        String string2 = currentPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentPath.toString()");
        String currentPathStr = string2;
        CharSequence charSequence = currentPathStr;
        Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
        int fileNameLocation = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)fileName, (int)0, (boolean)false, (int)6, null);
        String string3 = currentPathStr.substring(0, fileNameLocation);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String newPath = string3 + newFileName2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.saveLocationTextField;
        if (textFieldWithBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
            textFieldWithBrowseButton3 = null;
        }
        textFieldWithBrowseButton3.setText(newPath);
    }

    private final String selectedFormatExtension() {
        ExportFormat selectedFormat = this.selectedFormat();
        if (this.params instanceof ExportDialogParams.ExportDatabaseDialogParams && selectedFormat instanceof ExportFormat.CSV) {
            return "zip";
        }
        return this.getFileExtension(selectedFormat);
    }

    private final ExportFormat selectedFormat() {
        ExportFormat exportFormat;
        String buttonText;
        Object v2;
        block9: {
            ButtonGroup buttonGroup = this.formatButtonGroup;
            if (buttonGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"formatButtonGroup");
                buttonGroup = null;
            }
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"formatButtonGroup.elements");
            Sequence $this$firstOrNull$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AbstractButton it = (AbstractButton)element$iv;
                boolean bl = false;
                if (!it.isSelected()) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        AbstractButton abstractButton = v2;
        String string = buttonText = abstractButton != null ? abstractButton.getText() : null;
        if (Intrinsics.areEqual((Object)string, (Object)this.getDisplayName(ExportFormat.DB.INSTANCE))) {
            exportFormat = ExportFormat.DB.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getDisplayName(ExportFormat.SQL.INSTANCE))) {
            exportFormat = ExportFormat.SQL.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getDisplayName(new ExportFormat.CSV(Delimiter.SEMICOLON)))) {
            ComboBox<String> comboBox2 = this.delimiterComboBox;
            if (comboBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delimiterComboBox");
                comboBox2 = null;
            }
            Object object = comboBox2.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"delimiterComboBox.item");
            exportFormat = new ExportFormat.CSV(this.delimiterFromDisplayName((String)object));
        } else {
            throw new IllegalStateException("Expected an export format to be selected.");
        }
        return exportFormat;
    }

    private final ExportRequest createExportRequest() {
        ExportRequest exportRequest;
        ExportFormat format;
        Path dstPath;
        block11: {
            block10: {
                dstPath = this.parseSaveLocationTextFieldPath();
                format = this.selectedFormat();
                if (dstPath == null || !IOUtils.INSTANCE.isValidDestinationFilePath(dstPath)) break block10;
                TextFieldWithBrowseButton textFieldWithBrowseButton = this.saveLocationTextField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationTextField");
                    textFieldWithBrowseButton = null;
                }
                String string = textFieldWithBrowseButton.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"saveLocationTextField.text");
                if (!IOUtils.INSTANCE.endsWithSeparatorChar(string) && this.showConfirmOverwriteDialog(this.project, dstPath)) break block11;
            }
            return null;
        }
        ExportDialogParams exportDialogParams = this.params;
        if (exportDialogParams instanceof ExportDialogParams.ExportDatabaseDialogParams) {
            exportRequest = new ExportRequest.ExportDatabaseRequest(this.params.getSrcDatabase(), format, dstPath);
        } else if (exportDialogParams instanceof ExportDialogParams.ExportTableDialogParams) {
            exportRequest = new ExportRequest.ExportTableRequest(this.params.getSrcDatabase(), ((ExportDialogParams.ExportTableDialogParams)this.params).getSrcTable(), format, dstPath);
        } else if (exportDialogParams instanceof ExportDialogParams.ExportQueryResultsDialogParams) {
            exportRequest = new ExportRequest.ExportQueryResultsRequest(this.params.getSrcDatabase(), ((ExportDialogParams.ExportQueryResultsDialogParams)this.params).getQuery(), format, dstPath);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportRequest;
    }

    private final boolean showConfirmOverwriteDialog(Project project, Path file2) {
        if (!PathKt.exists((Path)file2)) {
            return true;
        }
        String[] stringArray = new String[]{((Object)file2.getFileName()).toString(), ((Object)file2.getParent()).toString()};
        int result2 = Messages.showYesNoDialog((Project)project, (String)DatabaseInspectorBundle.INSTANCE.message("export.dialog.file.already.exists.overwrite.prompt", stringArray), (String)DatabaseInspectorBundle.INSTANCE.message("export.dialog.file.already.exists.overwrite.title", new String[0]), (String)CommonBundle.message((String)"button.overwrite", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        return result2 == 0;
    }

    protected void doOKAction() {
        block1: {
            ExportRequest exportRequest = this.createExportRequest();
            if (exportRequest == null) break block1;
            ExportRequest params2 = exportRequest;
            boolean bl = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExportToFileDialogView.Listener it = (ExportToFileDialogView.Listener)element$iv;
                boolean bl2 = false;
                it.exportRequestSubmitted(params2);
            }
            super.doOKAction();
        }
    }

    private final String getDisplayName(Delimiter $this$displayName) {
        return DatabaseInspectorBundle.INSTANCE.message(switch (WhenMappings.$EnumSwitchMapping$0[$this$displayName.ordinal()]) {
            case 1 -> "export.dialog.delimiter.semicolon.label";
            case 2 -> "export.dialog.delimiter.tab.label";
            case 3 -> "export.dialog.delimiter.comma.label";
            case 4 -> "export.dialog.delimiter.vertical_bar.label";
            case 5 -> "export.dialog.delimiter.space.label";
            default -> throw new NoWhenBranchMatchedException();
        }, new String[0]);
    }

    private final Delimiter delimiterFromDisplayName(String displayName2) {
        Delimiter element$iv;
        block2: {
            Delimiter[] $this$first$iv = Delimiter.values();
            boolean $i$f$first = false;
            int n = $this$first$iv.length;
            for (int i = 0; i < n; ++i) {
                Delimiter it = element$iv = $this$first$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.getDisplayName(it), (Object)displayName2)) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        return element$iv;
    }

    private final String getFileExtension(ExportFormat $this$fileExtension) {
        String string;
        ExportFormat exportFormat = $this$fileExtension;
        if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.DB.INSTANCE)) {
            string = "db";
        } else if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.SQL.INSTANCE)) {
            string = "sql";
        } else if (exportFormat instanceof ExportFormat.CSV) {
            string = "csv";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getDisplayName(ExportFormat $this$displayName) {
        String string;
        ExportFormat exportFormat = $this$displayName;
        if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.DB.INSTANCE)) {
            string = "DB";
        } else if (Intrinsics.areEqual((Object)exportFormat, (Object)ExportFormat.SQL.INSTANCE)) {
            string = "SQL";
        } else if (exportFormat instanceof ExportFormat.CSV) {
            string = "CSV";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final ValidationInfo setUpSaveLocationValidation$getValidationError(ExportToFileDialogViewImpl this$0, JTextField $locationTextField) {
        String string;
        Path path2 = this$0.parseSaveLocationTextFieldPath();
        String pathString = $locationTextField.getText();
        if (IOUtils.INSTANCE.isValidDestinationFilePath(path2)) {
            Intrinsics.checkNotNullExpressionValue((Object)pathString, (String)"pathString");
            if (!IOUtils.INSTANCE.endsWithSeparatorChar(pathString)) {
                return null;
            }
        }
        if (Strings.isBlank((String)pathString)) {
            string = "Path not defined";
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)pathString, (String)"pathString");
            if (IOUtils.INSTANCE.endsWithSeparatorChar(pathString)) {
                string = "File name not specified";
            } else if (path2 == null) {
                string = "Path is invalid";
            } else if (PathKt.isDirectory((Path)path2)) {
                string = "Path is an existing directory";
            } else if (path2.getParent() == null) {
                string = "Parent directory not defined";
            } else {
                Path path3 = path2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.parent");
                string = !PathKt.exists((Path)path3) ? "Parent directory does not exist" : "Path is invalid";
            }
        }
        String errorMessage = string;
        return new ValidationInfo(errorMessage, (JComponent)$locationTextField);
    }

    private static final void setUpSaveLocationValidation$runValidator(JTextField $locationTextField) {
        ComponentValidator.getInstance((JComponent)$locationTextField).ifPresent(setUpSaveLocationValidation.runValidator.1.INSTANCE);
    }

    public static final /* synthetic */ void access$showSaveFileDialog(ExportToFileDialogViewImpl $this) {
        $this.showSaveFileDialog();
    }

    public static final /* synthetic */ ValidationInfo access$setUpSaveLocationValidation$getValidationError(ExportToFileDialogViewImpl this$0, JTextField $locationTextField) {
        return ExportToFileDialogViewImpl.setUpSaveLocationValidation$getValidationError(this$0, $locationTextField);
    }

    public static final /* synthetic */ void access$setUpSaveLocationValidation$runValidator(JTextField $locationTextField) {
        ExportToFileDialogViewImpl.setUpSaveLocationValidation$runValidator($locationTextField);
    }

    public static final /* synthetic */ void access$updateDelimiterEnabled(ExportToFileDialogViewImpl $this) {
        $this.updateDelimiterEnabled();
    }

    public static final /* synthetic */ void access$updateDestinationExtension(ExportToFileDialogViewImpl $this) {
        $this.updateDestinationExtension();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Delimiter.values().length];
            try {
                nArray[Delimiter.SEMICOLON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.TAB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.COMMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.VERTICAL_BAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Delimiter.SPACE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

