/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.model;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.lang.androidSql.parser.AndroidSqlParserDefinition;
import com.android.tools.idea.sqlite.model.DatabaseInspectorModel;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteAffinity;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteStatementType;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007*\u00020\u000f\u001a&\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0014\u00a8\u0006\u0015"}, d2={"createSqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "project", "Lcom/intellij/openapi/project/Project;", "sqliteStatementText", "", "parametersValues", "", "Lcom/android/tools/idea/sqlite/model/SqliteValue;", "getRowIdName", "Lcom/android/tools/idea/sqlite/model/RowIdName;", "columns", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "getAllDatabaseIds", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel;", "transform", "newStatementType", "Lcom/android/tools/idea/sqlite/model/SqliteStatementType;", "func", "Lkotlin/Function1;", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/android/tools/idea/sqlite/model/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1743#2,3:95\n2620#2,3:98\n2620#2,3:101\n2620#2,3:104\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/android/tools/idea/sqlite/model/UtilsKt\n*L\n42#1:95,3\n45#1:98,3\n46#1:101,3\n47#1:104,3\n*E\n"})
public final class UtilsKt {
    @Nullable
    public static final RowIdName getRowIdName(@NotNull List<SqliteColumn> columns2) {
        RowIdName rowIdName;
        SqliteColumn it;
        boolean bl;
        block18: {
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Iterable $this$any$iv = columns2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (SqliteColumn)element$iv;
                    boolean bl2 = false;
                    if (!(it.getInPrimaryKey() && it.getAffinity() == SqliteAffinity.INTEGER)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        boolean hasIntegerPrimaryKey = bl;
        if (hasIntegerPrimaryKey) {
            rowIdName = null;
        } else {
            boolean bl3;
            boolean $i$f$none;
            Iterable $this$none$iv;
            block19: {
                $this$none$iv = columns2;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (SqliteColumn)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)RowIdName._ROWID_.getStringName())) continue;
                        bl3 = false;
                        break block19;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                rowIdName = RowIdName._ROWID_;
            } else {
                boolean bl5;
                block20: {
                    $this$none$iv = columns2;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (SqliteColumn)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)RowIdName.ROWID.getStringName())) continue;
                            bl5 = false;
                            break block20;
                        }
                        bl5 = true;
                    }
                }
                if (bl5) {
                    rowIdName = RowIdName.ROWID;
                } else {
                    boolean bl7;
                    block21: {
                        $this$none$iv = columns2;
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (SqliteColumn)element$iv;
                                boolean bl8 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)RowIdName.OID.getStringName())) continue;
                                bl7 = false;
                                break block21;
                            }
                            bl7 = true;
                        }
                    }
                    rowIdName = bl7 ? RowIdName.OID : null;
                }
            }
        }
        return rowIdName;
    }

    @NotNull
    public static final SqliteStatement transform(@NotNull SqliteStatement $this$transform, @NotNull SqliteStatementType newStatementType, @NotNull Function1<? super String, String> func) {
        Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)newStatementType), (String)"newStatementType");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        String newStatement = (String)func.invoke((Object)$this$transform.getSqliteStatementText());
        String newStatementStringRepresentation = (String)func.invoke((Object)$this$transform.getSqliteStatementWithInlineParameters());
        return new SqliteStatement(newStatementType, newStatement, $this$transform.getParametersValues(), newStatementStringRepresentation);
    }

    @UiThread
    @NotNull
    public static final SqliteStatement createSqliteStatement(@NotNull Project project, @NotNull String sqliteStatementText, @NotNull List<? extends SqliteValue> parametersValues) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqliteStatementText, (String)"sqliteStatementText");
        Intrinsics.checkNotNullParameter(parametersValues, (String)"parametersValues");
        PsiFile psiElement = AndroidSqlParserDefinition.Companion.parseSqlQuery(project, sqliteStatementText);
        String statementStringRepresentation = com.android.tools.idea.sqlite.sqlLanguage.UtilsKt.inlineParameterValues((PsiElement)psiElement, new LinkedList(parametersValues));
        SqliteStatementType statementType = com.android.tools.idea.sqlite.sqlLanguage.UtilsKt.getSqliteStatementType(project, sqliteStatementText);
        String sqliteStatementTextWithNoTrailingSemicolon = com.android.tools.idea.sqlite.sqlLanguage.UtilsKt.getWrappableStatement(project, sqliteStatementText);
        return new SqliteStatement(statementType, sqliteStatementTextWithNoTrailingSemicolon, parametersValues, statementStringRepresentation);
    }

    public static /* synthetic */ SqliteStatement createSqliteStatement$default(Project project, String string, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return UtilsKt.createSqliteStatement(project, string, list2);
    }

    @NotNull
    public static final List<SqliteDatabaseId> getAllDatabaseIds(@NotNull DatabaseInspectorModel $this$getAllDatabaseIds) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllDatabaseIds, (String)"<this>");
        return CollectionsKt.plus((Collection)$this$getAllDatabaseIds.getOpenDatabaseIds(), (Iterable)$this$getAllDatabaseIds.getCloseDatabaseIds());
    }
}

