/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.model;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.sqlite.model.DatabaseInspectorModel;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.intellij.openapi.application.ApplicationManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl;", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel;", "()V", "closeDatabases", "", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "listeners", "", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel$Listener;", "openDatabases", "", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "addDatabaseSchema", "", "databaseId", "sqliteSchema", "addListener", "modelListener", "clearDatabases", "getCloseDatabaseIds", "", "getDatabaseSchema", "getOpenDatabaseIds", "removeDatabaseSchema", "removeListener", "updateSchema", "newSchema", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nDatabaseInspectorModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseInspectorModel.kt\ncom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1851#2,2:134\n1851#2,2:136\n1851#2,2:138\n1851#2,2:140\n*S KotlinDebug\n*F\n+ 1 DatabaseInspectorModel.kt\ncom/android/tools/idea/sqlite/model/DatabaseInspectorModelImpl\n*L\n83#1:134,2\n97#1:136,2\n108#1:138,2\n117#1:140,2\n*E\n"})
public final class DatabaseInspectorModelImpl
implements DatabaseInspectorModel {
    @NotNull
    private final List<DatabaseInspectorModel.Listener> listeners = new ArrayList();
    @NotNull
    private final Map<SqliteDatabaseId, SqliteSchema> openDatabases = new LinkedHashMap();
    @NotNull
    private final Set<SqliteDatabaseId> closeDatabases = new LinkedHashSet();

    @Override
    @NotNull
    public List<SqliteDatabaseId> getOpenDatabaseIds() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return CollectionsKt.toList((Iterable)this.openDatabases.keySet());
    }

    @Override
    @NotNull
    public List<SqliteDatabaseId> getCloseDatabaseIds() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return CollectionsKt.toList((Iterable)this.closeDatabases);
    }

    @Override
    @Nullable
    public SqliteSchema getDatabaseSchema(@NotNull SqliteDatabaseId databaseId) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.openDatabases.get(databaseId);
    }

    @Override
    public void addDatabaseSchema(@NotNull SqliteDatabaseId databaseId, @NotNull SqliteSchema sqliteSchema) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Intrinsics.checkNotNullParameter((Object)sqliteSchema, (String)"sqliteSchema");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.closeDatabases.remove(databaseId);
        this.openDatabases.put(databaseId, sqliteSchema);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            it.onDatabasesChanged(CollectionsKt.toList((Iterable)this.openDatabases.keySet()), CollectionsKt.toList((Iterable)this.closeDatabases));
        }
    }

    @Override
    public void removeDatabaseSchema(@NotNull SqliteDatabaseId databaseId) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.openDatabases.remove(databaseId);
        if (databaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
            this.closeDatabases.add(databaseId);
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            it.onDatabasesChanged(CollectionsKt.toList((Iterable)this.openDatabases.keySet()), CollectionsKt.toList((Iterable)this.closeDatabases));
        }
    }

    @Override
    public void updateSchema(@NotNull SqliteDatabaseId databaseId, @NotNull SqliteSchema newSchema) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Intrinsics.checkNotNullParameter((Object)newSchema, (String)"newSchema");
        ApplicationManager.getApplication().assertIsDispatchThread();
        SqliteSchema sqliteSchema = this.openDatabases.get(databaseId);
        if (sqliteSchema == null) {
            return;
        }
        SqliteSchema oldSchema = sqliteSchema;
        this.openDatabases.put(databaseId, newSchema);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            it.onSchemaChanged(databaseId, oldSchema, newSchema);
        }
    }

    @Override
    public void clearDatabases() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.openDatabases.clear();
        this.closeDatabases.clear();
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseInspectorModel.Listener it = (DatabaseInspectorModel.Listener)element$iv;
            boolean bl = false;
            it.onDatabasesChanged(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
    }

    @Override
    public void addListener(@NotNull DatabaseInspectorModel.Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.listeners.add(modelListener2);
        modelListener2.onDatabasesChanged(CollectionsKt.toList((Iterable)this.openDatabases.keySet()), CollectionsKt.toList((Iterable)this.closeDatabases));
    }

    @Override
    public void removeListener(@NotNull DatabaseInspectorModel.Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.listeners.remove(modelListener2);
    }
}

