/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSetKt;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.PagedLiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ3\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\r0\f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/live/PagedLiveSqliteResultSet;", "Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveSqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "messenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "connectionId", "", "taskExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/idea/sqlite/model/SqliteStatement;Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;ILjava/util/concurrent/Executor;)V", "columns", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Lcom/android/tools/idea/sqlite/model/ResultSetSqliteColumn;", "getColumns", "()Lcom/google/common/util/concurrent/ListenableFuture;", "totalRowCount", "getTotalRowCount", "getRowBatch", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "rowOffset", "rowBatchSize", "responseSizeByteLimitHint", "", "(IILjava/lang/Long;)Lcom/google/common/util/concurrent/ListenableFuture;", "app-inspection.inspectors.database"})
public final class PagedLiveSqliteResultSet
extends LiveSqliteResultSet {
    @NotNull
    private final SqliteStatement sqliteStatement;
    @NotNull
    private final Executor taskExecutor;

    public PagedLiveSqliteResultSet(@NotNull SqliteStatement sqliteStatement, @NotNull DatabaseInspectorMessenger messenger, int connectionId, @NotNull Executor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        super(sqliteStatement, messenger, connectionId, taskExecutor);
        this.sqliteStatement = sqliteStatement;
        this.taskExecutor = taskExecutor;
    }

    @Override
    @NotNull
    public ListenableFuture<List<ResultSetSqliteColumn>> getColumns() {
        return UtilsKt.mapToColumns((ListenableFuture<SqliteInspectorProtocol.Response>)LiveSqliteResultSet.sendQueryCommand$default(this, this.toSelectLimitOffset(this.sqliteStatement, 0, 1), null, 2, null), this.taskExecutor);
    }

    @Override
    @NotNull
    public ListenableFuture<Integer> getTotalRowCount() {
        return FutureUtils.transform((ListenableFuture)LiveSqliteResultSet.sendQueryCommand$default(this, this.toRowCountStatement(this.sqliteStatement), null, 2, null), (Executor)this.taskExecutor, (Function1)totalRowCount.1.INSTANCE);
    }

    @Override
    @NotNull
    public ListenableFuture<List<SqliteRow>> getRowBatch(int rowOffset, int rowBatchSize, @Nullable Long responseSizeByteLimitHint) {
        SqliteResultSetKt.checkOffsetAndSize(rowOffset, rowBatchSize);
        return FutureUtils.transform(this.sendQueryCommand(this.toSelectLimitOffset(this.sqliteStatement, rowOffset, rowBatchSize), responseSizeByteLimitHint), (Executor)this.taskExecutor, (Function1)getRowBatch.1.INSTANCE);
    }
}

