/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.LazyLiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveDatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.PagedLiveSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteStatementType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveDatabaseConnection;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "messenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "id", "", "taskExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;ILjava/util/concurrent/Executor;)V", "close", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "execute", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "query", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "readSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "app-inspection.inspectors.database"})
public final class LiveDatabaseConnection
implements DatabaseConnection {
    @NotNull
    private final DatabaseInspectorMessenger messenger;
    private final int id;
    @NotNull
    private final Executor taskExecutor;

    public LiveDatabaseConnection(@NotNull Disposable parentDisposable, @NotNull DatabaseInspectorMessenger messenger, int id2, @NotNull Executor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.messenger = messenger;
        this.id = id2;
        this.taskExecutor = taskExecutor;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> close() {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(Unit)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteSchema> readSchema() {
        SqliteInspectorProtocol.Command commands = SqliteInspectorProtocol.Command.newBuilder().setGetSchema(SqliteInspectorProtocol.GetSchemaCommand.newBuilder().setDatabaseId(this.id)).build();
        Intrinsics.checkNotNullExpressionValue((Object)commands, (String)"commands");
        ListenableFuture<SqliteInspectorProtocol.Response> responseFuture = this.messenger.sendCommandAsync(commands);
        return FutureUtils.transform(responseFuture, (Executor)this.taskExecutor, (Function1)readSchema.1.INSTANCE);
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteResultSet> query(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        LiveSqliteResultSet resultSet = switch (WhenMappings.$EnumSwitchMapping$0[sqliteStatement.getStatementType().ordinal()]) {
            case 1 -> new PagedLiveSqliteResultSet(sqliteStatement, this.messenger, this.id, this.taskExecutor);
            case 2, 3 -> new LazyLiveSqliteResultSet(sqliteStatement, this.messenger, this.id, this.taskExecutor);
            default -> throw new IllegalArgumentException("SqliteStatement must be of type SELECT, EXPLAIN or PRAGMA, but is " + sqliteStatement.getStatementType());
        };
        Disposer.register((Disposable)this, (Disposable)resultSet);
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)resultSet);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(resultSet)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> execute(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        SqliteInspectorProtocol.Command queryCommand = UtilsKt.buildQueryCommand$default(sqliteStatement, this.id, null, 4, null);
        ListenableFuture<SqliteInspectorProtocol.Response> responseFuture = this.messenger.sendCommandAsync(queryCommand);
        return FutureUtils.transform(responseFuture, (Executor)this.taskExecutor, (Function1)execute.1.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqliteStatementType.values().length];
            try {
                nArray[SqliteStatementType.SELECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteStatementType.EXPLAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteStatementType.PRAGMA_QUERY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

