/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionConnectionException;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorController;
import com.android.tools.idea.sqlite.controllers.TableController;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.model.ExportDialogParams;
import com.android.tools.idea.sqlite.model.ModelKt;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.android.tools.idea.sqlite.repository.DatabaseRepository;
import com.android.tools.idea.sqlite.ui.tableView.OrderBy;
import com.android.tools.idea.sqlite.ui.tableView.RowDiffOperation;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.android.tools.idea.sqlite.ui.tableView.ViewColumn;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001BBy\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0019J\b\u0010.\u001a\u00020\u0012H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0002J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120*2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0002J\b\u00103\u001a\u00020&H\u0002J\b\u00104\u001a\u00020\u0012H\u0016J&\u00105\u001a\b\u0012\u0004\u0012\u0002060\u001d2\u0006\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u0005H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0016J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00120*J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0002J\u0018\u0010>\u001a\u00020?*\u00020\u001e2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\fH\u0002J$\u0010A\u001a\b\u0012\u0004\u0012\u00020?0\u001d*\b\u0012\u0004\u0012\u00020\u001e0\u001d2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\fH\u0002R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00060$R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/sqlite/controllers/TableController;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$TabController;", "project", "Lcom/intellij/openapi/project/Project;", "rowBatchSize", "", "view", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "tableSupplier", "Lkotlin/Function0;", "Lcom/android/tools/idea/sqlite/model/SqliteTable;", "databaseRepository", "Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "closeTabInvoked", "", "showExportDialog", "Lkotlin/Function1;", "Lcom/android/tools/idea/sqlite/model/ExportDialogParams;", "edtExecutor", "Ljava/util/concurrent/Executor;", "taskExecutor", "(Lcom/intellij/openapi/project/Project;ILcom/android/tools/idea/sqlite/ui/tableView/TableView;Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;Lkotlin/jvm/functions/Function0;Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;Lcom/android/tools/idea/sqlite/model/SqliteStatement;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)V", "getCloseTabInvoked", "()Lkotlin/jvm/functions/Function0;", "currentCols", "", "Lcom/android/tools/idea/sqlite/model/ResultSetSqliteColumn;", "currentRows", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "databaseInspectorAnalyticsTracker", "Lcom/android/tools/idea/sqlite/DatabaseInspectorAnalyticsTracker;", "listener", "Lcom/android/tools/idea/sqlite/controllers/TableController$TableViewListenerImpl;", "liveUpdatesEnabled", "", "orderBy", "Lcom/android/tools/idea/sqlite/ui/tableView/OrderBy;", "refreshDataFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "resultSet", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "rowOffset", "dispose", "fetchAndDisplayRows", "fetchAndDisplayTableData", "handleFetchRowsError", "future", "isEditable", "notifyDataMightBeStale", "performRowsDiff", "Lcom/android/tools/idea/sqlite/ui/tableView/RowDiffOperation$UpdateCell;", "oldRow", "newRow", "rowIndex", "refreshData", "setUp", "updateDataAndButtons", "updateDataAndButtonsWithLoadingScreens", "toViewColumn", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "table", "toViewColumns", "TableViewListenerImpl", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nTableController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableController.kt\ncom/android/tools/idea/sqlite/controllers/TableController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,447:1\n1549#2:448\n1620#2,3:449\n288#2,2:452\n*S KotlinDebug\n*F\n+ 1 TableController.kt\ncom/android/tools/idea/sqlite/controllers/TableController\n*L\n430#1:448\n430#1:449,3\n439#1:452,2\n*E\n"})
public final class TableController
implements DatabaseInspectorController.TabController {
    private int rowBatchSize;
    @NotNull
    private final TableView view;
    @NotNull
    private final SqliteDatabaseId databaseId;
    @NotNull
    private final Function0<SqliteTable> tableSupplier;
    @NotNull
    private final DatabaseRepository databaseRepository;
    @NotNull
    private final SqliteStatement sqliteStatement;
    @NotNull
    private final Function0<Unit> closeTabInvoked;
    @NotNull
    private final Function1<ExportDialogParams, Unit> showExportDialog;
    @NotNull
    private final Executor edtExecutor;
    @NotNull
    private final Executor taskExecutor;
    private SqliteResultSet resultSet;
    @NotNull
    private final TableViewListenerImpl listener;
    @NotNull
    private OrderBy orderBy;
    private int rowOffset;
    @NotNull
    private final DatabaseInspectorAnalyticsTracker databaseInspectorAnalyticsTracker;
    @NotNull
    private List<ResultSetSqliteColumn> currentCols;
    @NotNull
    private List<SqliteRow> currentRows;
    @NotNull
    private ListenableFuture<Unit> refreshDataFuture;
    private boolean liveUpdatesEnabled;

    public TableController(@NotNull Project project, int rowBatchSize, @NotNull TableView view, @NotNull SqliteDatabaseId databaseId, @NotNull Function0<SqliteTable> tableSupplier, @NotNull DatabaseRepository databaseRepository, @NotNull SqliteStatement sqliteStatement, @NotNull Function0<Unit> closeTabInvoked, @NotNull Function1<? super ExportDialogParams, Unit> showExportDialog2, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Intrinsics.checkNotNullParameter(tableSupplier, (String)"tableSupplier");
        Intrinsics.checkNotNullParameter((Object)databaseRepository, (String)"databaseRepository");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Intrinsics.checkNotNullParameter(closeTabInvoked, (String)"closeTabInvoked");
        Intrinsics.checkNotNullParameter(showExportDialog2, (String)"showExportDialog");
        Intrinsics.checkNotNullParameter((Object)edtExecutor, (String)"edtExecutor");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.rowBatchSize = rowBatchSize;
        this.view = view;
        this.databaseId = databaseId;
        this.tableSupplier = tableSupplier;
        this.databaseRepository = databaseRepository;
        this.sqliteStatement = sqliteStatement;
        this.closeTabInvoked = closeTabInvoked;
        this.showExportDialog = showExportDialog2;
        this.edtExecutor = edtExecutor;
        this.taskExecutor = taskExecutor;
        this.listener = new TableViewListenerImpl();
        this.orderBy = OrderBy.NotOrdered.INSTANCE;
        this.databaseInspectorAnalyticsTracker = DatabaseInspectorAnalyticsTracker.Companion.getInstance(project);
        this.currentCols = CollectionsKt.emptyList();
        this.currentRows = CollectionsKt.emptyList();
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(Unit)");
        this.refreshDataFuture = listenableFuture;
    }

    public /* synthetic */ TableController(Project project, int n, TableView tableView, SqliteDatabaseId sqliteDatabaseId, Function0 function0, DatabaseRepository databaseRepository, SqliteStatement sqliteStatement, Function0 function02, Function1 function1, Executor executor2, Executor executor3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        this(project, n, tableView, sqliteDatabaseId, (Function0<SqliteTable>)function0, databaseRepository, sqliteStatement, (Function0<Unit>)function02, (Function1<? super ExportDialogParams, Unit>)function1, executor2, executor3);
    }

    @Override
    @NotNull
    public Function0<Unit> getCloseTabInvoked() {
        return this.closeTabInvoked;
    }

    @NotNull
    public final ListenableFuture<Unit> setUp() {
        if (!(this.databaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId)) {
            this.view.setLiveUpdatesButtonState(false);
            this.view.setRefreshButtonState(false);
        }
        this.view.startTableLoading();
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.transformAsync(this.databaseRepository.runQuery(this.databaseId, this.sqliteStatement), (Executor)this.edtExecutor, (Function1)((Function1)new Function1<SqliteResultSet, ListenableFuture<Unit>>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ListenableFuture<Unit> invoke(@NotNull SqliteResultSet newResultSet) {
                Intrinsics.checkNotNullParameter((Object)newResultSet, (String)"newResultSet");
                TableController.access$getView$p(this.this$0).setEditable(TableController.access$isEditable(this.this$0));
                TableController.access$getView$p(this.this$0).showPageSizeValue(TableController.access$getRowBatchSize$p(this.this$0));
                TableController.access$getView$p(this.this$0).addListener(TableController.access$getListener$p(this.this$0));
                TableController.access$setResultSet$p(this.this$0, newResultSet);
                Disposer.register((Disposable)this.this$0, (Disposable)newResultSet);
                return TableController.access$fetchAndDisplayTableData(this.this$0);
            }
        })), (Disposable)this);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> refreshData() {
        if (!this.refreshDataFuture.isDone()) {
            return this.refreshDataFuture;
        }
        this.view.startTableLoading();
        this.refreshDataFuture = this.fetchAndDisplayTableData();
        return this.refreshDataFuture;
    }

    @Override
    public void notifyDataMightBeStale() {
        if (this.liveUpdatesEnabled && this.refreshDataFuture.isDone()) {
            this.refreshDataFuture = this.fetchAndDisplayTableData();
        }
    }

    public void dispose() {
        this.view.stopTableLoading();
        this.view.removeListener(this.listener);
    }

    private final ListenableFuture<Unit> fetchAndDisplayTableData() {
        SqliteResultSet sqliteResultSet = this.resultSet;
        if (sqliteResultSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
            sqliteResultSet = null;
        }
        ListenableFuture fetchTableDataFuture2 = FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.transformAsync(sqliteResultSet.getColumns(), (Executor)this.edtExecutor, (Function1)((Function1)new Function1<List<? extends ResultSetSqliteColumn>, ListenableFuture<Unit>>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ListenableFuture<Unit> invoke(@NotNull List<ResultSetSqliteColumn> columns2) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(columns2, (String)"columns");
                if (Disposer.isDisposed((Disposable)this.this$0)) {
                    throw new ProcessCanceledException();
                }
                if (!Intrinsics.areEqual(columns2, (Object)TableController.access$getCurrentCols$p(this.this$0))) {
                    TableController.access$setCurrentRows$p(this.this$0, CollectionsKt.emptyList());
                }
                TableController.access$setCurrentCols$p(this.this$0, columns2);
                SqliteTable table2 = (SqliteTable)TableController.access$getTableSupplier$p(this.this$0).invoke();
                Iterable iterable = columns2;
                TableController tableController2 = this.this$0;
                TableView tableView = TableController.access$getView$p(this.this$0);
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Object object;
                    ResultSetSqliteColumn it = (ResultSetSqliteColumn)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getName(), (object = table2) != null && (object = ((SqliteTable)object).getRowIdName()) != null ? ((RowIdName)((Object)object)).getStringName() : null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                tableView.showTableColumns(TableController.access$toViewColumns(tableController2, list2, table2));
                TableController.access$getView$p(this.this$0).setEditable(TableController.access$isEditable(this.this$0));
                return TableController.access$updateDataAndButtons(this.this$0);
            }
        })), (Disposable)this);
        ListenableFuture<Unit> futureCatching = this.handleFetchRowsError((ListenableFuture<Unit>)fetchTableDataFuture2);
        ListenableFuture future2 = FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.finallySync(futureCatching, (Executor)this.edtExecutor, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TableController.access$getView$p(this.this$0).stopTableLoading();
            }
        })), (Disposable)this);
        ListenableFuture listenableFuture = Futures.transform((ListenableFuture)future2, (Function)Functions.constant((Object)Unit.INSTANCE), (Executor)MoreExecutors.directExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"transform(future, Functi\u2026ecutors.directExecutor())");
        return listenableFuture;
    }

    private final ListenableFuture<Unit> updateDataAndButtons() {
        this.view.setFetchPreviousRowsButtonState(false);
        this.view.setFetchNextRowsButtonState(false);
        return FutureUtils.transform((ListenableFuture)FutureUtils.transformAsync(this.fetchAndDisplayRows(), (Executor)this.taskExecutor, (Function1)((Function1)new Function1<Unit, ListenableFuture<Integer>>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ListenableFuture<Integer> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SqliteResultSet sqliteResultSet = TableController.access$getResultSet$p(this.this$0);
                if (sqliteResultSet == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
                    sqliteResultSet = null;
                }
                return sqliteResultSet.getTotalRowCount();
            }
        })), (Executor)this.edtExecutor, (Function1)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int rowCount) {
                TableController.access$getView$p(this.this$0).setFetchPreviousRowsButtonState(TableController.access$getRowOffset$p(this.this$0) > 0);
                TableController.access$getView$p(this.this$0).setFetchNextRowsButtonState(TableController.access$getRowOffset$p(this.this$0) + TableController.access$getRowBatchSize$p(this.this$0) < rowCount);
            }
        }));
    }

    private final ListenableFuture<Unit> updateDataAndButtonsWithLoadingScreens() {
        this.view.startTableLoading();
        ListenableFuture<Unit> updateDataFuture = this.updateDataAndButtons();
        ListenableFuture future2 = FutureUtils.finallySync(updateDataFuture, (Executor)this.edtExecutor, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (Disposer.isDisposed((Disposable)this.this$0)) {
                    throw new ProcessCanceledException();
                }
                TableController.access$getView$p(this.this$0).stopTableLoading();
            }
        }));
        return this.handleFetchRowsError((ListenableFuture<Unit>)future2);
    }

    private final ListenableFuture<Unit> fetchAndDisplayRows() {
        SqliteResultSet sqliteResultSet = this.resultSet;
        if (sqliteResultSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
            sqliteResultSet = null;
        }
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.transform(sqliteResultSet.getRowBatch(this.rowOffset, this.rowBatchSize), (Executor)this.edtExecutor, (Function1)((Function1)new Function1<List<? extends SqliteRow>, Unit>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<SqliteRow> newRows) {
                List rowCellUpdates;
                Intrinsics.checkNotNullParameter(newRows, (String)"newRows");
                List rowDiffOperations = new ArrayList<E>();
                int n = Math.min(TableController.access$getCurrentRows$p(this.this$0).size(), newRows.size());
                for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
                    rowCellUpdates = TableController.access$performRowsDiff(this.this$0, (SqliteRow)TableController.access$getCurrentRows$p(this.this$0).get(rowIndex), newRows.get(rowIndex), rowIndex);
                    rowDiffOperations.addAll(rowCellUpdates);
                }
                if (TableController.access$getCurrentRows$p(this.this$0).size() < newRows.size()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable rowIndex = CollectionsKt.drop((Iterable)newRows, (int)TableController.access$getCurrentRows$p(this.this$0).size());
                    List list2 = rowDiffOperations;
                    boolean $i$f$map = false;
                    rowCellUpdates = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        SqliteRow sqliteRow = (SqliteRow)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(new RowDiffOperation.AddRow((SqliteRow)it));
                    }
                    list2.addAll((List)destination$iv$iv);
                } else if (TableController.access$getCurrentRows$p(this.this$0).size() > newRows.size()) {
                    rowDiffOperations.add(new RowDiffOperation.RemoveLastRows(newRows.size()));
                }
                TableController.access$getView$p(this.this$0).setRowOffset(TableController.access$getRowOffset$p(this.this$0));
                TableController.access$getView$p(this.this$0).updateRows(rowDiffOperations);
                TableController.access$getView$p(this.this$0).setEditable(TableController.access$isEditable(this.this$0));
                TableController.access$setCurrentRows$p(this.this$0, newRows);
            }
        })), (Disposable)this);
    }

    private final List<RowDiffOperation.UpdateCell> performRowsDiff(SqliteRow oldRow, SqliteRow newRow, int rowIndex) {
        List cellUpdates = new ArrayList();
        int n = oldRow.getValues().size();
        for (int colIndex = 0; colIndex < n; ++colIndex) {
            if (Intrinsics.areEqual((Object)oldRow.getValues().get(colIndex), (Object)newRow.getValues().get(colIndex))) continue;
            cellUpdates.add(new RowDiffOperation.UpdateCell(newRow.getValues().get(colIndex), rowIndex, colIndex));
        }
        return cellUpdates;
    }

    private final ListenableFuture<Unit> handleFetchRowsError(ListenableFuture<Unit> future2) {
        FutureUtils.addCallback(future2, (Executor)this.edtExecutor, (Function1)handleFetchRowsError.1.INSTANCE, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ TableController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable error) {
                if (Disposer.isDisposed((Disposable)this.this$0)) {
                    return;
                }
                TableController.access$getView$p(this.this$0).resetView();
                if (!(error instanceof CancellationException) && !(error instanceof AppInspectionConnectionException)) {
                    TableController.access$getView$p(this.this$0).reportError("Error retrieving data from table.", error);
                }
            }
        }));
        return future2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEditable() {
        if (this.tableSupplier.invoke() == null) return false;
        if (this.liveUpdatesEnabled) return false;
        SqliteTable sqliteTable = (SqliteTable)this.tableSupplier.invoke();
        if (sqliteTable != null ? sqliteTable.isView() : false) return false;
        if (!(this.databaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ViewColumn> toViewColumns(List<ResultSetSqliteColumn> $this$toViewColumns, SqliteTable table2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toViewColumns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultSetSqliteColumn resultSetSqliteColumn = (ResultSetSqliteColumn)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.toViewColumn((ResultSetSqliteColumn)it, table2));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List toViewColumns$default(TableController tableController2, List list2, SqliteTable sqliteTable, int n, Object object) {
        if ((n & 1) != 0) {
            sqliteTable = null;
        }
        return tableController2.toViewColumns(list2, sqliteTable);
    }

    private final ViewColumn toViewColumn(ResultSetSqliteColumn $this$toViewColumn, SqliteTable table2) {
        boolean bl;
        boolean bl2;
        SqliteColumn sqliteColumn;
        Object object = table2;
        if (object != null && (object = ((SqliteTable)object).getColumns()) != null) {
            Object v1;
            block7: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SqliteColumn it = (SqliteColumn)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$toViewColumn.getName())) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            sqliteColumn = v1;
        } else {
            sqliteColumn = null;
        }
        SqliteColumn schemaColumn = sqliteColumn;
        String string = $this$toViewColumn.getName();
        SqliteColumn sqliteColumn2 = schemaColumn;
        if (sqliteColumn2 != null) {
            bl2 = sqliteColumn2.getInPrimaryKey();
        } else {
            Boolean bl4 = $this$toViewColumn.getInPrimaryKey();
            bl2 = bl4 != null ? bl4 : false;
        }
        SqliteColumn sqliteColumn3 = schemaColumn;
        if (sqliteColumn3 != null) {
            bl = sqliteColumn3.isNullable();
        } else {
            Boolean bl5 = $this$toViewColumn.isNullable();
            bl = bl5 != null ? bl5 : true;
        }
        return new ViewColumn(string, bl2, bl);
    }

    static /* synthetic */ ViewColumn toViewColumn$default(TableController tableController2, ResultSetSqliteColumn resultSetSqliteColumn, SqliteTable sqliteTable, int n, Object object) {
        if ((n & 1) != 0) {
            sqliteTable = null;
        }
        return tableController2.toViewColumn(resultSetSqliteColumn, sqliteTable);
    }

    public static final /* synthetic */ TableViewListenerImpl access$getListener$p(TableController $this) {
        return $this.listener;
    }

    public static final /* synthetic */ void access$setResultSet$p(TableController $this, SqliteResultSet sqliteResultSet) {
        $this.resultSet = sqliteResultSet;
    }

    public static final /* synthetic */ ListenableFuture access$fetchAndDisplayTableData(TableController $this) {
        return $this.fetchAndDisplayTableData();
    }

    public static final /* synthetic */ List access$getCurrentCols$p(TableController $this) {
        return $this.currentCols;
    }

    public static final /* synthetic */ void access$setCurrentRows$p(TableController $this, List list2) {
        $this.currentRows = list2;
    }

    public static final /* synthetic */ void access$setCurrentCols$p(TableController $this, List list2) {
        $this.currentCols = list2;
    }

    public static final /* synthetic */ List access$toViewColumns(TableController $this, List $receiver, SqliteTable table2) {
        return $this.toViewColumns($receiver, table2);
    }

    public static final /* synthetic */ ListenableFuture access$updateDataAndButtons(TableController $this) {
        return $this.updateDataAndButtons();
    }

    public static final /* synthetic */ List access$performRowsDiff(TableController $this, SqliteRow oldRow, SqliteRow newRow, int rowIndex) {
        return $this.performRowsDiff(oldRow, newRow, rowIndex);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/sqlite/controllers/TableController$TableViewListenerImpl;", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView$Listener;", "(Lcom/android/tools/idea/sqlite/controllers/TableController;)V", "cancelRunningStatementInvoked", "", "loadFirstRowsInvoked", "loadLastRowsInvoked", "loadNextRowsInvoked", "loadPreviousRowsInvoked", "refreshDataInvoked", "rowCountChanged", "rowCount", "", "showExportToFileDialogInvoked", "toggleLiveUpdatesInvoked", "toggleOrderByColumnInvoked", "viewColumn", "Lcom/android/tools/idea/sqlite/ui/tableView/ViewColumn;", "updateCellInvoked", "targetRowIndex", "", "targetColumn", "newValue", "Lcom/android/tools/idea/sqlite/model/SqliteValue;", "app-inspection.inspectors.database"})
    private final class TableViewListenerImpl
    implements TableView.Listener {
        @Override
        public void toggleOrderByColumnInvoked(@NotNull ViewColumn viewColumn) {
            Intrinsics.checkNotNullParameter((Object)viewColumn, (String)"viewColumn");
            TableController.this.orderBy = TableController.this.orderBy.nextState(viewColumn.getName());
            SqliteResultSet sqliteResultSet = TableController.this.resultSet;
            if (sqliteResultSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
                sqliteResultSet = null;
            }
            Disposer.dispose((Disposable)sqliteResultSet);
            TableController.this.view.startTableLoading();
            FutureUtils.transform((ListenableFuture)FutureUtils.transform(TableController.this.databaseRepository.selectOrdered(TableController.this.databaseId, TableController.this.sqliteStatement, TableController.this.orderBy), (Executor)TableController.this.edtExecutor, (Function1)((Function1)new Function1<SqliteResultSet, ListenableFuture<Unit>>(TableController.this){
                final /* synthetic */ TableController this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final ListenableFuture<Unit> invoke(@NotNull SqliteResultSet newResultSet) {
                    Intrinsics.checkNotNullParameter((Object)newResultSet, (String)"newResultSet");
                    if (Disposer.isDisposed((Disposable)this.this$0)) {
                        newResultSet.dispose();
                        throw new ProcessCanceledException();
                    }
                    TableController.access$setResultSet$p(this.this$0, newResultSet);
                    Disposer.register((Disposable)this.this$0, (Disposable)newResultSet);
                    TableController.access$setRowOffset$p(this.this$0, 0);
                    return TableController.access$fetchAndDisplayTableData(this.this$0);
                }
            })), (Executor)TableController.this.edtExecutor, (Function1)((Function1)new Function1<ListenableFuture<Unit>, Unit>(TableController.this){
                final /* synthetic */ TableController this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ListenableFuture<Unit> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    TableController.access$getView$p(this.this$0).setColumnSortIndicator(TableController.access$getOrderBy$p(this.this$0));
                }
            }));
        }

        @Override
        public void cancelRunningStatementInvoked() {
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState;
            SqliteDatabaseId sqliteDatabaseId = TableController.this.databaseId;
            if (sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_OFFLINE;
            } else if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_ONLINE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState2 = connectivityState;
            TableController.this.databaseInspectorAnalyticsTracker.trackStatementExecutionCanceled(connectivityState2, AppInspectionEvent.DatabaseInspectorEvent.StatementContext.UNKNOWN_STATEMENT_CONTEXT);
            TableController.this.getCloseTabInvoked().invoke();
        }

        @Override
        public void rowCountChanged(@NotNull String rowCount) {
            Intrinsics.checkNotNullParameter((Object)rowCount, (String)"rowCount");
            String errorMessage = "Row count must be a positive integer.";
            try {
                int intRowCount = Integer.parseInt(rowCount);
                if (intRowCount <= 0) {
                    TableController.this.view.reportError(errorMessage, null);
                    return;
                }
                TableController.this.rowBatchSize = intRowCount;
                TableController.this.updateDataAndButtonsWithLoadingScreens();
            }
            catch (NumberFormatException e) {
                TableController.this.view.reportError(errorMessage, null);
            }
        }

        @Override
        public void loadPreviousRowsInvoked() {
            Comparable comparable = ComparatorUtil.max((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(TableController.this.rowOffset - TableController.this.rowBatchSize));
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"max(0, rowOffset - rowBatchSize)");
            TableController.this.rowOffset = ((Number)((Object)comparable)).intValue();
            TableController.this.updateDataAndButtonsWithLoadingScreens();
        }

        @Override
        public void loadNextRowsInvoked() {
            TableController tableController2 = TableController.this;
            tableController2.rowOffset = tableController2.rowOffset + TableController.this.rowBatchSize;
            TableController.this.updateDataAndButtonsWithLoadingScreens();
        }

        @Override
        public void loadFirstRowsInvoked() {
            TableController.this.rowOffset = 0;
            TableController.this.updateDataAndButtonsWithLoadingScreens();
        }

        @Override
        public void loadLastRowsInvoked() {
            SqliteResultSet sqliteResultSet = TableController.this.resultSet;
            if (sqliteResultSet == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resultSet");
                sqliteResultSet = null;
            }
            FutureUtils.transformAsync(sqliteResultSet.getTotalRowCount(), (Executor)TableController.this.edtExecutor, (Function1)((Function1)new Function1<Integer, ListenableFuture<Unit>>(TableController.this){
                final /* synthetic */ TableController this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final ListenableFuture<Unit> invoke(int rowCount) {
                    TableController.access$setRowOffset$p(this.this$0, rowCount / TableController.access$getRowBatchSize$p(this.this$0) * TableController.access$getRowBatchSize$p(this.this$0));
                    if (TableController.access$getRowOffset$p(this.this$0) == rowCount) {
                        TableController tableController2 = this.this$0;
                        TableController.access$setRowOffset$p(tableController2, TableController.access$getRowOffset$p(tableController2) - TableController.access$getRowBatchSize$p(this.this$0));
                    }
                    return TableController.access$updateDataAndButtonsWithLoadingScreens(this.this$0);
                }
            }));
        }

        @Override
        public void refreshDataInvoked() {
            TableController.this.databaseInspectorAnalyticsTracker.trackTargetRefreshed(AppInspectionEvent.DatabaseInspectorEvent.TargetType.TABLE_TARGET);
            TableController.this.refreshData();
        }

        @Override
        public void toggleLiveUpdatesInvoked() {
            TableController.this.liveUpdatesEnabled = !TableController.this.liveUpdatesEnabled;
            TableController.this.view.setEditable(TableController.this.isEditable());
            if (TableController.this.liveUpdatesEnabled) {
                TableController.this.notifyDataMightBeStale();
            }
            TableController.this.databaseInspectorAnalyticsTracker.trackLiveUpdatedToggled(TableController.this.liveUpdatesEnabled);
        }

        @Override
        public void showExportToFileDialogInvoked() {
            ExportDialogParams exportDialogParams;
            SqliteTable sqliteTable = (SqliteTable)TableController.this.tableSupplier.invoke();
            String tableName = sqliteTable != null ? sqliteTable.getName() : null;
            if (tableName != null) {
                exportDialogParams = new ExportDialogParams.ExportTableDialogParams(TableController.this.databaseId, tableName, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.TABLE_CONTENTS_EXPORT_BUTTON);
            } else if (ModelKt.isQueryStatement(TableController.this.sqliteStatement)) {
                exportDialogParams = new ExportDialogParams.ExportQueryResultsDialogParams(TableController.this.databaseId, TableController.this.sqliteStatement, AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin.QUERY_RESULTS_EXPORT_BUTTON);
            } else {
                return;
            }
            ExportDialogParams exportScenario = exportDialogParams;
            TableController.this.showExportDialog.invoke((Object)exportScenario);
        }

        @Override
        public void updateCellInvoked(int targetRowIndex, @NotNull ViewColumn targetColumn, @NotNull SqliteValue newValue) {
            Intrinsics.checkNotNullParameter((Object)targetColumn, (String)"targetColumn");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            SqliteTable targetTable = (SqliteTable)TableController.this.tableSupplier.invoke();
            if (targetTable == null) {
                TableController.this.view.reportError("Can't update. Table not found.", null);
                return;
            }
            TableController.this.view.startTableLoading();
            SqliteRow targetRow = (SqliteRow)TableController.this.currentRows.get(targetRowIndex);
            FutureUtils.addCallback(TableController.this.databaseRepository.updateTable(TableController.this.databaseId, targetTable, targetRow, targetColumn.getName(), newValue), (Executor)TableController.this.edtExecutor, (FutureCallback)((FutureCallback)new FutureCallback<Unit>(TableController.this){
                final /* synthetic */ TableController this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess(@Nullable Unit result2) {
                    TableController.access$getDatabaseInspectorAnalyticsTracker$p(this.this$0).trackTableCellEdited();
                    this.this$0.refreshData();
                }

                public void onFailure(@NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    TableController.access$getView$p(this.this$0).revertLastTableCellEdit();
                    TableController.access$getView$p(this.this$0).stopTableLoading();
                    TableController.access$getView$p(this.this$0).reportError("Can't execute update: ", t);
                }
            }));
        }
    }
}

