/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.cli;

import com.android.SdkConstants;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.sqlite.cli.SqliteCliProvider;
import com.android.tools.idea.sqlite.cli.SqliteCliProviderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016JT\u0010\b\u001a\u0004\u0018\u00010\t2#\u0010\n\u001a\u001f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2#\u0010\u0010\u001a\u001f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/sqlite/cli/SqliteCliProviderImpl;", "Lcom/android/tools/idea/sqlite/cli/SqliteCliProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getSqliteCli", "Ljava/nio/file/Path;", "systemPropertyResolver", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "key", "systemEnvResolver", "logAny", "", "s", "logCheckingSqlite3", "path", "logFoundSqlite3", "logUnableToFind", "what", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nSqliteCliProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteCliProvider.kt\ncom/android/tools/idea/sqlite/cli/SqliteCliProviderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n10#2:116\n766#3:117\n857#3,2:118\n1549#3:120\n1620#3,3:121\n288#3,2:124\n1#4:126\n11335#5:127\n11670#5,3:128\n11335#5:131\n11670#5,3:132\n*S KotlinDebug\n*F\n+ 1 SqliteCliProvider.kt\ncom/android/tools/idea/sqlite/cli/SqliteCliProviderImpl\n*L\n49#1:116\n67#1:117\n67#1:118,2\n68#1:120\n68#1:121,3\n69#1:124,2\n82#1:127\n82#1:128,3\n90#1:131\n90#1:132,3\n*E\n"})
public final class SqliteCliProviderImpl
implements SqliteCliProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;

    public SqliteCliProviderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SqliteCliProviderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        this.logger = logger2;
    }

    @Override
    @Nullable
    public Path getSqliteCli() {
        return this.getSqliteCli((Function1<? super String, String>)((Function1)getSqliteCli.1.INSTANCE), (Function1<? super String, String>)((Function1)getSqliteCli.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @Nullable
    public final Path getSqliteCli(@NotNull Function1<? super String, String> systemPropertyResolver, @NotNull Function1<? super String, String> systemEnvResolver) {
        Path path2;
        List list2;
        Collection collection2;
        int n;
        File overrideFile;
        Object v2;
        Path $this$firstOrNull$iv;
        Object object;
        Path path3;
        block13: {
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(systemPropertyResolver, (String)"systemPropertyResolver");
            Intrinsics.checkNotNullParameter(systemEnvResolver, (String)"systemEnvResolver");
            Object object2 = new String[]{systemPropertyResolver.invoke((Object)"android.sqlite3.path"), systemEnvResolver.invoke((Object)"ANDROID_SQLITE3_PATH")};
            object2 = CollectionsKt.listOf((Object[])object2);
            boolean $i$f$filter = false;
            path3 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!Strings.isNotEmpty((String)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                it = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string = it;
                Intrinsics.checkNotNull((Object)string);
                object.add(new File(string));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it2 = (File)element$iv;
                boolean bl = false;
                Path path4 = it2.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"it.toPath()");
                this.logCheckingSqlite3(path4);
                if (!it2.exists()) continue;
                v2 = element$iv;
                break block13;
            }
            v2 = null;
        }
        File file2 = overrideFile = (File)v2;
        if (file2 != null) {
            Path it = $this$firstOrNull$iv = file2.toPath();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.logFoundSqlite3(it);
            return $this$firstOrNull$iv;
        }
        File adbFile = AdbFileProvider.Companion.fromProject(this.project).get();
        if (adbFile == null) {
            this.logUnableToFind("adb");
            return null;
        }
        this.logAny("Adb location: " + adbFile.toPath());
        Object object3 = this;
        File[] fileArray = adbFile.getParentFile().listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            File[] bl = fileArray;
            object = object3;
            boolean $i$f$map = false;
            void it2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            n = ((void)$this$mapTo$iv$iv).length;
            for (int it = 0; it < n; ++it) {
                void it3;
                void item$iv$iv;
                void var14_33 = item$iv$iv = $this$mapTo$iv$iv[it];
                collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it3.toPath());
            }
            list2 = (List)destination$iv$iv;
            object3 = object;
        } else {
            list2 = null;
        }
        ((SqliteCliProviderImpl)object3).logAny("Adb neighbours: " + list2);
        File adbSibling = adbFile.toPath().getParent().resolve(SdkConstants.FN_SQLITE3).toFile();
        Path path5 = adbSibling.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"adbSibling.toPath()");
        this.logCheckingSqlite3(path5);
        if (adbSibling.exists()) {
            Path it = path3 = adbSibling.toPath();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.logFoundSqlite3(it);
            path2 = path3;
        } else {
            List list3;
            this.logAny("Adb location: " + adbFile.toPath());
            Object object4 = this;
            File[] fileArray2 = adbFile.getParentFile().listFiles();
            if (fileArray2 != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                File[] it = fileArray2;
                object = object4;
                boolean $i$f$map = false;
                void destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n2 = ((void)$this$mapTo$iv$iv).length;
                for (n = 0; n < n2; ++n) {
                    void it4;
                    void item$iv$iv;
                    void bl2 = item$iv$iv = $this$mapTo$iv$iv[n];
                    collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add(it4.toPath());
                }
                list3 = (List)destination$iv$iv2;
                object4 = object;
            } else {
                list3 = null;
            }
            ((SqliteCliProviderImpl)object4).logAny("Adb neighbours: " + list3);
            this.logUnableToFind("sqlite3");
            path2 = null;
        }
        return path2;
    }

    private final void logCheckingSqlite3(Path path2) {
        String s = "Checking " + path2.toAbsolutePath() + " for sqlite3";
        this.logger.info(s);
    }

    private final void logFoundSqlite3(Path path2) {
        String s = "Located sqlite3 under " + path2.toAbsolutePath();
        this.logger.info(s);
    }

    private final void logUnableToFind(String what) {
        String s = "Unable to locate " + what + " file";
        this.logger.error(s);
    }

    private final void logAny(String s) {
        this.logger.debug(s);
    }
}

