/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.appinspection.inspector.api.AppInspectorMessenger;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorClient;
import com.android.tools.idea.sqlite.DatabaseInspectorClientCommandsChannel;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.DatabaseInspectorMessengerKt;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveDatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u00b3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u000e\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012\u0012!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u001e\b\u0002\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!2\u0006\u0010\u0014\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0!2\u0006\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0007J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0!2\u0006\u0010*\u001a\u00020\"H\u0016J\u0011\u0010+\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/sqlite/DatabaseInspectorClient;", "Lcom/android/tools/idea/sqlite/DatabaseInspectorClientCommandsChannel;", "messenger", "Lcom/android/tools/idea/appinspection/inspector/api/AppInspectorMessenger;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "onErrorEventListener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "errorMessage", "", "onDatabaseAddedListener", "Lkotlin/Function2;", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveDatabaseConnection;", "onDatabasePossiblyChanged", "Lkotlin/Function0;", "onDatabaseClosed", "databaseId", "taskExecutor", "Ljava/util/concurrent/Executor;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "errorsSideChannel", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Command;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$ErrorOccurredResponse;", "Lcom/android/tools/idea/sqlite/ErrorsSideChannel;", "(Lcom/android/tools/idea/appinspection/inspector/api/AppInspectorMessenger;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/Executor;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function2;)V", "dbMessenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "acquireDatabaseLock", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "keepConnectionsOpen", "", "keepOpen", "onRawEvent", "eventData", "", "releaseDatabaseLock", "lockId", "startTrackingDatabaseConnections", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nDatabaseInspectorClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseInspectorClient.kt\ncom/android/tools/idea/sqlite/DatabaseInspectorClient\n+ 2 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,168:1\n58#2,3:169\n58#2,3:172\n*S KotlinDebug\n*F\n+ 1 DatabaseInspectorClient.kt\ncom/android/tools/idea/sqlite/DatabaseInspectorClient\n*L\n75#1:169,3\n92#1:172,3\n*E\n"})
public final class DatabaseInspectorClient
implements DatabaseInspectorClientCommandsChannel {
    @NotNull
    private final AppInspectorMessenger messenger;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final Function1<String, Unit> onErrorEventListener;
    @NotNull
    private final Function2<SqliteDatabaseId, LiveDatabaseConnection, Unit> onDatabaseAddedListener;
    @NotNull
    private final Function0<Unit> onDatabasePossiblyChanged;
    @NotNull
    private final Function1<SqliteDatabaseId, Unit> onDatabaseClosed;
    @NotNull
    private final Executor taskExecutor;
    @NotNull
    private final DatabaseInspectorMessenger dbMessenger;

    public DatabaseInspectorClient(@NotNull AppInspectorMessenger messenger, @NotNull Disposable parentDisposable, @NotNull Function1<? super String, Unit> onErrorEventListener, @NotNull Function2<? super SqliteDatabaseId, ? super LiveDatabaseConnection, Unit> onDatabaseAddedListener, @NotNull Function0<Unit> onDatabasePossiblyChanged2, @NotNull Function1<? super SqliteDatabaseId, Unit> onDatabaseClosed2, @NotNull Executor taskExecutor, @NotNull CoroutineScope scope2, @NotNull Function2<? super SqliteInspectorProtocol.Command, ? super SqliteInspectorProtocol.ErrorOccurredResponse, Unit> errorsSideChannel) {
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(onErrorEventListener, (String)"onErrorEventListener");
        Intrinsics.checkNotNullParameter(onDatabaseAddedListener, (String)"onDatabaseAddedListener");
        Intrinsics.checkNotNullParameter(onDatabasePossiblyChanged2, (String)"onDatabasePossiblyChanged");
        Intrinsics.checkNotNullParameter(onDatabaseClosed2, (String)"onDatabaseClosed");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(errorsSideChannel, (String)"errorsSideChannel");
        this.messenger = messenger;
        this.parentDisposable = parentDisposable;
        this.onErrorEventListener = onErrorEventListener;
        this.onDatabaseAddedListener = onDatabaseAddedListener;
        this.onDatabasePossiblyChanged = onDatabasePossiblyChanged2;
        this.onDatabaseClosed = onDatabaseClosed2;
        this.taskExecutor = taskExecutor;
        this.dbMessenger = new DatabaseInspectorMessenger(this.messenger, scope2, this.taskExecutor, errorsSideChannel);
        BuildersKt.launch$default((CoroutineScope)scope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DatabaseInspectorClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.messenger.getEventFlow().collect(new FlowCollector(){

                            @Nullable
                            public final Object emit(@NotNull byte[] eventData, @NotNull Continuation<? super Unit> $completion) {
                                this$0.onRawEvent(eventData);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ DatabaseInspectorClient(AppInspectorMessenger appInspectorMessenger, Disposable disposable2, Function1 function1, Function2 function2, Function0 function0, Function1 function12, Executor executor2, CoroutineScope coroutineScope, Function2 function22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            function22 = 1.INSTANCE;
        }
        this(appInspectorMessenger, disposable2, (Function1<? super String, Unit>)function1, (Function2<? super SqliteDatabaseId, ? super LiveDatabaseConnection, Unit>)function2, (Function0<Unit>)function0, (Function1<? super SqliteDatabaseId, Unit>)function12, executor2, coroutineScope, (Function2<? super SqliteInspectorProtocol.Command, ? super SqliteInspectorProtocol.ErrorOccurredResponse, Unit>)function22);
    }

    @VisibleForTesting
    public final void onRawEvent(@NotNull byte[] eventData) {
        Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
        SqliteInspectorProtocol.Event event2 = SqliteInspectorProtocol.Event.parseFrom((byte[])eventData);
        if (event2.hasDatabaseOpened()) {
            SqliteInspectorProtocol.DatabaseOpenedEvent openedDatabase = event2.getDatabaseOpened();
            Object modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(openedDatabase, this){
                final /* synthetic */ SqliteInspectorProtocol.DatabaseOpenedEvent $openedDatabase$inlined;
                final /* synthetic */ DatabaseInspectorClient this$0;
                {
                    this.$openedDatabase$inlined = databaseOpenedEvent;
                    this.this$0 = databaseInspectorClient;
                }

                public final void run() {
                    boolean bl = false;
                    String string = this.$openedDatabase$inlined.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"openedDatabase.path");
                    SqliteDatabaseId databaseId = SqliteDatabaseId.Companion.fromLiveDatabase(string, this.$openedDatabase$inlined.getDatabaseId());
                    LiveDatabaseConnection databaseConnection = new LiveDatabaseConnection(DatabaseInspectorClient.access$getParentDisposable$p(this.this$0), DatabaseInspectorClient.access$getDbMessenger$p(this.this$0), this.$openedDatabase$inlined.getDatabaseId(), DatabaseInspectorClient.access$getTaskExecutor$p(this.this$0));
                    DatabaseInspectorClient.access$getOnDatabaseAddedListener$p(this.this$0).invoke((Object)databaseId, (Object)databaseConnection);
                }
            }, ModalityState.defaultModalityState());
        } else if (event2.hasDatabasePossiblyChanged()) {
            this.onDatabasePossiblyChanged.invoke();
        } else if (event2.hasDatabaseClosed()) {
            Object modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, event2){
                final /* synthetic */ DatabaseInspectorClient this$0;
                final /* synthetic */ SqliteInspectorProtocol.Event $event$inlined;
                {
                    this.this$0 = databaseInspectorClient;
                    this.$event$inlined = event2;
                }

                public final void run() {
                    boolean bl = false;
                    Function1 function1 = DatabaseInspectorClient.access$getOnDatabaseClosed$p(this.this$0);
                    String string = this.$event$inlined.getDatabaseClosed().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.databaseClosed.path");
                    function1.invoke((Object)SqliteDatabaseId.Companion.fromLiveDatabase(string, this.$event$inlined.getDatabaseClosed().getDatabaseId()));
                }
            }, ModalityState.defaultModalityState());
        } else if (event2.hasErrorOccurred()) {
            SqliteInspectorProtocol.ErrorContent errorContent = event2.getErrorOccurred().getContent();
            Intrinsics.checkNotNullExpressionValue((Object)errorContent, (String)"errorContent");
            String errorMessage = UtilsKt.getErrorMessage(errorContent);
            this.onErrorEventListener.invoke((Object)errorMessage);
        }
    }

    @Nullable
    public final Object startTrackingDatabaseConnections(@NotNull Continuation<? super Unit> $completion) {
        SqliteInspectorProtocol.Command.Builder builder2 = SqliteInspectorProtocol.Command.newBuilder().setTrackDatabases(SqliteInspectorProtocol.TrackDatabasesCommand.getDefaultInstance());
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder().setTrackDat\u2026and.getDefaultInstance())");
        Object object = DatabaseInspectorMessengerKt.sendCommand(this.dbMessenger, builder2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> keepConnectionsOpen(boolean keepOpen) {
        SqliteInspectorProtocol.Command.Builder builder2 = SqliteInspectorProtocol.Command.newBuilder().setKeepDatabasesOpen(SqliteInspectorProtocol.KeepDatabasesOpenCommand.newBuilder().setSetEnabled(keepOpen));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n          .\u2026.setSetEnabled(keepOpen))");
        ListenableFuture<SqliteInspectorProtocol.Response> response2 = DatabaseInspectorMessengerKt.sendCommandAsync(this.dbMessenger, builder2);
        return FutureUtils.transform(response2, (Executor)this.taskExecutor, (Function1)((Function1)new Function1<SqliteInspectorProtocol.Response, Boolean>(keepOpen){
            final /* synthetic */ boolean $keepOpen;
            {
                this.$keepOpen = $keepOpen;
                super(1);
            }

            @Nullable
            public final Boolean invoke(@NotNull SqliteInspectorProtocol.Response it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SqliteInspectorProtocol.Response.OneOfCase oneOfCase = it.getOneOfCase();
                return (oneOfCase == null ? -1 : keepConnectionsOpen.WhenMappings.$EnumSwitchMapping$0[oneOfCase.ordinal()]) == 1 ? Boolean.valueOf(this.$keepOpen) : null;
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<Integer> acquireDatabaseLock(int databaseId) {
        SqliteInspectorProtocol.Command.Builder builder2 = SqliteInspectorProtocol.Command.newBuilder().setAcquireDatabaseLock(SqliteInspectorProtocol.AcquireDatabaseLockCommand.newBuilder().setDatabaseId(databaseId));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n          .\u2026etDatabaseId(databaseId))");
        return FutureUtils.transform(DatabaseInspectorMessengerKt.sendCommandAsync(this.dbMessenger, builder2), (Executor)this.taskExecutor, (Function1)acquireDatabaseLock.1.INSTANCE);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> releaseDatabaseLock(int lockId) {
        SqliteInspectorProtocol.Command.Builder builder2 = SqliteInspectorProtocol.Command.newBuilder().setReleaseDatabaseLock(SqliteInspectorProtocol.ReleaseDatabaseLockCommand.newBuilder().setLockId(lockId));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n          .\u2026lder().setLockId(lockId))");
        return FutureUtils.transform(DatabaseInspectorMessengerKt.sendCommandAsync(this.dbMessenger, builder2), (Executor)this.taskExecutor, (Function1)releaseDatabaseLock.1.INSTANCE);
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(DatabaseInspectorClient $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ DatabaseInspectorMessenger access$getDbMessenger$p(DatabaseInspectorClient $this) {
        return $this.dbMessenger;
    }

    public static final /* synthetic */ Executor access$getTaskExecutor$p(DatabaseInspectorClient $this) {
        return $this.taskExecutor;
    }

    public static final /* synthetic */ Function2 access$getOnDatabaseAddedListener$p(DatabaseInspectorClient $this) {
        return $this.onDatabaseAddedListener;
    }

    public static final /* synthetic */ Function1 access$getOnDatabaseClosed$p(DatabaseInspectorClient $this) {
        return $this.onDatabaseClosed;
    }
}

