/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.License;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseAgreementStep
extends ModelWizardStep<LicenseAgreementModel> {
    private JTextPane myLicenseTextField;
    private Tree myChangeTree;
    private JBRadioButton myDeclineRadioButton;
    private JBRadioButton myAcceptRadioButton;
    private JPanel myRootPanel;
    private Splitter splitter;
    private JPanel optionsPanel;
    private JBScrollPane myTreeScroll;
    private JBScrollPane myLicensePane;
    private DefaultTreeModel myTreeModel;
    @Nullable
    private String myCurrentLicense;
    private final Map<String, Boolean> myAcceptances;
    private final Set<String> myVisibleLicenses;
    private final List<RemotePackage> myInstallRequests;
    private final BoolProperty myAllLicensesAreAccepted;

    public LicenseAgreementStep(@NotNull LicenseAgreementModel model2, @NotNull List<RemotePackage> installRequests) {
        super(model2, "License Agreement");
        this.$$$setupUI$$$();
        this.myTreeModel = new DefaultTreeModel(null);
        this.myAcceptances = Maps.newHashMap();
        this.myVisibleLicenses = Sets.newHashSet();
        this.myAllLicensesAreAccepted = new BoolValueProperty();
        this.myInstallRequests = installRequests;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        this.createUI();
        this.initUI();
    }

    private void createUI() {
        this.splitter.setHonorComponentsMinimumSize(true);
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add((AbstractButton)this.myDeclineRadioButton);
        optionsGroup.add((AbstractButton)this.myAcceptRadioButton);
        this.myRootPanel.add((Component)this.splitter, "Center");
        this.myRootPanel.add((Component)this.optionsPanel, "South");
        this.myLicenseTextField.setFont(StartupUiUtil.getLabelFont());
    }

    private void initUI() {
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.myChangeTree.setShowsRootHandles(false);
        this.myLicenseTextField.setEditable(false);
        SelectedProperty accepted = new SelectedProperty((AbstractButton)this.myAcceptRadioButton);
        accepted.addListener(() -> {
            this.myAcceptances.put(this.myCurrentLicense, accepted.get());
            this.checkAllLicensesAreAccepted();
            this.myChangeTree.repaint();
        });
        this.myChangeTree.addTreeSelectionListener(this.createTreeSelectionListener());
        this.myChangeTree.setCellRenderer((TreeCellRenderer)this.createCellRenderer());
        this.setChanges(this.createChangesList());
    }

    private TreeSelectionListener createTreeSelectionListener() {
        return e -> {
            DefaultMutableTreeNode selected = (DefaultMutableTreeNode)this.myChangeTree.getLastSelectedPathComponent();
            if (selected != null && selected.isRoot()) {
                return;
            }
            if (selected != null && !selected.isLeaf()) {
                License license = (License)selected.getUserObject();
                this.myLicenseTextField.setText(license.getValue());
                this.myCurrentLicense = license.getId();
            } else if (selected != null && !selected.isRoot()) {
                Change change = (Change)selected.getUserObject();
                this.myLicenseTextField.setText(change.license.getValue());
                this.myCurrentLicense = change.license.getId();
            }
            if (this.myAcceptances.get(this.myCurrentLicense).booleanValue()) {
                this.myAcceptRadioButton.setSelected(true);
            } else {
                this.myDeclineRadioButton.setSelected(true);
            }
            this.myLicenseTextField.setCaretPosition(0);
        };
    }

    private ColoredTreeCellRenderer createCellRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                if (row2 == 0) {
                    this.append("Licenses", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
                if (!leaf) {
                    License license = (License)node.getUserObject();
                    this.appendLicenseText(license, license.getId());
                } else {
                    Change change = (Change)node.getUserObject();
                    if (change == null) {
                        return;
                    }
                    this.appendLicenseText(change.license, change.toString());
                    this.setIcon(AllIcons.Actions.Download);
                }
            }

            private void appendLicenseText(@Nullable License license, String text2) {
                boolean notAccepted;
                boolean bl = notAccepted = license != null && LicenseAgreementStep.this.myAcceptances.get(license.getId()) == false;
                if (notAccepted) {
                    this.append("*", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(text2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        };
    }

    private void expandTree() {
        for (int i = 0; i < this.myChangeTree.getRowCount(); ++i) {
            this.myChangeTree.expandRow(i);
        }
    }

    private void setChanges(List<Change> changes) {
        HashMap licenseNodeMap = Maps.newHashMap();
        this.myVisibleLicenses.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode firstChild = null;
        for (Change change : changes) {
            String licenseRef = change.license.getId();
            this.myVisibleLicenses.add(licenseRef);
            if (!licenseNodeMap.containsKey(licenseRef)) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(change.license);
                if (firstChild == null) {
                    firstChild = n;
                }
                licenseNodeMap.put(licenseRef, n);
                this.myAcceptances.put(licenseRef, Boolean.FALSE);
                root.add(n);
            }
            ((DefaultMutableTreeNode)licenseNodeMap.get(licenseRef)).add(new DefaultMutableTreeNode(change));
        }
        this.myTreeModel = new DefaultTreeModel(root);
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.expandTree();
        if (firstChild != null) {
            this.myChangeTree.setSelectionPath(new TreePath(firstChild.getPath()));
        }
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    protected boolean shouldShow() {
        return !this.myVisibleLicenses.isEmpty() && !((LicenseAgreementModel)this.getModel()).getLicenses().isEmpty();
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myChangeTree;
    }

    private void checkAllLicensesAreAccepted() {
        this.myAllLicensesAreAccepted.set(true);
        for (String licenseRef : this.myVisibleLicenses) {
            if (this.myAcceptances.get(licenseRef).booleanValue()) continue;
            this.myAllLicensesAreAccepted.set(false);
            break;
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myAllLicensesAreAccepted;
    }

    private List<Change> createChangesList() {
        ArrayList<Change> toReturn = new ArrayList<Change>();
        if (this.myInstallRequests != null) {
            for (RemotePackage p : this.myInstallRequests) {
                License license = p.getLicense();
                if (license == null) continue;
                ((LicenseAgreementModel)this.getModel()).getLicenses().add(license);
                if (license.checkAccepted((Path)((LicenseAgreementModel)this.getModel()).getSdkRoot().getValue())) continue;
                toReturn.add(new Change(p, license));
            }
        }
        return toReturn;
    }

    private void createUIComponents() {
        this.optionsPanel = new JPanel(new FlowLayout(4));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JTextPane jTextPane;
        JBScrollPane jBScrollPane;
        Tree tree2;
        JBScrollPane jBScrollPane2;
        Splitter splitter;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setMaximumSize(new Dimension(1250, 937));
        jPanel.setMinimumSize(new Dimension(230, 160));
        jPanel.setPreferredSize(new Dimension(230, 160));
        this.splitter = splitter = new Splitter();
        splitter.setLayout(new FlowLayout(1, 5, 5));
        splitter.setMaximumSize(new Dimension(1250, 937));
        splitter.setPreferredSize(new Dimension(230, 160));
        splitter.setProportion(0.3f);
        splitter.setShowDividerControls(false);
        splitter.setShowDividerIcon(false);
        jPanel.add((Component)splitter, "Center");
        this.myTreeScroll = jBScrollPane2 = new JBScrollPane();
        Component component2 = splitter.add((Component)jBScrollPane2);
        this.myChangeTree = tree2 = new Tree();
        jBScrollPane2.setViewportView((Component)tree2);
        this.myLicensePane = jBScrollPane = new JBScrollPane();
        Component component3 = splitter.add((Component)jBScrollPane);
        this.myLicenseTextField = jTextPane = new JTextPane();
        jTextPane.setAutoscrolls(false);
        jTextPane.setEditable(false);
        jTextPane.setMaximumSize(new Dimension(1250, 937));
        jTextPane.setPreferredSize(new Dimension(230, 160));
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.FALSE);
        jTextPane.putClientProperty("charset", "");
        jBScrollPane.setViewportView(jTextPane);
        JPanel jPanel2 = this.optionsPanel;
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add((Component)jPanel2, "South");
        this.myDeclineRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Decline");
        Component component4 = jPanel2.add((Component)jBRadioButton2);
        this.myAcceptRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Accept");
        Component component5 = jPanel2.add((Component)jBRadioButton);
        splitter.setFirstComponent((JComponent)jBScrollPane2);
        splitter.setSecondComponent((JComponent)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static final class Change {
        public RemotePackage myPackage;
        public License license;

        public Change(@NotNull RemotePackage p, @NotNull License license) {
            this.myPackage = p;
            this.license = license;
        }

        public String toString() {
            return this.myPackage.getDisplayName();
        }
    }
}

