/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.sources;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.editors.AttachAndroidSdkSourcesNotificationProvider;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.SdkInstallListener;
import com.android.tools.idea.sdk.sources.SdkSourceFinderForApiLevelKt;
import com.intellij.debugger.SourcePosition;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBus;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\bH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/sdk/sources/SdkSourceFinderForApiLevel;", "", "project", "Lcom/intellij/openapi/project/Project;", "apiLevel", "", "(Lcom/intellij/openapi/project/Project;I)V", "missingSourcesFile", "Lcom/intellij/psi/PsiFile;", "getMissingSourcesFile", "()Lcom/intellij/psi/PsiFile;", "missingSourcesFile$delegate", "Lkotlin/Lazy;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createMissingSourcesFile", "createSourcePackageForApiLevel", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPositionForMissingSources", "Lcom/intellij/debugger/SourcePosition;", "getRelPathForJavaSource", "", "file", "getSourceFileForApiLevel", "lineNumber", "getSourcePosition", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSdkSourceFinderForApiLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkSourceFinderForApiLevel.kt\ncom/android/tools/idea/sdk/sources/SdkSourceFinderForApiLevel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 actions.kt\ncom/intellij/openapi/application/ActionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n8#2:172\n8#2:173\n8#2:175\n8#2:176\n21#3:174\n21#3:177\n1#4:178\n*S KotlinDebug\n*F\n+ 1 SdkSourceFinderForApiLevel.kt\ncom/android/tools/idea/sdk/sources/SdkSourceFinderForApiLevel\n*L\n69#1:172\n76#1:173\n92#1:175\n122#1:176\n80#1:174\n144#1:177\n*E\n"})
public final class SdkSourceFinderForApiLevel {
    @NotNull
    private final Project project;
    private final int apiLevel;
    @NotNull
    private final Lazy missingSourcesFile$delegate;

    public SdkSourceFinderForApiLevel(@NotNull Project project, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.apiLevel = apiLevel;
        this.missingSourcesFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<PsiFile>(this){
            final /* synthetic */ SdkSourceFinderForApiLevel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PsiFile invoke() {
                return SdkSourceFinderForApiLevel.access$createMissingSourcesFile(this.this$0);
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final PsiFile getMissingSourcesFile() {
        Lazy lazy = this.missingSourcesFile$delegate;
        return (PsiFile)lazy.getValue();
    }

    @NotNull
    public final SourcePosition getSourcePosition(@NotNull PsiFile file2, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        SourcePosition sourcePosition = this.getSourceFileForApiLevel(file2, lineNumber);
        if (sourcePosition == null) {
            sourcePosition = this.getPositionForMissingSources();
        }
        return sourcePosition;
    }

    private final SourcePosition getSourceFileForApiLevel(PsiFile file2, int lineNumber) {
        String relPath = this.getRelPathForJavaSource(file2);
        if (relPath == null) {
            SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SdkSourceFinderForApiLevel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
            logger2.debug("getApiSpecificPsi returned null because relPath is null for file: " + file2.getName());
            return null;
        }
        VirtualFile virtualFile = this.createSourcePackageForApiLevel();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile sourceFolder = virtualFile;
        VirtualFile virtualFile2 = sourceFolder.findFileByRelativePath(relPath);
        if (virtualFile2 == null) {
            SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(SdkSourceFinderForApiLevel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(T::class.java)");
            logger3.debug("getSourceForApiLevel returned null because " + relPath + " is not present in " + sourceFolder);
            return null;
        }
        boolean $i$f$runReadAction = false;
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable(this, virtualFile2){
            final /* synthetic */ SdkSourceFinderForApiLevel this$0;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            {
                this.this$0 = sdkSourceFinderForApiLevel;
                this.$virtualFile$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)PsiManager.getInstance((Project)this.this$0.getProject()).findFile(this.$virtualFile$inlined);
            }
        });
        if (psiFile == null) {
            return null;
        }
        PsiFile apiSpecificSourceFile = psiFile;
        return SourcePosition.createFromLine((PsiFile)apiSpecificSourceFile, (int)lineNumber);
    }

    private final String getRelPathForJavaSource(PsiFile file2) {
        String string;
        FileType fileType = file2.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
            VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)this.project).getSourceRootForFile(file2.getVirtualFile());
            if (sourceRoot == null) {
                SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(SdkSourceFinderForApiLevel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.debug("Could not determine source root for file: " + file2.getVirtualFile().getPath());
                string = null;
            } else {
                string = VfsUtilCore.getRelativePath((VirtualFile)file2.getVirtualFile(), (VirtualFile)sourceRoot);
            }
        } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
            String relativeClassPath;
            VirtualFile virtualFile = file2.getVirtualFile();
            String string2 = relativeClassPath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)VfsUtilCore.getRootFile((VirtualFile)virtualFile));
            string = string2 != null ? SdkSourceFinderForApiLevelKt.changeClassExtensionToJava(string2) : null;
        } else {
            string = null;
        }
        return string;
    }

    private final VirtualFile createSourcePackageForApiLevel() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        for (LocalPackage sourcePackage : sdkManager.getPackages().getLocalPackagesForPrefix("sources")) {
            VirtualFile sourceFolder;
            TypeDetails typeDetails = sourcePackage.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.ApiDetailsType)) {
                SdkSourceFinderForApiLevel $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(SdkSourceFinderForApiLevel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.warn("Unable to get type details for source package @ " + sourcePackage.getLocation());
                continue;
            }
            if (this.apiLevel != ((DetailsTypes.ApiDetailsType)typeDetails).getAndroidVersion().getApiLevel()) continue;
            VirtualFile virtualFile = sourceFolder = VfsUtil.findFile((Path)sourcePackage.getLocation(), (boolean)true);
            boolean bl = virtualFile != null ? virtualFile.isValid() : false;
            if (!bl) continue;
            return sourceFolder;
        }
        return null;
    }

    private final SourcePosition getPositionForMissingSources() {
        SourcePosition sourcePosition = SourcePosition.createFromLine((PsiFile)this.getMissingSourcesFile(), (int)-1);
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition, (String)"createFromLine(missingSourcesFile, -1)");
        return sourcePosition;
    }

    private final PsiFile createMissingSourcesFile() {
        Object object = Locale.getDefault();
        Object[] objectArray = SdkSourceFinderForApiLevelKt.access$getMissingSourcesFileContentsFormat$p();
        Object object2 = new Object[]{this.apiLevel};
        String string = String.format((Locale)object, (String)objectArray, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, format, *args)");
        String content2 = string;
        object = "android-%d/UnavailableSource";
        objectArray = new Object[]{this.apiLevel};
        String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        String name2 = string2;
        boolean $i$f$runReadAction = false;
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable(this, name2, content2){
            final /* synthetic */ SdkSourceFinderForApiLevel this$0;
            final /* synthetic */ String $name$inlined;
            final /* synthetic */ String $content$inlined;
            {
                this.this$0 = sdkSourceFinderForApiLevel;
                this.$name$inlined = string;
                this.$content$inlined = string2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)PsiFileFactory.getInstance((Project)this.this$0.getProject()).createFileFromText(this.$name$inlined, (Language)JavaLanguage.INSTANCE, (CharSequence)this.$content$inlined, true, true);
            }
        });
        VirtualFile file2 = psiFile.getVirtualFile();
        object2 = this;
        try {
            SdkSourceFinderForApiLevel $this$createMissingSourcesFile_u24lambda_u242 = (SdkSourceFinderForApiLevel)object2;
            boolean bl = false;
            file2.setWritable(false);
            Object object3 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"project.messageBus");
        MessageBus messageBus2 = messageBus;
        messageBus2.connect((Disposable)messageBus2).subscribe(SdkInstallListener.TOPIC, (Object)new SdkInstallListener(this, file2){
            final /* synthetic */ SdkSourceFinderForApiLevel this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
            }

            public final void installCompleted(@NotNull Collection<? extends UpdatablePackage> installed, @NotNull Collection<? extends LocalPackage> collection2) {
                Object v0;
                VirtualFile virtualFile;
                Object object;
                block4: {
                    Intrinsics.checkNotNullParameter(installed, (String)"installed");
                    Intrinsics.checkNotNullParameter(collection2, (String)"<anonymous parameter 1>");
                    String path2 = DetailsTypes.getSourcesPath((AndroidVersion)new AndroidVersion(SdkSourceFinderForApiLevel.access$getApiLevel$p(this.this$0)));
                    object = installed;
                    virtualFile = object.iterator();
                    while (virtualFile.hasNext()) {
                        T t = virtualFile.next();
                        UpdatablePackage it = (UpdatablePackage)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getPath(), (Object)path2)) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                if (v0 != null && this.$file.isValid()) {
                    object = this.this$0;
                    virtualFile = this.$file;
                    Object modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application app$iv = ApplicationManager.getApplication();
                    if (app$iv.isDispatchThread()) {
                        boolean bl = false;
                        FileEditorManager.getInstance((Project)((SdkSourceFinderForApiLevel)object).getProject()).closeFile(virtualFile);
                    } else {
                        boolean $i$f$invokeLater = false;
                        ApplicationManager.getApplication().invokeLater(new Runnable((SdkSourceFinderForApiLevel)object, virtualFile){
                            final /* synthetic */ SdkSourceFinderForApiLevel this$0;
                            final /* synthetic */ VirtualFile $file$inlined;
                            {
                                this.this$0 = sdkSourceFinderForApiLevel;
                                this.$file$inlined = virtualFile;
                            }

                            public final void run() {
                                boolean bl = false;
                                FileEditorManager.getInstance((Project)this.this$0.getProject()).closeFile(this.$file$inlined);
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }
            }
        });
        file2.putUserData(AttachAndroidSdkSourcesNotificationProvider.REQUIRED_SOURCES_KEY, (Object)this.apiLevel);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiFile");
        return psiFile;
    }

    public static final /* synthetic */ int access$getApiLevel$p(SdkSourceFinderForApiLevel $this) {
        return $this.apiLevel;
    }

    public static final /* synthetic */ PsiFile access$createMissingSourcesFile(SdkSourceFinderForApiLevel $this) {
        return $this.createMissingSourcesFile();
    }
}

